/*
nitroxcalc
Copyright (C) 2015-2024 Salvo "LtWorf" Tomaselli

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

author Salvo "LtWorf" Tomaselli <tiposchi@tiscali.it>
*/

#include <math.h>

#include "calc.h"

#define MAX_PO2 1.6 //atm

static int best_depth(int ean, double factors) {
    double o2 = (double)ean / 100;
    double margin = (factors) / 10;
    double pressure = (MAX_PO2 - margin) / o2;
    return (int)floor((pressure - 1) * 10);
}

int maximum_operative_depth(int ean) {
    return best_depth(ean, 0);
}

int best_operative_depth(int ean, unsigned int factors) {
    return best_depth(ean, factors+1);
}

int equivalent_air_depth(int ean, double depth) {
    //Amount of nitrogen in the mix. [0, 1]
    double n = 1-((double)ean/100);
    return (int)floor(((n*(depth+10)) / 0.79) - 10);
}
