// Type definitions for carbon-icons-svelte
// 5860 icons from @carbon/icons@10.21.0

export interface CarbonIconEvents {
  click: MouseEvent,
  mouseover: MouseEvent,
  mouseenter: MouseEvent,
  mouseleave: MouseEvent,
  keyup: KeyboardEvent,
  keydown: KeyboardEvent
}

export declare class CarbonIcon {
  $$prop_def: {
    /** @type {string} [id] */
    id?: string;

    /** @type {string} [class] */
    class?: string;

    /** @type {string} [tabindex] */
    tabindex?: string;

    /** @type {boolean} [focusable] */
    focusable?: boolean;

    /** @type {string} [title] */
    title?: string;

    /** @type {string} [style] */
    style?: string;

    /**
     * Fill color
     * @type {string} [fill="#161616"]
     */
    fill?: string;

    /**
     * Stroke color
     * @type {string} [stroke="currentColor"]
     */
    stroke?: string;

    /** @type {string} [width="48"] */
    width?: string;

    /** @type {string} [height="48"] */
    height?: string;
  };

  $$slot_def: {
    /** @type {{}} [default] */
    default?: {};
  };

  $$events_def: CarbonIconEvents;

  /**
   * stub $on method from svelte-shims.d.ts
   * https://github.com/sveltejs/language-tools/blob/master/packages/svelte2tsx/svelte-shims.d.ts#L48
   */
  $on<K extends keyof CarbonIconEvents>(event: K, handler: (e: CarbonIconEvents[K]) => any): void;
}

export declare class Accessibility16 extends CarbonIcon {}
export declare class Accessibility20 extends CarbonIcon {}
export declare class Accessibility24 extends CarbonIcon {}
export declare class Accessibility32 extends CarbonIcon {}
export declare class AccessibilityAlt16 extends CarbonIcon {}
export declare class AccessibilityAlt20 extends CarbonIcon {}
export declare class AccessibilityAlt24 extends CarbonIcon {}
export declare class AccessibilityAlt32 extends CarbonIcon {}
export declare class AccessibilityColor16 extends CarbonIcon {}
export declare class AccessibilityColor20 extends CarbonIcon {}
export declare class AccessibilityColor24 extends CarbonIcon {}
export declare class AccessibilityColor32 extends CarbonIcon {}
export declare class AccessibilityColorFilled16 extends CarbonIcon {}
export declare class AccessibilityColorFilled20 extends CarbonIcon {}
export declare class AccessibilityColorFilled24 extends CarbonIcon {}
export declare class AccessibilityColorFilled32 extends CarbonIcon {}
export declare class Account16 extends CarbonIcon {}
export declare class Account20 extends CarbonIcon {}
export declare class Account24 extends CarbonIcon {}
export declare class Account32 extends CarbonIcon {}
export declare class AccumulationIce16 extends CarbonIcon {}
export declare class AccumulationIce20 extends CarbonIcon {}
export declare class AccumulationIce24 extends CarbonIcon {}
export declare class AccumulationIce32 extends CarbonIcon {}
export declare class AccumulationPrecipitation16 extends CarbonIcon {}
export declare class AccumulationPrecipitation20 extends CarbonIcon {}
export declare class AccumulationPrecipitation24 extends CarbonIcon {}
export declare class AccumulationPrecipitation32 extends CarbonIcon {}
export declare class AccumulationRain16 extends CarbonIcon {}
export declare class AccumulationRain20 extends CarbonIcon {}
export declare class AccumulationRain24 extends CarbonIcon {}
export declare class AccumulationRain32 extends CarbonIcon {}
export declare class AccumulationSnow16 extends CarbonIcon {}
export declare class AccumulationSnow20 extends CarbonIcon {}
export declare class AccumulationSnow24 extends CarbonIcon {}
export declare class AccumulationSnow32 extends CarbonIcon {}
export declare class Activity16 extends CarbonIcon {}
export declare class Activity20 extends CarbonIcon {}
export declare class Activity24 extends CarbonIcon {}
export declare class Activity32 extends CarbonIcon {}
export declare class Add16 extends CarbonIcon {}
export declare class Add20 extends CarbonIcon {}
export declare class Add24 extends CarbonIcon {}
export declare class Add32 extends CarbonIcon {}
export declare class AddAlt16 extends CarbonIcon {}
export declare class AddAlt20 extends CarbonIcon {}
export declare class AddAlt24 extends CarbonIcon {}
export declare class AddAlt32 extends CarbonIcon {}
export declare class AddComment16 extends CarbonIcon {}
export declare class AddComment20 extends CarbonIcon {}
export declare class AddComment24 extends CarbonIcon {}
export declare class AddComment32 extends CarbonIcon {}
export declare class AddFilled16 extends CarbonIcon {}
export declare class AddFilled20 extends CarbonIcon {}
export declare class AddFilled24 extends CarbonIcon {}
export declare class AddFilled32 extends CarbonIcon {}
export declare class AgricultureAnalytics16 extends CarbonIcon {}
export declare class AgricultureAnalytics20 extends CarbonIcon {}
export declare class AgricultureAnalytics24 extends CarbonIcon {}
export declare class AgricultureAnalytics32 extends CarbonIcon {}
export declare class AirlineDigitalGate16 extends CarbonIcon {}
export declare class AirlineDigitalGate20 extends CarbonIcon {}
export declare class AirlineDigitalGate24 extends CarbonIcon {}
export declare class AirlineDigitalGate32 extends CarbonIcon {}
export declare class AirlineManageGates16 extends CarbonIcon {}
export declare class AirlineManageGates20 extends CarbonIcon {}
export declare class AirlineManageGates24 extends CarbonIcon {}
export declare class AirlineManageGates32 extends CarbonIcon {}
export declare class AirlinePassengerCare16 extends CarbonIcon {}
export declare class AirlinePassengerCare20 extends CarbonIcon {}
export declare class AirlinePassengerCare24 extends CarbonIcon {}
export declare class AirlinePassengerCare32 extends CarbonIcon {}
export declare class AirlineRapidBoard16 extends CarbonIcon {}
export declare class AirlineRapidBoard20 extends CarbonIcon {}
export declare class AirlineRapidBoard24 extends CarbonIcon {}
export declare class AirlineRapidBoard32 extends CarbonIcon {}
export declare class AirportLocation16 extends CarbonIcon {}
export declare class AirportLocation20 extends CarbonIcon {}
export declare class AirportLocation24 extends CarbonIcon {}
export declare class AirportLocation32 extends CarbonIcon {}
export declare class Airport_0116 extends CarbonIcon {}
export declare class Airport_0120 extends CarbonIcon {}
export declare class Airport_0124 extends CarbonIcon {}
export declare class Airport_0132 extends CarbonIcon {}
export declare class Airport_0216 extends CarbonIcon {}
export declare class Airport_0220 extends CarbonIcon {}
export declare class Airport_0224 extends CarbonIcon {}
export declare class Airport_0232 extends CarbonIcon {}
export declare class Alarm16 extends CarbonIcon {}
export declare class Alarm20 extends CarbonIcon {}
export declare class Alarm24 extends CarbonIcon {}
export declare class Alarm32 extends CarbonIcon {}
export declare class AlarmAdd16 extends CarbonIcon {}
export declare class AlarmAdd20 extends CarbonIcon {}
export declare class AlarmAdd24 extends CarbonIcon {}
export declare class AlarmAdd32 extends CarbonIcon {}
export declare class AlarmSubtract16 extends CarbonIcon {}
export declare class AlarmSubtract20 extends CarbonIcon {}
export declare class AlarmSubtract24 extends CarbonIcon {}
export declare class AlarmSubtract32 extends CarbonIcon {}
export declare class AlignBoxBottomCenter16 extends CarbonIcon {}
export declare class AlignBoxBottomCenter20 extends CarbonIcon {}
export declare class AlignBoxBottomCenter24 extends CarbonIcon {}
export declare class AlignBoxBottomCenter32 extends CarbonIcon {}
export declare class AlignBoxBottomLeft16 extends CarbonIcon {}
export declare class AlignBoxBottomLeft20 extends CarbonIcon {}
export declare class AlignBoxBottomLeft24 extends CarbonIcon {}
export declare class AlignBoxBottomLeft32 extends CarbonIcon {}
export declare class AlignBoxBottomRight16 extends CarbonIcon {}
export declare class AlignBoxBottomRight20 extends CarbonIcon {}
export declare class AlignBoxBottomRight24 extends CarbonIcon {}
export declare class AlignBoxBottomRight32 extends CarbonIcon {}
export declare class AlignBoxMiddleCenter16 extends CarbonIcon {}
export declare class AlignBoxMiddleCenter20 extends CarbonIcon {}
export declare class AlignBoxMiddleCenter24 extends CarbonIcon {}
export declare class AlignBoxMiddleCenter32 extends CarbonIcon {}
export declare class AlignBoxMiddleLeft16 extends CarbonIcon {}
export declare class AlignBoxMiddleLeft20 extends CarbonIcon {}
export declare class AlignBoxMiddleLeft24 extends CarbonIcon {}
export declare class AlignBoxMiddleLeft32 extends CarbonIcon {}
export declare class AlignBoxMiddleRight16 extends CarbonIcon {}
export declare class AlignBoxMiddleRight20 extends CarbonIcon {}
export declare class AlignBoxMiddleRight24 extends CarbonIcon {}
export declare class AlignBoxMiddleRight32 extends CarbonIcon {}
export declare class AlignBoxTopCenter16 extends CarbonIcon {}
export declare class AlignBoxTopCenter20 extends CarbonIcon {}
export declare class AlignBoxTopCenter24 extends CarbonIcon {}
export declare class AlignBoxTopCenter32 extends CarbonIcon {}
export declare class AlignBoxTopLeft16 extends CarbonIcon {}
export declare class AlignBoxTopLeft20 extends CarbonIcon {}
export declare class AlignBoxTopLeft24 extends CarbonIcon {}
export declare class AlignBoxTopLeft32 extends CarbonIcon {}
export declare class AlignBoxTopRight16 extends CarbonIcon {}
export declare class AlignBoxTopRight20 extends CarbonIcon {}
export declare class AlignBoxTopRight24 extends CarbonIcon {}
export declare class AlignBoxTopRight32 extends CarbonIcon {}
export declare class AlignHorizontalCenter16 extends CarbonIcon {}
export declare class AlignHorizontalCenter20 extends CarbonIcon {}
export declare class AlignHorizontalCenter24 extends CarbonIcon {}
export declare class AlignHorizontalCenter32 extends CarbonIcon {}
export declare class AlignHorizontalLeft16 extends CarbonIcon {}
export declare class AlignHorizontalLeft20 extends CarbonIcon {}
export declare class AlignHorizontalLeft24 extends CarbonIcon {}
export declare class AlignHorizontalLeft32 extends CarbonIcon {}
export declare class AlignHorizontalRight16 extends CarbonIcon {}
export declare class AlignHorizontalRight20 extends CarbonIcon {}
export declare class AlignHorizontalRight24 extends CarbonIcon {}
export declare class AlignHorizontalRight32 extends CarbonIcon {}
export declare class AlignVerticalBottom16 extends CarbonIcon {}
export declare class AlignVerticalBottom20 extends CarbonIcon {}
export declare class AlignVerticalBottom24 extends CarbonIcon {}
export declare class AlignVerticalBottom32 extends CarbonIcon {}
export declare class AlignVerticalCenter16 extends CarbonIcon {}
export declare class AlignVerticalCenter20 extends CarbonIcon {}
export declare class AlignVerticalCenter24 extends CarbonIcon {}
export declare class AlignVerticalCenter32 extends CarbonIcon {}
export declare class AlignVerticalTop16 extends CarbonIcon {}
export declare class AlignVerticalTop20 extends CarbonIcon {}
export declare class AlignVerticalTop24 extends CarbonIcon {}
export declare class AlignVerticalTop32 extends CarbonIcon {}
export declare class Analytics16 extends CarbonIcon {}
export declare class Analytics20 extends CarbonIcon {}
export declare class Analytics24 extends CarbonIcon {}
export declare class Analytics32 extends CarbonIcon {}
export declare class AnalyticsReference16 extends CarbonIcon {}
export declare class AnalyticsReference20 extends CarbonIcon {}
export declare class AnalyticsReference24 extends CarbonIcon {}
export declare class AnalyticsReference32 extends CarbonIcon {}
export declare class Aperture16 extends CarbonIcon {}
export declare class Aperture20 extends CarbonIcon {}
export declare class Aperture24 extends CarbonIcon {}
export declare class Aperture32 extends CarbonIcon {}
export declare class Api16 extends CarbonIcon {}
export declare class Api20 extends CarbonIcon {}
export declare class Api24 extends CarbonIcon {}
export declare class Api32 extends CarbonIcon {}
export declare class Api_116 extends CarbonIcon {}
export declare class Api_120 extends CarbonIcon {}
export declare class Api_124 extends CarbonIcon {}
export declare class Api_132 extends CarbonIcon {}
export declare class App16 extends CarbonIcon {}
export declare class App20 extends CarbonIcon {}
export declare class App24 extends CarbonIcon {}
export declare class App32 extends CarbonIcon {}
export declare class AppConnectivity16 extends CarbonIcon {}
export declare class AppConnectivity20 extends CarbonIcon {}
export declare class AppConnectivity24 extends CarbonIcon {}
export declare class AppConnectivity32 extends CarbonIcon {}
export declare class AppSwitcher16 extends CarbonIcon {}
export declare class AppSwitcher20 extends CarbonIcon {}
export declare class AppSwitcher24 extends CarbonIcon {}
export declare class AppSwitcher32 extends CarbonIcon {}
export declare class Apple16 extends CarbonIcon {}
export declare class Apple20 extends CarbonIcon {}
export declare class Apple24 extends CarbonIcon {}
export declare class Apple32 extends CarbonIcon {}
export declare class Application16 extends CarbonIcon {}
export declare class Application20 extends CarbonIcon {}
export declare class Application24 extends CarbonIcon {}
export declare class Application32 extends CarbonIcon {}
export declare class Apps16 extends CarbonIcon {}
export declare class Apps20 extends CarbonIcon {}
export declare class Apps24 extends CarbonIcon {}
export declare class Apps32 extends CarbonIcon {}
export declare class Archive16 extends CarbonIcon {}
export declare class Archive20 extends CarbonIcon {}
export declare class Archive24 extends CarbonIcon {}
export declare class Archive32 extends CarbonIcon {}
export declare class Area16 extends CarbonIcon {}
export declare class Area20 extends CarbonIcon {}
export declare class Area24 extends CarbonIcon {}
export declare class Area32 extends CarbonIcon {}
export declare class AreaCustom16 extends CarbonIcon {}
export declare class AreaCustom20 extends CarbonIcon {}
export declare class AreaCustom24 extends CarbonIcon {}
export declare class AreaCustom32 extends CarbonIcon {}
export declare class Arrival16 extends CarbonIcon {}
export declare class Arrival20 extends CarbonIcon {}
export declare class Arrival24 extends CarbonIcon {}
export declare class Arrival32 extends CarbonIcon {}
export declare class ArrowDown16 extends CarbonIcon {}
export declare class ArrowDown20 extends CarbonIcon {}
export declare class ArrowDown24 extends CarbonIcon {}
export declare class ArrowDown32 extends CarbonIcon {}
export declare class ArrowDownLeft16 extends CarbonIcon {}
export declare class ArrowDownLeft20 extends CarbonIcon {}
export declare class ArrowDownLeft24 extends CarbonIcon {}
export declare class ArrowDownLeft32 extends CarbonIcon {}
export declare class ArrowDownRight16 extends CarbonIcon {}
export declare class ArrowDownRight20 extends CarbonIcon {}
export declare class ArrowDownRight24 extends CarbonIcon {}
export declare class ArrowDownRight32 extends CarbonIcon {}
export declare class ArrowLeft16 extends CarbonIcon {}
export declare class ArrowLeft20 extends CarbonIcon {}
export declare class ArrowLeft24 extends CarbonIcon {}
export declare class ArrowLeft32 extends CarbonIcon {}
export declare class ArrowRight16 extends CarbonIcon {}
export declare class ArrowRight20 extends CarbonIcon {}
export declare class ArrowRight24 extends CarbonIcon {}
export declare class ArrowRight32 extends CarbonIcon {}
export declare class ArrowShiftDown16 extends CarbonIcon {}
export declare class ArrowShiftDown20 extends CarbonIcon {}
export declare class ArrowShiftDown24 extends CarbonIcon {}
export declare class ArrowShiftDown32 extends CarbonIcon {}
export declare class ArrowUp16 extends CarbonIcon {}
export declare class ArrowUp20 extends CarbonIcon {}
export declare class ArrowUp24 extends CarbonIcon {}
export declare class ArrowUp32 extends CarbonIcon {}
export declare class ArrowUpLeft16 extends CarbonIcon {}
export declare class ArrowUpLeft20 extends CarbonIcon {}
export declare class ArrowUpLeft24 extends CarbonIcon {}
export declare class ArrowUpLeft32 extends CarbonIcon {}
export declare class ArrowUpRight16 extends CarbonIcon {}
export declare class ArrowUpRight20 extends CarbonIcon {}
export declare class ArrowUpRight24 extends CarbonIcon {}
export declare class ArrowUpRight32 extends CarbonIcon {}
export declare class Arrows16 extends CarbonIcon {}
export declare class Arrows20 extends CarbonIcon {}
export declare class Arrows24 extends CarbonIcon {}
export declare class Arrows32 extends CarbonIcon {}
export declare class ArrowsHorizontal16 extends CarbonIcon {}
export declare class ArrowsHorizontal20 extends CarbonIcon {}
export declare class ArrowsHorizontal24 extends CarbonIcon {}
export declare class ArrowsHorizontal32 extends CarbonIcon {}
export declare class ArrowsVertical16 extends CarbonIcon {}
export declare class ArrowsVertical20 extends CarbonIcon {}
export declare class ArrowsVertical24 extends CarbonIcon {}
export declare class ArrowsVertical32 extends CarbonIcon {}
export declare class Asleep16 extends CarbonIcon {}
export declare class Asleep20 extends CarbonIcon {}
export declare class Asleep24 extends CarbonIcon {}
export declare class Asleep32 extends CarbonIcon {}
export declare class AsleepFilled16 extends CarbonIcon {}
export declare class AsleepFilled20 extends CarbonIcon {}
export declare class AsleepFilled24 extends CarbonIcon {}
export declare class AsleepFilled32 extends CarbonIcon {}
export declare class Asset16 extends CarbonIcon {}
export declare class Asset20 extends CarbonIcon {}
export declare class Asset24 extends CarbonIcon {}
export declare class Asset32 extends CarbonIcon {}
export declare class At16 extends CarbonIcon {}
export declare class At20 extends CarbonIcon {}
export declare class At24 extends CarbonIcon {}
export declare class At32 extends CarbonIcon {}
export declare class Attachment16 extends CarbonIcon {}
export declare class Attachment20 extends CarbonIcon {}
export declare class Attachment24 extends CarbonIcon {}
export declare class Attachment32 extends CarbonIcon {}
export declare class AudioConsole16 extends CarbonIcon {}
export declare class AudioConsole20 extends CarbonIcon {}
export declare class AudioConsole24 extends CarbonIcon {}
export declare class AudioConsole32 extends CarbonIcon {}
export declare class AugmentedReality16 extends CarbonIcon {}
export declare class AugmentedReality20 extends CarbonIcon {}
export declare class AugmentedReality24 extends CarbonIcon {}
export declare class AugmentedReality32 extends CarbonIcon {}
export declare class Automatic16 extends CarbonIcon {}
export declare class Automatic20 extends CarbonIcon {}
export declare class Automatic24 extends CarbonIcon {}
export declare class Automatic32 extends CarbonIcon {}
export declare class Awake16 extends CarbonIcon {}
export declare class Awake20 extends CarbonIcon {}
export declare class Awake24 extends CarbonIcon {}
export declare class Awake32 extends CarbonIcon {}
export declare class BackToTop16 extends CarbonIcon {}
export declare class BackToTop20 extends CarbonIcon {}
export declare class BackToTop24 extends CarbonIcon {}
export declare class BackToTop32 extends CarbonIcon {}
export declare class Badge16 extends CarbonIcon {}
export declare class Badge20 extends CarbonIcon {}
export declare class Badge24 extends CarbonIcon {}
export declare class Badge32 extends CarbonIcon {}
export declare class BaggageClaim16 extends CarbonIcon {}
export declare class BaggageClaim20 extends CarbonIcon {}
export declare class BaggageClaim24 extends CarbonIcon {}
export declare class BaggageClaim32 extends CarbonIcon {}
export declare class Bar16 extends CarbonIcon {}
export declare class Bar20 extends CarbonIcon {}
export declare class Bar24 extends CarbonIcon {}
export declare class Bar32 extends CarbonIcon {}
export declare class Basketball16 extends CarbonIcon {}
export declare class Basketball20 extends CarbonIcon {}
export declare class Basketball24 extends CarbonIcon {}
export declare class Basketball32 extends CarbonIcon {}
export declare class Bat16 extends CarbonIcon {}
export declare class Bat20 extends CarbonIcon {}
export declare class Bat24 extends CarbonIcon {}
export declare class Bat32 extends CarbonIcon {}
export declare class BatteryCharging16 extends CarbonIcon {}
export declare class BatteryCharging20 extends CarbonIcon {}
export declare class BatteryCharging24 extends CarbonIcon {}
export declare class BatteryCharging32 extends CarbonIcon {}
export declare class BatteryEmpty16 extends CarbonIcon {}
export declare class BatteryEmpty20 extends CarbonIcon {}
export declare class BatteryEmpty24 extends CarbonIcon {}
export declare class BatteryEmpty32 extends CarbonIcon {}
export declare class BatteryFull16 extends CarbonIcon {}
export declare class BatteryFull20 extends CarbonIcon {}
export declare class BatteryFull24 extends CarbonIcon {}
export declare class BatteryFull32 extends CarbonIcon {}
export declare class BatteryHalf16 extends CarbonIcon {}
export declare class BatteryHalf20 extends CarbonIcon {}
export declare class BatteryHalf24 extends CarbonIcon {}
export declare class BatteryHalf32 extends CarbonIcon {}
export declare class BatteryLow16 extends CarbonIcon {}
export declare class BatteryLow20 extends CarbonIcon {}
export declare class BatteryLow24 extends CarbonIcon {}
export declare class BatteryLow32 extends CarbonIcon {}
export declare class BatteryQuarter16 extends CarbonIcon {}
export declare class BatteryQuarter20 extends CarbonIcon {}
export declare class BatteryQuarter24 extends CarbonIcon {}
export declare class BatteryQuarter32 extends CarbonIcon {}
export declare class Bee16 extends CarbonIcon {}
export declare class Bee20 extends CarbonIcon {}
export declare class Bee24 extends CarbonIcon {}
export declare class Bee32 extends CarbonIcon {}
export declare class BeeBat16 extends CarbonIcon {}
export declare class BeeBat20 extends CarbonIcon {}
export declare class BeeBat24 extends CarbonIcon {}
export declare class BeeBat32 extends CarbonIcon {}
export declare class Bicycle16 extends CarbonIcon {}
export declare class Bicycle20 extends CarbonIcon {}
export declare class Bicycle24 extends CarbonIcon {}
export declare class Bicycle32 extends CarbonIcon {}
export declare class Binoculars16 extends CarbonIcon {}
export declare class Binoculars20 extends CarbonIcon {}
export declare class Binoculars24 extends CarbonIcon {}
export declare class Binoculars32 extends CarbonIcon {}
export declare class Blockchain16 extends CarbonIcon {}
export declare class Blockchain20 extends CarbonIcon {}
export declare class Blockchain24 extends CarbonIcon {}
export declare class Blockchain32 extends CarbonIcon {}
export declare class Blog16 extends CarbonIcon {}
export declare class Blog20 extends CarbonIcon {}
export declare class Blog24 extends CarbonIcon {}
export declare class Blog32 extends CarbonIcon {}
export declare class Bluetooth16 extends CarbonIcon {}
export declare class Bluetooth20 extends CarbonIcon {}
export declare class Bluetooth24 extends CarbonIcon {}
export declare class Bluetooth32 extends CarbonIcon {}
export declare class BluetoothOff16 extends CarbonIcon {}
export declare class BluetoothOff20 extends CarbonIcon {}
export declare class BluetoothOff24 extends CarbonIcon {}
export declare class BluetoothOff32 extends CarbonIcon {}
export declare class Book16 extends CarbonIcon {}
export declare class Book20 extends CarbonIcon {}
export declare class Book24 extends CarbonIcon {}
export declare class Book32 extends CarbonIcon {}
export declare class Bookmark16 extends CarbonIcon {}
export declare class Bookmark20 extends CarbonIcon {}
export declare class Bookmark24 extends CarbonIcon {}
export declare class Bookmark32 extends CarbonIcon {}
export declare class BookmarkFilled16 extends CarbonIcon {}
export declare class BookmarkFilled20 extends CarbonIcon {}
export declare class BookmarkFilled24 extends CarbonIcon {}
export declare class BookmarkFilled32 extends CarbonIcon {}
export declare class Boolean16 extends CarbonIcon {}
export declare class Boolean20 extends CarbonIcon {}
export declare class Boolean24 extends CarbonIcon {}
export declare class Boolean32 extends CarbonIcon {}
export declare class BorderBottom16 extends CarbonIcon {}
export declare class BorderBottom20 extends CarbonIcon {}
export declare class BorderBottom24 extends CarbonIcon {}
export declare class BorderBottom32 extends CarbonIcon {}
export declare class BorderFull16 extends CarbonIcon {}
export declare class BorderFull20 extends CarbonIcon {}
export declare class BorderFull24 extends CarbonIcon {}
export declare class BorderFull32 extends CarbonIcon {}
export declare class BorderLeft16 extends CarbonIcon {}
export declare class BorderLeft20 extends CarbonIcon {}
export declare class BorderLeft24 extends CarbonIcon {}
export declare class BorderLeft32 extends CarbonIcon {}
export declare class BorderNone16 extends CarbonIcon {}
export declare class BorderNone20 extends CarbonIcon {}
export declare class BorderNone24 extends CarbonIcon {}
export declare class BorderNone32 extends CarbonIcon {}
export declare class BorderRight16 extends CarbonIcon {}
export declare class BorderRight20 extends CarbonIcon {}
export declare class BorderRight24 extends CarbonIcon {}
export declare class BorderRight32 extends CarbonIcon {}
export declare class BorderTop16 extends CarbonIcon {}
export declare class BorderTop20 extends CarbonIcon {}
export declare class BorderTop24 extends CarbonIcon {}
export declare class BorderTop32 extends CarbonIcon {}
export declare class Bot16 extends CarbonIcon {}
export declare class Bot20 extends CarbonIcon {}
export declare class Bot24 extends CarbonIcon {}
export declare class Bot32 extends CarbonIcon {}
export declare class Box16 extends CarbonIcon {}
export declare class Box20 extends CarbonIcon {}
export declare class Box24 extends CarbonIcon {}
export declare class Box32 extends CarbonIcon {}
export declare class BoxPlot16 extends CarbonIcon {}
export declare class BoxPlot20 extends CarbonIcon {}
export declare class BoxPlot24 extends CarbonIcon {}
export declare class BoxPlot32 extends CarbonIcon {}
export declare class Branch16 extends CarbonIcon {}
export declare class Branch20 extends CarbonIcon {}
export declare class Branch24 extends CarbonIcon {}
export declare class Branch32 extends CarbonIcon {}
export declare class BrightnessContrast16 extends CarbonIcon {}
export declare class BrightnessContrast20 extends CarbonIcon {}
export declare class BrightnessContrast24 extends CarbonIcon {}
export declare class BrightnessContrast32 extends CarbonIcon {}
export declare class BringToFront16 extends CarbonIcon {}
export declare class BringToFront20 extends CarbonIcon {}
export declare class BringToFront24 extends CarbonIcon {}
export declare class BringToFront32 extends CarbonIcon {}
export declare class Building16 extends CarbonIcon {}
export declare class Building20 extends CarbonIcon {}
export declare class Building24 extends CarbonIcon {}
export declare class Building32 extends CarbonIcon {}
export declare class BuildingInsights_116 extends CarbonIcon {}
export declare class BuildingInsights_120 extends CarbonIcon {}
export declare class BuildingInsights_124 extends CarbonIcon {}
export declare class BuildingInsights_132 extends CarbonIcon {}
export declare class BuildingInsights_216 extends CarbonIcon {}
export declare class BuildingInsights_220 extends CarbonIcon {}
export declare class BuildingInsights_224 extends CarbonIcon {}
export declare class BuildingInsights_232 extends CarbonIcon {}
export declare class BuildingInsights_316 extends CarbonIcon {}
export declare class BuildingInsights_320 extends CarbonIcon {}
export declare class BuildingInsights_324 extends CarbonIcon {}
export declare class BuildingInsights_332 extends CarbonIcon {}
export declare class Bullhorn16 extends CarbonIcon {}
export declare class Bullhorn20 extends CarbonIcon {}
export declare class Bullhorn24 extends CarbonIcon {}
export declare class Bullhorn32 extends CarbonIcon {}
export declare class Buoy16 extends CarbonIcon {}
export declare class Buoy20 extends CarbonIcon {}
export declare class Buoy24 extends CarbonIcon {}
export declare class Buoy32 extends CarbonIcon {}
export declare class Bus16 extends CarbonIcon {}
export declare class Bus20 extends CarbonIcon {}
export declare class Bus24 extends CarbonIcon {}
export declare class Bus32 extends CarbonIcon {}
export declare class CabinCare16 extends CarbonIcon {}
export declare class CabinCare20 extends CarbonIcon {}
export declare class CabinCare24 extends CarbonIcon {}
export declare class CabinCare32 extends CarbonIcon {}
export declare class CabinCareAlert16 extends CarbonIcon {}
export declare class CabinCareAlert20 extends CarbonIcon {}
export declare class CabinCareAlert24 extends CarbonIcon {}
export declare class CabinCareAlert32 extends CarbonIcon {}
export declare class CabinCareAlt16 extends CarbonIcon {}
export declare class CabinCareAlt20 extends CarbonIcon {}
export declare class CabinCareAlt24 extends CarbonIcon {}
export declare class CabinCareAlt32 extends CarbonIcon {}
export declare class Cad16 extends CarbonIcon {}
export declare class Cad20 extends CarbonIcon {}
export declare class Cad24 extends CarbonIcon {}
export declare class Cad32 extends CarbonIcon {}
export declare class Cafe16 extends CarbonIcon {}
export declare class Cafe20 extends CarbonIcon {}
export declare class Cafe24 extends CarbonIcon {}
export declare class Cafe32 extends CarbonIcon {}
export declare class Calculator16 extends CarbonIcon {}
export declare class Calculator20 extends CarbonIcon {}
export declare class Calculator24 extends CarbonIcon {}
export declare class Calculator32 extends CarbonIcon {}
export declare class CalculatorCheck16 extends CarbonIcon {}
export declare class CalculatorCheck20 extends CarbonIcon {}
export declare class CalculatorCheck24 extends CarbonIcon {}
export declare class CalculatorCheck32 extends CarbonIcon {}
export declare class Calendar16 extends CarbonIcon {}
export declare class Calendar20 extends CarbonIcon {}
export declare class Calendar24 extends CarbonIcon {}
export declare class Calendar32 extends CarbonIcon {}
export declare class CalendarHeatMap16 extends CarbonIcon {}
export declare class CalendarHeatMap20 extends CarbonIcon {}
export declare class CalendarHeatMap24 extends CarbonIcon {}
export declare class CalendarHeatMap32 extends CarbonIcon {}
export declare class CalendarSettings16 extends CarbonIcon {}
export declare class CalendarSettings20 extends CarbonIcon {}
export declare class CalendarSettings24 extends CarbonIcon {}
export declare class CalendarSettings32 extends CarbonIcon {}
export declare class CalendarTools16 extends CarbonIcon {}
export declare class CalendarTools20 extends CarbonIcon {}
export declare class CalendarTools24 extends CarbonIcon {}
export declare class CalendarTools32 extends CarbonIcon {}
export declare class Calibrate16 extends CarbonIcon {}
export declare class Calibrate20 extends CarbonIcon {}
export declare class Calibrate24 extends CarbonIcon {}
export declare class Calibrate32 extends CarbonIcon {}
export declare class Camera16 extends CarbonIcon {}
export declare class Camera20 extends CarbonIcon {}
export declare class Camera24 extends CarbonIcon {}
export declare class Camera32 extends CarbonIcon {}
export declare class CameraAction16 extends CarbonIcon {}
export declare class CameraAction20 extends CarbonIcon {}
export declare class CameraAction24 extends CarbonIcon {}
export declare class CameraAction32 extends CarbonIcon {}
export declare class Campsite16 extends CarbonIcon {}
export declare class Campsite20 extends CarbonIcon {}
export declare class Campsite24 extends CarbonIcon {}
export declare class Campsite32 extends CarbonIcon {}
export declare class Car16 extends CarbonIcon {}
export declare class Car20 extends CarbonIcon {}
export declare class Car24 extends CarbonIcon {}
export declare class Car32 extends CarbonIcon {}
export declare class CarFront16 extends CarbonIcon {}
export declare class CarFront20 extends CarbonIcon {}
export declare class CarFront24 extends CarbonIcon {}
export declare class CarFront32 extends CarbonIcon {}
export declare class Carbon16 extends CarbonIcon {}
export declare class Carbon20 extends CarbonIcon {}
export declare class Carbon24 extends CarbonIcon {}
export declare class Carbon32 extends CarbonIcon {}
export declare class CaretDown16 extends CarbonIcon {}
export declare class CaretDown20 extends CarbonIcon {}
export declare class CaretDown24 extends CarbonIcon {}
export declare class CaretDown32 extends CarbonIcon {}
export declare class CaretDownGlyph extends CarbonIcon {}
export declare class CaretLeft16 extends CarbonIcon {}
export declare class CaretLeft20 extends CarbonIcon {}
export declare class CaretLeft24 extends CarbonIcon {}
export declare class CaretLeft32 extends CarbonIcon {}
export declare class CaretLeftGlyph extends CarbonIcon {}
export declare class CaretRight16 extends CarbonIcon {}
export declare class CaretRight20 extends CarbonIcon {}
export declare class CaretRight24 extends CarbonIcon {}
export declare class CaretRight32 extends CarbonIcon {}
export declare class CaretRightGlyph extends CarbonIcon {}
export declare class CaretSort16 extends CarbonIcon {}
export declare class CaretSort20 extends CarbonIcon {}
export declare class CaretSort24 extends CarbonIcon {}
export declare class CaretSort32 extends CarbonIcon {}
export declare class CaretSortDown16 extends CarbonIcon {}
export declare class CaretSortDown20 extends CarbonIcon {}
export declare class CaretSortDown24 extends CarbonIcon {}
export declare class CaretSortDown32 extends CarbonIcon {}
export declare class CaretSortUp16 extends CarbonIcon {}
export declare class CaretSortUp20 extends CarbonIcon {}
export declare class CaretSortUp24 extends CarbonIcon {}
export declare class CaretSortUp32 extends CarbonIcon {}
export declare class CaretUp16 extends CarbonIcon {}
export declare class CaretUp20 extends CarbonIcon {}
export declare class CaretUp24 extends CarbonIcon {}
export declare class CaretUp32 extends CarbonIcon {}
export declare class CaretUpGlyph extends CarbonIcon {}
export declare class CarouselHorizontal16 extends CarbonIcon {}
export declare class CarouselHorizontal20 extends CarbonIcon {}
export declare class CarouselHorizontal24 extends CarbonIcon {}
export declare class CarouselHorizontal32 extends CarbonIcon {}
export declare class CarouselVertical16 extends CarbonIcon {}
export declare class CarouselVertical20 extends CarbonIcon {}
export declare class CarouselVertical24 extends CarbonIcon {}
export declare class CarouselVertical32 extends CarbonIcon {}
export declare class Catalog16 extends CarbonIcon {}
export declare class Catalog20 extends CarbonIcon {}
export declare class Catalog24 extends CarbonIcon {}
export declare class Catalog32 extends CarbonIcon {}
export declare class Categories16 extends CarbonIcon {}
export declare class Categories20 extends CarbonIcon {}
export declare class Categories24 extends CarbonIcon {}
export declare class Categories32 extends CarbonIcon {}
export declare class Category16 extends CarbonIcon {}
export declare class Category20 extends CarbonIcon {}
export declare class Category24 extends CarbonIcon {}
export declare class Category32 extends CarbonIcon {}
export declare class CategoryAdd16 extends CarbonIcon {}
export declare class CategoryAdd20 extends CarbonIcon {}
export declare class CategoryAdd24 extends CarbonIcon {}
export declare class CategoryAdd32 extends CarbonIcon {}
export declare class CategoryAnd16 extends CarbonIcon {}
export declare class CategoryAnd20 extends CarbonIcon {}
export declare class CategoryAnd24 extends CarbonIcon {}
export declare class CategoryAnd32 extends CarbonIcon {}
export declare class CategoryNew16 extends CarbonIcon {}
export declare class CategoryNew20 extends CarbonIcon {}
export declare class CategoryNew24 extends CarbonIcon {}
export declare class CategoryNew32 extends CarbonIcon {}
export declare class CategoryNewEach16 extends CarbonIcon {}
export declare class CategoryNewEach20 extends CarbonIcon {}
export declare class CategoryNewEach24 extends CarbonIcon {}
export declare class CategoryNewEach32 extends CarbonIcon {}
export declare class Cda16 extends CarbonIcon {}
export declare class Cda20 extends CarbonIcon {}
export declare class Cda24 extends CarbonIcon {}
export declare class Cda32 extends CarbonIcon {}
export declare class CenterCircle16 extends CarbonIcon {}
export declare class CenterCircle20 extends CarbonIcon {}
export declare class CenterCircle24 extends CarbonIcon {}
export declare class CenterCircle32 extends CarbonIcon {}
export declare class CenterSquare16 extends CarbonIcon {}
export declare class CenterSquare20 extends CarbonIcon {}
export declare class CenterSquare24 extends CarbonIcon {}
export declare class CenterSquare32 extends CarbonIcon {}
export declare class CenterToFit16 extends CarbonIcon {}
export declare class CenterToFit20 extends CarbonIcon {}
export declare class CenterToFit24 extends CarbonIcon {}
export declare class CenterToFit32 extends CarbonIcon {}
export declare class Certificate16 extends CarbonIcon {}
export declare class Certificate20 extends CarbonIcon {}
export declare class Certificate24 extends CarbonIcon {}
export declare class Certificate32 extends CarbonIcon {}
export declare class CertificateCheck16 extends CarbonIcon {}
export declare class CertificateCheck20 extends CarbonIcon {}
export declare class CertificateCheck24 extends CarbonIcon {}
export declare class CertificateCheck32 extends CarbonIcon {}
export declare class ChangeCatalog16 extends CarbonIcon {}
export declare class ChangeCatalog20 extends CarbonIcon {}
export declare class ChangeCatalog24 extends CarbonIcon {}
export declare class ChangeCatalog32 extends CarbonIcon {}
export declare class CharacterPatterns16 extends CarbonIcon {}
export declare class CharacterPatterns20 extends CarbonIcon {}
export declare class CharacterPatterns24 extends CarbonIcon {}
export declare class CharacterPatterns32 extends CarbonIcon {}
export declare class ChargingStation16 extends CarbonIcon {}
export declare class ChargingStation20 extends CarbonIcon {}
export declare class ChargingStation24 extends CarbonIcon {}
export declare class ChargingStation32 extends CarbonIcon {}
export declare class ChargingStationFilled16 extends CarbonIcon {}
export declare class ChargingStationFilled20 extends CarbonIcon {}
export declare class ChargingStationFilled24 extends CarbonIcon {}
export declare class ChargingStationFilled32 extends CarbonIcon {}
export declare class ChartArea16 extends CarbonIcon {}
export declare class ChartArea20 extends CarbonIcon {}
export declare class ChartArea24 extends CarbonIcon {}
export declare class ChartArea32 extends CarbonIcon {}
export declare class ChartAreaSmooth16 extends CarbonIcon {}
export declare class ChartAreaSmooth20 extends CarbonIcon {}
export declare class ChartAreaSmooth24 extends CarbonIcon {}
export declare class ChartAreaSmooth32 extends CarbonIcon {}
export declare class ChartAreaStepper16 extends CarbonIcon {}
export declare class ChartAreaStepper20 extends CarbonIcon {}
export declare class ChartAreaStepper24 extends CarbonIcon {}
export declare class ChartAreaStepper32 extends CarbonIcon {}
export declare class ChartAverage16 extends CarbonIcon {}
export declare class ChartAverage20 extends CarbonIcon {}
export declare class ChartAverage24 extends CarbonIcon {}
export declare class ChartAverage32 extends CarbonIcon {}
export declare class ChartBar16 extends CarbonIcon {}
export declare class ChartBar20 extends CarbonIcon {}
export declare class ChartBar24 extends CarbonIcon {}
export declare class ChartBar32 extends CarbonIcon {}
export declare class ChartBarFloating16 extends CarbonIcon {}
export declare class ChartBarFloating20 extends CarbonIcon {}
export declare class ChartBarFloating24 extends CarbonIcon {}
export declare class ChartBarFloating32 extends CarbonIcon {}
export declare class ChartBarOverlay16 extends CarbonIcon {}
export declare class ChartBarOverlay20 extends CarbonIcon {}
export declare class ChartBarOverlay24 extends CarbonIcon {}
export declare class ChartBarOverlay32 extends CarbonIcon {}
export declare class ChartBarStacked16 extends CarbonIcon {}
export declare class ChartBarStacked20 extends CarbonIcon {}
export declare class ChartBarStacked24 extends CarbonIcon {}
export declare class ChartBarStacked32 extends CarbonIcon {}
export declare class ChartBarTarget16 extends CarbonIcon {}
export declare class ChartBarTarget20 extends CarbonIcon {}
export declare class ChartBarTarget24 extends CarbonIcon {}
export declare class ChartBarTarget32 extends CarbonIcon {}
export declare class ChartBubble16 extends CarbonIcon {}
export declare class ChartBubble20 extends CarbonIcon {}
export declare class ChartBubble24 extends CarbonIcon {}
export declare class ChartBubble32 extends CarbonIcon {}
export declare class ChartBullet16 extends CarbonIcon {}
export declare class ChartBullet20 extends CarbonIcon {}
export declare class ChartBullet24 extends CarbonIcon {}
export declare class ChartBullet32 extends CarbonIcon {}
export declare class ChartCandlestick16 extends CarbonIcon {}
export declare class ChartCandlestick20 extends CarbonIcon {}
export declare class ChartCandlestick24 extends CarbonIcon {}
export declare class ChartCandlestick32 extends CarbonIcon {}
export declare class ChartClusterBar16 extends CarbonIcon {}
export declare class ChartClusterBar20 extends CarbonIcon {}
export declare class ChartClusterBar24 extends CarbonIcon {}
export declare class ChartClusterBar32 extends CarbonIcon {}
export declare class ChartColumn16 extends CarbonIcon {}
export declare class ChartColumn20 extends CarbonIcon {}
export declare class ChartColumn24 extends CarbonIcon {}
export declare class ChartColumn32 extends CarbonIcon {}
export declare class ChartColumnFloating16 extends CarbonIcon {}
export declare class ChartColumnFloating20 extends CarbonIcon {}
export declare class ChartColumnFloating24 extends CarbonIcon {}
export declare class ChartColumnFloating32 extends CarbonIcon {}
export declare class ChartColumnTarget16 extends CarbonIcon {}
export declare class ChartColumnTarget20 extends CarbonIcon {}
export declare class ChartColumnTarget24 extends CarbonIcon {}
export declare class ChartColumnTarget32 extends CarbonIcon {}
export declare class ChartCombo16 extends CarbonIcon {}
export declare class ChartCombo20 extends CarbonIcon {}
export declare class ChartCombo24 extends CarbonIcon {}
export declare class ChartCombo32 extends CarbonIcon {}
export declare class ChartComboStacked16 extends CarbonIcon {}
export declare class ChartComboStacked20 extends CarbonIcon {}
export declare class ChartComboStacked24 extends CarbonIcon {}
export declare class ChartComboStacked32 extends CarbonIcon {}
export declare class ChartCustom16 extends CarbonIcon {}
export declare class ChartCustom20 extends CarbonIcon {}
export declare class ChartCustom24 extends CarbonIcon {}
export declare class ChartCustom32 extends CarbonIcon {}
export declare class ChartErrorBar16 extends CarbonIcon {}
export declare class ChartErrorBar20 extends CarbonIcon {}
export declare class ChartErrorBar24 extends CarbonIcon {}
export declare class ChartErrorBar32 extends CarbonIcon {}
export declare class ChartErrorBarAlt16 extends CarbonIcon {}
export declare class ChartErrorBarAlt20 extends CarbonIcon {}
export declare class ChartErrorBarAlt24 extends CarbonIcon {}
export declare class ChartErrorBarAlt32 extends CarbonIcon {}
export declare class ChartEvaluation16 extends CarbonIcon {}
export declare class ChartEvaluation20 extends CarbonIcon {}
export declare class ChartEvaluation24 extends CarbonIcon {}
export declare class ChartEvaluation32 extends CarbonIcon {}
export declare class ChartHighLow16 extends CarbonIcon {}
export declare class ChartHighLow20 extends CarbonIcon {}
export declare class ChartHighLow24 extends CarbonIcon {}
export declare class ChartHighLow32 extends CarbonIcon {}
export declare class ChartHistogram16 extends CarbonIcon {}
export declare class ChartHistogram20 extends CarbonIcon {}
export declare class ChartHistogram24 extends CarbonIcon {}
export declare class ChartHistogram32 extends CarbonIcon {}
export declare class ChartLine16 extends CarbonIcon {}
export declare class ChartLine20 extends CarbonIcon {}
export declare class ChartLine24 extends CarbonIcon {}
export declare class ChartLine32 extends CarbonIcon {}
export declare class ChartLineData16 extends CarbonIcon {}
export declare class ChartLineData20 extends CarbonIcon {}
export declare class ChartLineData24 extends CarbonIcon {}
export declare class ChartLineData32 extends CarbonIcon {}
export declare class ChartLineSmooth16 extends CarbonIcon {}
export declare class ChartLineSmooth20 extends CarbonIcon {}
export declare class ChartLineSmooth24 extends CarbonIcon {}
export declare class ChartLineSmooth32 extends CarbonIcon {}
export declare class ChartMarimekko16 extends CarbonIcon {}
export declare class ChartMarimekko20 extends CarbonIcon {}
export declare class ChartMarimekko24 extends CarbonIcon {}
export declare class ChartMarimekko32 extends CarbonIcon {}
export declare class ChartMaximum16 extends CarbonIcon {}
export declare class ChartMaximum20 extends CarbonIcon {}
export declare class ChartMaximum24 extends CarbonIcon {}
export declare class ChartMaximum32 extends CarbonIcon {}
export declare class ChartMinimum16 extends CarbonIcon {}
export declare class ChartMinimum20 extends CarbonIcon {}
export declare class ChartMinimum24 extends CarbonIcon {}
export declare class ChartMinimum32 extends CarbonIcon {}
export declare class ChartMultiLine16 extends CarbonIcon {}
export declare class ChartMultiLine20 extends CarbonIcon {}
export declare class ChartMultiLine24 extends CarbonIcon {}
export declare class ChartMultiLine32 extends CarbonIcon {}
export declare class ChartMultitype16 extends CarbonIcon {}
export declare class ChartMultitype20 extends CarbonIcon {}
export declare class ChartMultitype24 extends CarbonIcon {}
export declare class ChartMultitype32 extends CarbonIcon {}
export declare class ChartNetwork16 extends CarbonIcon {}
export declare class ChartNetwork20 extends CarbonIcon {}
export declare class ChartNetwork24 extends CarbonIcon {}
export declare class ChartNetwork32 extends CarbonIcon {}
export declare class ChartParallel16 extends CarbonIcon {}
export declare class ChartParallel20 extends CarbonIcon {}
export declare class ChartParallel24 extends CarbonIcon {}
export declare class ChartParallel32 extends CarbonIcon {}
export declare class ChartPie16 extends CarbonIcon {}
export declare class ChartPie20 extends CarbonIcon {}
export declare class ChartPie24 extends CarbonIcon {}
export declare class ChartPie32 extends CarbonIcon {}
export declare class ChartPoint16 extends CarbonIcon {}
export declare class ChartPoint20 extends CarbonIcon {}
export declare class ChartPoint24 extends CarbonIcon {}
export declare class ChartPoint32 extends CarbonIcon {}
export declare class ChartPopulation16 extends CarbonIcon {}
export declare class ChartPopulation20 extends CarbonIcon {}
export declare class ChartPopulation24 extends CarbonIcon {}
export declare class ChartPopulation32 extends CarbonIcon {}
export declare class ChartRadar16 extends CarbonIcon {}
export declare class ChartRadar20 extends CarbonIcon {}
export declare class ChartRadar24 extends CarbonIcon {}
export declare class ChartRadar32 extends CarbonIcon {}
export declare class ChartRadial16 extends CarbonIcon {}
export declare class ChartRadial20 extends CarbonIcon {}
export declare class ChartRadial24 extends CarbonIcon {}
export declare class ChartRadial32 extends CarbonIcon {}
export declare class ChartRelationship16 extends CarbonIcon {}
export declare class ChartRelationship20 extends CarbonIcon {}
export declare class ChartRelationship24 extends CarbonIcon {}
export declare class ChartRelationship32 extends CarbonIcon {}
export declare class ChartRing16 extends CarbonIcon {}
export declare class ChartRing20 extends CarbonIcon {}
export declare class ChartRing24 extends CarbonIcon {}
export declare class ChartRing32 extends CarbonIcon {}
export declare class ChartRiver16 extends CarbonIcon {}
export declare class ChartRiver20 extends CarbonIcon {}
export declare class ChartRiver24 extends CarbonIcon {}
export declare class ChartRiver32 extends CarbonIcon {}
export declare class ChartRose16 extends CarbonIcon {}
export declare class ChartRose20 extends CarbonIcon {}
export declare class ChartRose24 extends CarbonIcon {}
export declare class ChartRose32 extends CarbonIcon {}
export declare class ChartScatter16 extends CarbonIcon {}
export declare class ChartScatter20 extends CarbonIcon {}
export declare class ChartScatter24 extends CarbonIcon {}
export declare class ChartScatter32 extends CarbonIcon {}
export declare class ChartStacked16 extends CarbonIcon {}
export declare class ChartStacked20 extends CarbonIcon {}
export declare class ChartStacked24 extends CarbonIcon {}
export declare class ChartStacked32 extends CarbonIcon {}
export declare class ChartStepper16 extends CarbonIcon {}
export declare class ChartStepper20 extends CarbonIcon {}
export declare class ChartStepper24 extends CarbonIcon {}
export declare class ChartStepper32 extends CarbonIcon {}
export declare class ChartSunburst16 extends CarbonIcon {}
export declare class ChartSunburst20 extends CarbonIcon {}
export declare class ChartSunburst24 extends CarbonIcon {}
export declare class ChartSunburst32 extends CarbonIcon {}
export declare class ChartTSne16 extends CarbonIcon {}
export declare class ChartTSne20 extends CarbonIcon {}
export declare class ChartTSne24 extends CarbonIcon {}
export declare class ChartTSne32 extends CarbonIcon {}
export declare class ChartTreemap16 extends CarbonIcon {}
export declare class ChartTreemap20 extends CarbonIcon {}
export declare class ChartTreemap24 extends CarbonIcon {}
export declare class ChartTreemap32 extends CarbonIcon {}
export declare class ChartVennDiagram16 extends CarbonIcon {}
export declare class ChartVennDiagram20 extends CarbonIcon {}
export declare class ChartVennDiagram24 extends CarbonIcon {}
export declare class ChartVennDiagram32 extends CarbonIcon {}
export declare class ChartWaterfall16 extends CarbonIcon {}
export declare class ChartWaterfall20 extends CarbonIcon {}
export declare class ChartWaterfall24 extends CarbonIcon {}
export declare class ChartWaterfall32 extends CarbonIcon {}
export declare class Chart_3D16 extends CarbonIcon {}
export declare class Chart_3D20 extends CarbonIcon {}
export declare class Chart_3D24 extends CarbonIcon {}
export declare class Chart_3D32 extends CarbonIcon {}
export declare class Chat16 extends CarbonIcon {}
export declare class Chat20 extends CarbonIcon {}
export declare class Chat24 extends CarbonIcon {}
export declare class Chat32 extends CarbonIcon {}
export declare class ChatBot16 extends CarbonIcon {}
export declare class ChatBot20 extends CarbonIcon {}
export declare class ChatBot24 extends CarbonIcon {}
export declare class ChatBot32 extends CarbonIcon {}
export declare class Checkbox16 extends CarbonIcon {}
export declare class Checkbox20 extends CarbonIcon {}
export declare class Checkbox24 extends CarbonIcon {}
export declare class Checkbox32 extends CarbonIcon {}
export declare class CheckboxChecked16 extends CarbonIcon {}
export declare class CheckboxChecked20 extends CarbonIcon {}
export declare class CheckboxChecked24 extends CarbonIcon {}
export declare class CheckboxChecked32 extends CarbonIcon {}
export declare class CheckboxCheckedFilled16 extends CarbonIcon {}
export declare class CheckboxCheckedFilled20 extends CarbonIcon {}
export declare class CheckboxCheckedFilled24 extends CarbonIcon {}
export declare class CheckboxCheckedFilled32 extends CarbonIcon {}
export declare class CheckboxIndeterminate16 extends CarbonIcon {}
export declare class CheckboxIndeterminate20 extends CarbonIcon {}
export declare class CheckboxIndeterminate24 extends CarbonIcon {}
export declare class CheckboxIndeterminate32 extends CarbonIcon {}
export declare class CheckboxIndeterminateFilled16 extends CarbonIcon {}
export declare class CheckboxIndeterminateFilled20 extends CarbonIcon {}
export declare class CheckboxIndeterminateFilled24 extends CarbonIcon {}
export declare class CheckboxIndeterminateFilled32 extends CarbonIcon {}
export declare class CheckboxUndeterminate16 extends CarbonIcon {}
export declare class CheckboxUndeterminate20 extends CarbonIcon {}
export declare class CheckboxUndeterminate24 extends CarbonIcon {}
export declare class CheckboxUndeterminate32 extends CarbonIcon {}
export declare class CheckboxUndeterminateFilled16 extends CarbonIcon {}
export declare class CheckboxUndeterminateFilled20 extends CarbonIcon {}
export declare class CheckboxUndeterminateFilled24 extends CarbonIcon {}
export declare class CheckboxUndeterminateFilled32 extends CarbonIcon {}
export declare class Checkmark16 extends CarbonIcon {}
export declare class Checkmark20 extends CarbonIcon {}
export declare class Checkmark24 extends CarbonIcon {}
export declare class Checkmark32 extends CarbonIcon {}
export declare class CheckmarkFilled16 extends CarbonIcon {}
export declare class CheckmarkFilled20 extends CarbonIcon {}
export declare class CheckmarkFilled24 extends CarbonIcon {}
export declare class CheckmarkFilled32 extends CarbonIcon {}
export declare class CheckmarkFilledError16 extends CarbonIcon {}
export declare class CheckmarkFilledError20 extends CarbonIcon {}
export declare class CheckmarkFilledError24 extends CarbonIcon {}
export declare class CheckmarkFilledError32 extends CarbonIcon {}
export declare class CheckmarkFilledWarning16 extends CarbonIcon {}
export declare class CheckmarkFilledWarning20 extends CarbonIcon {}
export declare class CheckmarkFilledWarning24 extends CarbonIcon {}
export declare class CheckmarkFilledWarning32 extends CarbonIcon {}
export declare class CheckmarkOutline16 extends CarbonIcon {}
export declare class CheckmarkOutline20 extends CarbonIcon {}
export declare class CheckmarkOutline24 extends CarbonIcon {}
export declare class CheckmarkOutline32 extends CarbonIcon {}
export declare class CheckmarkOutlineError16 extends CarbonIcon {}
export declare class CheckmarkOutlineError20 extends CarbonIcon {}
export declare class CheckmarkOutlineError24 extends CarbonIcon {}
export declare class CheckmarkOutlineError32 extends CarbonIcon {}
export declare class CheckmarkOutlineWarning16 extends CarbonIcon {}
export declare class CheckmarkOutlineWarning20 extends CarbonIcon {}
export declare class CheckmarkOutlineWarning24 extends CarbonIcon {}
export declare class CheckmarkOutlineWarning32 extends CarbonIcon {}
export declare class Chemistry16 extends CarbonIcon {}
export declare class Chemistry20 extends CarbonIcon {}
export declare class Chemistry24 extends CarbonIcon {}
export declare class Chemistry32 extends CarbonIcon {}
export declare class ChemistryReference16 extends CarbonIcon {}
export declare class ChemistryReference20 extends CarbonIcon {}
export declare class ChemistryReference24 extends CarbonIcon {}
export declare class ChemistryReference32 extends CarbonIcon {}
export declare class ChevronDown16 extends CarbonIcon {}
export declare class ChevronDown20 extends CarbonIcon {}
export declare class ChevronDown24 extends CarbonIcon {}
export declare class ChevronDown32 extends CarbonIcon {}
export declare class ChevronDownGlyph extends CarbonIcon {}
export declare class ChevronLeft16 extends CarbonIcon {}
export declare class ChevronLeft20 extends CarbonIcon {}
export declare class ChevronLeft24 extends CarbonIcon {}
export declare class ChevronLeft32 extends CarbonIcon {}
export declare class ChevronLeftGlyph extends CarbonIcon {}
export declare class ChevronMini16 extends CarbonIcon {}
export declare class ChevronMini20 extends CarbonIcon {}
export declare class ChevronMini24 extends CarbonIcon {}
export declare class ChevronMini32 extends CarbonIcon {}
export declare class ChevronRight16 extends CarbonIcon {}
export declare class ChevronRight20 extends CarbonIcon {}
export declare class ChevronRight24 extends CarbonIcon {}
export declare class ChevronRight32 extends CarbonIcon {}
export declare class ChevronRightGlyph extends CarbonIcon {}
export declare class ChevronSort16 extends CarbonIcon {}
export declare class ChevronSort20 extends CarbonIcon {}
export declare class ChevronSort24 extends CarbonIcon {}
export declare class ChevronSort32 extends CarbonIcon {}
export declare class ChevronSortDown16 extends CarbonIcon {}
export declare class ChevronSortDown20 extends CarbonIcon {}
export declare class ChevronSortDown24 extends CarbonIcon {}
export declare class ChevronSortDown32 extends CarbonIcon {}
export declare class ChevronSortUp16 extends CarbonIcon {}
export declare class ChevronSortUp20 extends CarbonIcon {}
export declare class ChevronSortUp24 extends CarbonIcon {}
export declare class ChevronSortUp32 extends CarbonIcon {}
export declare class ChevronUp16 extends CarbonIcon {}
export declare class ChevronUp20 extends CarbonIcon {}
export declare class ChevronUp24 extends CarbonIcon {}
export declare class ChevronUp32 extends CarbonIcon {}
export declare class ChevronUpGlyph extends CarbonIcon {}
export declare class Chip16 extends CarbonIcon {}
export declare class Chip20 extends CarbonIcon {}
export declare class Chip24 extends CarbonIcon {}
export declare class Chip32 extends CarbonIcon {}
export declare class Choices16 extends CarbonIcon {}
export declare class Choices20 extends CarbonIcon {}
export declare class Choices24 extends CarbonIcon {}
export declare class Choices32 extends CarbonIcon {}
export declare class CircleDash16 extends CarbonIcon {}
export declare class CircleDash20 extends CarbonIcon {}
export declare class CircleDash24 extends CarbonIcon {}
export declare class CircleDash32 extends CarbonIcon {}
export declare class CircleFilled16 extends CarbonIcon {}
export declare class CircleFilled20 extends CarbonIcon {}
export declare class CircleFilled24 extends CarbonIcon {}
export declare class CircleFilled32 extends CarbonIcon {}
export declare class CirclePacking16 extends CarbonIcon {}
export declare class CirclePacking20 extends CarbonIcon {}
export declare class CirclePacking24 extends CarbonIcon {}
export declare class CirclePacking32 extends CarbonIcon {}
export declare class Classification16 extends CarbonIcon {}
export declare class Classification20 extends CarbonIcon {}
export declare class Classification24 extends CarbonIcon {}
export declare class Classification32 extends CarbonIcon {}
export declare class ClassifierLanguage16 extends CarbonIcon {}
export declare class ClassifierLanguage20 extends CarbonIcon {}
export declare class ClassifierLanguage24 extends CarbonIcon {}
export declare class ClassifierLanguage32 extends CarbonIcon {}
export declare class Clean16 extends CarbonIcon {}
export declare class Clean20 extends CarbonIcon {}
export declare class Clean24 extends CarbonIcon {}
export declare class Clean32 extends CarbonIcon {}
export declare class Close16 extends CarbonIcon {}
export declare class Close20 extends CarbonIcon {}
export declare class Close24 extends CarbonIcon {}
export declare class Close32 extends CarbonIcon {}
export declare class CloseFilled16 extends CarbonIcon {}
export declare class CloseFilled20 extends CarbonIcon {}
export declare class CloseFilled24 extends CarbonIcon {}
export declare class CloseFilled32 extends CarbonIcon {}
export declare class CloseOutline16 extends CarbonIcon {}
export declare class CloseOutline20 extends CarbonIcon {}
export declare class CloseOutline24 extends CarbonIcon {}
export declare class CloseOutline32 extends CarbonIcon {}
export declare class ClosedCaption16 extends CarbonIcon {}
export declare class ClosedCaption20 extends CarbonIcon {}
export declare class ClosedCaption24 extends CarbonIcon {}
export declare class ClosedCaption32 extends CarbonIcon {}
export declare class ClosedCaptionAlt16 extends CarbonIcon {}
export declare class ClosedCaptionAlt20 extends CarbonIcon {}
export declare class ClosedCaptionAlt24 extends CarbonIcon {}
export declare class ClosedCaptionAlt32 extends CarbonIcon {}
export declare class ClosedCaptionFilled16 extends CarbonIcon {}
export declare class ClosedCaptionFilled20 extends CarbonIcon {}
export declare class ClosedCaptionFilled24 extends CarbonIcon {}
export declare class ClosedCaptionFilled32 extends CarbonIcon {}
export declare class Cloud16 extends CarbonIcon {}
export declare class Cloud20 extends CarbonIcon {}
export declare class Cloud24 extends CarbonIcon {}
export declare class Cloud32 extends CarbonIcon {}
export declare class CloudApp16 extends CarbonIcon {}
export declare class CloudApp20 extends CarbonIcon {}
export declare class CloudApp24 extends CarbonIcon {}
export declare class CloudApp32 extends CarbonIcon {}
export declare class CloudCeiling16 extends CarbonIcon {}
export declare class CloudCeiling20 extends CarbonIcon {}
export declare class CloudCeiling24 extends CarbonIcon {}
export declare class CloudCeiling32 extends CarbonIcon {}
export declare class CloudDataOps16 extends CarbonIcon {}
export declare class CloudDataOps20 extends CarbonIcon {}
export declare class CloudDataOps24 extends CarbonIcon {}
export declare class CloudDataOps32 extends CarbonIcon {}
export declare class CloudDownload16 extends CarbonIcon {}
export declare class CloudDownload20 extends CarbonIcon {}
export declare class CloudDownload24 extends CarbonIcon {}
export declare class CloudDownload32 extends CarbonIcon {}
export declare class CloudFoundry_116 extends CarbonIcon {}
export declare class CloudFoundry_120 extends CarbonIcon {}
export declare class CloudFoundry_124 extends CarbonIcon {}
export declare class CloudFoundry_132 extends CarbonIcon {}
export declare class CloudFoundry_216 extends CarbonIcon {}
export declare class CloudFoundry_220 extends CarbonIcon {}
export declare class CloudFoundry_224 extends CarbonIcon {}
export declare class CloudFoundry_232 extends CarbonIcon {}
export declare class CloudLightning16 extends CarbonIcon {}
export declare class CloudLightning20 extends CarbonIcon {}
export declare class CloudLightning24 extends CarbonIcon {}
export declare class CloudLightning32 extends CarbonIcon {}
export declare class CloudRain16 extends CarbonIcon {}
export declare class CloudRain20 extends CarbonIcon {}
export declare class CloudRain24 extends CarbonIcon {}
export declare class CloudRain32 extends CarbonIcon {}
export declare class CloudSatellite16 extends CarbonIcon {}
export declare class CloudSatellite20 extends CarbonIcon {}
export declare class CloudSatellite24 extends CarbonIcon {}
export declare class CloudSatellite32 extends CarbonIcon {}
export declare class CloudSnow16 extends CarbonIcon {}
export declare class CloudSnow20 extends CarbonIcon {}
export declare class CloudSnow24 extends CarbonIcon {}
export declare class CloudSnow32 extends CarbonIcon {}
export declare class CloudUpload16 extends CarbonIcon {}
export declare class CloudUpload20 extends CarbonIcon {}
export declare class CloudUpload24 extends CarbonIcon {}
export declare class CloudUpload32 extends CarbonIcon {}
export declare class Cloudy16 extends CarbonIcon {}
export declare class Cloudy20 extends CarbonIcon {}
export declare class Cloudy24 extends CarbonIcon {}
export declare class Cloudy32 extends CarbonIcon {}
export declare class Code16 extends CarbonIcon {}
export declare class Code20 extends CarbonIcon {}
export declare class Code24 extends CarbonIcon {}
export declare class Code32 extends CarbonIcon {}
export declare class CodeReference16 extends CarbonIcon {}
export declare class CodeReference20 extends CarbonIcon {}
export declare class CodeReference24 extends CarbonIcon {}
export declare class CodeReference32 extends CarbonIcon {}
export declare class Cognitive16 extends CarbonIcon {}
export declare class Cognitive20 extends CarbonIcon {}
export declare class Cognitive24 extends CarbonIcon {}
export declare class Cognitive32 extends CarbonIcon {}
export declare class Collaborate16 extends CarbonIcon {}
export declare class Collaborate20 extends CarbonIcon {}
export declare class Collaborate24 extends CarbonIcon {}
export declare class Collaborate32 extends CarbonIcon {}
export declare class CollapseAll16 extends CarbonIcon {}
export declare class CollapseAll20 extends CarbonIcon {}
export declare class CollapseAll24 extends CarbonIcon {}
export declare class CollapseAll32 extends CarbonIcon {}
export declare class CollapseCategories16 extends CarbonIcon {}
export declare class CollapseCategories20 extends CarbonIcon {}
export declare class CollapseCategories24 extends CarbonIcon {}
export declare class CollapseCategories32 extends CarbonIcon {}
export declare class ColorPalette16 extends CarbonIcon {}
export declare class ColorPalette20 extends CarbonIcon {}
export declare class ColorPalette24 extends CarbonIcon {}
export declare class ColorPalette32 extends CarbonIcon {}
export declare class ColorSwitch16 extends CarbonIcon {}
export declare class ColorSwitch20 extends CarbonIcon {}
export declare class ColorSwitch24 extends CarbonIcon {}
export declare class ColorSwitch32 extends CarbonIcon {}
export declare class Column16 extends CarbonIcon {}
export declare class Column20 extends CarbonIcon {}
export declare class Column24 extends CarbonIcon {}
export declare class Column32 extends CarbonIcon {}
export declare class ColumnDelete16 extends CarbonIcon {}
export declare class ColumnDelete20 extends CarbonIcon {}
export declare class ColumnDelete24 extends CarbonIcon {}
export declare class ColumnDelete32 extends CarbonIcon {}
export declare class ColumnInsert16 extends CarbonIcon {}
export declare class ColumnInsert20 extends CarbonIcon {}
export declare class ColumnInsert24 extends CarbonIcon {}
export declare class ColumnInsert32 extends CarbonIcon {}
export declare class Compare16 extends CarbonIcon {}
export declare class Compare20 extends CarbonIcon {}
export declare class Compare24 extends CarbonIcon {}
export declare class Compare32 extends CarbonIcon {}
export declare class Compass16 extends CarbonIcon {}
export declare class Compass20 extends CarbonIcon {}
export declare class Compass24 extends CarbonIcon {}
export declare class Compass32 extends CarbonIcon {}
export declare class Concept16 extends CarbonIcon {}
export declare class Concept20 extends CarbonIcon {}
export declare class Concept24 extends CarbonIcon {}
export declare class Concept32 extends CarbonIcon {}
export declare class Connect16 extends CarbonIcon {}
export declare class Connect20 extends CarbonIcon {}
export declare class Connect24 extends CarbonIcon {}
export declare class Connect32 extends CarbonIcon {}
export declare class ConnectionSignal16 extends CarbonIcon {}
export declare class ConnectionSignal20 extends CarbonIcon {}
export declare class ConnectionSignal24 extends CarbonIcon {}
export declare class ConnectionSignal32 extends CarbonIcon {}
export declare class Construction16 extends CarbonIcon {}
export declare class Construction20 extends CarbonIcon {}
export declare class Construction24 extends CarbonIcon {}
export declare class Construction32 extends CarbonIcon {}
export declare class ContainerSoftware16 extends CarbonIcon {}
export declare class ContainerSoftware20 extends CarbonIcon {}
export declare class ContainerSoftware24 extends CarbonIcon {}
export declare class ContainerSoftware32 extends CarbonIcon {}
export declare class ContentView16 extends CarbonIcon {}
export declare class ContentView20 extends CarbonIcon {}
export declare class ContentView24 extends CarbonIcon {}
export declare class ContentView32 extends CarbonIcon {}
export declare class Contrast16 extends CarbonIcon {}
export declare class Contrast20 extends CarbonIcon {}
export declare class Contrast24 extends CarbonIcon {}
export declare class Contrast32 extends CarbonIcon {}
export declare class Copy16 extends CarbonIcon {}
export declare class Copy20 extends CarbonIcon {}
export declare class Copy24 extends CarbonIcon {}
export declare class Copy32 extends CarbonIcon {}
export declare class CopyFile16 extends CarbonIcon {}
export declare class CopyFile20 extends CarbonIcon {}
export declare class CopyFile24 extends CarbonIcon {}
export declare class CopyFile32 extends CarbonIcon {}
export declare class CopyLink16 extends CarbonIcon {}
export declare class CopyLink20 extends CarbonIcon {}
export declare class CopyLink24 extends CarbonIcon {}
export declare class CopyLink32 extends CarbonIcon {}
export declare class Corn16 extends CarbonIcon {}
export declare class Corn20 extends CarbonIcon {}
export declare class Corn24 extends CarbonIcon {}
export declare class Corn32 extends CarbonIcon {}
export declare class Corner16 extends CarbonIcon {}
export declare class Corner20 extends CarbonIcon {}
export declare class Corner24 extends CarbonIcon {}
export declare class Corner32 extends CarbonIcon {}
export declare class Coronavirus16 extends CarbonIcon {}
export declare class Coronavirus20 extends CarbonIcon {}
export declare class Coronavirus24 extends CarbonIcon {}
export declare class Coronavirus32 extends CarbonIcon {}
export declare class Course16 extends CarbonIcon {}
export declare class Course20 extends CarbonIcon {}
export declare class Course24 extends CarbonIcon {}
export declare class Course32 extends CarbonIcon {}
export declare class Covariate16 extends CarbonIcon {}
export declare class Covariate20 extends CarbonIcon {}
export declare class Covariate24 extends CarbonIcon {}
export declare class Covariate32 extends CarbonIcon {}
export declare class Credentials16 extends CarbonIcon {}
export declare class Credentials20 extends CarbonIcon {}
export declare class Credentials24 extends CarbonIcon {}
export declare class Credentials32 extends CarbonIcon {}
export declare class Crop16 extends CarbonIcon {}
export declare class Crop20 extends CarbonIcon {}
export declare class Crop24 extends CarbonIcon {}
export declare class Crop32 extends CarbonIcon {}
export declare class CropGrowth16 extends CarbonIcon {}
export declare class CropGrowth20 extends CarbonIcon {}
export declare class CropGrowth24 extends CarbonIcon {}
export declare class CropGrowth32 extends CarbonIcon {}
export declare class CropHealth16 extends CarbonIcon {}
export declare class CropHealth20 extends CarbonIcon {}
export declare class CropHealth24 extends CarbonIcon {}
export declare class CropHealth32 extends CarbonIcon {}
export declare class CrossTab16 extends CarbonIcon {}
export declare class CrossTab20 extends CarbonIcon {}
export declare class CrossTab24 extends CarbonIcon {}
export declare class CrossTab32 extends CarbonIcon {}
export declare class Crossroads16 extends CarbonIcon {}
export declare class Crossroads20 extends CarbonIcon {}
export declare class Crossroads24 extends CarbonIcon {}
export declare class Crossroads32 extends CarbonIcon {}
export declare class CrowdReport16 extends CarbonIcon {}
export declare class CrowdReport20 extends CarbonIcon {}
export declare class CrowdReport24 extends CarbonIcon {}
export declare class CrowdReport32 extends CarbonIcon {}
export declare class CrowdReportFilled16 extends CarbonIcon {}
export declare class CrowdReportFilled20 extends CarbonIcon {}
export declare class CrowdReportFilled24 extends CarbonIcon {}
export declare class CrowdReportFilled32 extends CarbonIcon {}
export declare class Csv16 extends CarbonIcon {}
export declare class Csv20 extends CarbonIcon {}
export declare class Csv24 extends CarbonIcon {}
export declare class Csv32 extends CarbonIcon {}
export declare class CubeView16 extends CarbonIcon {}
export declare class CubeView20 extends CarbonIcon {}
export declare class CubeView24 extends CarbonIcon {}
export declare class CubeView32 extends CarbonIcon {}
export declare class CurrencyBaht16 extends CarbonIcon {}
export declare class CurrencyBaht20 extends CarbonIcon {}
export declare class CurrencyBaht24 extends CarbonIcon {}
export declare class CurrencyBaht32 extends CarbonIcon {}
export declare class CurrencyDollar16 extends CarbonIcon {}
export declare class CurrencyDollar20 extends CarbonIcon {}
export declare class CurrencyDollar24 extends CarbonIcon {}
export declare class CurrencyDollar32 extends CarbonIcon {}
export declare class CurrencyEuro16 extends CarbonIcon {}
export declare class CurrencyEuro20 extends CarbonIcon {}
export declare class CurrencyEuro24 extends CarbonIcon {}
export declare class CurrencyEuro32 extends CarbonIcon {}
export declare class CurrencyLira16 extends CarbonIcon {}
export declare class CurrencyLira20 extends CarbonIcon {}
export declare class CurrencyLira24 extends CarbonIcon {}
export declare class CurrencyLira32 extends CarbonIcon {}
export declare class CurrencyPound16 extends CarbonIcon {}
export declare class CurrencyPound20 extends CarbonIcon {}
export declare class CurrencyPound24 extends CarbonIcon {}
export declare class CurrencyPound32 extends CarbonIcon {}
export declare class CurrencyRupee16 extends CarbonIcon {}
export declare class CurrencyRupee20 extends CarbonIcon {}
export declare class CurrencyRupee24 extends CarbonIcon {}
export declare class CurrencyRupee32 extends CarbonIcon {}
export declare class CurrencyShekel16 extends CarbonIcon {}
export declare class CurrencyShekel20 extends CarbonIcon {}
export declare class CurrencyShekel24 extends CarbonIcon {}
export declare class CurrencyShekel32 extends CarbonIcon {}
export declare class CurrencyWon16 extends CarbonIcon {}
export declare class CurrencyWon20 extends CarbonIcon {}
export declare class CurrencyWon24 extends CarbonIcon {}
export declare class CurrencyWon32 extends CarbonIcon {}
export declare class CurrencyYen16 extends CarbonIcon {}
export declare class CurrencyYen20 extends CarbonIcon {}
export declare class CurrencyYen24 extends CarbonIcon {}
export declare class CurrencyYen32 extends CarbonIcon {}
export declare class Cursor_116 extends CarbonIcon {}
export declare class Cursor_120 extends CarbonIcon {}
export declare class Cursor_124 extends CarbonIcon {}
export declare class Cursor_132 extends CarbonIcon {}
export declare class Cursor_216 extends CarbonIcon {}
export declare class Cursor_220 extends CarbonIcon {}
export declare class Cursor_224 extends CarbonIcon {}
export declare class Cursor_232 extends CarbonIcon {}
export declare class Cut16 extends CarbonIcon {}
export declare class Cut20 extends CarbonIcon {}
export declare class Cut24 extends CarbonIcon {}
export declare class Cut32 extends CarbonIcon {}
export declare class Cyclist16 extends CarbonIcon {}
export declare class Cyclist20 extends CarbonIcon {}
export declare class Cyclist24 extends CarbonIcon {}
export declare class Cyclist32 extends CarbonIcon {}
export declare class Dashboard16 extends CarbonIcon {}
export declare class Dashboard20 extends CarbonIcon {}
export declare class Dashboard24 extends CarbonIcon {}
export declare class Dashboard32 extends CarbonIcon {}
export declare class DashboardReference16 extends CarbonIcon {}
export declare class DashboardReference20 extends CarbonIcon {}
export declare class DashboardReference24 extends CarbonIcon {}
export declare class DashboardReference32 extends CarbonIcon {}
export declare class DataBase16 extends CarbonIcon {}
export declare class DataBase20 extends CarbonIcon {}
export declare class DataBase24 extends CarbonIcon {}
export declare class DataBase32 extends CarbonIcon {}
export declare class DataBaseAlt16 extends CarbonIcon {}
export declare class DataBaseAlt20 extends CarbonIcon {}
export declare class DataBaseAlt24 extends CarbonIcon {}
export declare class DataBaseAlt32 extends CarbonIcon {}
export declare class DataCheck16 extends CarbonIcon {}
export declare class DataCheck20 extends CarbonIcon {}
export declare class DataCheck24 extends CarbonIcon {}
export declare class DataCheck32 extends CarbonIcon {}
export declare class DataClass16 extends CarbonIcon {}
export declare class DataClass20 extends CarbonIcon {}
export declare class DataClass24 extends CarbonIcon {}
export declare class DataClass32 extends CarbonIcon {}
export declare class DataCollection16 extends CarbonIcon {}
export declare class DataCollection20 extends CarbonIcon {}
export declare class DataCollection24 extends CarbonIcon {}
export declare class DataCollection32 extends CarbonIcon {}
export declare class DataConnected16 extends CarbonIcon {}
export declare class DataConnected20 extends CarbonIcon {}
export declare class DataConnected24 extends CarbonIcon {}
export declare class DataConnected32 extends CarbonIcon {}
export declare class DataError16 extends CarbonIcon {}
export declare class DataError20 extends CarbonIcon {}
export declare class DataError24 extends CarbonIcon {}
export declare class DataError32 extends CarbonIcon {}
export declare class DataPlayer16 extends CarbonIcon {}
export declare class DataPlayer20 extends CarbonIcon {}
export declare class DataPlayer24 extends CarbonIcon {}
export declare class DataPlayer32 extends CarbonIcon {}
export declare class DataReference16 extends CarbonIcon {}
export declare class DataReference20 extends CarbonIcon {}
export declare class DataReference24 extends CarbonIcon {}
export declare class DataReference32 extends CarbonIcon {}
export declare class DataRefinery16 extends CarbonIcon {}
export declare class DataRefinery20 extends CarbonIcon {}
export declare class DataRefinery24 extends CarbonIcon {}
export declare class DataRefinery32 extends CarbonIcon {}
export declare class DataRefineryReference16 extends CarbonIcon {}
export declare class DataRefineryReference20 extends CarbonIcon {}
export declare class DataRefineryReference24 extends CarbonIcon {}
export declare class DataRefineryReference32 extends CarbonIcon {}
export declare class DataSet16 extends CarbonIcon {}
export declare class DataSet20 extends CarbonIcon {}
export declare class DataSet24 extends CarbonIcon {}
export declare class DataSet32 extends CarbonIcon {}
export declare class DataShare16 extends CarbonIcon {}
export declare class DataShare20 extends CarbonIcon {}
export declare class DataShare24 extends CarbonIcon {}
export declare class DataShare32 extends CarbonIcon {}
export declare class DataStructured16 extends CarbonIcon {}
export declare class DataStructured20 extends CarbonIcon {}
export declare class DataStructured24 extends CarbonIcon {}
export declare class DataStructured32 extends CarbonIcon {}
export declare class DataTable16 extends CarbonIcon {}
export declare class DataTable20 extends CarbonIcon {}
export declare class DataTable24 extends CarbonIcon {}
export declare class DataTable32 extends CarbonIcon {}
export declare class DataTableReference16 extends CarbonIcon {}
export declare class DataTableReference20 extends CarbonIcon {}
export declare class DataTableReference24 extends CarbonIcon {}
export declare class DataTableReference32 extends CarbonIcon {}
export declare class DataUnstructured16 extends CarbonIcon {}
export declare class DataUnstructured20 extends CarbonIcon {}
export declare class DataUnstructured24 extends CarbonIcon {}
export declare class DataUnstructured32 extends CarbonIcon {}
export declare class DataVis_116 extends CarbonIcon {}
export declare class DataVis_120 extends CarbonIcon {}
export declare class DataVis_124 extends CarbonIcon {}
export declare class DataVis_132 extends CarbonIcon {}
export declare class DataVis_216 extends CarbonIcon {}
export declare class DataVis_220 extends CarbonIcon {}
export declare class DataVis_224 extends CarbonIcon {}
export declare class DataVis_232 extends CarbonIcon {}
export declare class DataVis_316 extends CarbonIcon {}
export declare class DataVis_320 extends CarbonIcon {}
export declare class DataVis_324 extends CarbonIcon {}
export declare class DataVis_332 extends CarbonIcon {}
export declare class DataVis_416 extends CarbonIcon {}
export declare class DataVis_420 extends CarbonIcon {}
export declare class DataVis_424 extends CarbonIcon {}
export declare class DataVis_432 extends CarbonIcon {}
export declare class Data_116 extends CarbonIcon {}
export declare class Data_120 extends CarbonIcon {}
export declare class Data_124 extends CarbonIcon {}
export declare class Data_132 extends CarbonIcon {}
export declare class Data_216 extends CarbonIcon {}
export declare class Data_220 extends CarbonIcon {}
export declare class Data_224 extends CarbonIcon {}
export declare class Data_232 extends CarbonIcon {}
export declare class Datastore16 extends CarbonIcon {}
export declare class Datastore20 extends CarbonIcon {}
export declare class Datastore24 extends CarbonIcon {}
export declare class Datastore32 extends CarbonIcon {}
export declare class Debug16 extends CarbonIcon {}
export declare class Debug20 extends CarbonIcon {}
export declare class Debug24 extends CarbonIcon {}
export declare class Debug32 extends CarbonIcon {}
export declare class DecisionTree16 extends CarbonIcon {}
export declare class DecisionTree20 extends CarbonIcon {}
export declare class DecisionTree24 extends CarbonIcon {}
export declare class DecisionTree32 extends CarbonIcon {}
export declare class Delete16 extends CarbonIcon {}
export declare class Delete20 extends CarbonIcon {}
export declare class Delete24 extends CarbonIcon {}
export declare class Delete32 extends CarbonIcon {}
export declare class DeliveryTruck16 extends CarbonIcon {}
export declare class DeliveryTruck20 extends CarbonIcon {}
export declare class DeliveryTruck24 extends CarbonIcon {}
export declare class DeliveryTruck32 extends CarbonIcon {}
export declare class Departure16 extends CarbonIcon {}
export declare class Departure20 extends CarbonIcon {}
export declare class Departure24 extends CarbonIcon {}
export declare class Departure32 extends CarbonIcon {}
export declare class Deploy16 extends CarbonIcon {}
export declare class Deploy20 extends CarbonIcon {}
export declare class Deploy24 extends CarbonIcon {}
export declare class Deploy32 extends CarbonIcon {}
export declare class DeployRules16 extends CarbonIcon {}
export declare class DeployRules20 extends CarbonIcon {}
export declare class DeployRules24 extends CarbonIcon {}
export declare class DeployRules32 extends CarbonIcon {}
export declare class DeploymentPattern16 extends CarbonIcon {}
export declare class DeploymentPattern20 extends CarbonIcon {}
export declare class DeploymentPattern24 extends CarbonIcon {}
export declare class DeploymentPattern32 extends CarbonIcon {}
export declare class DeploymentPolicy16 extends CarbonIcon {}
export declare class DeploymentPolicy20 extends CarbonIcon {}
export declare class DeploymentPolicy24 extends CarbonIcon {}
export declare class DeploymentPolicy32 extends CarbonIcon {}
export declare class Development16 extends CarbonIcon {}
export declare class Development20 extends CarbonIcon {}
export declare class Development24 extends CarbonIcon {}
export declare class Development32 extends CarbonIcon {}
export declare class Devices16 extends CarbonIcon {}
export declare class Devices20 extends CarbonIcon {}
export declare class Devices24 extends CarbonIcon {}
export declare class Devices32 extends CarbonIcon {}
export declare class DewPoint16 extends CarbonIcon {}
export declare class DewPoint20 extends CarbonIcon {}
export declare class DewPoint24 extends CarbonIcon {}
export declare class DewPoint32 extends CarbonIcon {}
export declare class DewPointFilled16 extends CarbonIcon {}
export declare class DewPointFilled20 extends CarbonIcon {}
export declare class DewPointFilled24 extends CarbonIcon {}
export declare class DewPointFilled32 extends CarbonIcon {}
export declare class Diagram16 extends CarbonIcon {}
export declare class Diagram20 extends CarbonIcon {}
export declare class Diagram24 extends CarbonIcon {}
export declare class Diagram32 extends CarbonIcon {}
export declare class DiagramReference16 extends CarbonIcon {}
export declare class DiagramReference20 extends CarbonIcon {}
export declare class DiagramReference24 extends CarbonIcon {}
export declare class DiagramReference32 extends CarbonIcon {}
export declare class DirectionBearRight_0116 extends CarbonIcon {}
export declare class DirectionBearRight_0120 extends CarbonIcon {}
export declare class DirectionBearRight_0124 extends CarbonIcon {}
export declare class DirectionBearRight_0132 extends CarbonIcon {}
export declare class DirectionBearRight_01Filled16 extends CarbonIcon {}
export declare class DirectionBearRight_01Filled20 extends CarbonIcon {}
export declare class DirectionBearRight_01Filled24 extends CarbonIcon {}
export declare class DirectionBearRight_01Filled32 extends CarbonIcon {}
export declare class DirectionBearRight_0216 extends CarbonIcon {}
export declare class DirectionBearRight_0220 extends CarbonIcon {}
export declare class DirectionBearRight_0224 extends CarbonIcon {}
export declare class DirectionBearRight_0232 extends CarbonIcon {}
export declare class DirectionBearRight_02Filled16 extends CarbonIcon {}
export declare class DirectionBearRight_02Filled20 extends CarbonIcon {}
export declare class DirectionBearRight_02Filled24 extends CarbonIcon {}
export declare class DirectionBearRight_02Filled32 extends CarbonIcon {}
export declare class DirectionCurve16 extends CarbonIcon {}
export declare class DirectionCurve20 extends CarbonIcon {}
export declare class DirectionCurve24 extends CarbonIcon {}
export declare class DirectionCurve32 extends CarbonIcon {}
export declare class DirectionCurveFilled16 extends CarbonIcon {}
export declare class DirectionCurveFilled20 extends CarbonIcon {}
export declare class DirectionCurveFilled24 extends CarbonIcon {}
export declare class DirectionCurveFilled32 extends CarbonIcon {}
export declare class DirectionMerge16 extends CarbonIcon {}
export declare class DirectionMerge20 extends CarbonIcon {}
export declare class DirectionMerge24 extends CarbonIcon {}
export declare class DirectionMerge32 extends CarbonIcon {}
export declare class DirectionMergeFilled16 extends CarbonIcon {}
export declare class DirectionMergeFilled20 extends CarbonIcon {}
export declare class DirectionMergeFilled24 extends CarbonIcon {}
export declare class DirectionMergeFilled32 extends CarbonIcon {}
export declare class DirectionRight_0116 extends CarbonIcon {}
export declare class DirectionRight_0120 extends CarbonIcon {}
export declare class DirectionRight_0124 extends CarbonIcon {}
export declare class DirectionRight_0132 extends CarbonIcon {}
export declare class DirectionRight_01Filled16 extends CarbonIcon {}
export declare class DirectionRight_01Filled20 extends CarbonIcon {}
export declare class DirectionRight_01Filled24 extends CarbonIcon {}
export declare class DirectionRight_01Filled32 extends CarbonIcon {}
export declare class DirectionRight_0216 extends CarbonIcon {}
export declare class DirectionRight_0220 extends CarbonIcon {}
export declare class DirectionRight_0224 extends CarbonIcon {}
export declare class DirectionRight_0232 extends CarbonIcon {}
export declare class DirectionRight_02Filled16 extends CarbonIcon {}
export declare class DirectionRight_02Filled20 extends CarbonIcon {}
export declare class DirectionRight_02Filled24 extends CarbonIcon {}
export declare class DirectionRight_02Filled32 extends CarbonIcon {}
export declare class DirectionRotaryFirstRight16 extends CarbonIcon {}
export declare class DirectionRotaryFirstRight20 extends CarbonIcon {}
export declare class DirectionRotaryFirstRight24 extends CarbonIcon {}
export declare class DirectionRotaryFirstRight32 extends CarbonIcon {}
export declare class DirectionRotaryFirstRightFilled16 extends CarbonIcon {}
export declare class DirectionRotaryFirstRightFilled20 extends CarbonIcon {}
export declare class DirectionRotaryFirstRightFilled24 extends CarbonIcon {}
export declare class DirectionRotaryFirstRightFilled32 extends CarbonIcon {}
export declare class DirectionRotaryRight16 extends CarbonIcon {}
export declare class DirectionRotaryRight20 extends CarbonIcon {}
export declare class DirectionRotaryRight24 extends CarbonIcon {}
export declare class DirectionRotaryRight32 extends CarbonIcon {}
export declare class DirectionRotaryRightFilled16 extends CarbonIcon {}
export declare class DirectionRotaryRightFilled20 extends CarbonIcon {}
export declare class DirectionRotaryRightFilled24 extends CarbonIcon {}
export declare class DirectionRotaryRightFilled32 extends CarbonIcon {}
export declare class DirectionRotaryStraight16 extends CarbonIcon {}
export declare class DirectionRotaryStraight20 extends CarbonIcon {}
export declare class DirectionRotaryStraight24 extends CarbonIcon {}
export declare class DirectionRotaryStraight32 extends CarbonIcon {}
export declare class DirectionRotaryStraightFilled16 extends CarbonIcon {}
export declare class DirectionRotaryStraightFilled20 extends CarbonIcon {}
export declare class DirectionRotaryStraightFilled24 extends CarbonIcon {}
export declare class DirectionRotaryStraightFilled32 extends CarbonIcon {}
export declare class DirectionSharpTurn16 extends CarbonIcon {}
export declare class DirectionSharpTurn20 extends CarbonIcon {}
export declare class DirectionSharpTurn24 extends CarbonIcon {}
export declare class DirectionSharpTurn32 extends CarbonIcon {}
export declare class DirectionSharpTurnFilled16 extends CarbonIcon {}
export declare class DirectionSharpTurnFilled20 extends CarbonIcon {}
export declare class DirectionSharpTurnFilled24 extends CarbonIcon {}
export declare class DirectionSharpTurnFilled32 extends CarbonIcon {}
export declare class DirectionStraight16 extends CarbonIcon {}
export declare class DirectionStraight20 extends CarbonIcon {}
export declare class DirectionStraight24 extends CarbonIcon {}
export declare class DirectionStraight32 extends CarbonIcon {}
export declare class DirectionStraightFilled16 extends CarbonIcon {}
export declare class DirectionStraightFilled20 extends CarbonIcon {}
export declare class DirectionStraightFilled24 extends CarbonIcon {}
export declare class DirectionStraightFilled32 extends CarbonIcon {}
export declare class DirectionStraightRight16 extends CarbonIcon {}
export declare class DirectionStraightRight20 extends CarbonIcon {}
export declare class DirectionStraightRight24 extends CarbonIcon {}
export declare class DirectionStraightRight32 extends CarbonIcon {}
export declare class DirectionStraightRightFilled16 extends CarbonIcon {}
export declare class DirectionStraightRightFilled20 extends CarbonIcon {}
export declare class DirectionStraightRightFilled24 extends CarbonIcon {}
export declare class DirectionStraightRightFilled32 extends CarbonIcon {}
export declare class DirectionUTurn16 extends CarbonIcon {}
export declare class DirectionUTurn20 extends CarbonIcon {}
export declare class DirectionUTurn24 extends CarbonIcon {}
export declare class DirectionUTurn32 extends CarbonIcon {}
export declare class DirectionUTurnFilled16 extends CarbonIcon {}
export declare class DirectionUTurnFilled20 extends CarbonIcon {}
export declare class DirectionUTurnFilled24 extends CarbonIcon {}
export declare class DirectionUTurnFilled32 extends CarbonIcon {}
export declare class DistributeHorizontalCenter16 extends CarbonIcon {}
export declare class DistributeHorizontalCenter20 extends CarbonIcon {}
export declare class DistributeHorizontalCenter24 extends CarbonIcon {}
export declare class DistributeHorizontalCenter32 extends CarbonIcon {}
export declare class DistributeHorizontalLeft16 extends CarbonIcon {}
export declare class DistributeHorizontalLeft20 extends CarbonIcon {}
export declare class DistributeHorizontalLeft24 extends CarbonIcon {}
export declare class DistributeHorizontalLeft32 extends CarbonIcon {}
export declare class DistributeHorizontalRight16 extends CarbonIcon {}
export declare class DistributeHorizontalRight20 extends CarbonIcon {}
export declare class DistributeHorizontalRight24 extends CarbonIcon {}
export declare class DistributeHorizontalRight32 extends CarbonIcon {}
export declare class DistributeVerticalBottom16 extends CarbonIcon {}
export declare class DistributeVerticalBottom20 extends CarbonIcon {}
export declare class DistributeVerticalBottom24 extends CarbonIcon {}
export declare class DistributeVerticalBottom32 extends CarbonIcon {}
export declare class DistributeVerticalCenter16 extends CarbonIcon {}
export declare class DistributeVerticalCenter20 extends CarbonIcon {}
export declare class DistributeVerticalCenter24 extends CarbonIcon {}
export declare class DistributeVerticalCenter32 extends CarbonIcon {}
export declare class DistributeVerticalTop16 extends CarbonIcon {}
export declare class DistributeVerticalTop20 extends CarbonIcon {}
export declare class DistributeVerticalTop24 extends CarbonIcon {}
export declare class DistributeVerticalTop32 extends CarbonIcon {}
export declare class Doc16 extends CarbonIcon {}
export declare class Doc20 extends CarbonIcon {}
export declare class Doc24 extends CarbonIcon {}
export declare class Doc32 extends CarbonIcon {}
export declare class Document16 extends CarbonIcon {}
export declare class Document20 extends CarbonIcon {}
export declare class Document24 extends CarbonIcon {}
export declare class Document32 extends CarbonIcon {}
export declare class DocumentAdd16 extends CarbonIcon {}
export declare class DocumentAdd20 extends CarbonIcon {}
export declare class DocumentAdd24 extends CarbonIcon {}
export declare class DocumentAdd32 extends CarbonIcon {}
export declare class DocumentBlank16 extends CarbonIcon {}
export declare class DocumentBlank20 extends CarbonIcon {}
export declare class DocumentBlank24 extends CarbonIcon {}
export declare class DocumentBlank32 extends CarbonIcon {}
export declare class DocumentDownload16 extends CarbonIcon {}
export declare class DocumentDownload20 extends CarbonIcon {}
export declare class DocumentDownload24 extends CarbonIcon {}
export declare class DocumentDownload32 extends CarbonIcon {}
export declare class DocumentExport16 extends CarbonIcon {}
export declare class DocumentExport20 extends CarbonIcon {}
export declare class DocumentExport24 extends CarbonIcon {}
export declare class DocumentExport32 extends CarbonIcon {}
export declare class DocumentImport16 extends CarbonIcon {}
export declare class DocumentImport20 extends CarbonIcon {}
export declare class DocumentImport24 extends CarbonIcon {}
export declare class DocumentImport32 extends CarbonIcon {}
export declare class DocumentPdf16 extends CarbonIcon {}
export declare class DocumentPdf20 extends CarbonIcon {}
export declare class DocumentPdf24 extends CarbonIcon {}
export declare class DocumentPdf32 extends CarbonIcon {}
export declare class DocumentSentiment16 extends CarbonIcon {}
export declare class DocumentSentiment20 extends CarbonIcon {}
export declare class DocumentSentiment24 extends CarbonIcon {}
export declare class DocumentSentiment32 extends CarbonIcon {}
export declare class DocumentSubtract16 extends CarbonIcon {}
export declare class DocumentSubtract20 extends CarbonIcon {}
export declare class DocumentSubtract24 extends CarbonIcon {}
export declare class DocumentSubtract32 extends CarbonIcon {}
export declare class DocumentTasks16 extends CarbonIcon {}
export declare class DocumentTasks20 extends CarbonIcon {}
export declare class DocumentTasks24 extends CarbonIcon {}
export declare class DocumentTasks32 extends CarbonIcon {}
export declare class DocumentUnknown16 extends CarbonIcon {}
export declare class DocumentUnknown20 extends CarbonIcon {}
export declare class DocumentUnknown24 extends CarbonIcon {}
export declare class DocumentUnknown32 extends CarbonIcon {}
export declare class DocumentView16 extends CarbonIcon {}
export declare class DocumentView20 extends CarbonIcon {}
export declare class DocumentView24 extends CarbonIcon {}
export declare class DocumentView32 extends CarbonIcon {}
export declare class DocumentWordProcessor16 extends CarbonIcon {}
export declare class DocumentWordProcessor20 extends CarbonIcon {}
export declare class DocumentWordProcessor24 extends CarbonIcon {}
export declare class DocumentWordProcessor32 extends CarbonIcon {}
export declare class DocumentWordProcessorReference16 extends CarbonIcon {}
export declare class DocumentWordProcessorReference20 extends CarbonIcon {}
export declare class DocumentWordProcessorReference24 extends CarbonIcon {}
export declare class DocumentWordProcessorReference32 extends CarbonIcon {}
export declare class DotMark16 extends CarbonIcon {}
export declare class DotMark20 extends CarbonIcon {}
export declare class DotMark24 extends CarbonIcon {}
export declare class DotMark32 extends CarbonIcon {}
export declare class DoubleInteger16 extends CarbonIcon {}
export declare class DoubleInteger20 extends CarbonIcon {}
export declare class DoubleInteger24 extends CarbonIcon {}
export declare class DoubleInteger32 extends CarbonIcon {}
export declare class DownToBottom16 extends CarbonIcon {}
export declare class DownToBottom20 extends CarbonIcon {}
export declare class DownToBottom24 extends CarbonIcon {}
export declare class DownToBottom32 extends CarbonIcon {}
export declare class Download16 extends CarbonIcon {}
export declare class Download20 extends CarbonIcon {}
export declare class Download24 extends CarbonIcon {}
export declare class Download32 extends CarbonIcon {}
export declare class DragHorizontal16 extends CarbonIcon {}
export declare class DragHorizontal20 extends CarbonIcon {}
export declare class DragHorizontal24 extends CarbonIcon {}
export declare class DragHorizontal32 extends CarbonIcon {}
export declare class DragVertical16 extends CarbonIcon {}
export declare class DragVertical20 extends CarbonIcon {}
export declare class DragVertical24 extends CarbonIcon {}
export declare class DragVertical32 extends CarbonIcon {}
export declare class Draggable16 extends CarbonIcon {}
export declare class Draggable20 extends CarbonIcon {}
export declare class Draggable24 extends CarbonIcon {}
export declare class Draggable32 extends CarbonIcon {}
export declare class Draw16 extends CarbonIcon {}
export declare class Draw20 extends CarbonIcon {}
export declare class Draw24 extends CarbonIcon {}
export declare class Draw32 extends CarbonIcon {}
export declare class DriverAnalysis16 extends CarbonIcon {}
export declare class DriverAnalysis20 extends CarbonIcon {}
export declare class DriverAnalysis24 extends CarbonIcon {}
export declare class DriverAnalysis32 extends CarbonIcon {}
export declare class DropPhoto16 extends CarbonIcon {}
export declare class DropPhoto20 extends CarbonIcon {}
export declare class DropPhoto24 extends CarbonIcon {}
export declare class DropPhoto32 extends CarbonIcon {}
export declare class DropPhotoFilled16 extends CarbonIcon {}
export declare class DropPhotoFilled20 extends CarbonIcon {}
export declare class DropPhotoFilled24 extends CarbonIcon {}
export declare class DropPhotoFilled32 extends CarbonIcon {}
export declare class Drought16 extends CarbonIcon {}
export declare class Drought20 extends CarbonIcon {}
export declare class Drought24 extends CarbonIcon {}
export declare class Drought32 extends CarbonIcon {}
export declare class Dvr16 extends CarbonIcon {}
export declare class Dvr20 extends CarbonIcon {}
export declare class Dvr24 extends CarbonIcon {}
export declare class Dvr32 extends CarbonIcon {}
export declare class Earth16 extends CarbonIcon {}
export declare class Earth20 extends CarbonIcon {}
export declare class Earth24 extends CarbonIcon {}
export declare class Earth32 extends CarbonIcon {}
export declare class EarthAmericas16 extends CarbonIcon {}
export declare class EarthAmericas20 extends CarbonIcon {}
export declare class EarthAmericas24 extends CarbonIcon {}
export declare class EarthAmericas32 extends CarbonIcon {}
export declare class EarthAmericasFilled16 extends CarbonIcon {}
export declare class EarthAmericasFilled20 extends CarbonIcon {}
export declare class EarthAmericasFilled24 extends CarbonIcon {}
export declare class EarthAmericasFilled32 extends CarbonIcon {}
export declare class EarthEuropeAfrica16 extends CarbonIcon {}
export declare class EarthEuropeAfrica20 extends CarbonIcon {}
export declare class EarthEuropeAfrica24 extends CarbonIcon {}
export declare class EarthEuropeAfrica32 extends CarbonIcon {}
export declare class EarthEuropeAfricaFilled16 extends CarbonIcon {}
export declare class EarthEuropeAfricaFilled20 extends CarbonIcon {}
export declare class EarthEuropeAfricaFilled24 extends CarbonIcon {}
export declare class EarthEuropeAfricaFilled32 extends CarbonIcon {}
export declare class EarthFilled16 extends CarbonIcon {}
export declare class EarthFilled20 extends CarbonIcon {}
export declare class EarthFilled24 extends CarbonIcon {}
export declare class EarthFilled32 extends CarbonIcon {}
export declare class EarthSoutheastAsia16 extends CarbonIcon {}
export declare class EarthSoutheastAsia20 extends CarbonIcon {}
export declare class EarthSoutheastAsia24 extends CarbonIcon {}
export declare class EarthSoutheastAsia32 extends CarbonIcon {}
export declare class EarthSoutheastAsiaFilled16 extends CarbonIcon {}
export declare class EarthSoutheastAsiaFilled20 extends CarbonIcon {}
export declare class EarthSoutheastAsiaFilled24 extends CarbonIcon {}
export declare class EarthSoutheastAsiaFilled32 extends CarbonIcon {}
export declare class Earthquake16 extends CarbonIcon {}
export declare class Earthquake20 extends CarbonIcon {}
export declare class Earthquake24 extends CarbonIcon {}
export declare class Earthquake32 extends CarbonIcon {}
export declare class EdgeCluster16 extends CarbonIcon {}
export declare class EdgeCluster20 extends CarbonIcon {}
export declare class EdgeCluster24 extends CarbonIcon {}
export declare class EdgeCluster32 extends CarbonIcon {}
export declare class EdgeDevice16 extends CarbonIcon {}
export declare class EdgeDevice20 extends CarbonIcon {}
export declare class EdgeDevice24 extends CarbonIcon {}
export declare class EdgeDevice32 extends CarbonIcon {}
export declare class EdgeNode16 extends CarbonIcon {}
export declare class EdgeNode20 extends CarbonIcon {}
export declare class EdgeNode24 extends CarbonIcon {}
export declare class EdgeNode32 extends CarbonIcon {}
export declare class EdgeService16 extends CarbonIcon {}
export declare class EdgeService20 extends CarbonIcon {}
export declare class EdgeService24 extends CarbonIcon {}
export declare class EdgeService32 extends CarbonIcon {}
export declare class Edit16 extends CarbonIcon {}
export declare class Edit20 extends CarbonIcon {}
export declare class Edit24 extends CarbonIcon {}
export declare class Edit32 extends CarbonIcon {}
export declare class EditOff16 extends CarbonIcon {}
export declare class EditOff20 extends CarbonIcon {}
export declare class EditOff24 extends CarbonIcon {}
export declare class EditOff32 extends CarbonIcon {}
export declare class EdtLoop16 extends CarbonIcon {}
export declare class EdtLoop20 extends CarbonIcon {}
export declare class EdtLoop24 extends CarbonIcon {}
export declare class EdtLoop32 extends CarbonIcon {}
export declare class Education16 extends CarbonIcon {}
export declare class Education20 extends CarbonIcon {}
export declare class Education24 extends CarbonIcon {}
export declare class Education32 extends CarbonIcon {}
export declare class Email16 extends CarbonIcon {}
export declare class Email20 extends CarbonIcon {}
export declare class Email24 extends CarbonIcon {}
export declare class Email32 extends CarbonIcon {}
export declare class EmailNew16 extends CarbonIcon {}
export declare class EmailNew20 extends CarbonIcon {}
export declare class EmailNew24 extends CarbonIcon {}
export declare class EmailNew32 extends CarbonIcon {}
export declare class Enterprise16 extends CarbonIcon {}
export declare class Enterprise20 extends CarbonIcon {}
export declare class Enterprise24 extends CarbonIcon {}
export declare class Enterprise32 extends CarbonIcon {}
export declare class Erase16 extends CarbonIcon {}
export declare class Erase20 extends CarbonIcon {}
export declare class Erase24 extends CarbonIcon {}
export declare class Erase32 extends CarbonIcon {}
export declare class Error16 extends CarbonIcon {}
export declare class Error20 extends CarbonIcon {}
export declare class Error24 extends CarbonIcon {}
export declare class Error32 extends CarbonIcon {}
export declare class ErrorFilled16 extends CarbonIcon {}
export declare class ErrorFilled20 extends CarbonIcon {}
export declare class ErrorFilled24 extends CarbonIcon {}
export declare class ErrorFilled32 extends CarbonIcon {}
export declare class ErrorOutline16 extends CarbonIcon {}
export declare class ErrorOutline20 extends CarbonIcon {}
export declare class ErrorOutline24 extends CarbonIcon {}
export declare class ErrorOutline32 extends CarbonIcon {}
export declare class Event16 extends CarbonIcon {}
export declare class Event20 extends CarbonIcon {}
export declare class Event24 extends CarbonIcon {}
export declare class Event32 extends CarbonIcon {}
export declare class EventSchedule16 extends CarbonIcon {}
export declare class EventSchedule20 extends CarbonIcon {}
export declare class EventSchedule24 extends CarbonIcon {}
export declare class EventSchedule32 extends CarbonIcon {}
export declare class Events16 extends CarbonIcon {}
export declare class Events20 extends CarbonIcon {}
export declare class Events24 extends CarbonIcon {}
export declare class Events32 extends CarbonIcon {}
export declare class EventsAlt16 extends CarbonIcon {}
export declare class EventsAlt20 extends CarbonIcon {}
export declare class EventsAlt24 extends CarbonIcon {}
export declare class EventsAlt32 extends CarbonIcon {}
export declare class ExamMode16 extends CarbonIcon {}
export declare class ExamMode20 extends CarbonIcon {}
export declare class ExamMode24 extends CarbonIcon {}
export declare class ExamMode32 extends CarbonIcon {}
export declare class Exit16 extends CarbonIcon {}
export declare class Exit20 extends CarbonIcon {}
export declare class Exit24 extends CarbonIcon {}
export declare class Exit32 extends CarbonIcon {}
export declare class ExpandAll16 extends CarbonIcon {}
export declare class ExpandAll20 extends CarbonIcon {}
export declare class ExpandAll24 extends CarbonIcon {}
export declare class ExpandAll32 extends CarbonIcon {}
export declare class ExpandCategories16 extends CarbonIcon {}
export declare class ExpandCategories20 extends CarbonIcon {}
export declare class ExpandCategories24 extends CarbonIcon {}
export declare class ExpandCategories32 extends CarbonIcon {}
export declare class Export16 extends CarbonIcon {}
export declare class Export20 extends CarbonIcon {}
export declare class Export24 extends CarbonIcon {}
export declare class Export32 extends CarbonIcon {}
export declare class Eyedropper16 extends CarbonIcon {}
export declare class Eyedropper20 extends CarbonIcon {}
export declare class Eyedropper24 extends CarbonIcon {}
export declare class Eyedropper32 extends CarbonIcon {}
export declare class FaceActivated16 extends CarbonIcon {}
export declare class FaceActivated20 extends CarbonIcon {}
export declare class FaceActivated24 extends CarbonIcon {}
export declare class FaceActivated32 extends CarbonIcon {}
export declare class FaceActivatedAdd16 extends CarbonIcon {}
export declare class FaceActivatedAdd20 extends CarbonIcon {}
export declare class FaceActivatedAdd24 extends CarbonIcon {}
export declare class FaceActivatedAdd32 extends CarbonIcon {}
export declare class FaceActivatedFilled16 extends CarbonIcon {}
export declare class FaceActivatedFilled20 extends CarbonIcon {}
export declare class FaceActivatedFilled24 extends CarbonIcon {}
export declare class FaceActivatedFilled32 extends CarbonIcon {}
export declare class FaceAdd16 extends CarbonIcon {}
export declare class FaceAdd20 extends CarbonIcon {}
export declare class FaceAdd24 extends CarbonIcon {}
export declare class FaceAdd32 extends CarbonIcon {}
export declare class FaceCool16 extends CarbonIcon {}
export declare class FaceCool20 extends CarbonIcon {}
export declare class FaceCool24 extends CarbonIcon {}
export declare class FaceCool32 extends CarbonIcon {}
export declare class FaceDissatisfied16 extends CarbonIcon {}
export declare class FaceDissatisfied20 extends CarbonIcon {}
export declare class FaceDissatisfied24 extends CarbonIcon {}
export declare class FaceDissatisfied32 extends CarbonIcon {}
export declare class FaceDissatisfiedFilled16 extends CarbonIcon {}
export declare class FaceDissatisfiedFilled20 extends CarbonIcon {}
export declare class FaceDissatisfiedFilled24 extends CarbonIcon {}
export declare class FaceDissatisfiedFilled32 extends CarbonIcon {}
export declare class FaceDizzy16 extends CarbonIcon {}
export declare class FaceDizzy20 extends CarbonIcon {}
export declare class FaceDizzy24 extends CarbonIcon {}
export declare class FaceDizzy32 extends CarbonIcon {}
export declare class FaceDizzyFilled16 extends CarbonIcon {}
export declare class FaceDizzyFilled20 extends CarbonIcon {}
export declare class FaceDizzyFilled24 extends CarbonIcon {}
export declare class FaceDizzyFilled32 extends CarbonIcon {}
export declare class FaceMask16 extends CarbonIcon {}
export declare class FaceMask20 extends CarbonIcon {}
export declare class FaceMask24 extends CarbonIcon {}
export declare class FaceMask32 extends CarbonIcon {}
export declare class FaceNeutral16 extends CarbonIcon {}
export declare class FaceNeutral20 extends CarbonIcon {}
export declare class FaceNeutral24 extends CarbonIcon {}
export declare class FaceNeutral32 extends CarbonIcon {}
export declare class FaceNeutralFilled16 extends CarbonIcon {}
export declare class FaceNeutralFilled20 extends CarbonIcon {}
export declare class FaceNeutralFilled24 extends CarbonIcon {}
export declare class FaceNeutralFilled32 extends CarbonIcon {}
export declare class FacePending16 extends CarbonIcon {}
export declare class FacePending20 extends CarbonIcon {}
export declare class FacePending24 extends CarbonIcon {}
export declare class FacePending32 extends CarbonIcon {}
export declare class FacePendingFilled16 extends CarbonIcon {}
export declare class FacePendingFilled20 extends CarbonIcon {}
export declare class FacePendingFilled24 extends CarbonIcon {}
export declare class FacePendingFilled32 extends CarbonIcon {}
export declare class FaceSatisfied16 extends CarbonIcon {}
export declare class FaceSatisfied20 extends CarbonIcon {}
export declare class FaceSatisfied24 extends CarbonIcon {}
export declare class FaceSatisfied32 extends CarbonIcon {}
export declare class FaceSatisfiedFilled16 extends CarbonIcon {}
export declare class FaceSatisfiedFilled20 extends CarbonIcon {}
export declare class FaceSatisfiedFilled24 extends CarbonIcon {}
export declare class FaceSatisfiedFilled32 extends CarbonIcon {}
export declare class FaceWink16 extends CarbonIcon {}
export declare class FaceWink20 extends CarbonIcon {}
export declare class FaceWink24 extends CarbonIcon {}
export declare class FaceWink32 extends CarbonIcon {}
export declare class FaceWinkFilled16 extends CarbonIcon {}
export declare class FaceWinkFilled20 extends CarbonIcon {}
export declare class FaceWinkFilled24 extends CarbonIcon {}
export declare class FaceWinkFilled32 extends CarbonIcon {}
export declare class Factor16 extends CarbonIcon {}
export declare class Factor20 extends CarbonIcon {}
export declare class Factor24 extends CarbonIcon {}
export declare class Factor32 extends CarbonIcon {}
export declare class Fade16 extends CarbonIcon {}
export declare class Fade20 extends CarbonIcon {}
export declare class Fade24 extends CarbonIcon {}
export declare class Fade32 extends CarbonIcon {}
export declare class Favorite16 extends CarbonIcon {}
export declare class Favorite20 extends CarbonIcon {}
export declare class Favorite24 extends CarbonIcon {}
export declare class Favorite32 extends CarbonIcon {}
export declare class FavoriteFilled16 extends CarbonIcon {}
export declare class FavoriteFilled20 extends CarbonIcon {}
export declare class FavoriteFilled24 extends CarbonIcon {}
export declare class FavoriteFilled32 extends CarbonIcon {}
export declare class FetchUpload16 extends CarbonIcon {}
export declare class FetchUpload20 extends CarbonIcon {}
export declare class FetchUpload24 extends CarbonIcon {}
export declare class FetchUpload32 extends CarbonIcon {}
export declare class FetchUploadCloud16 extends CarbonIcon {}
export declare class FetchUploadCloud20 extends CarbonIcon {}
export declare class FetchUploadCloud24 extends CarbonIcon {}
export declare class FetchUploadCloud32 extends CarbonIcon {}
export declare class Filter16 extends CarbonIcon {}
export declare class Filter20 extends CarbonIcon {}
export declare class Filter24 extends CarbonIcon {}
export declare class Filter32 extends CarbonIcon {}
export declare class FilterEdit16 extends CarbonIcon {}
export declare class FilterEdit20 extends CarbonIcon {}
export declare class FilterEdit24 extends CarbonIcon {}
export declare class FilterEdit32 extends CarbonIcon {}
export declare class FilterRemove16 extends CarbonIcon {}
export declare class FilterRemove20 extends CarbonIcon {}
export declare class FilterRemove24 extends CarbonIcon {}
export declare class FilterRemove32 extends CarbonIcon {}
export declare class FilterReset16 extends CarbonIcon {}
export declare class FilterReset20 extends CarbonIcon {}
export declare class FilterReset24 extends CarbonIcon {}
export declare class FilterReset32 extends CarbonIcon {}
export declare class Finance16 extends CarbonIcon {}
export declare class Finance20 extends CarbonIcon {}
export declare class Finance24 extends CarbonIcon {}
export declare class Finance32 extends CarbonIcon {}
export declare class FingerprintRecognition16 extends CarbonIcon {}
export declare class FingerprintRecognition20 extends CarbonIcon {}
export declare class FingerprintRecognition24 extends CarbonIcon {}
export declare class FingerprintRecognition32 extends CarbonIcon {}
export declare class Fire16 extends CarbonIcon {}
export declare class Fire20 extends CarbonIcon {}
export declare class Fire24 extends CarbonIcon {}
export declare class Fire32 extends CarbonIcon {}
export declare class Fish16 extends CarbonIcon {}
export declare class Fish20 extends CarbonIcon {}
export declare class Fish24 extends CarbonIcon {}
export declare class Fish32 extends CarbonIcon {}
export declare class FishMultiple16 extends CarbonIcon {}
export declare class FishMultiple20 extends CarbonIcon {}
export declare class FishMultiple24 extends CarbonIcon {}
export declare class FishMultiple32 extends CarbonIcon {}
export declare class FitToScreen16 extends CarbonIcon {}
export declare class FitToScreen20 extends CarbonIcon {}
export declare class FitToScreen24 extends CarbonIcon {}
export declare class FitToScreen32 extends CarbonIcon {}
export declare class Flag16 extends CarbonIcon {}
export declare class Flag20 extends CarbonIcon {}
export declare class Flag24 extends CarbonIcon {}
export declare class Flag32 extends CarbonIcon {}
export declare class FlagFilled16 extends CarbonIcon {}
export declare class FlagFilled20 extends CarbonIcon {}
export declare class FlagFilled24 extends CarbonIcon {}
export declare class FlagFilled32 extends CarbonIcon {}
export declare class FlaggingTaxi16 extends CarbonIcon {}
export declare class FlaggingTaxi20 extends CarbonIcon {}
export declare class FlaggingTaxi24 extends CarbonIcon {}
export declare class FlaggingTaxi32 extends CarbonIcon {}
export declare class Flash16 extends CarbonIcon {}
export declare class Flash20 extends CarbonIcon {}
export declare class Flash24 extends CarbonIcon {}
export declare class Flash32 extends CarbonIcon {}
export declare class FlashFilled16 extends CarbonIcon {}
export declare class FlashFilled20 extends CarbonIcon {}
export declare class FlashFilled24 extends CarbonIcon {}
export declare class FlashFilled32 extends CarbonIcon {}
export declare class FlashOff16 extends CarbonIcon {}
export declare class FlashOff20 extends CarbonIcon {}
export declare class FlashOff24 extends CarbonIcon {}
export declare class FlashOff32 extends CarbonIcon {}
export declare class FlashOffFilled16 extends CarbonIcon {}
export declare class FlashOffFilled20 extends CarbonIcon {}
export declare class FlashOffFilled24 extends CarbonIcon {}
export declare class FlashOffFilled32 extends CarbonIcon {}
export declare class FlightInternational16 extends CarbonIcon {}
export declare class FlightInternational20 extends CarbonIcon {}
export declare class FlightInternational24 extends CarbonIcon {}
export declare class FlightInternational32 extends CarbonIcon {}
export declare class FlightRoster16 extends CarbonIcon {}
export declare class FlightRoster20 extends CarbonIcon {}
export declare class FlightRoster24 extends CarbonIcon {}
export declare class FlightRoster32 extends CarbonIcon {}
export declare class FlightSchedule16 extends CarbonIcon {}
export declare class FlightSchedule20 extends CarbonIcon {}
export declare class FlightSchedule24 extends CarbonIcon {}
export declare class FlightSchedule32 extends CarbonIcon {}
export declare class Flood16 extends CarbonIcon {}
export declare class Flood20 extends CarbonIcon {}
export declare class Flood24 extends CarbonIcon {}
export declare class Flood32 extends CarbonIcon {}
export declare class FloodWarning16 extends CarbonIcon {}
export declare class FloodWarning20 extends CarbonIcon {}
export declare class FloodWarning24 extends CarbonIcon {}
export declare class FloodWarning32 extends CarbonIcon {}
export declare class Flow16 extends CarbonIcon {}
export declare class Flow20 extends CarbonIcon {}
export declare class Flow24 extends CarbonIcon {}
export declare class Flow32 extends CarbonIcon {}
export declare class FlowConnection16 extends CarbonIcon {}
export declare class FlowConnection20 extends CarbonIcon {}
export declare class FlowConnection24 extends CarbonIcon {}
export declare class FlowConnection32 extends CarbonIcon {}
export declare class FlowData16 extends CarbonIcon {}
export declare class FlowData20 extends CarbonIcon {}
export declare class FlowData24 extends CarbonIcon {}
export declare class FlowData32 extends CarbonIcon {}
export declare class FlowStream16 extends CarbonIcon {}
export declare class FlowStream20 extends CarbonIcon {}
export declare class FlowStream24 extends CarbonIcon {}
export declare class FlowStream32 extends CarbonIcon {}
export declare class FlowStreamReference16 extends CarbonIcon {}
export declare class FlowStreamReference20 extends CarbonIcon {}
export declare class FlowStreamReference24 extends CarbonIcon {}
export declare class FlowStreamReference32 extends CarbonIcon {}
export declare class Fog16 extends CarbonIcon {}
export declare class Fog20 extends CarbonIcon {}
export declare class Fog24 extends CarbonIcon {}
export declare class Fog32 extends CarbonIcon {}
export declare class Folder16 extends CarbonIcon {}
export declare class Folder20 extends CarbonIcon {}
export declare class Folder24 extends CarbonIcon {}
export declare class Folder32 extends CarbonIcon {}
export declare class FolderAdd16 extends CarbonIcon {}
export declare class FolderAdd20 extends CarbonIcon {}
export declare class FolderAdd24 extends CarbonIcon {}
export declare class FolderAdd32 extends CarbonIcon {}
export declare class FolderDetails16 extends CarbonIcon {}
export declare class FolderDetails20 extends CarbonIcon {}
export declare class FolderDetails24 extends CarbonIcon {}
export declare class FolderDetails32 extends CarbonIcon {}
export declare class FolderDetailsReference16 extends CarbonIcon {}
export declare class FolderDetailsReference20 extends CarbonIcon {}
export declare class FolderDetailsReference24 extends CarbonIcon {}
export declare class FolderDetailsReference32 extends CarbonIcon {}
export declare class FolderOff16 extends CarbonIcon {}
export declare class FolderOff20 extends CarbonIcon {}
export declare class FolderOff24 extends CarbonIcon {}
export declare class FolderOff32 extends CarbonIcon {}
export declare class FolderShared16 extends CarbonIcon {}
export declare class FolderShared20 extends CarbonIcon {}
export declare class FolderShared24 extends CarbonIcon {}
export declare class FolderShared32 extends CarbonIcon {}
export declare class Folders16 extends CarbonIcon {}
export declare class Folders20 extends CarbonIcon {}
export declare class Folders24 extends CarbonIcon {}
export declare class Folders32 extends CarbonIcon {}
export declare class ForecastHail16 extends CarbonIcon {}
export declare class ForecastHail20 extends CarbonIcon {}
export declare class ForecastHail24 extends CarbonIcon {}
export declare class ForecastHail32 extends CarbonIcon {}
export declare class ForecastHail_3016 extends CarbonIcon {}
export declare class ForecastHail_3020 extends CarbonIcon {}
export declare class ForecastHail_3024 extends CarbonIcon {}
export declare class ForecastHail_3032 extends CarbonIcon {}
export declare class ForecastLightning16 extends CarbonIcon {}
export declare class ForecastLightning20 extends CarbonIcon {}
export declare class ForecastLightning24 extends CarbonIcon {}
export declare class ForecastLightning32 extends CarbonIcon {}
export declare class ForecastLightning_3016 extends CarbonIcon {}
export declare class ForecastLightning_3020 extends CarbonIcon {}
export declare class ForecastLightning_3024 extends CarbonIcon {}
export declare class ForecastLightning_3032 extends CarbonIcon {}
export declare class Fork16 extends CarbonIcon {}
export declare class Fork20 extends CarbonIcon {}
export declare class Fork24 extends CarbonIcon {}
export declare class Fork32 extends CarbonIcon {}
export declare class Forum16 extends CarbonIcon {}
export declare class Forum20 extends CarbonIcon {}
export declare class Forum24 extends CarbonIcon {}
export declare class Forum32 extends CarbonIcon {}
export declare class Forward_1016 extends CarbonIcon {}
export declare class Forward_1020 extends CarbonIcon {}
export declare class Forward_1024 extends CarbonIcon {}
export declare class Forward_1032 extends CarbonIcon {}
export declare class Forward_3016 extends CarbonIcon {}
export declare class Forward_3020 extends CarbonIcon {}
export declare class Forward_3024 extends CarbonIcon {}
export declare class Forward_3032 extends CarbonIcon {}
export declare class Forward_516 extends CarbonIcon {}
export declare class Forward_520 extends CarbonIcon {}
export declare class Forward_524 extends CarbonIcon {}
export declare class Forward_532 extends CarbonIcon {}
export declare class Fragile16 extends CarbonIcon {}
export declare class Fragile20 extends CarbonIcon {}
export declare class Fragile24 extends CarbonIcon {}
export declare class Fragile32 extends CarbonIcon {}
export declare class FruitBowl16 extends CarbonIcon {}
export declare class FruitBowl20 extends CarbonIcon {}
export declare class FruitBowl24 extends CarbonIcon {}
export declare class FruitBowl32 extends CarbonIcon {}
export declare class Function16 extends CarbonIcon {}
export declare class Function20 extends CarbonIcon {}
export declare class Function24 extends CarbonIcon {}
export declare class Function32 extends CarbonIcon {}
export declare class FunctionMath16 extends CarbonIcon {}
export declare class FunctionMath20 extends CarbonIcon {}
export declare class FunctionMath24 extends CarbonIcon {}
export declare class FunctionMath32 extends CarbonIcon {}
export declare class GameConsole16 extends CarbonIcon {}
export declare class GameConsole20 extends CarbonIcon {}
export declare class GameConsole24 extends CarbonIcon {}
export declare class GameConsole32 extends CarbonIcon {}
export declare class GameWireless16 extends CarbonIcon {}
export declare class GameWireless20 extends CarbonIcon {}
export declare class GameWireless24 extends CarbonIcon {}
export declare class GameWireless32 extends CarbonIcon {}
export declare class Gamification16 extends CarbonIcon {}
export declare class Gamification20 extends CarbonIcon {}
export declare class Gamification24 extends CarbonIcon {}
export declare class Gamification32 extends CarbonIcon {}
export declare class GasStation16 extends CarbonIcon {}
export declare class GasStation20 extends CarbonIcon {}
export declare class GasStation24 extends CarbonIcon {}
export declare class GasStation32 extends CarbonIcon {}
export declare class GenderFemale16 extends CarbonIcon {}
export declare class GenderFemale20 extends CarbonIcon {}
export declare class GenderFemale24 extends CarbonIcon {}
export declare class GenderFemale32 extends CarbonIcon {}
export declare class GenderMale16 extends CarbonIcon {}
export declare class GenderMale20 extends CarbonIcon {}
export declare class GenderMale24 extends CarbonIcon {}
export declare class GenderMale32 extends CarbonIcon {}
export declare class GeneratePdf16 extends CarbonIcon {}
export declare class GeneratePdf20 extends CarbonIcon {}
export declare class GeneratePdf24 extends CarbonIcon {}
export declare class GeneratePdf32 extends CarbonIcon {}
export declare class Gif16 extends CarbonIcon {}
export declare class Gif20 extends CarbonIcon {}
export declare class Gif24 extends CarbonIcon {}
export declare class Gif32 extends CarbonIcon {}
export declare class Gift16 extends CarbonIcon {}
export declare class Gift20 extends CarbonIcon {}
export declare class Gift24 extends CarbonIcon {}
export declare class Gift32 extends CarbonIcon {}
export declare class Globe16 extends CarbonIcon {}
export declare class Globe20 extends CarbonIcon {}
export declare class Globe24 extends CarbonIcon {}
export declare class Globe32 extends CarbonIcon {}
export declare class Gradient16 extends CarbonIcon {}
export declare class Gradient20 extends CarbonIcon {}
export declare class Gradient24 extends CarbonIcon {}
export declare class Gradient32 extends CarbonIcon {}
export declare class GraphicalDataFlow16 extends CarbonIcon {}
export declare class GraphicalDataFlow20 extends CarbonIcon {}
export declare class GraphicalDataFlow24 extends CarbonIcon {}
export declare class GraphicalDataFlow32 extends CarbonIcon {}
export declare class Grid16 extends CarbonIcon {}
export declare class Grid20 extends CarbonIcon {}
export declare class Grid24 extends CarbonIcon {}
export declare class Grid32 extends CarbonIcon {}
export declare class Group16 extends CarbonIcon {}
export declare class Group20 extends CarbonIcon {}
export declare class Group24 extends CarbonIcon {}
export declare class Group32 extends CarbonIcon {}
export declare class Hail16 extends CarbonIcon {}
export declare class Hail20 extends CarbonIcon {}
export declare class Hail24 extends CarbonIcon {}
export declare class Hail32 extends CarbonIcon {}
export declare class Harbor16 extends CarbonIcon {}
export declare class Harbor20 extends CarbonIcon {}
export declare class Harbor24 extends CarbonIcon {}
export declare class Harbor32 extends CarbonIcon {}
export declare class Hashtag16 extends CarbonIcon {}
export declare class Hashtag20 extends CarbonIcon {}
export declare class Hashtag24 extends CarbonIcon {}
export declare class Hashtag32 extends CarbonIcon {}
export declare class Haze16 extends CarbonIcon {}
export declare class Haze20 extends CarbonIcon {}
export declare class Haze24 extends CarbonIcon {}
export declare class Haze32 extends CarbonIcon {}
export declare class HazeNight16 extends CarbonIcon {}
export declare class HazeNight20 extends CarbonIcon {}
export declare class HazeNight24 extends CarbonIcon {}
export declare class HazeNight32 extends CarbonIcon {}
export declare class Hd16 extends CarbonIcon {}
export declare class Hd20 extends CarbonIcon {}
export declare class Hd24 extends CarbonIcon {}
export declare class Hd32 extends CarbonIcon {}
export declare class HdFilled16 extends CarbonIcon {}
export declare class HdFilled20 extends CarbonIcon {}
export declare class HdFilled24 extends CarbonIcon {}
export declare class HdFilled32 extends CarbonIcon {}
export declare class Hdr16 extends CarbonIcon {}
export declare class Hdr20 extends CarbonIcon {}
export declare class Hdr24 extends CarbonIcon {}
export declare class Hdr32 extends CarbonIcon {}
export declare class Headphones16 extends CarbonIcon {}
export declare class Headphones20 extends CarbonIcon {}
export declare class Headphones24 extends CarbonIcon {}
export declare class Headphones32 extends CarbonIcon {}
export declare class Headset16 extends CarbonIcon {}
export declare class Headset20 extends CarbonIcon {}
export declare class Headset24 extends CarbonIcon {}
export declare class Headset32 extends CarbonIcon {}
export declare class HealthCross16 extends CarbonIcon {}
export declare class HealthCross20 extends CarbonIcon {}
export declare class HealthCross24 extends CarbonIcon {}
export declare class HealthCross32 extends CarbonIcon {}
export declare class Hearing16 extends CarbonIcon {}
export declare class Hearing20 extends CarbonIcon {}
export declare class Hearing24 extends CarbonIcon {}
export declare class Hearing32 extends CarbonIcon {}
export declare class HeatMap16 extends CarbonIcon {}
export declare class HeatMap20 extends CarbonIcon {}
export declare class HeatMap24 extends CarbonIcon {}
export declare class HeatMap32 extends CarbonIcon {}
export declare class HeatMapStocks16 extends CarbonIcon {}
export declare class HeatMapStocks20 extends CarbonIcon {}
export declare class HeatMapStocks24 extends CarbonIcon {}
export declare class HeatMapStocks32 extends CarbonIcon {}
export declare class HeatMap_0216 extends CarbonIcon {}
export declare class HeatMap_0220 extends CarbonIcon {}
export declare class HeatMap_0224 extends CarbonIcon {}
export declare class HeatMap_0232 extends CarbonIcon {}
export declare class HeatMap_0316 extends CarbonIcon {}
export declare class HeatMap_0320 extends CarbonIcon {}
export declare class HeatMap_0324 extends CarbonIcon {}
export declare class HeatMap_0332 extends CarbonIcon {}
export declare class Helicopter16 extends CarbonIcon {}
export declare class Helicopter20 extends CarbonIcon {}
export declare class Helicopter24 extends CarbonIcon {}
export declare class Helicopter32 extends CarbonIcon {}
export declare class Help16 extends CarbonIcon {}
export declare class Help20 extends CarbonIcon {}
export declare class Help24 extends CarbonIcon {}
export declare class Help32 extends CarbonIcon {}
export declare class HelpDesk16 extends CarbonIcon {}
export declare class HelpDesk20 extends CarbonIcon {}
export declare class HelpDesk24 extends CarbonIcon {}
export declare class HelpDesk32 extends CarbonIcon {}
export declare class HelpFilled16 extends CarbonIcon {}
export declare class HelpFilled20 extends CarbonIcon {}
export declare class HelpFilled24 extends CarbonIcon {}
export declare class HelpFilled32 extends CarbonIcon {}
export declare class Home16 extends CarbonIcon {}
export declare class Home20 extends CarbonIcon {}
export declare class Home24 extends CarbonIcon {}
export declare class Home32 extends CarbonIcon {}
export declare class Hospital16 extends CarbonIcon {}
export declare class Hospital20 extends CarbonIcon {}
export declare class Hospital24 extends CarbonIcon {}
export declare class Hospital32 extends CarbonIcon {}
export declare class HospitalBed16 extends CarbonIcon {}
export declare class HospitalBed20 extends CarbonIcon {}
export declare class HospitalBed24 extends CarbonIcon {}
export declare class HospitalBed32 extends CarbonIcon {}
export declare class Hotel16 extends CarbonIcon {}
export declare class Hotel20 extends CarbonIcon {}
export declare class Hotel24 extends CarbonIcon {}
export declare class Hotel32 extends CarbonIcon {}
export declare class Hourglass16 extends CarbonIcon {}
export declare class Hourglass20 extends CarbonIcon {}
export declare class Hourglass24 extends CarbonIcon {}
export declare class Hourglass32 extends CarbonIcon {}
export declare class Html16 extends CarbonIcon {}
export declare class Html20 extends CarbonIcon {}
export declare class Html24 extends CarbonIcon {}
export declare class Html32 extends CarbonIcon {}
export declare class HtmlReference16 extends CarbonIcon {}
export declare class HtmlReference20 extends CarbonIcon {}
export declare class HtmlReference24 extends CarbonIcon {}
export declare class HtmlReference32 extends CarbonIcon {}
export declare class Http16 extends CarbonIcon {}
export declare class Http20 extends CarbonIcon {}
export declare class Http24 extends CarbonIcon {}
export declare class Http32 extends CarbonIcon {}
export declare class Humidity16 extends CarbonIcon {}
export declare class Humidity20 extends CarbonIcon {}
export declare class Humidity24 extends CarbonIcon {}
export declare class Humidity32 extends CarbonIcon {}
export declare class HumidityAlt16 extends CarbonIcon {}
export declare class HumidityAlt20 extends CarbonIcon {}
export declare class HumidityAlt24 extends CarbonIcon {}
export declare class HumidityAlt32 extends CarbonIcon {}
export declare class Hurricane16 extends CarbonIcon {}
export declare class Hurricane20 extends CarbonIcon {}
export declare class Hurricane24 extends CarbonIcon {}
export declare class Hurricane32 extends CarbonIcon {}
export declare class HybridNetworking16 extends CarbonIcon {}
export declare class HybridNetworking20 extends CarbonIcon {}
export declare class HybridNetworking24 extends CarbonIcon {}
export declare class HybridNetworking32 extends CarbonIcon {}
export declare class IbmCloud16 extends CarbonIcon {}
export declare class IbmCloud20 extends CarbonIcon {}
export declare class IbmCloud24 extends CarbonIcon {}
export declare class IbmCloud32 extends CarbonIcon {}
export declare class IbmSecurity16 extends CarbonIcon {}
export declare class IbmSecurity20 extends CarbonIcon {}
export declare class IbmSecurity24 extends CarbonIcon {}
export declare class IbmSecurity32 extends CarbonIcon {}
export declare class IceAccretion16 extends CarbonIcon {}
export declare class IceAccretion20 extends CarbonIcon {}
export declare class IceAccretion24 extends CarbonIcon {}
export declare class IceAccretion32 extends CarbonIcon {}
export declare class Idea16 extends CarbonIcon {}
export declare class Idea20 extends CarbonIcon {}
export declare class Idea24 extends CarbonIcon {}
export declare class Idea32 extends CarbonIcon {}
export declare class Identification16 extends CarbonIcon {}
export declare class Identification20 extends CarbonIcon {}
export declare class Identification24 extends CarbonIcon {}
export declare class Identification32 extends CarbonIcon {}
export declare class Image16 extends CarbonIcon {}
export declare class Image20 extends CarbonIcon {}
export declare class Image24 extends CarbonIcon {}
export declare class Image32 extends CarbonIcon {}
export declare class ImageMedical16 extends CarbonIcon {}
export declare class ImageMedical20 extends CarbonIcon {}
export declare class ImageMedical24 extends CarbonIcon {}
export declare class ImageMedical32 extends CarbonIcon {}
export declare class ImageReference16 extends CarbonIcon {}
export declare class ImageReference20 extends CarbonIcon {}
export declare class ImageReference24 extends CarbonIcon {}
export declare class ImageReference32 extends CarbonIcon {}
export declare class ImageSearch16 extends CarbonIcon {}
export declare class ImageSearch20 extends CarbonIcon {}
export declare class ImageSearch24 extends CarbonIcon {}
export declare class ImageSearch32 extends CarbonIcon {}
export declare class ImproveRelevance16 extends CarbonIcon {}
export declare class ImproveRelevance20 extends CarbonIcon {}
export declare class ImproveRelevance24 extends CarbonIcon {}
export declare class ImproveRelevance32 extends CarbonIcon {}
export declare class InProgress16 extends CarbonIcon {}
export declare class InProgress20 extends CarbonIcon {}
export declare class InProgress24 extends CarbonIcon {}
export declare class InProgress32 extends CarbonIcon {}
export declare class InProgressError16 extends CarbonIcon {}
export declare class InProgressError20 extends CarbonIcon {}
export declare class InProgressError24 extends CarbonIcon {}
export declare class InProgressError32 extends CarbonIcon {}
export declare class InProgressWarning16 extends CarbonIcon {}
export declare class InProgressWarning20 extends CarbonIcon {}
export declare class InProgressWarning24 extends CarbonIcon {}
export declare class InProgressWarning32 extends CarbonIcon {}
export declare class Incomplete16 extends CarbonIcon {}
export declare class Incomplete20 extends CarbonIcon {}
export declare class Incomplete24 extends CarbonIcon {}
export declare class Incomplete32 extends CarbonIcon {}
export declare class IncompleteCancel16 extends CarbonIcon {}
export declare class IncompleteCancel20 extends CarbonIcon {}
export declare class IncompleteCancel24 extends CarbonIcon {}
export declare class IncompleteCancel32 extends CarbonIcon {}
export declare class IncompleteError16 extends CarbonIcon {}
export declare class IncompleteError20 extends CarbonIcon {}
export declare class IncompleteError24 extends CarbonIcon {}
export declare class IncompleteError32 extends CarbonIcon {}
export declare class IncompleteWarning16 extends CarbonIcon {}
export declare class IncompleteWarning20 extends CarbonIcon {}
export declare class IncompleteWarning24 extends CarbonIcon {}
export declare class IncompleteWarning32 extends CarbonIcon {}
export declare class IncreaseLevel16 extends CarbonIcon {}
export declare class IncreaseLevel20 extends CarbonIcon {}
export declare class IncreaseLevel24 extends CarbonIcon {}
export declare class IncreaseLevel32 extends CarbonIcon {}
export declare class Industry16 extends CarbonIcon {}
export declare class Industry20 extends CarbonIcon {}
export declare class Industry24 extends CarbonIcon {}
export declare class Industry32 extends CarbonIcon {}
export declare class Information16 extends CarbonIcon {}
export declare class Information20 extends CarbonIcon {}
export declare class Information24 extends CarbonIcon {}
export declare class Information32 extends CarbonIcon {}
export declare class InformationFilled16 extends CarbonIcon {}
export declare class InformationFilled20 extends CarbonIcon {}
export declare class InformationFilled24 extends CarbonIcon {}
export declare class InformationFilled32 extends CarbonIcon {}
export declare class InformationSquare16 extends CarbonIcon {}
export declare class InformationSquare20 extends CarbonIcon {}
export declare class InformationSquare24 extends CarbonIcon {}
export declare class InformationSquare32 extends CarbonIcon {}
export declare class InformationSquareFilled16 extends CarbonIcon {}
export declare class InformationSquareFilled20 extends CarbonIcon {}
export declare class InformationSquareFilled24 extends CarbonIcon {}
export declare class InformationSquareFilled32 extends CarbonIcon {}
export declare class Insert16 extends CarbonIcon {}
export declare class Insert20 extends CarbonIcon {}
export declare class Insert24 extends CarbonIcon {}
export declare class Insert32 extends CarbonIcon {}
export declare class InsertPage16 extends CarbonIcon {}
export declare class InsertPage20 extends CarbonIcon {}
export declare class InsertPage24 extends CarbonIcon {}
export declare class InsertPage32 extends CarbonIcon {}
export declare class Integration16 extends CarbonIcon {}
export declare class Integration20 extends CarbonIcon {}
export declare class Integration24 extends CarbonIcon {}
export declare class Integration32 extends CarbonIcon {}
export declare class Interactions16 extends CarbonIcon {}
export declare class Interactions20 extends CarbonIcon {}
export declare class Interactions24 extends CarbonIcon {}
export declare class Interactions32 extends CarbonIcon {}
export declare class Intersect16 extends CarbonIcon {}
export declare class Intersect20 extends CarbonIcon {}
export declare class Intersect24 extends CarbonIcon {}
export declare class Intersect32 extends CarbonIcon {}
export declare class InventoryManagement16 extends CarbonIcon {}
export declare class InventoryManagement20 extends CarbonIcon {}
export declare class InventoryManagement24 extends CarbonIcon {}
export declare class InventoryManagement32 extends CarbonIcon {}
export declare class IotConnect16 extends CarbonIcon {}
export declare class IotConnect20 extends CarbonIcon {}
export declare class IotConnect24 extends CarbonIcon {}
export declare class IotConnect32 extends CarbonIcon {}
export declare class IotPlatform16 extends CarbonIcon {}
export declare class IotPlatform20 extends CarbonIcon {}
export declare class IotPlatform24 extends CarbonIcon {}
export declare class IotPlatform32 extends CarbonIcon {}
export declare class Iso16 extends CarbonIcon {}
export declare class Iso20 extends CarbonIcon {}
export declare class Iso24 extends CarbonIcon {}
export declare class Iso32 extends CarbonIcon {}
export declare class IsoFilled16 extends CarbonIcon {}
export declare class IsoFilled20 extends CarbonIcon {}
export declare class IsoFilled24 extends CarbonIcon {}
export declare class IsoFilled32 extends CarbonIcon {}
export declare class IsoOutline16 extends CarbonIcon {}
export declare class IsoOutline20 extends CarbonIcon {}
export declare class IsoOutline24 extends CarbonIcon {}
export declare class IsoOutline32 extends CarbonIcon {}
export declare class JoinInner16 extends CarbonIcon {}
export declare class JoinInner20 extends CarbonIcon {}
export declare class JoinInner24 extends CarbonIcon {}
export declare class JoinInner32 extends CarbonIcon {}
export declare class JoinLeft16 extends CarbonIcon {}
export declare class JoinLeft20 extends CarbonIcon {}
export declare class JoinLeft24 extends CarbonIcon {}
export declare class JoinLeft32 extends CarbonIcon {}
export declare class JoinOuter16 extends CarbonIcon {}
export declare class JoinOuter20 extends CarbonIcon {}
export declare class JoinOuter24 extends CarbonIcon {}
export declare class JoinOuter32 extends CarbonIcon {}
export declare class JoinRight16 extends CarbonIcon {}
export declare class JoinRight20 extends CarbonIcon {}
export declare class JoinRight24 extends CarbonIcon {}
export declare class JoinRight32 extends CarbonIcon {}
export declare class Jpg16 extends CarbonIcon {}
export declare class Jpg20 extends CarbonIcon {}
export declare class Jpg24 extends CarbonIcon {}
export declare class Jpg32 extends CarbonIcon {}
export declare class Json16 extends CarbonIcon {}
export declare class Json20 extends CarbonIcon {}
export declare class Json24 extends CarbonIcon {}
export declare class Json32 extends CarbonIcon {}
export declare class JsonReference16 extends CarbonIcon {}
export declare class JsonReference20 extends CarbonIcon {}
export declare class JsonReference24 extends CarbonIcon {}
export declare class JsonReference32 extends CarbonIcon {}
export declare class JumpLink16 extends CarbonIcon {}
export declare class JumpLink20 extends CarbonIcon {}
export declare class JumpLink24 extends CarbonIcon {}
export declare class JumpLink32 extends CarbonIcon {}
export declare class KeepDry16 extends CarbonIcon {}
export declare class KeepDry20 extends CarbonIcon {}
export declare class KeepDry24 extends CarbonIcon {}
export declare class KeepDry32 extends CarbonIcon {}
export declare class Keyboard16 extends CarbonIcon {}
export declare class Keyboard20 extends CarbonIcon {}
export declare class Keyboard24 extends CarbonIcon {}
export declare class Keyboard32 extends CarbonIcon {}
export declare class Language16 extends CarbonIcon {}
export declare class Language20 extends CarbonIcon {}
export declare class Language24 extends CarbonIcon {}
export declare class Language32 extends CarbonIcon {}
export declare class Laptop16 extends CarbonIcon {}
export declare class Laptop20 extends CarbonIcon {}
export declare class Laptop24 extends CarbonIcon {}
export declare class Laptop32 extends CarbonIcon {}
export declare class Lasso16 extends CarbonIcon {}
export declare class Lasso20 extends CarbonIcon {}
export declare class Lasso24 extends CarbonIcon {}
export declare class Lasso32 extends CarbonIcon {}
export declare class Launch16 extends CarbonIcon {}
export declare class Launch20 extends CarbonIcon {}
export declare class Launch24 extends CarbonIcon {}
export declare class Launch32 extends CarbonIcon {}
export declare class Layers16 extends CarbonIcon {}
export declare class Layers20 extends CarbonIcon {}
export declare class Layers24 extends CarbonIcon {}
export declare class Layers32 extends CarbonIcon {}
export declare class Legend16 extends CarbonIcon {}
export declare class Legend20 extends CarbonIcon {}
export declare class Legend24 extends CarbonIcon {}
export declare class Legend32 extends CarbonIcon {}
export declare class LetterAa16 extends CarbonIcon {}
export declare class LetterAa20 extends CarbonIcon {}
export declare class LetterAa24 extends CarbonIcon {}
export declare class LetterAa32 extends CarbonIcon {}
export declare class LetterBb16 extends CarbonIcon {}
export declare class LetterBb20 extends CarbonIcon {}
export declare class LetterBb24 extends CarbonIcon {}
export declare class LetterBb32 extends CarbonIcon {}
export declare class LetterCc16 extends CarbonIcon {}
export declare class LetterCc20 extends CarbonIcon {}
export declare class LetterCc24 extends CarbonIcon {}
export declare class LetterCc32 extends CarbonIcon {}
export declare class LetterDd16 extends CarbonIcon {}
export declare class LetterDd20 extends CarbonIcon {}
export declare class LetterDd24 extends CarbonIcon {}
export declare class LetterDd32 extends CarbonIcon {}
export declare class LetterEe16 extends CarbonIcon {}
export declare class LetterEe20 extends CarbonIcon {}
export declare class LetterEe24 extends CarbonIcon {}
export declare class LetterEe32 extends CarbonIcon {}
export declare class LetterFf16 extends CarbonIcon {}
export declare class LetterFf20 extends CarbonIcon {}
export declare class LetterFf24 extends CarbonIcon {}
export declare class LetterFf32 extends CarbonIcon {}
export declare class LetterGg16 extends CarbonIcon {}
export declare class LetterGg20 extends CarbonIcon {}
export declare class LetterGg24 extends CarbonIcon {}
export declare class LetterGg32 extends CarbonIcon {}
export declare class LetterHh16 extends CarbonIcon {}
export declare class LetterHh20 extends CarbonIcon {}
export declare class LetterHh24 extends CarbonIcon {}
export declare class LetterHh32 extends CarbonIcon {}
export declare class LetterIi16 extends CarbonIcon {}
export declare class LetterIi20 extends CarbonIcon {}
export declare class LetterIi24 extends CarbonIcon {}
export declare class LetterIi32 extends CarbonIcon {}
export declare class LetterJj16 extends CarbonIcon {}
export declare class LetterJj20 extends CarbonIcon {}
export declare class LetterJj24 extends CarbonIcon {}
export declare class LetterJj32 extends CarbonIcon {}
export declare class LetterKk16 extends CarbonIcon {}
export declare class LetterKk20 extends CarbonIcon {}
export declare class LetterKk24 extends CarbonIcon {}
export declare class LetterKk32 extends CarbonIcon {}
export declare class LetterLl16 extends CarbonIcon {}
export declare class LetterLl20 extends CarbonIcon {}
export declare class LetterLl24 extends CarbonIcon {}
export declare class LetterLl32 extends CarbonIcon {}
export declare class LetterMm16 extends CarbonIcon {}
export declare class LetterMm20 extends CarbonIcon {}
export declare class LetterMm24 extends CarbonIcon {}
export declare class LetterMm32 extends CarbonIcon {}
export declare class LetterNn16 extends CarbonIcon {}
export declare class LetterNn20 extends CarbonIcon {}
export declare class LetterNn24 extends CarbonIcon {}
export declare class LetterNn32 extends CarbonIcon {}
export declare class LetterOo16 extends CarbonIcon {}
export declare class LetterOo20 extends CarbonIcon {}
export declare class LetterOo24 extends CarbonIcon {}
export declare class LetterOo32 extends CarbonIcon {}
export declare class LetterPp16 extends CarbonIcon {}
export declare class LetterPp20 extends CarbonIcon {}
export declare class LetterPp24 extends CarbonIcon {}
export declare class LetterPp32 extends CarbonIcon {}
export declare class LetterQq16 extends CarbonIcon {}
export declare class LetterQq20 extends CarbonIcon {}
export declare class LetterQq24 extends CarbonIcon {}
export declare class LetterQq32 extends CarbonIcon {}
export declare class LetterRr16 extends CarbonIcon {}
export declare class LetterRr20 extends CarbonIcon {}
export declare class LetterRr24 extends CarbonIcon {}
export declare class LetterRr32 extends CarbonIcon {}
export declare class LetterSs16 extends CarbonIcon {}
export declare class LetterSs20 extends CarbonIcon {}
export declare class LetterSs24 extends CarbonIcon {}
export declare class LetterSs32 extends CarbonIcon {}
export declare class LetterTt16 extends CarbonIcon {}
export declare class LetterTt20 extends CarbonIcon {}
export declare class LetterTt24 extends CarbonIcon {}
export declare class LetterTt32 extends CarbonIcon {}
export declare class LetterUu16 extends CarbonIcon {}
export declare class LetterUu20 extends CarbonIcon {}
export declare class LetterUu24 extends CarbonIcon {}
export declare class LetterUu32 extends CarbonIcon {}
export declare class LetterVv16 extends CarbonIcon {}
export declare class LetterVv20 extends CarbonIcon {}
export declare class LetterVv24 extends CarbonIcon {}
export declare class LetterVv32 extends CarbonIcon {}
export declare class LetterWw16 extends CarbonIcon {}
export declare class LetterWw20 extends CarbonIcon {}
export declare class LetterWw24 extends CarbonIcon {}
export declare class LetterWw32 extends CarbonIcon {}
export declare class LetterXx16 extends CarbonIcon {}
export declare class LetterXx20 extends CarbonIcon {}
export declare class LetterXx24 extends CarbonIcon {}
export declare class LetterXx32 extends CarbonIcon {}
export declare class LetterYy16 extends CarbonIcon {}
export declare class LetterYy20 extends CarbonIcon {}
export declare class LetterYy24 extends CarbonIcon {}
export declare class LetterYy32 extends CarbonIcon {}
export declare class LetterZz16 extends CarbonIcon {}
export declare class LetterZz20 extends CarbonIcon {}
export declare class LetterZz24 extends CarbonIcon {}
export declare class LetterZz32 extends CarbonIcon {}
export declare class License16 extends CarbonIcon {}
export declare class License20 extends CarbonIcon {}
export declare class License24 extends CarbonIcon {}
export declare class License32 extends CarbonIcon {}
export declare class LicenseDraft16 extends CarbonIcon {}
export declare class LicenseDraft20 extends CarbonIcon {}
export declare class LicenseDraft24 extends CarbonIcon {}
export declare class LicenseDraft32 extends CarbonIcon {}
export declare class LicenseGlobal16 extends CarbonIcon {}
export declare class LicenseGlobal20 extends CarbonIcon {}
export declare class LicenseGlobal24 extends CarbonIcon {}
export declare class LicenseGlobal32 extends CarbonIcon {}
export declare class LicenseMaintenance16 extends CarbonIcon {}
export declare class LicenseMaintenance20 extends CarbonIcon {}
export declare class LicenseMaintenance24 extends CarbonIcon {}
export declare class LicenseMaintenance32 extends CarbonIcon {}
export declare class LicenseMaintenanceDraft16 extends CarbonIcon {}
export declare class LicenseMaintenanceDraft20 extends CarbonIcon {}
export declare class LicenseMaintenanceDraft24 extends CarbonIcon {}
export declare class LicenseMaintenanceDraft32 extends CarbonIcon {}
export declare class LicenseThirdParty16 extends CarbonIcon {}
export declare class LicenseThirdParty20 extends CarbonIcon {}
export declare class LicenseThirdParty24 extends CarbonIcon {}
export declare class LicenseThirdParty32 extends CarbonIcon {}
export declare class LicenseThirdPartyDraft16 extends CarbonIcon {}
export declare class LicenseThirdPartyDraft20 extends CarbonIcon {}
export declare class LicenseThirdPartyDraft24 extends CarbonIcon {}
export declare class LicenseThirdPartyDraft32 extends CarbonIcon {}
export declare class Light16 extends CarbonIcon {}
export declare class Light20 extends CarbonIcon {}
export declare class Light24 extends CarbonIcon {}
export declare class Light32 extends CarbonIcon {}
export declare class LightFilled16 extends CarbonIcon {}
export declare class LightFilled20 extends CarbonIcon {}
export declare class LightFilled24 extends CarbonIcon {}
export declare class LightFilled32 extends CarbonIcon {}
export declare class Lightning16 extends CarbonIcon {}
export declare class Lightning20 extends CarbonIcon {}
export declare class Lightning24 extends CarbonIcon {}
export declare class Lightning32 extends CarbonIcon {}
export declare class Link16 extends CarbonIcon {}
export declare class Link20 extends CarbonIcon {}
export declare class Link24 extends CarbonIcon {}
export declare class Link32 extends CarbonIcon {}
export declare class Linux16 extends CarbonIcon {}
export declare class Linux20 extends CarbonIcon {}
export declare class Linux24 extends CarbonIcon {}
export declare class Linux32 extends CarbonIcon {}
export declare class LinuxAlt16 extends CarbonIcon {}
export declare class LinuxAlt20 extends CarbonIcon {}
export declare class LinuxAlt24 extends CarbonIcon {}
export declare class LinuxAlt32 extends CarbonIcon {}
export declare class List16 extends CarbonIcon {}
export declare class List20 extends CarbonIcon {}
export declare class List24 extends CarbonIcon {}
export declare class List32 extends CarbonIcon {}
export declare class ListBoxes16 extends CarbonIcon {}
export declare class ListBoxes20 extends CarbonIcon {}
export declare class ListBoxes24 extends CarbonIcon {}
export declare class ListBoxes32 extends CarbonIcon {}
export declare class ListBulleted16 extends CarbonIcon {}
export declare class ListBulleted20 extends CarbonIcon {}
export declare class ListBulleted24 extends CarbonIcon {}
export declare class ListBulleted32 extends CarbonIcon {}
export declare class ListChecked16 extends CarbonIcon {}
export declare class ListChecked20 extends CarbonIcon {}
export declare class ListChecked24 extends CarbonIcon {}
export declare class ListChecked32 extends CarbonIcon {}
export declare class ListDropdown16 extends CarbonIcon {}
export declare class ListDropdown20 extends CarbonIcon {}
export declare class ListDropdown24 extends CarbonIcon {}
export declare class ListDropdown32 extends CarbonIcon {}
export declare class ListNumbered16 extends CarbonIcon {}
export declare class ListNumbered20 extends CarbonIcon {}
export declare class ListNumbered24 extends CarbonIcon {}
export declare class ListNumbered32 extends CarbonIcon {}
export declare class Location16 extends CarbonIcon {}
export declare class Location20 extends CarbonIcon {}
export declare class Location24 extends CarbonIcon {}
export declare class Location32 extends CarbonIcon {}
export declare class LocationCompany16 extends CarbonIcon {}
export declare class LocationCompany20 extends CarbonIcon {}
export declare class LocationCompany24 extends CarbonIcon {}
export declare class LocationCompany32 extends CarbonIcon {}
export declare class LocationCompanyFilled16 extends CarbonIcon {}
export declare class LocationCompanyFilled20 extends CarbonIcon {}
export declare class LocationCompanyFilled24 extends CarbonIcon {}
export declare class LocationCompanyFilled32 extends CarbonIcon {}
export declare class LocationHazard16 extends CarbonIcon {}
export declare class LocationHazard20 extends CarbonIcon {}
export declare class LocationHazard24 extends CarbonIcon {}
export declare class LocationHazard32 extends CarbonIcon {}
export declare class LocationHazardFilled16 extends CarbonIcon {}
export declare class LocationHazardFilled20 extends CarbonIcon {}
export declare class LocationHazardFilled24 extends CarbonIcon {}
export declare class LocationHazardFilled32 extends CarbonIcon {}
export declare class LocationHeart16 extends CarbonIcon {}
export declare class LocationHeart20 extends CarbonIcon {}
export declare class LocationHeart24 extends CarbonIcon {}
export declare class LocationHeart32 extends CarbonIcon {}
export declare class LocationHeartFilled16 extends CarbonIcon {}
export declare class LocationHeartFilled20 extends CarbonIcon {}
export declare class LocationHeartFilled24 extends CarbonIcon {}
export declare class LocationHeartFilled32 extends CarbonIcon {}
export declare class LocationPerson16 extends CarbonIcon {}
export declare class LocationPerson20 extends CarbonIcon {}
export declare class LocationPerson24 extends CarbonIcon {}
export declare class LocationPerson32 extends CarbonIcon {}
export declare class LocationPersonFilled16 extends CarbonIcon {}
export declare class LocationPersonFilled20 extends CarbonIcon {}
export declare class LocationPersonFilled24 extends CarbonIcon {}
export declare class LocationPersonFilled32 extends CarbonIcon {}
export declare class LocationStar16 extends CarbonIcon {}
export declare class LocationStar20 extends CarbonIcon {}
export declare class LocationStar24 extends CarbonIcon {}
export declare class LocationStar32 extends CarbonIcon {}
export declare class LocationStarFilled16 extends CarbonIcon {}
export declare class LocationStarFilled20 extends CarbonIcon {}
export declare class LocationStarFilled24 extends CarbonIcon {}
export declare class LocationStarFilled32 extends CarbonIcon {}
export declare class Locked16 extends CarbonIcon {}
export declare class Locked20 extends CarbonIcon {}
export declare class Locked24 extends CarbonIcon {}
export declare class Locked32 extends CarbonIcon {}
export declare class Login16 extends CarbonIcon {}
export declare class Login20 extends CarbonIcon {}
export declare class Login24 extends CarbonIcon {}
export declare class Login32 extends CarbonIcon {}
export declare class LogoDigg16 extends CarbonIcon {}
export declare class LogoDigg20 extends CarbonIcon {}
export declare class LogoDigg24 extends CarbonIcon {}
export declare class LogoDigg32 extends CarbonIcon {}
export declare class LogoFacebook16 extends CarbonIcon {}
export declare class LogoFacebook20 extends CarbonIcon {}
export declare class LogoFacebook24 extends CarbonIcon {}
export declare class LogoFacebook32 extends CarbonIcon {}
export declare class LogoFlickr16 extends CarbonIcon {}
export declare class LogoFlickr20 extends CarbonIcon {}
export declare class LogoFlickr24 extends CarbonIcon {}
export declare class LogoFlickr32 extends CarbonIcon {}
export declare class LogoGithub16 extends CarbonIcon {}
export declare class LogoGithub20 extends CarbonIcon {}
export declare class LogoGithub24 extends CarbonIcon {}
export declare class LogoGithub32 extends CarbonIcon {}
export declare class LogoGlassdoor16 extends CarbonIcon {}
export declare class LogoGlassdoor20 extends CarbonIcon {}
export declare class LogoGlassdoor24 extends CarbonIcon {}
export declare class LogoGlassdoor32 extends CarbonIcon {}
export declare class LogoInstagram16 extends CarbonIcon {}
export declare class LogoInstagram20 extends CarbonIcon {}
export declare class LogoInstagram24 extends CarbonIcon {}
export declare class LogoInstagram32 extends CarbonIcon {}
export declare class LogoJupyter16 extends CarbonIcon {}
export declare class LogoJupyter20 extends CarbonIcon {}
export declare class LogoJupyter24 extends CarbonIcon {}
export declare class LogoJupyter32 extends CarbonIcon {}
export declare class LogoKeybase16 extends CarbonIcon {}
export declare class LogoKeybase20 extends CarbonIcon {}
export declare class LogoKeybase24 extends CarbonIcon {}
export declare class LogoKeybase32 extends CarbonIcon {}
export declare class LogoLinkedin16 extends CarbonIcon {}
export declare class LogoLinkedin20 extends CarbonIcon {}
export declare class LogoLinkedin24 extends CarbonIcon {}
export declare class LogoLinkedin32 extends CarbonIcon {}
export declare class LogoLivestream16 extends CarbonIcon {}
export declare class LogoLivestream20 extends CarbonIcon {}
export declare class LogoLivestream24 extends CarbonIcon {}
export declare class LogoLivestream32 extends CarbonIcon {}
export declare class LogoMedium16 extends CarbonIcon {}
export declare class LogoMedium20 extends CarbonIcon {}
export declare class LogoMedium24 extends CarbonIcon {}
export declare class LogoMedium32 extends CarbonIcon {}
export declare class LogoOpenshift16 extends CarbonIcon {}
export declare class LogoOpenshift20 extends CarbonIcon {}
export declare class LogoOpenshift24 extends CarbonIcon {}
export declare class LogoOpenshift32 extends CarbonIcon {}
export declare class LogoPinterest16 extends CarbonIcon {}
export declare class LogoPinterest20 extends CarbonIcon {}
export declare class LogoPinterest24 extends CarbonIcon {}
export declare class LogoPinterest32 extends CarbonIcon {}
export declare class LogoPython16 extends CarbonIcon {}
export declare class LogoPython20 extends CarbonIcon {}
export declare class LogoPython24 extends CarbonIcon {}
export declare class LogoPython32 extends CarbonIcon {}
export declare class LogoQuora16 extends CarbonIcon {}
export declare class LogoQuora20 extends CarbonIcon {}
export declare class LogoQuora24 extends CarbonIcon {}
export declare class LogoQuora32 extends CarbonIcon {}
export declare class LogoRScript16 extends CarbonIcon {}
export declare class LogoRScript20 extends CarbonIcon {}
export declare class LogoRScript24 extends CarbonIcon {}
export declare class LogoRScript32 extends CarbonIcon {}
export declare class LogoSkype16 extends CarbonIcon {}
export declare class LogoSkype20 extends CarbonIcon {}
export declare class LogoSkype24 extends CarbonIcon {}
export declare class LogoSkype32 extends CarbonIcon {}
export declare class LogoSlack16 extends CarbonIcon {}
export declare class LogoSlack20 extends CarbonIcon {}
export declare class LogoSlack24 extends CarbonIcon {}
export declare class LogoSlack32 extends CarbonIcon {}
export declare class LogoSnapchat16 extends CarbonIcon {}
export declare class LogoSnapchat20 extends CarbonIcon {}
export declare class LogoSnapchat24 extends CarbonIcon {}
export declare class LogoSnapchat32 extends CarbonIcon {}
export declare class LogoTumblr16 extends CarbonIcon {}
export declare class LogoTumblr20 extends CarbonIcon {}
export declare class LogoTumblr24 extends CarbonIcon {}
export declare class LogoTumblr32 extends CarbonIcon {}
export declare class LogoTwitter16 extends CarbonIcon {}
export declare class LogoTwitter20 extends CarbonIcon {}
export declare class LogoTwitter24 extends CarbonIcon {}
export declare class LogoTwitter32 extends CarbonIcon {}
export declare class LogoVmware16 extends CarbonIcon {}
export declare class LogoVmware20 extends CarbonIcon {}
export declare class LogoVmware24 extends CarbonIcon {}
export declare class LogoVmware32 extends CarbonIcon {}
export declare class LogoXing16 extends CarbonIcon {}
export declare class LogoXing20 extends CarbonIcon {}
export declare class LogoXing24 extends CarbonIcon {}
export declare class LogoXing32 extends CarbonIcon {}
export declare class LogoYelp16 extends CarbonIcon {}
export declare class LogoYelp20 extends CarbonIcon {}
export declare class LogoYelp24 extends CarbonIcon {}
export declare class LogoYelp32 extends CarbonIcon {}
export declare class LogoYoutube16 extends CarbonIcon {}
export declare class LogoYoutube20 extends CarbonIcon {}
export declare class LogoYoutube24 extends CarbonIcon {}
export declare class LogoYoutube32 extends CarbonIcon {}
export declare class Logout16 extends CarbonIcon {}
export declare class Logout20 extends CarbonIcon {}
export declare class Logout24 extends CarbonIcon {}
export declare class Logout32 extends CarbonIcon {}
export declare class Loop16 extends CarbonIcon {}
export declare class Loop20 extends CarbonIcon {}
export declare class Loop24 extends CarbonIcon {}
export declare class Loop32 extends CarbonIcon {}
export declare class MacCommand16 extends CarbonIcon {}
export declare class MacCommand20 extends CarbonIcon {}
export declare class MacCommand24 extends CarbonIcon {}
export declare class MacCommand32 extends CarbonIcon {}
export declare class MacOption16 extends CarbonIcon {}
export declare class MacOption20 extends CarbonIcon {}
export declare class MacOption24 extends CarbonIcon {}
export declare class MacOption32 extends CarbonIcon {}
export declare class MacShift16 extends CarbonIcon {}
export declare class MacShift20 extends CarbonIcon {}
export declare class MacShift24 extends CarbonIcon {}
export declare class MacShift32 extends CarbonIcon {}
export declare class MachineLearning16 extends CarbonIcon {}
export declare class MachineLearning20 extends CarbonIcon {}
export declare class MachineLearning24 extends CarbonIcon {}
export declare class MachineLearning32 extends CarbonIcon {}
export declare class MachineLearningModel16 extends CarbonIcon {}
export declare class MachineLearningModel20 extends CarbonIcon {}
export declare class MachineLearningModel24 extends CarbonIcon {}
export declare class MachineLearningModel32 extends CarbonIcon {}
export declare class MagicWand16 extends CarbonIcon {}
export declare class MagicWand20 extends CarbonIcon {}
export declare class MagicWand24 extends CarbonIcon {}
export declare class MagicWand32 extends CarbonIcon {}
export declare class MagicWandFilled16 extends CarbonIcon {}
export declare class MagicWandFilled20 extends CarbonIcon {}
export declare class MagicWandFilled24 extends CarbonIcon {}
export declare class MagicWandFilled32 extends CarbonIcon {}
export declare class MailAll16 extends CarbonIcon {}
export declare class MailAll20 extends CarbonIcon {}
export declare class MailAll24 extends CarbonIcon {}
export declare class MailAll32 extends CarbonIcon {}
export declare class MailReply16 extends CarbonIcon {}
export declare class MailReply20 extends CarbonIcon {}
export declare class MailReply24 extends CarbonIcon {}
export declare class MailReply32 extends CarbonIcon {}
export declare class ManageProtection16 extends CarbonIcon {}
export declare class ManageProtection20 extends CarbonIcon {}
export declare class ManageProtection24 extends CarbonIcon {}
export declare class ManageProtection32 extends CarbonIcon {}
export declare class ManagedSolutions16 extends CarbonIcon {}
export declare class ManagedSolutions20 extends CarbonIcon {}
export declare class ManagedSolutions24 extends CarbonIcon {}
export declare class ManagedSolutions32 extends CarbonIcon {}
export declare class Map16 extends CarbonIcon {}
export declare class Map20 extends CarbonIcon {}
export declare class Map24 extends CarbonIcon {}
export declare class Map32 extends CarbonIcon {}
export declare class MapBoundary16 extends CarbonIcon {}
export declare class MapBoundary20 extends CarbonIcon {}
export declare class MapBoundary24 extends CarbonIcon {}
export declare class MapBoundary32 extends CarbonIcon {}
export declare class MarineWarning16 extends CarbonIcon {}
export declare class MarineWarning20 extends CarbonIcon {}
export declare class MarineWarning24 extends CarbonIcon {}
export declare class MarineWarning32 extends CarbonIcon {}
export declare class MathCurve16 extends CarbonIcon {}
export declare class MathCurve20 extends CarbonIcon {}
export declare class MathCurve24 extends CarbonIcon {}
export declare class MathCurve32 extends CarbonIcon {}
export declare class Maximize16 extends CarbonIcon {}
export declare class Maximize20 extends CarbonIcon {}
export declare class Maximize24 extends CarbonIcon {}
export declare class Maximize32 extends CarbonIcon {}
export declare class Medication16 extends CarbonIcon {}
export declare class Medication20 extends CarbonIcon {}
export declare class Medication24 extends CarbonIcon {}
export declare class Medication32 extends CarbonIcon {}
export declare class MedicationAlert16 extends CarbonIcon {}
export declare class MedicationAlert20 extends CarbonIcon {}
export declare class MedicationAlert24 extends CarbonIcon {}
export declare class MedicationAlert32 extends CarbonIcon {}
export declare class MedicationReminder16 extends CarbonIcon {}
export declare class MedicationReminder20 extends CarbonIcon {}
export declare class MedicationReminder24 extends CarbonIcon {}
export declare class MedicationReminder32 extends CarbonIcon {}
export declare class Menu16 extends CarbonIcon {}
export declare class Menu20 extends CarbonIcon {}
export declare class Menu24 extends CarbonIcon {}
export declare class Menu32 extends CarbonIcon {}
export declare class Meter16 extends CarbonIcon {}
export declare class Meter20 extends CarbonIcon {}
export declare class Meter24 extends CarbonIcon {}
export declare class Meter32 extends CarbonIcon {}
export declare class MeterAlt16 extends CarbonIcon {}
export declare class MeterAlt20 extends CarbonIcon {}
export declare class MeterAlt24 extends CarbonIcon {}
export declare class MeterAlt32 extends CarbonIcon {}
export declare class Microphone16 extends CarbonIcon {}
export declare class Microphone20 extends CarbonIcon {}
export declare class Microphone24 extends CarbonIcon {}
export declare class Microphone32 extends CarbonIcon {}
export declare class MicrophoneFilled16 extends CarbonIcon {}
export declare class MicrophoneFilled20 extends CarbonIcon {}
export declare class MicrophoneFilled24 extends CarbonIcon {}
export declare class MicrophoneFilled32 extends CarbonIcon {}
export declare class MicrophoneOff16 extends CarbonIcon {}
export declare class MicrophoneOff20 extends CarbonIcon {}
export declare class MicrophoneOff24 extends CarbonIcon {}
export declare class MicrophoneOff32 extends CarbonIcon {}
export declare class MicrophoneOffFilled16 extends CarbonIcon {}
export declare class MicrophoneOffFilled20 extends CarbonIcon {}
export declare class MicrophoneOffFilled24 extends CarbonIcon {}
export declare class MicrophoneOffFilled32 extends CarbonIcon {}
export declare class Microscope16 extends CarbonIcon {}
export declare class Microscope20 extends CarbonIcon {}
export declare class Microscope24 extends CarbonIcon {}
export declare class Microscope32 extends CarbonIcon {}
export declare class Migrate16 extends CarbonIcon {}
export declare class Migrate20 extends CarbonIcon {}
export declare class Migrate24 extends CarbonIcon {}
export declare class Migrate32 extends CarbonIcon {}
export declare class MigrateAlt16 extends CarbonIcon {}
export declare class MigrateAlt20 extends CarbonIcon {}
export declare class MigrateAlt24 extends CarbonIcon {}
export declare class MigrateAlt32 extends CarbonIcon {}
export declare class Milestone16 extends CarbonIcon {}
export declare class Milestone20 extends CarbonIcon {}
export declare class Milestone24 extends CarbonIcon {}
export declare class Milestone32 extends CarbonIcon {}
export declare class Minimize16 extends CarbonIcon {}
export declare class Minimize20 extends CarbonIcon {}
export declare class Minimize24 extends CarbonIcon {}
export declare class Minimize32 extends CarbonIcon {}
export declare class Misuse16 extends CarbonIcon {}
export declare class Misuse20 extends CarbonIcon {}
export declare class Misuse24 extends CarbonIcon {}
export declare class Misuse32 extends CarbonIcon {}
export declare class MisuseAlt16 extends CarbonIcon {}
export declare class MisuseAlt20 extends CarbonIcon {}
export declare class MisuseAlt24 extends CarbonIcon {}
export declare class MisuseAlt32 extends CarbonIcon {}
export declare class MisuseOutline16 extends CarbonIcon {}
export declare class MisuseOutline20 extends CarbonIcon {}
export declare class MisuseOutline24 extends CarbonIcon {}
export declare class MisuseOutline32 extends CarbonIcon {}
export declare class MixedRainHail16 extends CarbonIcon {}
export declare class MixedRainHail20 extends CarbonIcon {}
export declare class MixedRainHail24 extends CarbonIcon {}
export declare class MixedRainHail32 extends CarbonIcon {}
export declare class Mobile16 extends CarbonIcon {}
export declare class Mobile20 extends CarbonIcon {}
export declare class Mobile24 extends CarbonIcon {}
export declare class Mobile32 extends CarbonIcon {}
export declare class MobileAdd16 extends CarbonIcon {}
export declare class MobileAdd20 extends CarbonIcon {}
export declare class MobileAdd24 extends CarbonIcon {}
export declare class MobileAdd32 extends CarbonIcon {}
export declare class MobileAudio16 extends CarbonIcon {}
export declare class MobileAudio20 extends CarbonIcon {}
export declare class MobileAudio24 extends CarbonIcon {}
export declare class MobileAudio32 extends CarbonIcon {}
export declare class MobileCheck16 extends CarbonIcon {}
export declare class MobileCheck20 extends CarbonIcon {}
export declare class MobileCheck24 extends CarbonIcon {}
export declare class MobileCheck32 extends CarbonIcon {}
export declare class MobileDownload16 extends CarbonIcon {}
export declare class MobileDownload20 extends CarbonIcon {}
export declare class MobileDownload24 extends CarbonIcon {}
export declare class MobileDownload32 extends CarbonIcon {}
export declare class MobileLandscape16 extends CarbonIcon {}
export declare class MobileLandscape20 extends CarbonIcon {}
export declare class MobileLandscape24 extends CarbonIcon {}
export declare class MobileLandscape32 extends CarbonIcon {}
export declare class Model16 extends CarbonIcon {}
export declare class Model20 extends CarbonIcon {}
export declare class Model24 extends CarbonIcon {}
export declare class Model32 extends CarbonIcon {}
export declare class ModelAlt16 extends CarbonIcon {}
export declare class ModelAlt20 extends CarbonIcon {}
export declare class ModelAlt24 extends CarbonIcon {}
export declare class ModelAlt32 extends CarbonIcon {}
export declare class ModelBuilder16 extends CarbonIcon {}
export declare class ModelBuilder20 extends CarbonIcon {}
export declare class ModelBuilder24 extends CarbonIcon {}
export declare class ModelBuilder32 extends CarbonIcon {}
export declare class ModelBuilderReference16 extends CarbonIcon {}
export declare class ModelBuilderReference20 extends CarbonIcon {}
export declare class ModelBuilderReference24 extends CarbonIcon {}
export declare class ModelBuilderReference32 extends CarbonIcon {}
export declare class ModelReference16 extends CarbonIcon {}
export declare class ModelReference20 extends CarbonIcon {}
export declare class ModelReference24 extends CarbonIcon {}
export declare class ModelReference32 extends CarbonIcon {}
export declare class Money16 extends CarbonIcon {}
export declare class Money20 extends CarbonIcon {}
export declare class Money24 extends CarbonIcon {}
export declare class Money32 extends CarbonIcon {}
export declare class Monster16 extends CarbonIcon {}
export declare class Monster20 extends CarbonIcon {}
export declare class Monster24 extends CarbonIcon {}
export declare class Monster32 extends CarbonIcon {}
export declare class Monument16 extends CarbonIcon {}
export declare class Monument20 extends CarbonIcon {}
export declare class Monument24 extends CarbonIcon {}
export declare class Monument32 extends CarbonIcon {}
export declare class Moon16 extends CarbonIcon {}
export declare class Moon20 extends CarbonIcon {}
export declare class Moon24 extends CarbonIcon {}
export declare class Moon32 extends CarbonIcon {}
export declare class MostlyCloudy16 extends CarbonIcon {}
export declare class MostlyCloudy20 extends CarbonIcon {}
export declare class MostlyCloudy24 extends CarbonIcon {}
export declare class MostlyCloudy32 extends CarbonIcon {}
export declare class MostlyCloudyNight16 extends CarbonIcon {}
export declare class MostlyCloudyNight20 extends CarbonIcon {}
export declare class MostlyCloudyNight24 extends CarbonIcon {}
export declare class MostlyCloudyNight32 extends CarbonIcon {}
export declare class Mountain16 extends CarbonIcon {}
export declare class Mountain20 extends CarbonIcon {}
export declare class Mountain24 extends CarbonIcon {}
export declare class Mountain32 extends CarbonIcon {}
export declare class Mov16 extends CarbonIcon {}
export declare class Mov20 extends CarbonIcon {}
export declare class Mov24 extends CarbonIcon {}
export declare class Mov32 extends CarbonIcon {}
export declare class Move16 extends CarbonIcon {}
export declare class Move20 extends CarbonIcon {}
export declare class Move24 extends CarbonIcon {}
export declare class Move32 extends CarbonIcon {}
export declare class Movement16 extends CarbonIcon {}
export declare class Movement20 extends CarbonIcon {}
export declare class Movement24 extends CarbonIcon {}
export declare class Movement32 extends CarbonIcon {}
export declare class Mp316 extends CarbonIcon {}
export declare class Mp320 extends CarbonIcon {}
export declare class Mp324 extends CarbonIcon {}
export declare class Mp332 extends CarbonIcon {}
export declare class Mp416 extends CarbonIcon {}
export declare class Mp420 extends CarbonIcon {}
export declare class Mp424 extends CarbonIcon {}
export declare class Mp432 extends CarbonIcon {}
export declare class Mpeg16 extends CarbonIcon {}
export declare class Mpeg20 extends CarbonIcon {}
export declare class Mpeg24 extends CarbonIcon {}
export declare class Mpeg32 extends CarbonIcon {}
export declare class Mpg216 extends CarbonIcon {}
export declare class Mpg220 extends CarbonIcon {}
export declare class Mpg224 extends CarbonIcon {}
export declare class Mpg232 extends CarbonIcon {}
export declare class Music16 extends CarbonIcon {}
export declare class Music20 extends CarbonIcon {}
export declare class Music24 extends CarbonIcon {}
export declare class Music32 extends CarbonIcon {}
export declare class NameSpace16 extends CarbonIcon {}
export declare class NameSpace20 extends CarbonIcon {}
export declare class NameSpace24 extends CarbonIcon {}
export declare class NameSpace32 extends CarbonIcon {}
export declare class NavaidCivil16 extends CarbonIcon {}
export declare class NavaidCivil20 extends CarbonIcon {}
export declare class NavaidCivil24 extends CarbonIcon {}
export declare class NavaidCivil32 extends CarbonIcon {}
export declare class NavaidDme16 extends CarbonIcon {}
export declare class NavaidDme20 extends CarbonIcon {}
export declare class NavaidDme24 extends CarbonIcon {}
export declare class NavaidDme32 extends CarbonIcon {}
export declare class NavaidHelipad16 extends CarbonIcon {}
export declare class NavaidHelipad20 extends CarbonIcon {}
export declare class NavaidHelipad24 extends CarbonIcon {}
export declare class NavaidHelipad32 extends CarbonIcon {}
export declare class NavaidMilitary16 extends CarbonIcon {}
export declare class NavaidMilitary20 extends CarbonIcon {}
export declare class NavaidMilitary24 extends CarbonIcon {}
export declare class NavaidMilitary32 extends CarbonIcon {}
export declare class NavaidMilitaryCivil16 extends CarbonIcon {}
export declare class NavaidMilitaryCivil20 extends CarbonIcon {}
export declare class NavaidMilitaryCivil24 extends CarbonIcon {}
export declare class NavaidMilitaryCivil32 extends CarbonIcon {}
export declare class NavaidNdb16 extends CarbonIcon {}
export declare class NavaidNdb20 extends CarbonIcon {}
export declare class NavaidNdb24 extends CarbonIcon {}
export declare class NavaidNdb32 extends CarbonIcon {}
export declare class NavaidNdbDme16 extends CarbonIcon {}
export declare class NavaidNdbDme20 extends CarbonIcon {}
export declare class NavaidNdbDme24 extends CarbonIcon {}
export declare class NavaidNdbDme32 extends CarbonIcon {}
export declare class NavaidPrivate16 extends CarbonIcon {}
export declare class NavaidPrivate20 extends CarbonIcon {}
export declare class NavaidPrivate24 extends CarbonIcon {}
export declare class NavaidPrivate32 extends CarbonIcon {}
export declare class NavaidSeaplane16 extends CarbonIcon {}
export declare class NavaidSeaplane20 extends CarbonIcon {}
export declare class NavaidSeaplane24 extends CarbonIcon {}
export declare class NavaidSeaplane32 extends CarbonIcon {}
export declare class NavaidTacan16 extends CarbonIcon {}
export declare class NavaidTacan20 extends CarbonIcon {}
export declare class NavaidTacan24 extends CarbonIcon {}
export declare class NavaidTacan32 extends CarbonIcon {}
export declare class NavaidVhfor16 extends CarbonIcon {}
export declare class NavaidVhfor20 extends CarbonIcon {}
export declare class NavaidVhfor24 extends CarbonIcon {}
export declare class NavaidVhfor32 extends CarbonIcon {}
export declare class NavaidVor16 extends CarbonIcon {}
export declare class NavaidVor20 extends CarbonIcon {}
export declare class NavaidVor24 extends CarbonIcon {}
export declare class NavaidVor32 extends CarbonIcon {}
export declare class NavaidVordme16 extends CarbonIcon {}
export declare class NavaidVordme20 extends CarbonIcon {}
export declare class NavaidVordme24 extends CarbonIcon {}
export declare class NavaidVordme32 extends CarbonIcon {}
export declare class NavaidVortac16 extends CarbonIcon {}
export declare class NavaidVortac20 extends CarbonIcon {}
export declare class NavaidVortac24 extends CarbonIcon {}
export declare class NavaidVortac32 extends CarbonIcon {}
export declare class Network_116 extends CarbonIcon {}
export declare class Network_120 extends CarbonIcon {}
export declare class Network_124 extends CarbonIcon {}
export declare class Network_132 extends CarbonIcon {}
export declare class Network_216 extends CarbonIcon {}
export declare class Network_220 extends CarbonIcon {}
export declare class Network_224 extends CarbonIcon {}
export declare class Network_232 extends CarbonIcon {}
export declare class Network_316 extends CarbonIcon {}
export declare class Network_320 extends CarbonIcon {}
export declare class Network_324 extends CarbonIcon {}
export declare class Network_332 extends CarbonIcon {}
export declare class Network_3Reference16 extends CarbonIcon {}
export declare class Network_3Reference20 extends CarbonIcon {}
export declare class Network_3Reference24 extends CarbonIcon {}
export declare class Network_3Reference32 extends CarbonIcon {}
export declare class Network_416 extends CarbonIcon {}
export declare class Network_420 extends CarbonIcon {}
export declare class Network_424 extends CarbonIcon {}
export declare class Network_432 extends CarbonIcon {}
export declare class NewTab16 extends CarbonIcon {}
export declare class NewTab20 extends CarbonIcon {}
export declare class NewTab24 extends CarbonIcon {}
export declare class NewTab32 extends CarbonIcon {}
export declare class NextFilled16 extends CarbonIcon {}
export declare class NextFilled20 extends CarbonIcon {}
export declare class NextFilled24 extends CarbonIcon {}
export declare class NextFilled32 extends CarbonIcon {}
export declare class NextOutline16 extends CarbonIcon {}
export declare class NextOutline20 extends CarbonIcon {}
export declare class NextOutline24 extends CarbonIcon {}
export declare class NextOutline32 extends CarbonIcon {}
export declare class NoImage16 extends CarbonIcon {}
export declare class NoImage20 extends CarbonIcon {}
export declare class NoImage24 extends CarbonIcon {}
export declare class NoImage32 extends CarbonIcon {}
export declare class NoTicket16 extends CarbonIcon {}
export declare class NoTicket20 extends CarbonIcon {}
export declare class NoTicket24 extends CarbonIcon {}
export declare class NoTicket32 extends CarbonIcon {}
export declare class Nominal16 extends CarbonIcon {}
export declare class Nominal20 extends CarbonIcon {}
export declare class Nominal24 extends CarbonIcon {}
export declare class Nominal32 extends CarbonIcon {}
export declare class NonCertified16 extends CarbonIcon {}
export declare class NonCertified20 extends CarbonIcon {}
export declare class NonCertified24 extends CarbonIcon {}
export declare class NonCertified32 extends CarbonIcon {}
export declare class NoodleBowl16 extends CarbonIcon {}
export declare class NoodleBowl20 extends CarbonIcon {}
export declare class NoodleBowl24 extends CarbonIcon {}
export declare class NoodleBowl32 extends CarbonIcon {}
export declare class NotAvailable16 extends CarbonIcon {}
export declare class NotAvailable20 extends CarbonIcon {}
export declare class NotAvailable24 extends CarbonIcon {}
export declare class NotAvailable32 extends CarbonIcon {}
export declare class NotSent16 extends CarbonIcon {}
export declare class NotSent20 extends CarbonIcon {}
export declare class NotSent24 extends CarbonIcon {}
export declare class NotSent32 extends CarbonIcon {}
export declare class NotSentFilled16 extends CarbonIcon {}
export declare class NotSentFilled20 extends CarbonIcon {}
export declare class NotSentFilled24 extends CarbonIcon {}
export declare class NotSentFilled32 extends CarbonIcon {}
export declare class Notebook16 extends CarbonIcon {}
export declare class Notebook20 extends CarbonIcon {}
export declare class Notebook24 extends CarbonIcon {}
export declare class Notebook32 extends CarbonIcon {}
export declare class NotebookReference16 extends CarbonIcon {}
export declare class NotebookReference20 extends CarbonIcon {}
export declare class NotebookReference24 extends CarbonIcon {}
export declare class NotebookReference32 extends CarbonIcon {}
export declare class Notification16 extends CarbonIcon {}
export declare class Notification20 extends CarbonIcon {}
export declare class Notification24 extends CarbonIcon {}
export declare class Notification32 extends CarbonIcon {}
export declare class NotificationFilled16 extends CarbonIcon {}
export declare class NotificationFilled20 extends CarbonIcon {}
export declare class NotificationFilled24 extends CarbonIcon {}
export declare class NotificationFilled32 extends CarbonIcon {}
export declare class NotificationNew16 extends CarbonIcon {}
export declare class NotificationNew20 extends CarbonIcon {}
export declare class NotificationNew24 extends CarbonIcon {}
export declare class NotificationNew32 extends CarbonIcon {}
export declare class NotificationOff16 extends CarbonIcon {}
export declare class NotificationOff20 extends CarbonIcon {}
export declare class NotificationOff24 extends CarbonIcon {}
export declare class NotificationOff32 extends CarbonIcon {}
export declare class NotificationOffFilled16 extends CarbonIcon {}
export declare class NotificationOffFilled20 extends CarbonIcon {}
export declare class NotificationOffFilled24 extends CarbonIcon {}
export declare class NotificationOffFilled32 extends CarbonIcon {}
export declare class NumberSmall_016 extends CarbonIcon {}
export declare class NumberSmall_020 extends CarbonIcon {}
export declare class NumberSmall_024 extends CarbonIcon {}
export declare class NumberSmall_032 extends CarbonIcon {}
export declare class NumberSmall_116 extends CarbonIcon {}
export declare class NumberSmall_120 extends CarbonIcon {}
export declare class NumberSmall_124 extends CarbonIcon {}
export declare class NumberSmall_132 extends CarbonIcon {}
export declare class NumberSmall_216 extends CarbonIcon {}
export declare class NumberSmall_220 extends CarbonIcon {}
export declare class NumberSmall_224 extends CarbonIcon {}
export declare class NumberSmall_232 extends CarbonIcon {}
export declare class NumberSmall_316 extends CarbonIcon {}
export declare class NumberSmall_320 extends CarbonIcon {}
export declare class NumberSmall_324 extends CarbonIcon {}
export declare class NumberSmall_332 extends CarbonIcon {}
export declare class NumberSmall_416 extends CarbonIcon {}
export declare class NumberSmall_420 extends CarbonIcon {}
export declare class NumberSmall_424 extends CarbonIcon {}
export declare class NumberSmall_432 extends CarbonIcon {}
export declare class NumberSmall_516 extends CarbonIcon {}
export declare class NumberSmall_520 extends CarbonIcon {}
export declare class NumberSmall_524 extends CarbonIcon {}
export declare class NumberSmall_532 extends CarbonIcon {}
export declare class NumberSmall_616 extends CarbonIcon {}
export declare class NumberSmall_620 extends CarbonIcon {}
export declare class NumberSmall_624 extends CarbonIcon {}
export declare class NumberSmall_632 extends CarbonIcon {}
export declare class NumberSmall_716 extends CarbonIcon {}
export declare class NumberSmall_720 extends CarbonIcon {}
export declare class NumberSmall_724 extends CarbonIcon {}
export declare class NumberSmall_732 extends CarbonIcon {}
export declare class NumberSmall_816 extends CarbonIcon {}
export declare class NumberSmall_820 extends CarbonIcon {}
export declare class NumberSmall_824 extends CarbonIcon {}
export declare class NumberSmall_832 extends CarbonIcon {}
export declare class NumberSmall_916 extends CarbonIcon {}
export declare class NumberSmall_920 extends CarbonIcon {}
export declare class NumberSmall_924 extends CarbonIcon {}
export declare class NumberSmall_932 extends CarbonIcon {}
export declare class Number_016 extends CarbonIcon {}
export declare class Number_020 extends CarbonIcon {}
export declare class Number_024 extends CarbonIcon {}
export declare class Number_032 extends CarbonIcon {}
export declare class Number_116 extends CarbonIcon {}
export declare class Number_120 extends CarbonIcon {}
export declare class Number_124 extends CarbonIcon {}
export declare class Number_132 extends CarbonIcon {}
export declare class Number_216 extends CarbonIcon {}
export declare class Number_220 extends CarbonIcon {}
export declare class Number_224 extends CarbonIcon {}
export declare class Number_232 extends CarbonIcon {}
export declare class Number_316 extends CarbonIcon {}
export declare class Number_320 extends CarbonIcon {}
export declare class Number_324 extends CarbonIcon {}
export declare class Number_332 extends CarbonIcon {}
export declare class Number_416 extends CarbonIcon {}
export declare class Number_420 extends CarbonIcon {}
export declare class Number_424 extends CarbonIcon {}
export declare class Number_432 extends CarbonIcon {}
export declare class Number_516 extends CarbonIcon {}
export declare class Number_520 extends CarbonIcon {}
export declare class Number_524 extends CarbonIcon {}
export declare class Number_532 extends CarbonIcon {}
export declare class Number_616 extends CarbonIcon {}
export declare class Number_620 extends CarbonIcon {}
export declare class Number_624 extends CarbonIcon {}
export declare class Number_632 extends CarbonIcon {}
export declare class Number_716 extends CarbonIcon {}
export declare class Number_720 extends CarbonIcon {}
export declare class Number_724 extends CarbonIcon {}
export declare class Number_732 extends CarbonIcon {}
export declare class Number_816 extends CarbonIcon {}
export declare class Number_820 extends CarbonIcon {}
export declare class Number_824 extends CarbonIcon {}
export declare class Number_832 extends CarbonIcon {}
export declare class Number_916 extends CarbonIcon {}
export declare class Number_920 extends CarbonIcon {}
export declare class Number_924 extends CarbonIcon {}
export declare class Number_932 extends CarbonIcon {}
export declare class ObjectStorage16 extends CarbonIcon {}
export declare class ObjectStorage20 extends CarbonIcon {}
export declare class ObjectStorage24 extends CarbonIcon {}
export declare class ObjectStorage32 extends CarbonIcon {}
export declare class ObservedHail16 extends CarbonIcon {}
export declare class ObservedHail20 extends CarbonIcon {}
export declare class ObservedHail24 extends CarbonIcon {}
export declare class ObservedHail32 extends CarbonIcon {}
export declare class ObservedLightning16 extends CarbonIcon {}
export declare class ObservedLightning20 extends CarbonIcon {}
export declare class ObservedLightning24 extends CarbonIcon {}
export declare class ObservedLightning32 extends CarbonIcon {}
export declare class Omega16 extends CarbonIcon {}
export declare class Omega20 extends CarbonIcon {}
export declare class Omega24 extends CarbonIcon {}
export declare class Omega32 extends CarbonIcon {}
export declare class Opacity16 extends CarbonIcon {}
export declare class Opacity20 extends CarbonIcon {}
export declare class Opacity24 extends CarbonIcon {}
export declare class Opacity32 extends CarbonIcon {}
export declare class OpenPanelBottom16 extends CarbonIcon {}
export declare class OpenPanelBottom20 extends CarbonIcon {}
export declare class OpenPanelBottom24 extends CarbonIcon {}
export declare class OpenPanelBottom32 extends CarbonIcon {}
export declare class OpenPanelFilledBottom16 extends CarbonIcon {}
export declare class OpenPanelFilledBottom20 extends CarbonIcon {}
export declare class OpenPanelFilledBottom24 extends CarbonIcon {}
export declare class OpenPanelFilledBottom32 extends CarbonIcon {}
export declare class OpenPanelFilledLeft16 extends CarbonIcon {}
export declare class OpenPanelFilledLeft20 extends CarbonIcon {}
export declare class OpenPanelFilledLeft24 extends CarbonIcon {}
export declare class OpenPanelFilledLeft32 extends CarbonIcon {}
export declare class OpenPanelFilledRight16 extends CarbonIcon {}
export declare class OpenPanelFilledRight20 extends CarbonIcon {}
export declare class OpenPanelFilledRight24 extends CarbonIcon {}
export declare class OpenPanelFilledRight32 extends CarbonIcon {}
export declare class OpenPanelFilledTop16 extends CarbonIcon {}
export declare class OpenPanelFilledTop20 extends CarbonIcon {}
export declare class OpenPanelFilledTop24 extends CarbonIcon {}
export declare class OpenPanelFilledTop32 extends CarbonIcon {}
export declare class OpenPanelLeft16 extends CarbonIcon {}
export declare class OpenPanelLeft20 extends CarbonIcon {}
export declare class OpenPanelLeft24 extends CarbonIcon {}
export declare class OpenPanelLeft32 extends CarbonIcon {}
export declare class OpenPanelRight16 extends CarbonIcon {}
export declare class OpenPanelRight20 extends CarbonIcon {}
export declare class OpenPanelRight24 extends CarbonIcon {}
export declare class OpenPanelRight32 extends CarbonIcon {}
export declare class OpenPanelTop16 extends CarbonIcon {}
export declare class OpenPanelTop20 extends CarbonIcon {}
export declare class OpenPanelTop24 extends CarbonIcon {}
export declare class OpenPanelTop32 extends CarbonIcon {}
export declare class OperationsField16 extends CarbonIcon {}
export declare class OperationsField20 extends CarbonIcon {}
export declare class OperationsField24 extends CarbonIcon {}
export declare class OperationsField32 extends CarbonIcon {}
export declare class OperationsRecord16 extends CarbonIcon {}
export declare class OperationsRecord20 extends CarbonIcon {}
export declare class OperationsRecord24 extends CarbonIcon {}
export declare class OperationsRecord32 extends CarbonIcon {}
export declare class Ordinal16 extends CarbonIcon {}
export declare class Ordinal20 extends CarbonIcon {}
export declare class Ordinal24 extends CarbonIcon {}
export declare class Ordinal32 extends CarbonIcon {}
export declare class Outage16 extends CarbonIcon {}
export declare class Outage20 extends CarbonIcon {}
export declare class Outage24 extends CarbonIcon {}
export declare class Outage32 extends CarbonIcon {}
export declare class OutlookSevere16 extends CarbonIcon {}
export declare class OutlookSevere20 extends CarbonIcon {}
export declare class OutlookSevere24 extends CarbonIcon {}
export declare class OutlookSevere32 extends CarbonIcon {}
export declare class OverflowMenuHorizontal16 extends CarbonIcon {}
export declare class OverflowMenuHorizontal20 extends CarbonIcon {}
export declare class OverflowMenuHorizontal24 extends CarbonIcon {}
export declare class OverflowMenuHorizontal32 extends CarbonIcon {}
export declare class OverflowMenuVertical16 extends CarbonIcon {}
export declare class OverflowMenuVertical20 extends CarbonIcon {}
export declare class OverflowMenuVertical24 extends CarbonIcon {}
export declare class OverflowMenuVertical32 extends CarbonIcon {}
export declare class Overlay16 extends CarbonIcon {}
export declare class Overlay20 extends CarbonIcon {}
export declare class Overlay24 extends CarbonIcon {}
export declare class Overlay32 extends CarbonIcon {}
export declare class Package16 extends CarbonIcon {}
export declare class Package20 extends CarbonIcon {}
export declare class Package24 extends CarbonIcon {}
export declare class Package32 extends CarbonIcon {}
export declare class PageBreak16 extends CarbonIcon {}
export declare class PageBreak20 extends CarbonIcon {}
export declare class PageBreak24 extends CarbonIcon {}
export declare class PageBreak32 extends CarbonIcon {}
export declare class PageFirst16 extends CarbonIcon {}
export declare class PageFirst20 extends CarbonIcon {}
export declare class PageFirst24 extends CarbonIcon {}
export declare class PageFirst32 extends CarbonIcon {}
export declare class PageLast16 extends CarbonIcon {}
export declare class PageLast20 extends CarbonIcon {}
export declare class PageLast24 extends CarbonIcon {}
export declare class PageLast32 extends CarbonIcon {}
export declare class PageNumber16 extends CarbonIcon {}
export declare class PageNumber20 extends CarbonIcon {}
export declare class PageNumber24 extends CarbonIcon {}
export declare class PageNumber32 extends CarbonIcon {}
export declare class PaintBrush16 extends CarbonIcon {}
export declare class PaintBrush20 extends CarbonIcon {}
export declare class PaintBrush24 extends CarbonIcon {}
export declare class PaintBrush32 extends CarbonIcon {}
export declare class PaintBrushAlt16 extends CarbonIcon {}
export declare class PaintBrushAlt20 extends CarbonIcon {}
export declare class PaintBrushAlt24 extends CarbonIcon {}
export declare class PaintBrushAlt32 extends CarbonIcon {}
export declare class PalmTree16 extends CarbonIcon {}
export declare class PalmTree20 extends CarbonIcon {}
export declare class PalmTree24 extends CarbonIcon {}
export declare class PalmTree32 extends CarbonIcon {}
export declare class PanHorizontal16 extends CarbonIcon {}
export declare class PanHorizontal20 extends CarbonIcon {}
export declare class PanHorizontal24 extends CarbonIcon {}
export declare class PanHorizontal32 extends CarbonIcon {}
export declare class PanVertical16 extends CarbonIcon {}
export declare class PanVertical20 extends CarbonIcon {}
export declare class PanVertical24 extends CarbonIcon {}
export declare class PanVertical32 extends CarbonIcon {}
export declare class PanelExpansion16 extends CarbonIcon {}
export declare class PanelExpansion20 extends CarbonIcon {}
export declare class PanelExpansion24 extends CarbonIcon {}
export declare class PanelExpansion32 extends CarbonIcon {}
export declare class Paragraph16 extends CarbonIcon {}
export declare class Paragraph20 extends CarbonIcon {}
export declare class Paragraph24 extends CarbonIcon {}
export declare class Paragraph32 extends CarbonIcon {}
export declare class ParentChild16 extends CarbonIcon {}
export declare class ParentChild20 extends CarbonIcon {}
export declare class ParentChild24 extends CarbonIcon {}
export declare class ParentChild32 extends CarbonIcon {}
export declare class PartlyCloudy16 extends CarbonIcon {}
export declare class PartlyCloudy20 extends CarbonIcon {}
export declare class PartlyCloudy24 extends CarbonIcon {}
export declare class PartlyCloudy32 extends CarbonIcon {}
export declare class PartlyCloudyNight16 extends CarbonIcon {}
export declare class PartlyCloudyNight20 extends CarbonIcon {}
export declare class PartlyCloudyNight24 extends CarbonIcon {}
export declare class PartlyCloudyNight32 extends CarbonIcon {}
export declare class Partnership16 extends CarbonIcon {}
export declare class Partnership20 extends CarbonIcon {}
export declare class Partnership24 extends CarbonIcon {}
export declare class Partnership32 extends CarbonIcon {}
export declare class PassengerDrinks16 extends CarbonIcon {}
export declare class PassengerDrinks20 extends CarbonIcon {}
export declare class PassengerDrinks24 extends CarbonIcon {}
export declare class PassengerDrinks32 extends CarbonIcon {}
export declare class PassengerPlus16 extends CarbonIcon {}
export declare class PassengerPlus20 extends CarbonIcon {}
export declare class PassengerPlus24 extends CarbonIcon {}
export declare class PassengerPlus32 extends CarbonIcon {}
export declare class Password16 extends CarbonIcon {}
export declare class Password20 extends CarbonIcon {}
export declare class Password24 extends CarbonIcon {}
export declare class Password32 extends CarbonIcon {}
export declare class Paste16 extends CarbonIcon {}
export declare class Paste20 extends CarbonIcon {}
export declare class Paste24 extends CarbonIcon {}
export declare class Paste32 extends CarbonIcon {}
export declare class Pause16 extends CarbonIcon {}
export declare class Pause20 extends CarbonIcon {}
export declare class Pause24 extends CarbonIcon {}
export declare class Pause32 extends CarbonIcon {}
export declare class PauseFilled16 extends CarbonIcon {}
export declare class PauseFilled20 extends CarbonIcon {}
export declare class PauseFilled24 extends CarbonIcon {}
export declare class PauseFilled32 extends CarbonIcon {}
export declare class PauseFuture16 extends CarbonIcon {}
export declare class PauseFuture20 extends CarbonIcon {}
export declare class PauseFuture24 extends CarbonIcon {}
export declare class PauseFuture32 extends CarbonIcon {}
export declare class PauseOutline16 extends CarbonIcon {}
export declare class PauseOutline20 extends CarbonIcon {}
export declare class PauseOutline24 extends CarbonIcon {}
export declare class PauseOutline32 extends CarbonIcon {}
export declare class PauseOutlineFilled16 extends CarbonIcon {}
export declare class PauseOutlineFilled20 extends CarbonIcon {}
export declare class PauseOutlineFilled24 extends CarbonIcon {}
export declare class PauseOutlineFilled32 extends CarbonIcon {}
export declare class PausePast16 extends CarbonIcon {}
export declare class PausePast20 extends CarbonIcon {}
export declare class PausePast24 extends CarbonIcon {}
export declare class PausePast32 extends CarbonIcon {}
export declare class Pdf16 extends CarbonIcon {}
export declare class Pdf20 extends CarbonIcon {}
export declare class Pdf24 extends CarbonIcon {}
export declare class Pdf32 extends CarbonIcon {}
export declare class PdfReference16 extends CarbonIcon {}
export declare class PdfReference20 extends CarbonIcon {}
export declare class PdfReference24 extends CarbonIcon {}
export declare class PdfReference32 extends CarbonIcon {}
export declare class Pedestrian16 extends CarbonIcon {}
export declare class Pedestrian20 extends CarbonIcon {}
export declare class Pedestrian24 extends CarbonIcon {}
export declare class Pedestrian32 extends CarbonIcon {}
export declare class PedestrianChild16 extends CarbonIcon {}
export declare class PedestrianChild20 extends CarbonIcon {}
export declare class PedestrianChild24 extends CarbonIcon {}
export declare class PedestrianChild32 extends CarbonIcon {}
export declare class Pending16 extends CarbonIcon {}
export declare class Pending20 extends CarbonIcon {}
export declare class Pending24 extends CarbonIcon {}
export declare class Pending32 extends CarbonIcon {}
export declare class PendingFilled16 extends CarbonIcon {}
export declare class PendingFilled20 extends CarbonIcon {}
export declare class PendingFilled24 extends CarbonIcon {}
export declare class PendingFilled32 extends CarbonIcon {}
export declare class Percentage16 extends CarbonIcon {}
export declare class Percentage20 extends CarbonIcon {}
export declare class Percentage24 extends CarbonIcon {}
export declare class Percentage32 extends CarbonIcon {}
export declare class PercentageFilled16 extends CarbonIcon {}
export declare class PercentageFilled20 extends CarbonIcon {}
export declare class PercentageFilled24 extends CarbonIcon {}
export declare class PercentageFilled32 extends CarbonIcon {}
export declare class Person16 extends CarbonIcon {}
export declare class Person20 extends CarbonIcon {}
export declare class Person24 extends CarbonIcon {}
export declare class Person32 extends CarbonIcon {}
export declare class PersonFavorite16 extends CarbonIcon {}
export declare class PersonFavorite20 extends CarbonIcon {}
export declare class PersonFavorite24 extends CarbonIcon {}
export declare class PersonFavorite32 extends CarbonIcon {}
export declare class Pest16 extends CarbonIcon {}
export declare class Pest20 extends CarbonIcon {}
export declare class Pest24 extends CarbonIcon {}
export declare class Pest32 extends CarbonIcon {}
export declare class Phone16 extends CarbonIcon {}
export declare class Phone20 extends CarbonIcon {}
export declare class Phone24 extends CarbonIcon {}
export declare class Phone32 extends CarbonIcon {}
export declare class PhoneFilled16 extends CarbonIcon {}
export declare class PhoneFilled20 extends CarbonIcon {}
export declare class PhoneFilled24 extends CarbonIcon {}
export declare class PhoneFilled32 extends CarbonIcon {}
export declare class PhoneOff16 extends CarbonIcon {}
export declare class PhoneOff20 extends CarbonIcon {}
export declare class PhoneOff24 extends CarbonIcon {}
export declare class PhoneOff32 extends CarbonIcon {}
export declare class PhoneOffFilled16 extends CarbonIcon {}
export declare class PhoneOffFilled20 extends CarbonIcon {}
export declare class PhoneOffFilled24 extends CarbonIcon {}
export declare class PhoneOffFilled32 extends CarbonIcon {}
export declare class PhraseSentiment16 extends CarbonIcon {}
export declare class PhraseSentiment20 extends CarbonIcon {}
export declare class PhraseSentiment24 extends CarbonIcon {}
export declare class PhraseSentiment32 extends CarbonIcon {}
export declare class PicnicArea16 extends CarbonIcon {}
export declare class PicnicArea20 extends CarbonIcon {}
export declare class PicnicArea24 extends CarbonIcon {}
export declare class PicnicArea32 extends CarbonIcon {}
export declare class Pills16 extends CarbonIcon {}
export declare class Pills20 extends CarbonIcon {}
export declare class Pills24 extends CarbonIcon {}
export declare class Pills32 extends CarbonIcon {}
export declare class PillsAdd16 extends CarbonIcon {}
export declare class PillsAdd20 extends CarbonIcon {}
export declare class PillsAdd24 extends CarbonIcon {}
export declare class PillsAdd32 extends CarbonIcon {}
export declare class PillsSubtract16 extends CarbonIcon {}
export declare class PillsSubtract20 extends CarbonIcon {}
export declare class PillsSubtract24 extends CarbonIcon {}
export declare class PillsSubtract32 extends CarbonIcon {}
export declare class Pin16 extends CarbonIcon {}
export declare class Pin20 extends CarbonIcon {}
export declare class Pin24 extends CarbonIcon {}
export declare class Pin32 extends CarbonIcon {}
export declare class PinFilled16 extends CarbonIcon {}
export declare class PinFilled20 extends CarbonIcon {}
export declare class PinFilled24 extends CarbonIcon {}
export declare class PinFilled32 extends CarbonIcon {}
export declare class Plane16 extends CarbonIcon {}
export declare class Plane20 extends CarbonIcon {}
export declare class Plane24 extends CarbonIcon {}
export declare class Plane32 extends CarbonIcon {}
export declare class PlanePrivate16 extends CarbonIcon {}
export declare class PlanePrivate20 extends CarbonIcon {}
export declare class PlanePrivate24 extends CarbonIcon {}
export declare class PlanePrivate32 extends CarbonIcon {}
export declare class PlaneSea16 extends CarbonIcon {}
export declare class PlaneSea20 extends CarbonIcon {}
export declare class PlaneSea24 extends CarbonIcon {}
export declare class PlaneSea32 extends CarbonIcon {}
export declare class Play16 extends CarbonIcon {}
export declare class Play20 extends CarbonIcon {}
export declare class Play24 extends CarbonIcon {}
export declare class Play32 extends CarbonIcon {}
export declare class PlayFilled16 extends CarbonIcon {}
export declare class PlayFilled20 extends CarbonIcon {}
export declare class PlayFilled24 extends CarbonIcon {}
export declare class PlayFilled32 extends CarbonIcon {}
export declare class PlayFilledAlt16 extends CarbonIcon {}
export declare class PlayFilledAlt20 extends CarbonIcon {}
export declare class PlayFilledAlt24 extends CarbonIcon {}
export declare class PlayFilledAlt32 extends CarbonIcon {}
export declare class PlayOutline16 extends CarbonIcon {}
export declare class PlayOutline20 extends CarbonIcon {}
export declare class PlayOutline24 extends CarbonIcon {}
export declare class PlayOutline32 extends CarbonIcon {}
export declare class PlayOutlineFilled16 extends CarbonIcon {}
export declare class PlayOutlineFilled20 extends CarbonIcon {}
export declare class PlayOutlineFilled24 extends CarbonIcon {}
export declare class PlayOutlineFilled32 extends CarbonIcon {}
export declare class Playlist16 extends CarbonIcon {}
export declare class Playlist20 extends CarbonIcon {}
export declare class Playlist24 extends CarbonIcon {}
export declare class Playlist32 extends CarbonIcon {}
export declare class Plug16 extends CarbonIcon {}
export declare class Plug20 extends CarbonIcon {}
export declare class Plug24 extends CarbonIcon {}
export declare class Plug32 extends CarbonIcon {}
export declare class PlugFilled16 extends CarbonIcon {}
export declare class PlugFilled20 extends CarbonIcon {}
export declare class PlugFilled24 extends CarbonIcon {}
export declare class PlugFilled32 extends CarbonIcon {}
export declare class Png16 extends CarbonIcon {}
export declare class Png20 extends CarbonIcon {}
export declare class Png24 extends CarbonIcon {}
export declare class Png32 extends CarbonIcon {}
export declare class Police16 extends CarbonIcon {}
export declare class Police20 extends CarbonIcon {}
export declare class Police24 extends CarbonIcon {}
export declare class Police32 extends CarbonIcon {}
export declare class Policy16 extends CarbonIcon {}
export declare class Policy20 extends CarbonIcon {}
export declare class Policy24 extends CarbonIcon {}
export declare class Policy32 extends CarbonIcon {}
export declare class Popup16 extends CarbonIcon {}
export declare class Popup20 extends CarbonIcon {}
export declare class Popup24 extends CarbonIcon {}
export declare class Popup32 extends CarbonIcon {}
export declare class Portfolio16 extends CarbonIcon {}
export declare class Portfolio20 extends CarbonIcon {}
export declare class Portfolio24 extends CarbonIcon {}
export declare class Portfolio32 extends CarbonIcon {}
export declare class Power16 extends CarbonIcon {}
export declare class Power20 extends CarbonIcon {}
export declare class Power24 extends CarbonIcon {}
export declare class Power32 extends CarbonIcon {}
export declare class Ppt16 extends CarbonIcon {}
export declare class Ppt20 extends CarbonIcon {}
export declare class Ppt24 extends CarbonIcon {}
export declare class Ppt32 extends CarbonIcon {}
export declare class PresentationFile16 extends CarbonIcon {}
export declare class PresentationFile20 extends CarbonIcon {}
export declare class PresentationFile24 extends CarbonIcon {}
export declare class PresentationFile32 extends CarbonIcon {}
export declare class Pressure16 extends CarbonIcon {}
export declare class Pressure20 extends CarbonIcon {}
export declare class Pressure24 extends CarbonIcon {}
export declare class Pressure32 extends CarbonIcon {}
export declare class PressureFilled16 extends CarbonIcon {}
export declare class PressureFilled20 extends CarbonIcon {}
export declare class PressureFilled24 extends CarbonIcon {}
export declare class PressureFilled32 extends CarbonIcon {}
export declare class PreviousFilled16 extends CarbonIcon {}
export declare class PreviousFilled20 extends CarbonIcon {}
export declare class PreviousFilled24 extends CarbonIcon {}
export declare class PreviousFilled32 extends CarbonIcon {}
export declare class PreviousOutline16 extends CarbonIcon {}
export declare class PreviousOutline20 extends CarbonIcon {}
export declare class PreviousOutline24 extends CarbonIcon {}
export declare class PreviousOutline32 extends CarbonIcon {}
export declare class Printer16 extends CarbonIcon {}
export declare class Printer20 extends CarbonIcon {}
export declare class Printer24 extends CarbonIcon {}
export declare class Printer32 extends CarbonIcon {}
export declare class Product16 extends CarbonIcon {}
export declare class Product20 extends CarbonIcon {}
export declare class Product24 extends CarbonIcon {}
export declare class Product32 extends CarbonIcon {}
export declare class Purchase16 extends CarbonIcon {}
export declare class Purchase20 extends CarbonIcon {}
export declare class Purchase24 extends CarbonIcon {}
export declare class Purchase32 extends CarbonIcon {}
export declare class QBarrier16 extends CarbonIcon {}
export declare class QBarrier20 extends CarbonIcon {}
export declare class QBarrier24 extends CarbonIcon {}
export declare class QBarrier32 extends CarbonIcon {}
export declare class QBlochSphere16 extends CarbonIcon {}
export declare class QBlochSphere20 extends CarbonIcon {}
export declare class QBlochSphere24 extends CarbonIcon {}
export declare class QBlochSphere32 extends CarbonIcon {}
export declare class QCU116 extends CarbonIcon {}
export declare class QCU120 extends CarbonIcon {}
export declare class QCU124 extends CarbonIcon {}
export declare class QCU132 extends CarbonIcon {}
export declare class QCU316 extends CarbonIcon {}
export declare class QCU320 extends CarbonIcon {}
export declare class QCU324 extends CarbonIcon {}
export declare class QCU332 extends CarbonIcon {}
export declare class QCY16 extends CarbonIcon {}
export declare class QCY20 extends CarbonIcon {}
export declare class QCY24 extends CarbonIcon {}
export declare class QCY32 extends CarbonIcon {}
export declare class QCZ16 extends CarbonIcon {}
export declare class QCZ20 extends CarbonIcon {}
export declare class QCZ24 extends CarbonIcon {}
export declare class QCZ32 extends CarbonIcon {}
export declare class QCcX16 extends CarbonIcon {}
export declare class QCcX20 extends CarbonIcon {}
export declare class QCcX24 extends CarbonIcon {}
export declare class QCcX32 extends CarbonIcon {}
export declare class QCircuitComposer16 extends CarbonIcon {}
export declare class QCircuitComposer20 extends CarbonIcon {}
export declare class QCircuitComposer24 extends CarbonIcon {}
export declare class QCircuitComposer32 extends CarbonIcon {}
export declare class QComposerEdit16 extends CarbonIcon {}
export declare class QComposerEdit20 extends CarbonIcon {}
export declare class QComposerEdit24 extends CarbonIcon {}
export declare class QComposerEdit32 extends CarbonIcon {}
export declare class QH16 extends CarbonIcon {}
export declare class QH20 extends CarbonIcon {}
export declare class QH24 extends CarbonIcon {}
export declare class QH32 extends CarbonIcon {}
export declare class QHintonPlot16 extends CarbonIcon {}
export declare class QHintonPlot20 extends CarbonIcon {}
export declare class QHintonPlot24 extends CarbonIcon {}
export declare class QHintonPlot32 extends CarbonIcon {}
export declare class QID16 extends CarbonIcon {}
export declare class QID20 extends CarbonIcon {}
export declare class QID24 extends CarbonIcon {}
export declare class QID32 extends CarbonIcon {}
export declare class QMatrix16 extends CarbonIcon {}
export declare class QMatrix20 extends CarbonIcon {}
export declare class QMatrix24 extends CarbonIcon {}
export declare class QMatrix32 extends CarbonIcon {}
export declare class QOperation16 extends CarbonIcon {}
export declare class QOperation20 extends CarbonIcon {}
export declare class QOperation24 extends CarbonIcon {}
export declare class QOperation32 extends CarbonIcon {}
export declare class QOperationGauge16 extends CarbonIcon {}
export declare class QOperationGauge20 extends CarbonIcon {}
export declare class QOperationGauge24 extends CarbonIcon {}
export declare class QOperationGauge32 extends CarbonIcon {}
export declare class QOperationIf16 extends CarbonIcon {}
export declare class QOperationIf20 extends CarbonIcon {}
export declare class QOperationIf24 extends CarbonIcon {}
export declare class QOperationIf32 extends CarbonIcon {}
export declare class QS16 extends CarbonIcon {}
export declare class QS20 extends CarbonIcon {}
export declare class QS24 extends CarbonIcon {}
export declare class QS32 extends CarbonIcon {}
export declare class QSAlt16 extends CarbonIcon {}
export declare class QSAlt20 extends CarbonIcon {}
export declare class QSAlt24 extends CarbonIcon {}
export declare class QSAlt32 extends CarbonIcon {}
export declare class QT16 extends CarbonIcon {}
export declare class QT20 extends CarbonIcon {}
export declare class QT24 extends CarbonIcon {}
export declare class QT32 extends CarbonIcon {}
export declare class QTAlt16 extends CarbonIcon {}
export declare class QTAlt20 extends CarbonIcon {}
export declare class QTAlt24 extends CarbonIcon {}
export declare class QTAlt32 extends CarbonIcon {}
export declare class QU116 extends CarbonIcon {}
export declare class QU120 extends CarbonIcon {}
export declare class QU124 extends CarbonIcon {}
export declare class QU132 extends CarbonIcon {}
export declare class QU216 extends CarbonIcon {}
export declare class QU220 extends CarbonIcon {}
export declare class QU224 extends CarbonIcon {}
export declare class QU232 extends CarbonIcon {}
export declare class QU316 extends CarbonIcon {}
export declare class QU320 extends CarbonIcon {}
export declare class QU324 extends CarbonIcon {}
export declare class QU332 extends CarbonIcon {}
export declare class QX16 extends CarbonIcon {}
export declare class QX20 extends CarbonIcon {}
export declare class QX24 extends CarbonIcon {}
export declare class QX32 extends CarbonIcon {}
export declare class QY16 extends CarbonIcon {}
export declare class QY20 extends CarbonIcon {}
export declare class QY24 extends CarbonIcon {}
export declare class QY32 extends CarbonIcon {}
export declare class QZ16 extends CarbonIcon {}
export declare class QZ20 extends CarbonIcon {}
export declare class QZ24 extends CarbonIcon {}
export declare class QZ32 extends CarbonIcon {}
export declare class QqPlot16 extends CarbonIcon {}
export declare class QqPlot20 extends CarbonIcon {}
export declare class QqPlot24 extends CarbonIcon {}
export declare class QqPlot32 extends CarbonIcon {}
export declare class QrCode16 extends CarbonIcon {}
export declare class QrCode20 extends CarbonIcon {}
export declare class QrCode24 extends CarbonIcon {}
export declare class QrCode32 extends CarbonIcon {}
export declare class QuadrantPlot16 extends CarbonIcon {}
export declare class QuadrantPlot20 extends CarbonIcon {}
export declare class QuadrantPlot24 extends CarbonIcon {}
export declare class QuadrantPlot32 extends CarbonIcon {}
export declare class Query16 extends CarbonIcon {}
export declare class Query20 extends CarbonIcon {}
export declare class Query24 extends CarbonIcon {}
export declare class Query32 extends CarbonIcon {}
export declare class QueryQueue16 extends CarbonIcon {}
export declare class QueryQueue20 extends CarbonIcon {}
export declare class QueryQueue24 extends CarbonIcon {}
export declare class QueryQueue32 extends CarbonIcon {}
export declare class Queued16 extends CarbonIcon {}
export declare class Queued20 extends CarbonIcon {}
export declare class Queued24 extends CarbonIcon {}
export declare class Queued32 extends CarbonIcon {}
export declare class Quotes16 extends CarbonIcon {}
export declare class Quotes20 extends CarbonIcon {}
export declare class Quotes24 extends CarbonIcon {}
export declare class Quotes32 extends CarbonIcon {}
export declare class Radar16 extends CarbonIcon {}
export declare class Radar20 extends CarbonIcon {}
export declare class Radar24 extends CarbonIcon {}
export declare class Radar32 extends CarbonIcon {}
export declare class RadarEnhanced16 extends CarbonIcon {}
export declare class RadarEnhanced20 extends CarbonIcon {}
export declare class RadarEnhanced24 extends CarbonIcon {}
export declare class RadarEnhanced32 extends CarbonIcon {}
export declare class RadarWeather16 extends CarbonIcon {}
export declare class RadarWeather20 extends CarbonIcon {}
export declare class RadarWeather24 extends CarbonIcon {}
export declare class RadarWeather32 extends CarbonIcon {}
export declare class Radio16 extends CarbonIcon {}
export declare class Radio20 extends CarbonIcon {}
export declare class Radio24 extends CarbonIcon {}
export declare class Radio32 extends CarbonIcon {}
export declare class RadioButton16 extends CarbonIcon {}
export declare class RadioButton20 extends CarbonIcon {}
export declare class RadioButton24 extends CarbonIcon {}
export declare class RadioButton32 extends CarbonIcon {}
export declare class RadioButtonChecked16 extends CarbonIcon {}
export declare class RadioButtonChecked20 extends CarbonIcon {}
export declare class RadioButtonChecked24 extends CarbonIcon {}
export declare class RadioButtonChecked32 extends CarbonIcon {}
export declare class Rain16 extends CarbonIcon {}
export declare class Rain20 extends CarbonIcon {}
export declare class Rain24 extends CarbonIcon {}
export declare class Rain32 extends CarbonIcon {}
export declare class RainDrizzle16 extends CarbonIcon {}
export declare class RainDrizzle20 extends CarbonIcon {}
export declare class RainDrizzle24 extends CarbonIcon {}
export declare class RainDrizzle32 extends CarbonIcon {}
export declare class RainDrop16 extends CarbonIcon {}
export declare class RainDrop20 extends CarbonIcon {}
export declare class RainDrop24 extends CarbonIcon {}
export declare class RainDrop32 extends CarbonIcon {}
export declare class RainHeavy16 extends CarbonIcon {}
export declare class RainHeavy20 extends CarbonIcon {}
export declare class RainHeavy24 extends CarbonIcon {}
export declare class RainHeavy32 extends CarbonIcon {}
export declare class RainScattered16 extends CarbonIcon {}
export declare class RainScattered20 extends CarbonIcon {}
export declare class RainScattered24 extends CarbonIcon {}
export declare class RainScattered32 extends CarbonIcon {}
export declare class RainScatteredNight16 extends CarbonIcon {}
export declare class RainScatteredNight20 extends CarbonIcon {}
export declare class RainScatteredNight24 extends CarbonIcon {}
export declare class RainScatteredNight32 extends CarbonIcon {}
export declare class Raw16 extends CarbonIcon {}
export declare class Raw20 extends CarbonIcon {}
export declare class Raw24 extends CarbonIcon {}
export declare class Raw32 extends CarbonIcon {}
export declare class Receipt16 extends CarbonIcon {}
export declare class Receipt20 extends CarbonIcon {}
export declare class Receipt24 extends CarbonIcon {}
export declare class Receipt32 extends CarbonIcon {}
export declare class RecentlyViewed16 extends CarbonIcon {}
export declare class RecentlyViewed20 extends CarbonIcon {}
export declare class RecentlyViewed24 extends CarbonIcon {}
export declare class RecentlyViewed32 extends CarbonIcon {}
export declare class Recommend16 extends CarbonIcon {}
export declare class Recommend20 extends CarbonIcon {}
export declare class Recommend24 extends CarbonIcon {}
export declare class Recommend32 extends CarbonIcon {}
export declare class Recording16 extends CarbonIcon {}
export declare class Recording20 extends CarbonIcon {}
export declare class Recording24 extends CarbonIcon {}
export declare class Recording32 extends CarbonIcon {}
export declare class RecordingFilled16 extends CarbonIcon {}
export declare class RecordingFilled20 extends CarbonIcon {}
export declare class RecordingFilled24 extends CarbonIcon {}
export declare class RecordingFilled32 extends CarbonIcon {}
export declare class RecordingFilledAlt16 extends CarbonIcon {}
export declare class RecordingFilledAlt20 extends CarbonIcon {}
export declare class RecordingFilledAlt24 extends CarbonIcon {}
export declare class RecordingFilledAlt32 extends CarbonIcon {}
export declare class Redo16 extends CarbonIcon {}
export declare class Redo20 extends CarbonIcon {}
export declare class Redo24 extends CarbonIcon {}
export declare class Redo32 extends CarbonIcon {}
export declare class RefEvapotranspiration16 extends CarbonIcon {}
export declare class RefEvapotranspiration20 extends CarbonIcon {}
export declare class RefEvapotranspiration24 extends CarbonIcon {}
export declare class RefEvapotranspiration32 extends CarbonIcon {}
export declare class ReflectHorizontal16 extends CarbonIcon {}
export declare class ReflectHorizontal20 extends CarbonIcon {}
export declare class ReflectHorizontal24 extends CarbonIcon {}
export declare class ReflectHorizontal32 extends CarbonIcon {}
export declare class ReflectVertical16 extends CarbonIcon {}
export declare class ReflectVertical20 extends CarbonIcon {}
export declare class ReflectVertical24 extends CarbonIcon {}
export declare class ReflectVertical32 extends CarbonIcon {}
export declare class Reminder16 extends CarbonIcon {}
export declare class Reminder20 extends CarbonIcon {}
export declare class Reminder24 extends CarbonIcon {}
export declare class Reminder32 extends CarbonIcon {}
export declare class ReminderMedical16 extends CarbonIcon {}
export declare class ReminderMedical20 extends CarbonIcon {}
export declare class ReminderMedical24 extends CarbonIcon {}
export declare class ReminderMedical32 extends CarbonIcon {}
export declare class Renew16 extends CarbonIcon {}
export declare class Renew20 extends CarbonIcon {}
export declare class Renew24 extends CarbonIcon {}
export declare class Renew32 extends CarbonIcon {}
export declare class Repeat16 extends CarbonIcon {}
export declare class Repeat20 extends CarbonIcon {}
export declare class Repeat24 extends CarbonIcon {}
export declare class Repeat32 extends CarbonIcon {}
export declare class RepeatOne16 extends CarbonIcon {}
export declare class RepeatOne20 extends CarbonIcon {}
export declare class RepeatOne24 extends CarbonIcon {}
export declare class RepeatOne32 extends CarbonIcon {}
export declare class Reply16 extends CarbonIcon {}
export declare class Reply20 extends CarbonIcon {}
export declare class Reply24 extends CarbonIcon {}
export declare class Reply32 extends CarbonIcon {}
export declare class Report16 extends CarbonIcon {}
export declare class Report20 extends CarbonIcon {}
export declare class Report24 extends CarbonIcon {}
export declare class Report32 extends CarbonIcon {}
export declare class ReportData16 extends CarbonIcon {}
export declare class ReportData20 extends CarbonIcon {}
export declare class ReportData24 extends CarbonIcon {}
export declare class ReportData32 extends CarbonIcon {}
export declare class RequestQuote16 extends CarbonIcon {}
export declare class RequestQuote20 extends CarbonIcon {}
export declare class RequestQuote24 extends CarbonIcon {}
export declare class RequestQuote32 extends CarbonIcon {}
export declare class ResearchBlochSphere16 extends CarbonIcon {}
export declare class ResearchBlochSphere20 extends CarbonIcon {}
export declare class ResearchBlochSphere24 extends CarbonIcon {}
export declare class ResearchBlochSphere32 extends CarbonIcon {}
export declare class ResearchHintonPlot16 extends CarbonIcon {}
export declare class ResearchHintonPlot20 extends CarbonIcon {}
export declare class ResearchHintonPlot24 extends CarbonIcon {}
export declare class ResearchHintonPlot32 extends CarbonIcon {}
export declare class ResearchMatrix16 extends CarbonIcon {}
export declare class ResearchMatrix20 extends CarbonIcon {}
export declare class ResearchMatrix24 extends CarbonIcon {}
export declare class ResearchMatrix32 extends CarbonIcon {}
export declare class Reset16 extends CarbonIcon {}
export declare class Reset20 extends CarbonIcon {}
export declare class Reset24 extends CarbonIcon {}
export declare class Reset32 extends CarbonIcon {}
export declare class ResetAlt16 extends CarbonIcon {}
export declare class ResetAlt20 extends CarbonIcon {}
export declare class ResetAlt24 extends CarbonIcon {}
export declare class ResetAlt32 extends CarbonIcon {}
export declare class Restart16 extends CarbonIcon {}
export declare class Restart20 extends CarbonIcon {}
export declare class Restart24 extends CarbonIcon {}
export declare class Restart32 extends CarbonIcon {}
export declare class Restaurant16 extends CarbonIcon {}
export declare class Restaurant20 extends CarbonIcon {}
export declare class Restaurant24 extends CarbonIcon {}
export declare class Restaurant32 extends CarbonIcon {}
export declare class RestaurantFine16 extends CarbonIcon {}
export declare class RestaurantFine20 extends CarbonIcon {}
export declare class RestaurantFine24 extends CarbonIcon {}
export declare class RestaurantFine32 extends CarbonIcon {}
export declare class Rewind_1016 extends CarbonIcon {}
export declare class Rewind_1020 extends CarbonIcon {}
export declare class Rewind_1024 extends CarbonIcon {}
export declare class Rewind_1032 extends CarbonIcon {}
export declare class Rewind_3016 extends CarbonIcon {}
export declare class Rewind_3020 extends CarbonIcon {}
export declare class Rewind_3024 extends CarbonIcon {}
export declare class Rewind_3032 extends CarbonIcon {}
export declare class Rewind_516 extends CarbonIcon {}
export declare class Rewind_520 extends CarbonIcon {}
export declare class Rewind_524 extends CarbonIcon {}
export declare class Rewind_532 extends CarbonIcon {}
export declare class Road16 extends CarbonIcon {}
export declare class Road20 extends CarbonIcon {}
export declare class Road24 extends CarbonIcon {}
export declare class Road32 extends CarbonIcon {}
export declare class RoadWeather16 extends CarbonIcon {}
export declare class RoadWeather20 extends CarbonIcon {}
export declare class RoadWeather24 extends CarbonIcon {}
export declare class RoadWeather32 extends CarbonIcon {}
export declare class Roadmap16 extends CarbonIcon {}
export declare class Roadmap20 extends CarbonIcon {}
export declare class Roadmap24 extends CarbonIcon {}
export declare class Roadmap32 extends CarbonIcon {}
export declare class Rocket16 extends CarbonIcon {}
export declare class Rocket20 extends CarbonIcon {}
export declare class Rocket24 extends CarbonIcon {}
export declare class Rocket32 extends CarbonIcon {}
export declare class Rotate16 extends CarbonIcon {}
export declare class Rotate20 extends CarbonIcon {}
export declare class Rotate24 extends CarbonIcon {}
export declare class Rotate32 extends CarbonIcon {}
export declare class RotateClockwise16 extends CarbonIcon {}
export declare class RotateClockwise20 extends CarbonIcon {}
export declare class RotateClockwise24 extends CarbonIcon {}
export declare class RotateClockwise32 extends CarbonIcon {}
export declare class RotateClockwiseAlt16 extends CarbonIcon {}
export declare class RotateClockwiseAlt20 extends CarbonIcon {}
export declare class RotateClockwiseAlt24 extends CarbonIcon {}
export declare class RotateClockwiseAlt32 extends CarbonIcon {}
export declare class RotateClockwiseAltFilled16 extends CarbonIcon {}
export declare class RotateClockwiseAltFilled20 extends CarbonIcon {}
export declare class RotateClockwiseAltFilled24 extends CarbonIcon {}
export declare class RotateClockwiseAltFilled32 extends CarbonIcon {}
export declare class RotateClockwiseFilled16 extends CarbonIcon {}
export declare class RotateClockwiseFilled20 extends CarbonIcon {}
export declare class RotateClockwiseFilled24 extends CarbonIcon {}
export declare class RotateClockwiseFilled32 extends CarbonIcon {}
export declare class RotateCounterclockwise16 extends CarbonIcon {}
export declare class RotateCounterclockwise20 extends CarbonIcon {}
export declare class RotateCounterclockwise24 extends CarbonIcon {}
export declare class RotateCounterclockwise32 extends CarbonIcon {}
export declare class RotateCounterclockwiseAlt16 extends CarbonIcon {}
export declare class RotateCounterclockwiseAlt20 extends CarbonIcon {}
export declare class RotateCounterclockwiseAlt24 extends CarbonIcon {}
export declare class RotateCounterclockwiseAlt32 extends CarbonIcon {}
export declare class RotateCounterclockwiseAltFilled16 extends CarbonIcon {}
export declare class RotateCounterclockwiseAltFilled20 extends CarbonIcon {}
export declare class RotateCounterclockwiseAltFilled24 extends CarbonIcon {}
export declare class RotateCounterclockwiseAltFilled32 extends CarbonIcon {}
export declare class RotateCounterclockwiseFilled16 extends CarbonIcon {}
export declare class RotateCounterclockwiseFilled20 extends CarbonIcon {}
export declare class RotateCounterclockwiseFilled24 extends CarbonIcon {}
export declare class RotateCounterclockwiseFilled32 extends CarbonIcon {}
export declare class Row16 extends CarbonIcon {}
export declare class Row20 extends CarbonIcon {}
export declare class Row24 extends CarbonIcon {}
export declare class Row32 extends CarbonIcon {}
export declare class RowCollapse16 extends CarbonIcon {}
export declare class RowCollapse20 extends CarbonIcon {}
export declare class RowCollapse24 extends CarbonIcon {}
export declare class RowCollapse32 extends CarbonIcon {}
export declare class RowDelete16 extends CarbonIcon {}
export declare class RowDelete20 extends CarbonIcon {}
export declare class RowDelete24 extends CarbonIcon {}
export declare class RowDelete32 extends CarbonIcon {}
export declare class RowExpand16 extends CarbonIcon {}
export declare class RowExpand20 extends CarbonIcon {}
export declare class RowExpand24 extends CarbonIcon {}
export declare class RowExpand32 extends CarbonIcon {}
export declare class RowInsert16 extends CarbonIcon {}
export declare class RowInsert20 extends CarbonIcon {}
export declare class RowInsert24 extends CarbonIcon {}
export declare class RowInsert32 extends CarbonIcon {}
export declare class Rss16 extends CarbonIcon {}
export declare class Rss20 extends CarbonIcon {}
export declare class Rss24 extends CarbonIcon {}
export declare class Rss32 extends CarbonIcon {}
export declare class Rule16 extends CarbonIcon {}
export declare class Rule20 extends CarbonIcon {}
export declare class Rule24 extends CarbonIcon {}
export declare class Rule32 extends CarbonIcon {}
export declare class Ruler16 extends CarbonIcon {}
export declare class Ruler20 extends CarbonIcon {}
export declare class Ruler24 extends CarbonIcon {}
export declare class Ruler32 extends CarbonIcon {}
export declare class RulerAlt16 extends CarbonIcon {}
export declare class RulerAlt20 extends CarbonIcon {}
export declare class RulerAlt24 extends CarbonIcon {}
export declare class RulerAlt32 extends CarbonIcon {}
export declare class Run16 extends CarbonIcon {}
export declare class Run20 extends CarbonIcon {}
export declare class Run24 extends CarbonIcon {}
export declare class Run32 extends CarbonIcon {}
export declare class SailboatCoastal16 extends CarbonIcon {}
export declare class SailboatCoastal20 extends CarbonIcon {}
export declare class SailboatCoastal24 extends CarbonIcon {}
export declare class SailboatCoastal32 extends CarbonIcon {}
export declare class SailboatOffshore16 extends CarbonIcon {}
export declare class SailboatOffshore20 extends CarbonIcon {}
export declare class SailboatOffshore24 extends CarbonIcon {}
export declare class SailboatOffshore32 extends CarbonIcon {}
export declare class SankeyDiagram16 extends CarbonIcon {}
export declare class SankeyDiagram20 extends CarbonIcon {}
export declare class SankeyDiagram24 extends CarbonIcon {}
export declare class SankeyDiagram32 extends CarbonIcon {}
export declare class Satellite16 extends CarbonIcon {}
export declare class Satellite20 extends CarbonIcon {}
export declare class Satellite24 extends CarbonIcon {}
export declare class Satellite32 extends CarbonIcon {}
export declare class SatelliteRadar16 extends CarbonIcon {}
export declare class SatelliteRadar20 extends CarbonIcon {}
export declare class SatelliteRadar24 extends CarbonIcon {}
export declare class SatelliteRadar32 extends CarbonIcon {}
export declare class SatelliteWeather16 extends CarbonIcon {}
export declare class SatelliteWeather20 extends CarbonIcon {}
export declare class SatelliteWeather24 extends CarbonIcon {}
export declare class SatelliteWeather32 extends CarbonIcon {}
export declare class Save16 extends CarbonIcon {}
export declare class Save20 extends CarbonIcon {}
export declare class Save24 extends CarbonIcon {}
export declare class Save32 extends CarbonIcon {}
export declare class SaveModel16 extends CarbonIcon {}
export declare class SaveModel20 extends CarbonIcon {}
export declare class SaveModel24 extends CarbonIcon {}
export declare class SaveModel32 extends CarbonIcon {}
export declare class Scale16 extends CarbonIcon {}
export declare class Scale20 extends CarbonIcon {}
export declare class Scale24 extends CarbonIcon {}
export declare class Scale32 extends CarbonIcon {}
export declare class Scales16 extends CarbonIcon {}
export declare class Scales20 extends CarbonIcon {}
export declare class Scales24 extends CarbonIcon {}
export declare class Scales32 extends CarbonIcon {}
export declare class ScalesTipped16 extends CarbonIcon {}
export declare class ScalesTipped20 extends CarbonIcon {}
export declare class ScalesTipped24 extends CarbonIcon {}
export declare class ScalesTipped32 extends CarbonIcon {}
export declare class Scalpel16 extends CarbonIcon {}
export declare class Scalpel20 extends CarbonIcon {}
export declare class Scalpel24 extends CarbonIcon {}
export declare class Scalpel32 extends CarbonIcon {}
export declare class Scan16 extends CarbonIcon {}
export declare class Scan20 extends CarbonIcon {}
export declare class Scan24 extends CarbonIcon {}
export declare class Scan32 extends CarbonIcon {}
export declare class ScatterMatrix16 extends CarbonIcon {}
export declare class ScatterMatrix20 extends CarbonIcon {}
export declare class ScatterMatrix24 extends CarbonIcon {}
export declare class ScatterMatrix32 extends CarbonIcon {}
export declare class Schematics16 extends CarbonIcon {}
export declare class Schematics20 extends CarbonIcon {}
export declare class Schematics24 extends CarbonIcon {}
export declare class Schematics32 extends CarbonIcon {}
export declare class Scooter16 extends CarbonIcon {}
export declare class Scooter20 extends CarbonIcon {}
export declare class Scooter24 extends CarbonIcon {}
export declare class Scooter32 extends CarbonIcon {}
export declare class ScooterFront16 extends CarbonIcon {}
export declare class ScooterFront20 extends CarbonIcon {}
export declare class ScooterFront24 extends CarbonIcon {}
export declare class ScooterFront32 extends CarbonIcon {}
export declare class Screen16 extends CarbonIcon {}
export declare class Screen20 extends CarbonIcon {}
export declare class Screen24 extends CarbonIcon {}
export declare class Screen32 extends CarbonIcon {}
export declare class ScreenOff16 extends CarbonIcon {}
export declare class ScreenOff20 extends CarbonIcon {}
export declare class ScreenOff24 extends CarbonIcon {}
export declare class ScreenOff32 extends CarbonIcon {}
export declare class Script16 extends CarbonIcon {}
export declare class Script20 extends CarbonIcon {}
export declare class Script24 extends CarbonIcon {}
export declare class Script32 extends CarbonIcon {}
export declare class ScriptReference16 extends CarbonIcon {}
export declare class ScriptReference20 extends CarbonIcon {}
export declare class ScriptReference24 extends CarbonIcon {}
export declare class ScriptReference32 extends CarbonIcon {}
export declare class Sdk16 extends CarbonIcon {}
export declare class Sdk20 extends CarbonIcon {}
export declare class Sdk24 extends CarbonIcon {}
export declare class Sdk32 extends CarbonIcon {}
export declare class Search16 extends CarbonIcon {}
export declare class Search20 extends CarbonIcon {}
export declare class Search24 extends CarbonIcon {}
export declare class Search32 extends CarbonIcon {}
export declare class Security16 extends CarbonIcon {}
export declare class Security20 extends CarbonIcon {}
export declare class Security24 extends CarbonIcon {}
export declare class Security32 extends CarbonIcon {}
export declare class Select_0116 extends CarbonIcon {}
export declare class Select_0120 extends CarbonIcon {}
export declare class Select_0124 extends CarbonIcon {}
export declare class Select_0132 extends CarbonIcon {}
export declare class Select_0216 extends CarbonIcon {}
export declare class Select_0220 extends CarbonIcon {}
export declare class Select_0224 extends CarbonIcon {}
export declare class Select_0232 extends CarbonIcon {}
export declare class Send16 extends CarbonIcon {}
export declare class Send20 extends CarbonIcon {}
export declare class Send24 extends CarbonIcon {}
export declare class Send32 extends CarbonIcon {}
export declare class SendAlt16 extends CarbonIcon {}
export declare class SendAlt20 extends CarbonIcon {}
export declare class SendAlt24 extends CarbonIcon {}
export declare class SendAlt32 extends CarbonIcon {}
export declare class SendAltFilled16 extends CarbonIcon {}
export declare class SendAltFilled20 extends CarbonIcon {}
export declare class SendAltFilled24 extends CarbonIcon {}
export declare class SendAltFilled32 extends CarbonIcon {}
export declare class SendFilled16 extends CarbonIcon {}
export declare class SendFilled20 extends CarbonIcon {}
export declare class SendFilled24 extends CarbonIcon {}
export declare class SendFilled32 extends CarbonIcon {}
export declare class SendToBack16 extends CarbonIcon {}
export declare class SendToBack20 extends CarbonIcon {}
export declare class SendToBack24 extends CarbonIcon {}
export declare class SendToBack32 extends CarbonIcon {}
export declare class ServiceDesk16 extends CarbonIcon {}
export declare class ServiceDesk20 extends CarbonIcon {}
export declare class ServiceDesk24 extends CarbonIcon {}
export declare class ServiceDesk32 extends CarbonIcon {}
export declare class Settings16 extends CarbonIcon {}
export declare class Settings20 extends CarbonIcon {}
export declare class Settings24 extends CarbonIcon {}
export declare class Settings32 extends CarbonIcon {}
export declare class SettingsAdjust16 extends CarbonIcon {}
export declare class SettingsAdjust20 extends CarbonIcon {}
export declare class SettingsAdjust24 extends CarbonIcon {}
export declare class SettingsAdjust32 extends CarbonIcon {}
export declare class SettingsCheck16 extends CarbonIcon {}
export declare class SettingsCheck20 extends CarbonIcon {}
export declare class SettingsCheck24 extends CarbonIcon {}
export declare class SettingsCheck32 extends CarbonIcon {}
export declare class Share16 extends CarbonIcon {}
export declare class Share20 extends CarbonIcon {}
export declare class Share24 extends CarbonIcon {}
export declare class Share32 extends CarbonIcon {}
export declare class ShareKnowledge16 extends CarbonIcon {}
export declare class ShareKnowledge20 extends CarbonIcon {}
export declare class ShareKnowledge24 extends CarbonIcon {}
export declare class ShareKnowledge32 extends CarbonIcon {}
export declare class ShoppingBag16 extends CarbonIcon {}
export declare class ShoppingBag20 extends CarbonIcon {}
export declare class ShoppingBag24 extends CarbonIcon {}
export declare class ShoppingBag32 extends CarbonIcon {}
export declare class ShoppingCart16 extends CarbonIcon {}
export declare class ShoppingCart20 extends CarbonIcon {}
export declare class ShoppingCart24 extends CarbonIcon {}
export declare class ShoppingCart32 extends CarbonIcon {}
export declare class ShoppingCatalog16 extends CarbonIcon {}
export declare class ShoppingCatalog20 extends CarbonIcon {}
export declare class ShoppingCatalog24 extends CarbonIcon {}
export declare class ShoppingCatalog32 extends CarbonIcon {}
export declare class ShrinkScreen16 extends CarbonIcon {}
export declare class ShrinkScreen20 extends CarbonIcon {}
export declare class ShrinkScreen24 extends CarbonIcon {}
export declare class ShrinkScreen32 extends CarbonIcon {}
export declare class ShrinkScreenFilled16 extends CarbonIcon {}
export declare class ShrinkScreenFilled20 extends CarbonIcon {}
export declare class ShrinkScreenFilled24 extends CarbonIcon {}
export declare class ShrinkScreenFilled32 extends CarbonIcon {}
export declare class Shuffle16 extends CarbonIcon {}
export declare class Shuffle20 extends CarbonIcon {}
export declare class Shuffle24 extends CarbonIcon {}
export declare class Shuffle32 extends CarbonIcon {}
export declare class Shuttle16 extends CarbonIcon {}
export declare class Shuttle20 extends CarbonIcon {}
export declare class Shuttle24 extends CarbonIcon {}
export declare class Shuttle32 extends CarbonIcon {}
export declare class Sigma16 extends CarbonIcon {}
export declare class Sigma20 extends CarbonIcon {}
export declare class Sigma24 extends CarbonIcon {}
export declare class Sigma32 extends CarbonIcon {}
export declare class SignalStrength16 extends CarbonIcon {}
export declare class SignalStrength20 extends CarbonIcon {}
export declare class SignalStrength24 extends CarbonIcon {}
export declare class SignalStrength32 extends CarbonIcon {}
export declare class SkillLevel16 extends CarbonIcon {}
export declare class SkillLevel20 extends CarbonIcon {}
export declare class SkillLevel24 extends CarbonIcon {}
export declare class SkillLevel32 extends CarbonIcon {}
export declare class SkillLevelAdvanced16 extends CarbonIcon {}
export declare class SkillLevelAdvanced20 extends CarbonIcon {}
export declare class SkillLevelAdvanced24 extends CarbonIcon {}
export declare class SkillLevelAdvanced32 extends CarbonIcon {}
export declare class SkillLevelBasic16 extends CarbonIcon {}
export declare class SkillLevelBasic20 extends CarbonIcon {}
export declare class SkillLevelBasic24 extends CarbonIcon {}
export declare class SkillLevelBasic32 extends CarbonIcon {}
export declare class SkillLevelIntermediate16 extends CarbonIcon {}
export declare class SkillLevelIntermediate20 extends CarbonIcon {}
export declare class SkillLevelIntermediate24 extends CarbonIcon {}
export declare class SkillLevelIntermediate32 extends CarbonIcon {}
export declare class SkipBack16 extends CarbonIcon {}
export declare class SkipBack20 extends CarbonIcon {}
export declare class SkipBack24 extends CarbonIcon {}
export declare class SkipBack32 extends CarbonIcon {}
export declare class SkipBackFilled16 extends CarbonIcon {}
export declare class SkipBackFilled20 extends CarbonIcon {}
export declare class SkipBackFilled24 extends CarbonIcon {}
export declare class SkipBackFilled32 extends CarbonIcon {}
export declare class SkipBackOutline16 extends CarbonIcon {}
export declare class SkipBackOutline20 extends CarbonIcon {}
export declare class SkipBackOutline24 extends CarbonIcon {}
export declare class SkipBackOutline32 extends CarbonIcon {}
export declare class SkipBackOutlineFilled16 extends CarbonIcon {}
export declare class SkipBackOutlineFilled20 extends CarbonIcon {}
export declare class SkipBackOutlineFilled24 extends CarbonIcon {}
export declare class SkipBackOutlineFilled32 extends CarbonIcon {}
export declare class SkipBackOutlineSolid16 extends CarbonIcon {}
export declare class SkipBackOutlineSolid20 extends CarbonIcon {}
export declare class SkipBackOutlineSolid24 extends CarbonIcon {}
export declare class SkipBackOutlineSolid32 extends CarbonIcon {}
export declare class SkipBackSolidFilled16 extends CarbonIcon {}
export declare class SkipBackSolidFilled20 extends CarbonIcon {}
export declare class SkipBackSolidFilled24 extends CarbonIcon {}
export declare class SkipBackSolidFilled32 extends CarbonIcon {}
export declare class SkipForward16 extends CarbonIcon {}
export declare class SkipForward20 extends CarbonIcon {}
export declare class SkipForward24 extends CarbonIcon {}
export declare class SkipForward32 extends CarbonIcon {}
export declare class SkipForwardFilled16 extends CarbonIcon {}
export declare class SkipForwardFilled20 extends CarbonIcon {}
export declare class SkipForwardFilled24 extends CarbonIcon {}
export declare class SkipForwardFilled32 extends CarbonIcon {}
export declare class SkipForwardOutline16 extends CarbonIcon {}
export declare class SkipForwardOutline20 extends CarbonIcon {}
export declare class SkipForwardOutline24 extends CarbonIcon {}
export declare class SkipForwardOutline32 extends CarbonIcon {}
export declare class SkipForwardOutlineFilled16 extends CarbonIcon {}
export declare class SkipForwardOutlineFilled20 extends CarbonIcon {}
export declare class SkipForwardOutlineFilled24 extends CarbonIcon {}
export declare class SkipForwardOutlineFilled32 extends CarbonIcon {}
export declare class SkipForwardOutlineSolid16 extends CarbonIcon {}
export declare class SkipForwardOutlineSolid20 extends CarbonIcon {}
export declare class SkipForwardOutlineSolid24 extends CarbonIcon {}
export declare class SkipForwardOutlineSolid32 extends CarbonIcon {}
export declare class SkipForwardSolidFilled16 extends CarbonIcon {}
export declare class SkipForwardSolidFilled20 extends CarbonIcon {}
export declare class SkipForwardSolidFilled24 extends CarbonIcon {}
export declare class SkipForwardSolidFilled32 extends CarbonIcon {}
export declare class Sleet16 extends CarbonIcon {}
export declare class Sleet20 extends CarbonIcon {}
export declare class Sleet24 extends CarbonIcon {}
export declare class Sleet32 extends CarbonIcon {}
export declare class Smell16 extends CarbonIcon {}
export declare class Smell20 extends CarbonIcon {}
export declare class Smell24 extends CarbonIcon {}
export declare class Smell32 extends CarbonIcon {}
export declare class Smoke16 extends CarbonIcon {}
export declare class Smoke20 extends CarbonIcon {}
export declare class Smoke24 extends CarbonIcon {}
export declare class Smoke32 extends CarbonIcon {}
export declare class Snooze16 extends CarbonIcon {}
export declare class Snooze20 extends CarbonIcon {}
export declare class Snooze24 extends CarbonIcon {}
export declare class Snooze32 extends CarbonIcon {}
export declare class Snow16 extends CarbonIcon {}
export declare class Snow20 extends CarbonIcon {}
export declare class Snow24 extends CarbonIcon {}
export declare class Snow32 extends CarbonIcon {}
export declare class SnowBlizzard16 extends CarbonIcon {}
export declare class SnowBlizzard20 extends CarbonIcon {}
export declare class SnowBlizzard24 extends CarbonIcon {}
export declare class SnowBlizzard32 extends CarbonIcon {}
export declare class SnowDensity16 extends CarbonIcon {}
export declare class SnowDensity20 extends CarbonIcon {}
export declare class SnowDensity24 extends CarbonIcon {}
export declare class SnowDensity32 extends CarbonIcon {}
export declare class SnowHeavy16 extends CarbonIcon {}
export declare class SnowHeavy20 extends CarbonIcon {}
export declare class SnowHeavy24 extends CarbonIcon {}
export declare class SnowHeavy32 extends CarbonIcon {}
export declare class SnowScattered16 extends CarbonIcon {}
export declare class SnowScattered20 extends CarbonIcon {}
export declare class SnowScattered24 extends CarbonIcon {}
export declare class SnowScattered32 extends CarbonIcon {}
export declare class SnowScatteredNight16 extends CarbonIcon {}
export declare class SnowScatteredNight20 extends CarbonIcon {}
export declare class SnowScatteredNight24 extends CarbonIcon {}
export declare class SnowScatteredNight32 extends CarbonIcon {}
export declare class Snowflake16 extends CarbonIcon {}
export declare class Snowflake20 extends CarbonIcon {}
export declare class Snowflake24 extends CarbonIcon {}
export declare class Snowflake32 extends CarbonIcon {}
export declare class Soccer16 extends CarbonIcon {}
export declare class Soccer20 extends CarbonIcon {}
export declare class Soccer24 extends CarbonIcon {}
export declare class Soccer32 extends CarbonIcon {}
export declare class SoilMoisture16 extends CarbonIcon {}
export declare class SoilMoisture20 extends CarbonIcon {}
export declare class SoilMoisture24 extends CarbonIcon {}
export declare class SoilMoisture32 extends CarbonIcon {}
export declare class SoilMoistureField16 extends CarbonIcon {}
export declare class SoilMoistureField20 extends CarbonIcon {}
export declare class SoilMoistureField24 extends CarbonIcon {}
export declare class SoilMoistureField32 extends CarbonIcon {}
export declare class SoilMoistureGlobal16 extends CarbonIcon {}
export declare class SoilMoistureGlobal20 extends CarbonIcon {}
export declare class SoilMoistureGlobal24 extends CarbonIcon {}
export declare class SoilMoistureGlobal32 extends CarbonIcon {}
export declare class SoilTemperature16 extends CarbonIcon {}
export declare class SoilTemperature20 extends CarbonIcon {}
export declare class SoilTemperature24 extends CarbonIcon {}
export declare class SoilTemperature32 extends CarbonIcon {}
export declare class SoilTemperatureField16 extends CarbonIcon {}
export declare class SoilTemperatureField20 extends CarbonIcon {}
export declare class SoilTemperatureField24 extends CarbonIcon {}
export declare class SoilTemperatureField32 extends CarbonIcon {}
export declare class SoilTemperatureGlobal16 extends CarbonIcon {}
export declare class SoilTemperatureGlobal20 extends CarbonIcon {}
export declare class SoilTemperatureGlobal24 extends CarbonIcon {}
export declare class SoilTemperatureGlobal32 extends CarbonIcon {}
export declare class SpellCheck16 extends CarbonIcon {}
export declare class SpellCheck20 extends CarbonIcon {}
export declare class SpellCheck24 extends CarbonIcon {}
export declare class SpellCheck32 extends CarbonIcon {}
export declare class Split16 extends CarbonIcon {}
export declare class Split20 extends CarbonIcon {}
export declare class Split24 extends CarbonIcon {}
export declare class Split32 extends CarbonIcon {}
export declare class SplitScreen16 extends CarbonIcon {}
export declare class SplitScreen20 extends CarbonIcon {}
export declare class SplitScreen24 extends CarbonIcon {}
export declare class SplitScreen32 extends CarbonIcon {}
export declare class SprayPaint16 extends CarbonIcon {}
export declare class SprayPaint20 extends CarbonIcon {}
export declare class SprayPaint24 extends CarbonIcon {}
export declare class SprayPaint32 extends CarbonIcon {}
export declare class Sprout16 extends CarbonIcon {}
export declare class Sprout20 extends CarbonIcon {}
export declare class Sprout24 extends CarbonIcon {}
export declare class Sprout32 extends CarbonIcon {}
export declare class Sql16 extends CarbonIcon {}
export declare class Sql20 extends CarbonIcon {}
export declare class Sql24 extends CarbonIcon {}
export declare class Sql32 extends CarbonIcon {}
export declare class StackLimitation16 extends CarbonIcon {}
export declare class StackLimitation20 extends CarbonIcon {}
export declare class StackLimitation24 extends CarbonIcon {}
export declare class StackLimitation32 extends CarbonIcon {}
export declare class Stamp16 extends CarbonIcon {}
export declare class Stamp20 extends CarbonIcon {}
export declare class Stamp24 extends CarbonIcon {}
export declare class Stamp32 extends CarbonIcon {}
export declare class Star16 extends CarbonIcon {}
export declare class Star20 extends CarbonIcon {}
export declare class Star24 extends CarbonIcon {}
export declare class Star32 extends CarbonIcon {}
export declare class StarFilled16 extends CarbonIcon {}
export declare class StarFilled20 extends CarbonIcon {}
export declare class StarFilled24 extends CarbonIcon {}
export declare class StarFilled32 extends CarbonIcon {}
export declare class StarHalf16 extends CarbonIcon {}
export declare class StarHalf20 extends CarbonIcon {}
export declare class StarHalf24 extends CarbonIcon {}
export declare class StarHalf32 extends CarbonIcon {}
export declare class StarReview16 extends CarbonIcon {}
export declare class StarReview20 extends CarbonIcon {}
export declare class StarReview24 extends CarbonIcon {}
export declare class StarReview32 extends CarbonIcon {}
export declare class StayInside16 extends CarbonIcon {}
export declare class StayInside20 extends CarbonIcon {}
export declare class StayInside24 extends CarbonIcon {}
export declare class StayInside32 extends CarbonIcon {}
export declare class StemLeafPlot16 extends CarbonIcon {}
export declare class StemLeafPlot20 extends CarbonIcon {}
export declare class StemLeafPlot24 extends CarbonIcon {}
export declare class StemLeafPlot32 extends CarbonIcon {}
export declare class Stethoscope16 extends CarbonIcon {}
export declare class Stethoscope20 extends CarbonIcon {}
export declare class Stethoscope24 extends CarbonIcon {}
export declare class Stethoscope32 extends CarbonIcon {}
export declare class Stop16 extends CarbonIcon {}
export declare class Stop20 extends CarbonIcon {}
export declare class Stop24 extends CarbonIcon {}
export declare class Stop32 extends CarbonIcon {}
export declare class StopFilled16 extends CarbonIcon {}
export declare class StopFilled20 extends CarbonIcon {}
export declare class StopFilled24 extends CarbonIcon {}
export declare class StopFilled32 extends CarbonIcon {}
export declare class StopFilledAlt16 extends CarbonIcon {}
export declare class StopFilledAlt20 extends CarbonIcon {}
export declare class StopFilledAlt24 extends CarbonIcon {}
export declare class StopFilledAlt32 extends CarbonIcon {}
export declare class StopOutline16 extends CarbonIcon {}
export declare class StopOutline20 extends CarbonIcon {}
export declare class StopOutline24 extends CarbonIcon {}
export declare class StopOutline32 extends CarbonIcon {}
export declare class StopOutlineFilled16 extends CarbonIcon {}
export declare class StopOutlineFilled20 extends CarbonIcon {}
export declare class StopOutlineFilled24 extends CarbonIcon {}
export declare class StopOutlineFilled32 extends CarbonIcon {}
export declare class StorageRequest16 extends CarbonIcon {}
export declare class StorageRequest20 extends CarbonIcon {}
export declare class StorageRequest24 extends CarbonIcon {}
export declare class StorageRequest32 extends CarbonIcon {}
export declare class Store16 extends CarbonIcon {}
export declare class Store20 extends CarbonIcon {}
export declare class Store24 extends CarbonIcon {}
export declare class Store32 extends CarbonIcon {}
export declare class StormTracker16 extends CarbonIcon {}
export declare class StormTracker20 extends CarbonIcon {}
export declare class StormTracker24 extends CarbonIcon {}
export declare class StormTracker32 extends CarbonIcon {}
export declare class Strawberry16 extends CarbonIcon {}
export declare class Strawberry20 extends CarbonIcon {}
export declare class Strawberry24 extends CarbonIcon {}
export declare class Strawberry32 extends CarbonIcon {}
export declare class StringInteger16 extends CarbonIcon {}
export declare class StringInteger20 extends CarbonIcon {}
export declare class StringInteger24 extends CarbonIcon {}
export declare class StringInteger32 extends CarbonIcon {}
export declare class StringText16 extends CarbonIcon {}
export declare class StringText20 extends CarbonIcon {}
export declare class StringText24 extends CarbonIcon {}
export declare class StringText32 extends CarbonIcon {}
export declare class Subtract16 extends CarbonIcon {}
export declare class Subtract20 extends CarbonIcon {}
export declare class Subtract24 extends CarbonIcon {}
export declare class Subtract32 extends CarbonIcon {}
export declare class SubtractAlt16 extends CarbonIcon {}
export declare class SubtractAlt20 extends CarbonIcon {}
export declare class SubtractAlt24 extends CarbonIcon {}
export declare class SubtractAlt32 extends CarbonIcon {}
export declare class SummaryKpi16 extends CarbonIcon {}
export declare class SummaryKpi20 extends CarbonIcon {}
export declare class SummaryKpi24 extends CarbonIcon {}
export declare class SummaryKpi32 extends CarbonIcon {}
export declare class Sun16 extends CarbonIcon {}
export declare class Sun20 extends CarbonIcon {}
export declare class Sun24 extends CarbonIcon {}
export declare class Sun32 extends CarbonIcon {}
export declare class Sunny16 extends CarbonIcon {}
export declare class Sunny20 extends CarbonIcon {}
export declare class Sunny24 extends CarbonIcon {}
export declare class Sunny32 extends CarbonIcon {}
export declare class Sunrise16 extends CarbonIcon {}
export declare class Sunrise20 extends CarbonIcon {}
export declare class Sunrise24 extends CarbonIcon {}
export declare class Sunrise32 extends CarbonIcon {}
export declare class Sunset16 extends CarbonIcon {}
export declare class Sunset20 extends CarbonIcon {}
export declare class Sunset24 extends CarbonIcon {}
export declare class Sunset32 extends CarbonIcon {}
export declare class Svg16 extends CarbonIcon {}
export declare class Svg20 extends CarbonIcon {}
export declare class Svg24 extends CarbonIcon {}
export declare class Svg32 extends CarbonIcon {}
export declare class Swim16 extends CarbonIcon {}
export declare class Swim20 extends CarbonIcon {}
export declare class Swim24 extends CarbonIcon {}
export declare class Swim32 extends CarbonIcon {}
export declare class Switcher16 extends CarbonIcon {}
export declare class Switcher20 extends CarbonIcon {}
export declare class Switcher24 extends CarbonIcon {}
export declare class Switcher32 extends CarbonIcon {}
export declare class SysProvision16 extends CarbonIcon {}
export declare class SysProvision20 extends CarbonIcon {}
export declare class SysProvision24 extends CarbonIcon {}
export declare class SysProvision32 extends CarbonIcon {}
export declare class Table16 extends CarbonIcon {}
export declare class Table20 extends CarbonIcon {}
export declare class Table24 extends CarbonIcon {}
export declare class Table32 extends CarbonIcon {}
export declare class TableOfContents16 extends CarbonIcon {}
export declare class TableOfContents20 extends CarbonIcon {}
export declare class TableOfContents24 extends CarbonIcon {}
export declare class TableOfContents32 extends CarbonIcon {}
export declare class TableSplit16 extends CarbonIcon {}
export declare class TableSplit20 extends CarbonIcon {}
export declare class TableSplit24 extends CarbonIcon {}
export declare class TableSplit32 extends CarbonIcon {}
export declare class Tablet16 extends CarbonIcon {}
export declare class Tablet20 extends CarbonIcon {}
export declare class Tablet24 extends CarbonIcon {}
export declare class Tablet32 extends CarbonIcon {}
export declare class TabletLandscape16 extends CarbonIcon {}
export declare class TabletLandscape20 extends CarbonIcon {}
export declare class TabletLandscape24 extends CarbonIcon {}
export declare class TabletLandscape32 extends CarbonIcon {}
export declare class Tag16 extends CarbonIcon {}
export declare class Tag20 extends CarbonIcon {}
export declare class Tag24 extends CarbonIcon {}
export declare class Tag32 extends CarbonIcon {}
export declare class TagEdit16 extends CarbonIcon {}
export declare class TagEdit20 extends CarbonIcon {}
export declare class TagEdit24 extends CarbonIcon {}
export declare class TagEdit32 extends CarbonIcon {}
export declare class TagGroup16 extends CarbonIcon {}
export declare class TagGroup20 extends CarbonIcon {}
export declare class TagGroup24 extends CarbonIcon {}
export declare class TagGroup32 extends CarbonIcon {}
export declare class Task16 extends CarbonIcon {}
export declare class Task20 extends CarbonIcon {}
export declare class Task24 extends CarbonIcon {}
export declare class Task32 extends CarbonIcon {}
export declare class TaskView16 extends CarbonIcon {}
export declare class TaskView20 extends CarbonIcon {}
export declare class TaskView24 extends CarbonIcon {}
export declare class TaskView32 extends CarbonIcon {}
export declare class Taste16 extends CarbonIcon {}
export declare class Taste20 extends CarbonIcon {}
export declare class Taste24 extends CarbonIcon {}
export declare class Taste32 extends CarbonIcon {}
export declare class Taxi16 extends CarbonIcon {}
export declare class Taxi20 extends CarbonIcon {}
export declare class Taxi24 extends CarbonIcon {}
export declare class Taxi32 extends CarbonIcon {}
export declare class Temperature16 extends CarbonIcon {}
export declare class Temperature20 extends CarbonIcon {}
export declare class Temperature24 extends CarbonIcon {}
export declare class Temperature32 extends CarbonIcon {}
export declare class TemperatureFeelsLike16 extends CarbonIcon {}
export declare class TemperatureFeelsLike20 extends CarbonIcon {}
export declare class TemperatureFeelsLike24 extends CarbonIcon {}
export declare class TemperatureFeelsLike32 extends CarbonIcon {}
export declare class TemperatureFrigid16 extends CarbonIcon {}
export declare class TemperatureFrigid20 extends CarbonIcon {}
export declare class TemperatureFrigid24 extends CarbonIcon {}
export declare class TemperatureFrigid32 extends CarbonIcon {}
export declare class TemperatureHot16 extends CarbonIcon {}
export declare class TemperatureHot20 extends CarbonIcon {}
export declare class TemperatureHot24 extends CarbonIcon {}
export declare class TemperatureHot32 extends CarbonIcon {}
export declare class TemperatureInversion16 extends CarbonIcon {}
export declare class TemperatureInversion20 extends CarbonIcon {}
export declare class TemperatureInversion24 extends CarbonIcon {}
export declare class TemperatureInversion32 extends CarbonIcon {}
export declare class TemperatureMax16 extends CarbonIcon {}
export declare class TemperatureMax20 extends CarbonIcon {}
export declare class TemperatureMax24 extends CarbonIcon {}
export declare class TemperatureMax32 extends CarbonIcon {}
export declare class TemperatureMin16 extends CarbonIcon {}
export declare class TemperatureMin20 extends CarbonIcon {}
export declare class TemperatureMin24 extends CarbonIcon {}
export declare class TemperatureMin32 extends CarbonIcon {}
export declare class TemperatureWater16 extends CarbonIcon {}
export declare class TemperatureWater20 extends CarbonIcon {}
export declare class TemperatureWater24 extends CarbonIcon {}
export declare class TemperatureWater32 extends CarbonIcon {}
export declare class Template16 extends CarbonIcon {}
export declare class Template20 extends CarbonIcon {}
export declare class Template24 extends CarbonIcon {}
export declare class Template32 extends CarbonIcon {}
export declare class Tennis16 extends CarbonIcon {}
export declare class Tennis20 extends CarbonIcon {}
export declare class Tennis24 extends CarbonIcon {}
export declare class Tennis32 extends CarbonIcon {}
export declare class TennisBall16 extends CarbonIcon {}
export declare class TennisBall20 extends CarbonIcon {}
export declare class TennisBall24 extends CarbonIcon {}
export declare class TennisBall32 extends CarbonIcon {}
export declare class Term16 extends CarbonIcon {}
export declare class Term20 extends CarbonIcon {}
export declare class Term24 extends CarbonIcon {}
export declare class Term32 extends CarbonIcon {}
export declare class Terminal16 extends CarbonIcon {}
export declare class Terminal20 extends CarbonIcon {}
export declare class Terminal24 extends CarbonIcon {}
export declare class Terminal32 extends CarbonIcon {}
export declare class TextAlignCenter16 extends CarbonIcon {}
export declare class TextAlignCenter20 extends CarbonIcon {}
export declare class TextAlignCenter24 extends CarbonIcon {}
export declare class TextAlignCenter32 extends CarbonIcon {}
export declare class TextAlignJustify16 extends CarbonIcon {}
export declare class TextAlignJustify20 extends CarbonIcon {}
export declare class TextAlignJustify24 extends CarbonIcon {}
export declare class TextAlignJustify32 extends CarbonIcon {}
export declare class TextAlignLeft16 extends CarbonIcon {}
export declare class TextAlignLeft20 extends CarbonIcon {}
export declare class TextAlignLeft24 extends CarbonIcon {}
export declare class TextAlignLeft32 extends CarbonIcon {}
export declare class TextAlignRight16 extends CarbonIcon {}
export declare class TextAlignRight20 extends CarbonIcon {}
export declare class TextAlignRight24 extends CarbonIcon {}
export declare class TextAlignRight32 extends CarbonIcon {}
export declare class TextAllCaps16 extends CarbonIcon {}
export declare class TextAllCaps20 extends CarbonIcon {}
export declare class TextAllCaps24 extends CarbonIcon {}
export declare class TextAllCaps32 extends CarbonIcon {}
export declare class TextBold16 extends CarbonIcon {}
export declare class TextBold20 extends CarbonIcon {}
export declare class TextBold24 extends CarbonIcon {}
export declare class TextBold32 extends CarbonIcon {}
export declare class TextColor16 extends CarbonIcon {}
export declare class TextColor20 extends CarbonIcon {}
export declare class TextColor24 extends CarbonIcon {}
export declare class TextColor32 extends CarbonIcon {}
export declare class TextCreation16 extends CarbonIcon {}
export declare class TextCreation20 extends CarbonIcon {}
export declare class TextCreation24 extends CarbonIcon {}
export declare class TextCreation32 extends CarbonIcon {}
export declare class TextFill16 extends CarbonIcon {}
export declare class TextFill20 extends CarbonIcon {}
export declare class TextFill24 extends CarbonIcon {}
export declare class TextFill32 extends CarbonIcon {}
export declare class TextFootnote16 extends CarbonIcon {}
export declare class TextFootnote20 extends CarbonIcon {}
export declare class TextFootnote24 extends CarbonIcon {}
export declare class TextFootnote32 extends CarbonIcon {}
export declare class TextHighlight16 extends CarbonIcon {}
export declare class TextHighlight20 extends CarbonIcon {}
export declare class TextHighlight24 extends CarbonIcon {}
export declare class TextHighlight32 extends CarbonIcon {}
export declare class TextIndent16 extends CarbonIcon {}
export declare class TextIndent20 extends CarbonIcon {}
export declare class TextIndent24 extends CarbonIcon {}
export declare class TextIndent32 extends CarbonIcon {}
export declare class TextIndentLess16 extends CarbonIcon {}
export declare class TextIndentLess20 extends CarbonIcon {}
export declare class TextIndentLess24 extends CarbonIcon {}
export declare class TextIndentLess32 extends CarbonIcon {}
export declare class TextIndentMore16 extends CarbonIcon {}
export declare class TextIndentMore20 extends CarbonIcon {}
export declare class TextIndentMore24 extends CarbonIcon {}
export declare class TextIndentMore32 extends CarbonIcon {}
export declare class TextItalic16 extends CarbonIcon {}
export declare class TextItalic20 extends CarbonIcon {}
export declare class TextItalic24 extends CarbonIcon {}
export declare class TextItalic32 extends CarbonIcon {}
export declare class TextKerning16 extends CarbonIcon {}
export declare class TextKerning20 extends CarbonIcon {}
export declare class TextKerning24 extends CarbonIcon {}
export declare class TextKerning32 extends CarbonIcon {}
export declare class TextLeading16 extends CarbonIcon {}
export declare class TextLeading20 extends CarbonIcon {}
export declare class TextLeading24 extends CarbonIcon {}
export declare class TextLeading32 extends CarbonIcon {}
export declare class TextLineSpacing16 extends CarbonIcon {}
export declare class TextLineSpacing20 extends CarbonIcon {}
export declare class TextLineSpacing24 extends CarbonIcon {}
export declare class TextLineSpacing32 extends CarbonIcon {}
export declare class TextLink16 extends CarbonIcon {}
export declare class TextLink20 extends CarbonIcon {}
export declare class TextLink24 extends CarbonIcon {}
export declare class TextLink32 extends CarbonIcon {}
export declare class TextLinkAnalysis16 extends CarbonIcon {}
export declare class TextLinkAnalysis20 extends CarbonIcon {}
export declare class TextLinkAnalysis24 extends CarbonIcon {}
export declare class TextLinkAnalysis32 extends CarbonIcon {}
export declare class TextMining16 extends CarbonIcon {}
export declare class TextMining20 extends CarbonIcon {}
export declare class TextMining24 extends CarbonIcon {}
export declare class TextMining32 extends CarbonIcon {}
export declare class TextMiningApplier16 extends CarbonIcon {}
export declare class TextMiningApplier20 extends CarbonIcon {}
export declare class TextMiningApplier24 extends CarbonIcon {}
export declare class TextMiningApplier32 extends CarbonIcon {}
export declare class TextNewLine16 extends CarbonIcon {}
export declare class TextNewLine20 extends CarbonIcon {}
export declare class TextNewLine24 extends CarbonIcon {}
export declare class TextNewLine32 extends CarbonIcon {}
export declare class TextScale16 extends CarbonIcon {}
export declare class TextScale20 extends CarbonIcon {}
export declare class TextScale24 extends CarbonIcon {}
export declare class TextScale32 extends CarbonIcon {}
export declare class TextSelection16 extends CarbonIcon {}
export declare class TextSelection20 extends CarbonIcon {}
export declare class TextSelection24 extends CarbonIcon {}
export declare class TextSelection32 extends CarbonIcon {}
export declare class TextSmallCaps16 extends CarbonIcon {}
export declare class TextSmallCaps20 extends CarbonIcon {}
export declare class TextSmallCaps24 extends CarbonIcon {}
export declare class TextSmallCaps32 extends CarbonIcon {}
export declare class TextStrikethrough16 extends CarbonIcon {}
export declare class TextStrikethrough20 extends CarbonIcon {}
export declare class TextStrikethrough24 extends CarbonIcon {}
export declare class TextStrikethrough32 extends CarbonIcon {}
export declare class TextSubscript16 extends CarbonIcon {}
export declare class TextSubscript20 extends CarbonIcon {}
export declare class TextSubscript24 extends CarbonIcon {}
export declare class TextSubscript32 extends CarbonIcon {}
export declare class TextSuperscript16 extends CarbonIcon {}
export declare class TextSuperscript20 extends CarbonIcon {}
export declare class TextSuperscript24 extends CarbonIcon {}
export declare class TextSuperscript32 extends CarbonIcon {}
export declare class TextTracking16 extends CarbonIcon {}
export declare class TextTracking20 extends CarbonIcon {}
export declare class TextTracking24 extends CarbonIcon {}
export declare class TextTracking32 extends CarbonIcon {}
export declare class TextUnderline16 extends CarbonIcon {}
export declare class TextUnderline20 extends CarbonIcon {}
export declare class TextUnderline24 extends CarbonIcon {}
export declare class TextUnderline32 extends CarbonIcon {}
export declare class TextVerticalAlignment16 extends CarbonIcon {}
export declare class TextVerticalAlignment20 extends CarbonIcon {}
export declare class TextVerticalAlignment24 extends CarbonIcon {}
export declare class TextVerticalAlignment32 extends CarbonIcon {}
export declare class TextWrap16 extends CarbonIcon {}
export declare class TextWrap20 extends CarbonIcon {}
export declare class TextWrap24 extends CarbonIcon {}
export declare class TextWrap32 extends CarbonIcon {}
export declare class Theater16 extends CarbonIcon {}
export declare class Theater20 extends CarbonIcon {}
export declare class Theater24 extends CarbonIcon {}
export declare class Theater32 extends CarbonIcon {}
export declare class ThisSideUp16 extends CarbonIcon {}
export declare class ThisSideUp20 extends CarbonIcon {}
export declare class ThisSideUp24 extends CarbonIcon {}
export declare class ThisSideUp32 extends CarbonIcon {}
export declare class Thumbnail_116 extends CarbonIcon {}
export declare class Thumbnail_120 extends CarbonIcon {}
export declare class Thumbnail_124 extends CarbonIcon {}
export declare class Thumbnail_132 extends CarbonIcon {}
export declare class Thumbnail_216 extends CarbonIcon {}
export declare class Thumbnail_220 extends CarbonIcon {}
export declare class Thumbnail_224 extends CarbonIcon {}
export declare class Thumbnail_232 extends CarbonIcon {}
export declare class ThumbsDown16 extends CarbonIcon {}
export declare class ThumbsDown20 extends CarbonIcon {}
export declare class ThumbsDown24 extends CarbonIcon {}
export declare class ThumbsDown32 extends CarbonIcon {}
export declare class ThumbsUp16 extends CarbonIcon {}
export declare class ThumbsUp20 extends CarbonIcon {}
export declare class ThumbsUp24 extends CarbonIcon {}
export declare class ThumbsUp32 extends CarbonIcon {}
export declare class Thunderstorm16 extends CarbonIcon {}
export declare class Thunderstorm20 extends CarbonIcon {}
export declare class Thunderstorm24 extends CarbonIcon {}
export declare class Thunderstorm32 extends CarbonIcon {}
export declare class ThunderstormScattered16 extends CarbonIcon {}
export declare class ThunderstormScattered20 extends CarbonIcon {}
export declare class ThunderstormScattered24 extends CarbonIcon {}
export declare class ThunderstormScattered32 extends CarbonIcon {}
export declare class ThunderstormScatteredNight16 extends CarbonIcon {}
export declare class ThunderstormScatteredNight20 extends CarbonIcon {}
export declare class ThunderstormScatteredNight24 extends CarbonIcon {}
export declare class ThunderstormScatteredNight32 extends CarbonIcon {}
export declare class ThunderstormSevere16 extends CarbonIcon {}
export declare class ThunderstormSevere20 extends CarbonIcon {}
export declare class ThunderstormSevere24 extends CarbonIcon {}
export declare class ThunderstormSevere32 extends CarbonIcon {}
export declare class ThunderstormStrong16 extends CarbonIcon {}
export declare class ThunderstormStrong20 extends CarbonIcon {}
export declare class ThunderstormStrong24 extends CarbonIcon {}
export declare class ThunderstormStrong32 extends CarbonIcon {}
export declare class Ticket16 extends CarbonIcon {}
export declare class Ticket20 extends CarbonIcon {}
export declare class Ticket24 extends CarbonIcon {}
export declare class Ticket32 extends CarbonIcon {}
export declare class Tides16 extends CarbonIcon {}
export declare class Tides20 extends CarbonIcon {}
export declare class Tides24 extends CarbonIcon {}
export declare class Tides32 extends CarbonIcon {}
export declare class Tif16 extends CarbonIcon {}
export declare class Tif20 extends CarbonIcon {}
export declare class Tif24 extends CarbonIcon {}
export declare class Tif32 extends CarbonIcon {}
export declare class Time16 extends CarbonIcon {}
export declare class Time20 extends CarbonIcon {}
export declare class Time24 extends CarbonIcon {}
export declare class Time32 extends CarbonIcon {}
export declare class TimePlot16 extends CarbonIcon {}
export declare class TimePlot20 extends CarbonIcon {}
export declare class TimePlot24 extends CarbonIcon {}
export declare class TimePlot32 extends CarbonIcon {}
export declare class Timer16 extends CarbonIcon {}
export declare class Timer20 extends CarbonIcon {}
export declare class Timer24 extends CarbonIcon {}
export declare class Timer32 extends CarbonIcon {}
export declare class ToolBox16 extends CarbonIcon {}
export declare class ToolBox20 extends CarbonIcon {}
export declare class ToolBox24 extends CarbonIcon {}
export declare class ToolBox32 extends CarbonIcon {}
export declare class Tools16 extends CarbonIcon {}
export declare class Tools20 extends CarbonIcon {}
export declare class Tools24 extends CarbonIcon {}
export declare class Tools32 extends CarbonIcon {}
export declare class ToolsAlt16 extends CarbonIcon {}
export declare class ToolsAlt20 extends CarbonIcon {}
export declare class ToolsAlt24 extends CarbonIcon {}
export declare class ToolsAlt32 extends CarbonIcon {}
export declare class Tornado16 extends CarbonIcon {}
export declare class Tornado20 extends CarbonIcon {}
export declare class Tornado24 extends CarbonIcon {}
export declare class Tornado32 extends CarbonIcon {}
export declare class TornadoWarning16 extends CarbonIcon {}
export declare class TornadoWarning20 extends CarbonIcon {}
export declare class TornadoWarning24 extends CarbonIcon {}
export declare class TornadoWarning32 extends CarbonIcon {}
export declare class TouchInteraction16 extends CarbonIcon {}
export declare class TouchInteraction20 extends CarbonIcon {}
export declare class TouchInteraction24 extends CarbonIcon {}
export declare class TouchInteraction32 extends CarbonIcon {}
export declare class Touch_116 extends CarbonIcon {}
export declare class Touch_120 extends CarbonIcon {}
export declare class Touch_124 extends CarbonIcon {}
export declare class Touch_132 extends CarbonIcon {}
export declare class Touch_216 extends CarbonIcon {}
export declare class Touch_220 extends CarbonIcon {}
export declare class Touch_224 extends CarbonIcon {}
export declare class Touch_232 extends CarbonIcon {}
export declare class TrafficCone16 extends CarbonIcon {}
export declare class TrafficCone20 extends CarbonIcon {}
export declare class TrafficCone24 extends CarbonIcon {}
export declare class TrafficCone32 extends CarbonIcon {}
export declare class TrafficEvent16 extends CarbonIcon {}
export declare class TrafficEvent20 extends CarbonIcon {}
export declare class TrafficEvent24 extends CarbonIcon {}
export declare class TrafficEvent32 extends CarbonIcon {}
export declare class TrafficFlow16 extends CarbonIcon {}
export declare class TrafficFlow20 extends CarbonIcon {}
export declare class TrafficFlow24 extends CarbonIcon {}
export declare class TrafficFlow32 extends CarbonIcon {}
export declare class TrafficFlowIncident16 extends CarbonIcon {}
export declare class TrafficFlowIncident20 extends CarbonIcon {}
export declare class TrafficFlowIncident24 extends CarbonIcon {}
export declare class TrafficFlowIncident32 extends CarbonIcon {}
export declare class TrafficIncident16 extends CarbonIcon {}
export declare class TrafficIncident20 extends CarbonIcon {}
export declare class TrafficIncident24 extends CarbonIcon {}
export declare class TrafficIncident32 extends CarbonIcon {}
export declare class TrafficWeatherIncident16 extends CarbonIcon {}
export declare class TrafficWeatherIncident20 extends CarbonIcon {}
export declare class TrafficWeatherIncident24 extends CarbonIcon {}
export declare class TrafficWeatherIncident32 extends CarbonIcon {}
export declare class Train16 extends CarbonIcon {}
export declare class Train20 extends CarbonIcon {}
export declare class Train24 extends CarbonIcon {}
export declare class Train32 extends CarbonIcon {}
export declare class TrainHeart16 extends CarbonIcon {}
export declare class TrainHeart20 extends CarbonIcon {}
export declare class TrainHeart24 extends CarbonIcon {}
export declare class TrainHeart32 extends CarbonIcon {}
export declare class TrainTicket16 extends CarbonIcon {}
export declare class TrainTicket20 extends CarbonIcon {}
export declare class TrainTicket24 extends CarbonIcon {}
export declare class TrainTicket32 extends CarbonIcon {}
export declare class TrainTime16 extends CarbonIcon {}
export declare class TrainTime20 extends CarbonIcon {}
export declare class TrainTime24 extends CarbonIcon {}
export declare class TrainTime32 extends CarbonIcon {}
export declare class Tram16 extends CarbonIcon {}
export declare class Tram20 extends CarbonIcon {}
export declare class Tram24 extends CarbonIcon {}
export declare class Tram32 extends CarbonIcon {}
export declare class Transgender16 extends CarbonIcon {}
export declare class Transgender20 extends CarbonIcon {}
export declare class Transgender24 extends CarbonIcon {}
export declare class Transgender32 extends CarbonIcon {}
export declare class Translate16 extends CarbonIcon {}
export declare class Translate20 extends CarbonIcon {}
export declare class Translate24 extends CarbonIcon {}
export declare class Translate32 extends CarbonIcon {}
export declare class TrashCan16 extends CarbonIcon {}
export declare class TrashCan20 extends CarbonIcon {}
export declare class TrashCan24 extends CarbonIcon {}
export declare class TrashCan32 extends CarbonIcon {}
export declare class Tree16 extends CarbonIcon {}
export declare class Tree20 extends CarbonIcon {}
export declare class Tree24 extends CarbonIcon {}
export declare class Tree32 extends CarbonIcon {}
export declare class TreeView16 extends CarbonIcon {}
export declare class TreeView20 extends CarbonIcon {}
export declare class TreeView24 extends CarbonIcon {}
export declare class TreeView32 extends CarbonIcon {}
export declare class TreeViewAlt16 extends CarbonIcon {}
export declare class TreeViewAlt20 extends CarbonIcon {}
export declare class TreeViewAlt24 extends CarbonIcon {}
export declare class TreeViewAlt32 extends CarbonIcon {}
export declare class Trophy16 extends CarbonIcon {}
export declare class Trophy20 extends CarbonIcon {}
export declare class Trophy24 extends CarbonIcon {}
export declare class Trophy32 extends CarbonIcon {}
export declare class TrophyFilled16 extends CarbonIcon {}
export declare class TrophyFilled20 extends CarbonIcon {}
export declare class TrophyFilled24 extends CarbonIcon {}
export declare class TrophyFilled32 extends CarbonIcon {}
export declare class TropicalStorm16 extends CarbonIcon {}
export declare class TropicalStorm20 extends CarbonIcon {}
export declare class TropicalStorm24 extends CarbonIcon {}
export declare class TropicalStorm32 extends CarbonIcon {}
export declare class TropicalStormModelTracks16 extends CarbonIcon {}
export declare class TropicalStormModelTracks20 extends CarbonIcon {}
export declare class TropicalStormModelTracks24 extends CarbonIcon {}
export declare class TropicalStormModelTracks32 extends CarbonIcon {}
export declare class TropicalStormTracks16 extends CarbonIcon {}
export declare class TropicalStormTracks20 extends CarbonIcon {}
export declare class TropicalStormTracks24 extends CarbonIcon {}
export declare class TropicalStormTracks32 extends CarbonIcon {}
export declare class TropicalWarning16 extends CarbonIcon {}
export declare class TropicalWarning20 extends CarbonIcon {}
export declare class TropicalWarning24 extends CarbonIcon {}
export declare class TropicalWarning32 extends CarbonIcon {}
export declare class Tsv16 extends CarbonIcon {}
export declare class Tsv20 extends CarbonIcon {}
export declare class Tsv24 extends CarbonIcon {}
export declare class Tsv32 extends CarbonIcon {}
export declare class TwoPersonLift16 extends CarbonIcon {}
export declare class TwoPersonLift20 extends CarbonIcon {}
export declare class TwoPersonLift24 extends CarbonIcon {}
export declare class TwoPersonLift32 extends CarbonIcon {}
export declare class Txt16 extends CarbonIcon {}
export declare class Txt20 extends CarbonIcon {}
export declare class Txt24 extends CarbonIcon {}
export declare class Txt32 extends CarbonIcon {}
export declare class TxtReference16 extends CarbonIcon {}
export declare class TxtReference20 extends CarbonIcon {}
export declare class TxtReference24 extends CarbonIcon {}
export declare class TxtReference32 extends CarbonIcon {}
export declare class TypePattern16 extends CarbonIcon {}
export declare class TypePattern20 extends CarbonIcon {}
export declare class TypePattern24 extends CarbonIcon {}
export declare class TypePattern32 extends CarbonIcon {}
export declare class Types16 extends CarbonIcon {}
export declare class Types20 extends CarbonIcon {}
export declare class Types24 extends CarbonIcon {}
export declare class Types32 extends CarbonIcon {}
export declare class Umbrella16 extends CarbonIcon {}
export declare class Umbrella20 extends CarbonIcon {}
export declare class Umbrella24 extends CarbonIcon {}
export declare class Umbrella32 extends CarbonIcon {}
export declare class Undefined16 extends CarbonIcon {}
export declare class Undefined20 extends CarbonIcon {}
export declare class Undefined24 extends CarbonIcon {}
export declare class Undefined32 extends CarbonIcon {}
export declare class UndefinedFilled16 extends CarbonIcon {}
export declare class UndefinedFilled20 extends CarbonIcon {}
export declare class UndefinedFilled24 extends CarbonIcon {}
export declare class UndefinedFilled32 extends CarbonIcon {}
export declare class Undo16 extends CarbonIcon {}
export declare class Undo20 extends CarbonIcon {}
export declare class Undo24 extends CarbonIcon {}
export declare class Undo32 extends CarbonIcon {}
export declare class Unknown16 extends CarbonIcon {}
export declare class Unknown20 extends CarbonIcon {}
export declare class Unknown24 extends CarbonIcon {}
export declare class Unknown32 extends CarbonIcon {}
export declare class UnknownFilled16 extends CarbonIcon {}
export declare class UnknownFilled20 extends CarbonIcon {}
export declare class UnknownFilled24 extends CarbonIcon {}
export declare class UnknownFilled32 extends CarbonIcon {}
export declare class Unlink16 extends CarbonIcon {}
export declare class Unlink20 extends CarbonIcon {}
export declare class Unlink24 extends CarbonIcon {}
export declare class Unlink32 extends CarbonIcon {}
export declare class Unlocked16 extends CarbonIcon {}
export declare class Unlocked20 extends CarbonIcon {}
export declare class Unlocked24 extends CarbonIcon {}
export declare class Unlocked32 extends CarbonIcon {}
export declare class UpToTop16 extends CarbonIcon {}
export declare class UpToTop20 extends CarbonIcon {}
export declare class UpToTop24 extends CarbonIcon {}
export declare class UpToTop32 extends CarbonIcon {}
export declare class Upgrade16 extends CarbonIcon {}
export declare class Upgrade20 extends CarbonIcon {}
export declare class Upgrade24 extends CarbonIcon {}
export declare class Upgrade32 extends CarbonIcon {}
export declare class Upload16 extends CarbonIcon {}
export declare class Upload20 extends CarbonIcon {}
export declare class Upload24 extends CarbonIcon {}
export declare class Upload32 extends CarbonIcon {}
export declare class Usb16 extends CarbonIcon {}
export declare class Usb20 extends CarbonIcon {}
export declare class Usb24 extends CarbonIcon {}
export declare class Usb32 extends CarbonIcon {}
export declare class User16 extends CarbonIcon {}
export declare class User20 extends CarbonIcon {}
export declare class User24 extends CarbonIcon {}
export declare class User32 extends CarbonIcon {}
export declare class UserActivity16 extends CarbonIcon {}
export declare class UserActivity20 extends CarbonIcon {}
export declare class UserActivity24 extends CarbonIcon {}
export declare class UserActivity32 extends CarbonIcon {}
export declare class UserAdmin16 extends CarbonIcon {}
export declare class UserAdmin20 extends CarbonIcon {}
export declare class UserAdmin24 extends CarbonIcon {}
export declare class UserAdmin32 extends CarbonIcon {}
export declare class UserAvatar16 extends CarbonIcon {}
export declare class UserAvatar20 extends CarbonIcon {}
export declare class UserAvatar24 extends CarbonIcon {}
export declare class UserAvatar32 extends CarbonIcon {}
export declare class UserAvatarFilled16 extends CarbonIcon {}
export declare class UserAvatarFilled20 extends CarbonIcon {}
export declare class UserAvatarFilled24 extends CarbonIcon {}
export declare class UserAvatarFilled32 extends CarbonIcon {}
export declare class UserAvatarFilledAlt16 extends CarbonIcon {}
export declare class UserAvatarFilledAlt20 extends CarbonIcon {}
export declare class UserAvatarFilledAlt24 extends CarbonIcon {}
export declare class UserAvatarFilledAlt32 extends CarbonIcon {}
export declare class UserCertification16 extends CarbonIcon {}
export declare class UserCertification20 extends CarbonIcon {}
export declare class UserCertification24 extends CarbonIcon {}
export declare class UserCertification32 extends CarbonIcon {}
export declare class UserData16 extends CarbonIcon {}
export declare class UserData20 extends CarbonIcon {}
export declare class UserData24 extends CarbonIcon {}
export declare class UserData32 extends CarbonIcon {}
export declare class UserFavorite16 extends CarbonIcon {}
export declare class UserFavorite20 extends CarbonIcon {}
export declare class UserFavorite24 extends CarbonIcon {}
export declare class UserFavorite32 extends CarbonIcon {}
export declare class UserFavoriteAlt16 extends CarbonIcon {}
export declare class UserFavoriteAlt20 extends CarbonIcon {}
export declare class UserFavoriteAlt24 extends CarbonIcon {}
export declare class UserFavoriteAlt32 extends CarbonIcon {}
export declare class UserFavoriteAltFilled16 extends CarbonIcon {}
export declare class UserFavoriteAltFilled20 extends CarbonIcon {}
export declare class UserFavoriteAltFilled24 extends CarbonIcon {}
export declare class UserFavoriteAltFilled32 extends CarbonIcon {}
export declare class UserFilled16 extends CarbonIcon {}
export declare class UserFilled20 extends CarbonIcon {}
export declare class UserFilled24 extends CarbonIcon {}
export declare class UserFilled32 extends CarbonIcon {}
export declare class UserFollow16 extends CarbonIcon {}
export declare class UserFollow20 extends CarbonIcon {}
export declare class UserFollow24 extends CarbonIcon {}
export declare class UserFollow32 extends CarbonIcon {}
export declare class UserIdentification16 extends CarbonIcon {}
export declare class UserIdentification20 extends CarbonIcon {}
export declare class UserIdentification24 extends CarbonIcon {}
export declare class UserIdentification32 extends CarbonIcon {}
export declare class UserMultiple16 extends CarbonIcon {}
export declare class UserMultiple20 extends CarbonIcon {}
export declare class UserMultiple24 extends CarbonIcon {}
export declare class UserMultiple32 extends CarbonIcon {}
export declare class UserOnline16 extends CarbonIcon {}
export declare class UserOnline20 extends CarbonIcon {}
export declare class UserOnline24 extends CarbonIcon {}
export declare class UserOnline32 extends CarbonIcon {}
export declare class UserProfile16 extends CarbonIcon {}
export declare class UserProfile20 extends CarbonIcon {}
export declare class UserProfile24 extends CarbonIcon {}
export declare class UserProfile32 extends CarbonIcon {}
export declare class UserProfileAlt16 extends CarbonIcon {}
export declare class UserProfileAlt20 extends CarbonIcon {}
export declare class UserProfileAlt24 extends CarbonIcon {}
export declare class UserProfileAlt32 extends CarbonIcon {}
export declare class UserRole16 extends CarbonIcon {}
export declare class UserRole20 extends CarbonIcon {}
export declare class UserRole24 extends CarbonIcon {}
export declare class UserRole32 extends CarbonIcon {}
export declare class UserSimulation16 extends CarbonIcon {}
export declare class UserSimulation20 extends CarbonIcon {}
export declare class UserSimulation24 extends CarbonIcon {}
export declare class UserSimulation32 extends CarbonIcon {}
export declare class UserSpeaker16 extends CarbonIcon {}
export declare class UserSpeaker20 extends CarbonIcon {}
export declare class UserSpeaker24 extends CarbonIcon {}
export declare class UserSpeaker32 extends CarbonIcon {}
export declare class UserXRay16 extends CarbonIcon {}
export declare class UserXRay20 extends CarbonIcon {}
export declare class UserXRay24 extends CarbonIcon {}
export declare class UserXRay32 extends CarbonIcon {}
export declare class UvIndex16 extends CarbonIcon {}
export declare class UvIndex20 extends CarbonIcon {}
export declare class UvIndex24 extends CarbonIcon {}
export declare class UvIndex32 extends CarbonIcon {}
export declare class UvIndexAlt16 extends CarbonIcon {}
export declare class UvIndexAlt20 extends CarbonIcon {}
export declare class UvIndexAlt24 extends CarbonIcon {}
export declare class UvIndexAlt32 extends CarbonIcon {}
export declare class UvIndexFilled16 extends CarbonIcon {}
export declare class UvIndexFilled20 extends CarbonIcon {}
export declare class UvIndexFilled24 extends CarbonIcon {}
export declare class UvIndexFilled32 extends CarbonIcon {}
export declare class Van16 extends CarbonIcon {}
export declare class Van20 extends CarbonIcon {}
export declare class Van24 extends CarbonIcon {}
export declare class Van32 extends CarbonIcon {}
export declare class Video16 extends CarbonIcon {}
export declare class Video20 extends CarbonIcon {}
export declare class Video24 extends CarbonIcon {}
export declare class Video32 extends CarbonIcon {}
export declare class VideoAdd16 extends CarbonIcon {}
export declare class VideoAdd20 extends CarbonIcon {}
export declare class VideoAdd24 extends CarbonIcon {}
export declare class VideoAdd32 extends CarbonIcon {}
export declare class VideoChat16 extends CarbonIcon {}
export declare class VideoChat20 extends CarbonIcon {}
export declare class VideoChat24 extends CarbonIcon {}
export declare class VideoChat32 extends CarbonIcon {}
export declare class VideoFilled16 extends CarbonIcon {}
export declare class VideoFilled20 extends CarbonIcon {}
export declare class VideoFilled24 extends CarbonIcon {}
export declare class VideoFilled32 extends CarbonIcon {}
export declare class VideoOff16 extends CarbonIcon {}
export declare class VideoOff20 extends CarbonIcon {}
export declare class VideoOff24 extends CarbonIcon {}
export declare class VideoOff32 extends CarbonIcon {}
export declare class VideoOffFilled16 extends CarbonIcon {}
export declare class VideoOffFilled20 extends CarbonIcon {}
export declare class VideoOffFilled24 extends CarbonIcon {}
export declare class VideoOffFilled32 extends CarbonIcon {}
export declare class View16 extends CarbonIcon {}
export declare class View20 extends CarbonIcon {}
export declare class View24 extends CarbonIcon {}
export declare class View32 extends CarbonIcon {}
export declare class ViewFilled16 extends CarbonIcon {}
export declare class ViewFilled20 extends CarbonIcon {}
export declare class ViewFilled24 extends CarbonIcon {}
export declare class ViewFilled32 extends CarbonIcon {}
export declare class ViewMode_116 extends CarbonIcon {}
export declare class ViewMode_120 extends CarbonIcon {}
export declare class ViewMode_124 extends CarbonIcon {}
export declare class ViewMode_132 extends CarbonIcon {}
export declare class ViewMode_216 extends CarbonIcon {}
export declare class ViewMode_220 extends CarbonIcon {}
export declare class ViewMode_224 extends CarbonIcon {}
export declare class ViewMode_232 extends CarbonIcon {}
export declare class ViewNext16 extends CarbonIcon {}
export declare class ViewNext20 extends CarbonIcon {}
export declare class ViewNext24 extends CarbonIcon {}
export declare class ViewNext32 extends CarbonIcon {}
export declare class ViewOff16 extends CarbonIcon {}
export declare class ViewOff20 extends CarbonIcon {}
export declare class ViewOff24 extends CarbonIcon {}
export declare class ViewOff32 extends CarbonIcon {}
export declare class ViewOffFilled16 extends CarbonIcon {}
export declare class ViewOffFilled20 extends CarbonIcon {}
export declare class ViewOffFilled24 extends CarbonIcon {}
export declare class ViewOffFilled32 extends CarbonIcon {}
export declare class VirtualColumn16 extends CarbonIcon {}
export declare class VirtualColumn20 extends CarbonIcon {}
export declare class VirtualColumn24 extends CarbonIcon {}
export declare class VirtualColumn32 extends CarbonIcon {}
export declare class VirtualColumnKey16 extends CarbonIcon {}
export declare class VirtualColumnKey20 extends CarbonIcon {}
export declare class VirtualColumnKey24 extends CarbonIcon {}
export declare class VirtualColumnKey32 extends CarbonIcon {}
export declare class VirtualMachine16 extends CarbonIcon {}
export declare class VirtualMachine20 extends CarbonIcon {}
export declare class VirtualMachine24 extends CarbonIcon {}
export declare class VirtualMachine32 extends CarbonIcon {}
export declare class VirtualPrivateCloud16 extends CarbonIcon {}
export declare class VirtualPrivateCloud20 extends CarbonIcon {}
export declare class VirtualPrivateCloud24 extends CarbonIcon {}
export declare class VirtualPrivateCloud32 extends CarbonIcon {}
export declare class VirtualPrivateCloudAlt16 extends CarbonIcon {}
export declare class VirtualPrivateCloudAlt20 extends CarbonIcon {}
export declare class VirtualPrivateCloudAlt24 extends CarbonIcon {}
export declare class VirtualPrivateCloudAlt32 extends CarbonIcon {}
export declare class VisualRecognition16 extends CarbonIcon {}
export declare class VisualRecognition20 extends CarbonIcon {}
export declare class VisualRecognition24 extends CarbonIcon {}
export declare class VisualRecognition32 extends CarbonIcon {}
export declare class VmdkDisk16 extends CarbonIcon {}
export declare class VmdkDisk20 extends CarbonIcon {}
export declare class VmdkDisk24 extends CarbonIcon {}
export declare class VmdkDisk32 extends CarbonIcon {}
export declare class Voicemail16 extends CarbonIcon {}
export declare class Voicemail20 extends CarbonIcon {}
export declare class Voicemail24 extends CarbonIcon {}
export declare class Voicemail32 extends CarbonIcon {}
export declare class VolumeDown16 extends CarbonIcon {}
export declare class VolumeDown20 extends CarbonIcon {}
export declare class VolumeDown24 extends CarbonIcon {}
export declare class VolumeDown32 extends CarbonIcon {}
export declare class VolumeDownFilled16 extends CarbonIcon {}
export declare class VolumeDownFilled20 extends CarbonIcon {}
export declare class VolumeDownFilled24 extends CarbonIcon {}
export declare class VolumeDownFilled32 extends CarbonIcon {}
export declare class VolumeMute16 extends CarbonIcon {}
export declare class VolumeMute20 extends CarbonIcon {}
export declare class VolumeMute24 extends CarbonIcon {}
export declare class VolumeMute32 extends CarbonIcon {}
export declare class VolumeMuteFilled16 extends CarbonIcon {}
export declare class VolumeMuteFilled20 extends CarbonIcon {}
export declare class VolumeMuteFilled24 extends CarbonIcon {}
export declare class VolumeMuteFilled32 extends CarbonIcon {}
export declare class VolumeUp16 extends CarbonIcon {}
export declare class VolumeUp20 extends CarbonIcon {}
export declare class VolumeUp24 extends CarbonIcon {}
export declare class VolumeUp32 extends CarbonIcon {}
export declare class VolumeUpFilled16 extends CarbonIcon {}
export declare class VolumeUpFilled20 extends CarbonIcon {}
export declare class VolumeUpFilled24 extends CarbonIcon {}
export declare class VolumeUpFilled32 extends CarbonIcon {}
export declare class Vpn16 extends CarbonIcon {}
export declare class Vpn20 extends CarbonIcon {}
export declare class Vpn24 extends CarbonIcon {}
export declare class Vpn32 extends CarbonIcon {}
export declare class Wallet16 extends CarbonIcon {}
export declare class Wallet20 extends CarbonIcon {}
export declare class Wallet24 extends CarbonIcon {}
export declare class Wallet32 extends CarbonIcon {}
export declare class Warning16 extends CarbonIcon {}
export declare class Warning20 extends CarbonIcon {}
export declare class Warning24 extends CarbonIcon {}
export declare class Warning32 extends CarbonIcon {}
export declare class WarningAlt16 extends CarbonIcon {}
export declare class WarningAlt20 extends CarbonIcon {}
export declare class WarningAlt24 extends CarbonIcon {}
export declare class WarningAlt32 extends CarbonIcon {}
export declare class WarningAltFilled16 extends CarbonIcon {}
export declare class WarningAltFilled20 extends CarbonIcon {}
export declare class WarningAltFilled24 extends CarbonIcon {}
export declare class WarningAltFilled32 extends CarbonIcon {}
export declare class WarningAltInverted16 extends CarbonIcon {}
export declare class WarningAltInverted20 extends CarbonIcon {}
export declare class WarningAltInverted24 extends CarbonIcon {}
export declare class WarningAltInverted32 extends CarbonIcon {}
export declare class WarningAltInvertedFilled16 extends CarbonIcon {}
export declare class WarningAltInvertedFilled20 extends CarbonIcon {}
export declare class WarningAltInvertedFilled24 extends CarbonIcon {}
export declare class WarningAltInvertedFilled32 extends CarbonIcon {}
export declare class WarningFilled16 extends CarbonIcon {}
export declare class WarningFilled20 extends CarbonIcon {}
export declare class WarningFilled24 extends CarbonIcon {}
export declare class WarningFilled32 extends CarbonIcon {}
export declare class WarningOther16 extends CarbonIcon {}
export declare class WarningOther20 extends CarbonIcon {}
export declare class WarningOther24 extends CarbonIcon {}
export declare class WarningOther32 extends CarbonIcon {}
export declare class WarningSquare16 extends CarbonIcon {}
export declare class WarningSquare20 extends CarbonIcon {}
export declare class WarningSquare24 extends CarbonIcon {}
export declare class WarningSquare32 extends CarbonIcon {}
export declare class WarningSquareFilled16 extends CarbonIcon {}
export declare class WarningSquareFilled20 extends CarbonIcon {}
export declare class WarningSquareFilled24 extends CarbonIcon {}
export declare class WarningSquareFilled32 extends CarbonIcon {}
export declare class Watch16 extends CarbonIcon {}
export declare class Watch20 extends CarbonIcon {}
export declare class Watch24 extends CarbonIcon {}
export declare class Watch32 extends CarbonIcon {}
export declare class Watson16 extends CarbonIcon {}
export declare class Watson20 extends CarbonIcon {}
export declare class Watson24 extends CarbonIcon {}
export declare class Watson32 extends CarbonIcon {}
export declare class WatsonHealth3DCursor16 extends CarbonIcon {}
export declare class WatsonHealth3DCursor20 extends CarbonIcon {}
export declare class WatsonHealth3DCursor24 extends CarbonIcon {}
export declare class WatsonHealth3DCursor32 extends CarbonIcon {}
export declare class WatsonHealth3DCursorAlt16 extends CarbonIcon {}
export declare class WatsonHealth3DCursorAlt20 extends CarbonIcon {}
export declare class WatsonHealth3DCursorAlt24 extends CarbonIcon {}
export declare class WatsonHealth3DCursorAlt32 extends CarbonIcon {}
export declare class WatsonHealth3DCurveAutoColon16 extends CarbonIcon {}
export declare class WatsonHealth3DCurveAutoColon20 extends CarbonIcon {}
export declare class WatsonHealth3DCurveAutoColon24 extends CarbonIcon {}
export declare class WatsonHealth3DCurveAutoColon32 extends CarbonIcon {}
export declare class WatsonHealth3DCurveAutoVessels16 extends CarbonIcon {}
export declare class WatsonHealth3DCurveAutoVessels20 extends CarbonIcon {}
export declare class WatsonHealth3DCurveAutoVessels24 extends CarbonIcon {}
export declare class WatsonHealth3DCurveAutoVessels32 extends CarbonIcon {}
export declare class WatsonHealth3DCurveManual16 extends CarbonIcon {}
export declare class WatsonHealth3DCurveManual20 extends CarbonIcon {}
export declare class WatsonHealth3DCurveManual24 extends CarbonIcon {}
export declare class WatsonHealth3DCurveManual32 extends CarbonIcon {}
export declare class WatsonHealth3DICa16 extends CarbonIcon {}
export declare class WatsonHealth3DICa20 extends CarbonIcon {}
export declare class WatsonHealth3DICa24 extends CarbonIcon {}
export declare class WatsonHealth3DICa32 extends CarbonIcon {}
export declare class WatsonHealth3DMprToggle16 extends CarbonIcon {}
export declare class WatsonHealth3DMprToggle20 extends CarbonIcon {}
export declare class WatsonHealth3DMprToggle24 extends CarbonIcon {}
export declare class WatsonHealth3DMprToggle32 extends CarbonIcon {}
export declare class WatsonHealth3DPrintMesh16 extends CarbonIcon {}
export declare class WatsonHealth3DPrintMesh20 extends CarbonIcon {}
export declare class WatsonHealth3DPrintMesh24 extends CarbonIcon {}
export declare class WatsonHealth3DPrintMesh32 extends CarbonIcon {}
export declare class WatsonHealth3DSoftware16 extends CarbonIcon {}
export declare class WatsonHealth3DSoftware20 extends CarbonIcon {}
export declare class WatsonHealth3DSoftware24 extends CarbonIcon {}
export declare class WatsonHealth3DSoftware32 extends CarbonIcon {}
export declare class WatsonHealth3rdPartyConnected16 extends CarbonIcon {}
export declare class WatsonHealth3rdPartyConnected20 extends CarbonIcon {}
export declare class WatsonHealth3rdPartyConnected24 extends CarbonIcon {}
export declare class WatsonHealth3rdPartyConnected32 extends CarbonIcon {}
export declare class WatsonHealthAiResults16 extends CarbonIcon {}
export declare class WatsonHealthAiResults20 extends CarbonIcon {}
export declare class WatsonHealthAiResults24 extends CarbonIcon {}
export declare class WatsonHealthAiResults32 extends CarbonIcon {}
export declare class WatsonHealthAiResultsHigh16 extends CarbonIcon {}
export declare class WatsonHealthAiResultsHigh20 extends CarbonIcon {}
export declare class WatsonHealthAiResultsHigh24 extends CarbonIcon {}
export declare class WatsonHealthAiResultsHigh32 extends CarbonIcon {}
export declare class WatsonHealthAiResultsLow16 extends CarbonIcon {}
export declare class WatsonHealthAiResultsLow20 extends CarbonIcon {}
export declare class WatsonHealthAiResultsLow24 extends CarbonIcon {}
export declare class WatsonHealthAiResultsLow32 extends CarbonIcon {}
export declare class WatsonHealthAiResultsMedium16 extends CarbonIcon {}
export declare class WatsonHealthAiResultsMedium20 extends CarbonIcon {}
export declare class WatsonHealthAiResultsMedium24 extends CarbonIcon {}
export declare class WatsonHealthAiResultsMedium32 extends CarbonIcon {}
export declare class WatsonHealthAiResultsUrgent16 extends CarbonIcon {}
export declare class WatsonHealthAiResultsUrgent20 extends CarbonIcon {}
export declare class WatsonHealthAiResultsUrgent24 extends CarbonIcon {}
export declare class WatsonHealthAiResultsUrgent32 extends CarbonIcon {}
export declare class WatsonHealthAiResultsVeryHigh16 extends CarbonIcon {}
export declare class WatsonHealthAiResultsVeryHigh20 extends CarbonIcon {}
export declare class WatsonHealthAiResultsVeryHigh24 extends CarbonIcon {}
export declare class WatsonHealthAiResultsVeryHigh32 extends CarbonIcon {}
export declare class WatsonHealthAiStatus16 extends CarbonIcon {}
export declare class WatsonHealthAiStatus20 extends CarbonIcon {}
export declare class WatsonHealthAiStatus24 extends CarbonIcon {}
export declare class WatsonHealthAiStatus32 extends CarbonIcon {}
export declare class WatsonHealthAiStatusComplete16 extends CarbonIcon {}
export declare class WatsonHealthAiStatusComplete20 extends CarbonIcon {}
export declare class WatsonHealthAiStatusComplete24 extends CarbonIcon {}
export declare class WatsonHealthAiStatusComplete32 extends CarbonIcon {}
export declare class WatsonHealthAiStatusFailed16 extends CarbonIcon {}
export declare class WatsonHealthAiStatusFailed20 extends CarbonIcon {}
export declare class WatsonHealthAiStatusFailed24 extends CarbonIcon {}
export declare class WatsonHealthAiStatusFailed32 extends CarbonIcon {}
export declare class WatsonHealthAiStatusInProgress16 extends CarbonIcon {}
export declare class WatsonHealthAiStatusInProgress20 extends CarbonIcon {}
export declare class WatsonHealthAiStatusInProgress24 extends CarbonIcon {}
export declare class WatsonHealthAiStatusInProgress32 extends CarbonIcon {}
export declare class WatsonHealthAiStatusQueued16 extends CarbonIcon {}
export declare class WatsonHealthAiStatusQueued20 extends CarbonIcon {}
export declare class WatsonHealthAiStatusQueued24 extends CarbonIcon {}
export declare class WatsonHealthAiStatusQueued32 extends CarbonIcon {}
export declare class WatsonHealthAiStatusRejected16 extends CarbonIcon {}
export declare class WatsonHealthAiStatusRejected20 extends CarbonIcon {}
export declare class WatsonHealthAiStatusRejected24 extends CarbonIcon {}
export declare class WatsonHealthAiStatusRejected32 extends CarbonIcon {}
export declare class WatsonHealthAngle16 extends CarbonIcon {}
export declare class WatsonHealthAngle20 extends CarbonIcon {}
export declare class WatsonHealthAngle24 extends CarbonIcon {}
export declare class WatsonHealthAngle32 extends CarbonIcon {}
export declare class WatsonHealthAnnotationVisibility16 extends CarbonIcon {}
export declare class WatsonHealthAnnotationVisibility20 extends CarbonIcon {}
export declare class WatsonHealthAnnotationVisibility24 extends CarbonIcon {}
export declare class WatsonHealthAnnotationVisibility32 extends CarbonIcon {}
export declare class WatsonHealthArrowAnnotation16 extends CarbonIcon {}
export declare class WatsonHealthArrowAnnotation20 extends CarbonIcon {}
export declare class WatsonHealthArrowAnnotation24 extends CarbonIcon {}
export declare class WatsonHealthArrowAnnotation32 extends CarbonIcon {}
export declare class WatsonHealthAutoScroll16 extends CarbonIcon {}
export declare class WatsonHealthAutoScroll20 extends CarbonIcon {}
export declare class WatsonHealthAutoScroll24 extends CarbonIcon {}
export declare class WatsonHealthAutoScroll32 extends CarbonIcon {}
export declare class WatsonHealthBrushFreehand16 extends CarbonIcon {}
export declare class WatsonHealthBrushFreehand20 extends CarbonIcon {}
export declare class WatsonHealthBrushFreehand24 extends CarbonIcon {}
export declare class WatsonHealthBrushFreehand32 extends CarbonIcon {}
export declare class WatsonHealthBrushPolygon16 extends CarbonIcon {}
export declare class WatsonHealthBrushPolygon20 extends CarbonIcon {}
export declare class WatsonHealthBrushPolygon24 extends CarbonIcon {}
export declare class WatsonHealthBrushPolygon32 extends CarbonIcon {}
export declare class WatsonHealthCdArchive16 extends CarbonIcon {}
export declare class WatsonHealthCdArchive20 extends CarbonIcon {}
export declare class WatsonHealthCdArchive24 extends CarbonIcon {}
export declare class WatsonHealthCdArchive32 extends CarbonIcon {}
export declare class WatsonHealthCdCreateArchive16 extends CarbonIcon {}
export declare class WatsonHealthCdCreateArchive20 extends CarbonIcon {}
export declare class WatsonHealthCdCreateArchive24 extends CarbonIcon {}
export declare class WatsonHealthCdCreateArchive32 extends CarbonIcon {}
export declare class WatsonHealthCdCreateExchange16 extends CarbonIcon {}
export declare class WatsonHealthCdCreateExchange20 extends CarbonIcon {}
export declare class WatsonHealthCdCreateExchange24 extends CarbonIcon {}
export declare class WatsonHealthCdCreateExchange32 extends CarbonIcon {}
export declare class WatsonHealthCircleMeasurement16 extends CarbonIcon {}
export declare class WatsonHealthCircleMeasurement20 extends CarbonIcon {}
export declare class WatsonHealthCircleMeasurement24 extends CarbonIcon {}
export declare class WatsonHealthCircleMeasurement32 extends CarbonIcon {}
export declare class WatsonHealthCobbAngle16 extends CarbonIcon {}
export declare class WatsonHealthCobbAngle20 extends CarbonIcon {}
export declare class WatsonHealthCobbAngle24 extends CarbonIcon {}
export declare class WatsonHealthCobbAngle32 extends CarbonIcon {}
export declare class WatsonHealthContourFinding16 extends CarbonIcon {}
export declare class WatsonHealthContourFinding20 extends CarbonIcon {}
export declare class WatsonHealthContourFinding24 extends CarbonIcon {}
export declare class WatsonHealthContourFinding32 extends CarbonIcon {}
export declare class WatsonHealthCrossReference16 extends CarbonIcon {}
export declare class WatsonHealthCrossReference20 extends CarbonIcon {}
export declare class WatsonHealthCrossReference24 extends CarbonIcon {}
export declare class WatsonHealthCrossReference32 extends CarbonIcon {}
export declare class WatsonHealthCutInHalf16 extends CarbonIcon {}
export declare class WatsonHealthCutInHalf20 extends CarbonIcon {}
export declare class WatsonHealthCutInHalf24 extends CarbonIcon {}
export declare class WatsonHealthCutInHalf32 extends CarbonIcon {}
export declare class WatsonHealthDenominate16 extends CarbonIcon {}
export declare class WatsonHealthDenominate20 extends CarbonIcon {}
export declare class WatsonHealthDenominate24 extends CarbonIcon {}
export declare class WatsonHealthDenominate32 extends CarbonIcon {}
export declare class WatsonHealthDicomOverlay16 extends CarbonIcon {}
export declare class WatsonHealthDicomOverlay20 extends CarbonIcon {}
export declare class WatsonHealthDicomOverlay24 extends CarbonIcon {}
export declare class WatsonHealthDicomOverlay32 extends CarbonIcon {}
export declare class WatsonHealthDicom_600016 extends CarbonIcon {}
export declare class WatsonHealthDicom_600020 extends CarbonIcon {}
export declare class WatsonHealthDicom_600024 extends CarbonIcon {}
export declare class WatsonHealthDicom_600032 extends CarbonIcon {}
export declare class WatsonHealthDna16 extends CarbonIcon {}
export declare class WatsonHealthDna20 extends CarbonIcon {}
export declare class WatsonHealthDna24 extends CarbonIcon {}
export declare class WatsonHealthDna32 extends CarbonIcon {}
export declare class WatsonHealthDownloadStudy16 extends CarbonIcon {}
export declare class WatsonHealthDownloadStudy20 extends CarbonIcon {}
export declare class WatsonHealthDownloadStudy24 extends CarbonIcon {}
export declare class WatsonHealthDownloadStudy32 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement16 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement20 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement24 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement32 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement_0116 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement_0120 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement_0124 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement_0132 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement_0216 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement_0220 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement_0224 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement_0232 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement_0316 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement_0320 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement_0324 extends CarbonIcon {}
export declare class WatsonHealthEdgeEnhancement_0332 extends CarbonIcon {}
export declare class WatsonHealthEditFilter16 extends CarbonIcon {}
export declare class WatsonHealthEditFilter20 extends CarbonIcon {}
export declare class WatsonHealthEditFilter24 extends CarbonIcon {}
export declare class WatsonHealthEditFilter32 extends CarbonIcon {}
export declare class WatsonHealthErase_3D16 extends CarbonIcon {}
export declare class WatsonHealthErase_3D20 extends CarbonIcon {}
export declare class WatsonHealthErase_3D24 extends CarbonIcon {}
export declare class WatsonHealthErase_3D32 extends CarbonIcon {}
export declare class WatsonHealthFusionBlender16 extends CarbonIcon {}
export declare class WatsonHealthFusionBlender20 extends CarbonIcon {}
export declare class WatsonHealthFusionBlender24 extends CarbonIcon {}
export declare class WatsonHealthFusionBlender32 extends CarbonIcon {}
export declare class WatsonHealthHangingProtocol16 extends CarbonIcon {}
export declare class WatsonHealthHangingProtocol20 extends CarbonIcon {}
export declare class WatsonHealthHangingProtocol24 extends CarbonIcon {}
export declare class WatsonHealthHangingProtocol32 extends CarbonIcon {}
export declare class WatsonHealthHoleFilling16 extends CarbonIcon {}
export declare class WatsonHealthHoleFilling20 extends CarbonIcon {}
export declare class WatsonHealthHoleFilling24 extends CarbonIcon {}
export declare class WatsonHealthHoleFilling32 extends CarbonIcon {}
export declare class WatsonHealthHoleFillingCursor16 extends CarbonIcon {}
export declare class WatsonHealthHoleFillingCursor20 extends CarbonIcon {}
export declare class WatsonHealthHoleFillingCursor24 extends CarbonIcon {}
export declare class WatsonHealthHoleFillingCursor32 extends CarbonIcon {}
export declare class WatsonHealthICa_2D16 extends CarbonIcon {}
export declare class WatsonHealthICa_2D20 extends CarbonIcon {}
export declare class WatsonHealthICa_2D24 extends CarbonIcon {}
export declare class WatsonHealthICa_2D32 extends CarbonIcon {}
export declare class WatsonHealthInteractiveSegmentationCursor16 extends CarbonIcon {}
export declare class WatsonHealthInteractiveSegmentationCursor20 extends CarbonIcon {}
export declare class WatsonHealthInteractiveSegmentationCursor24 extends CarbonIcon {}
export declare class WatsonHealthInteractiveSegmentationCursor32 extends CarbonIcon {}
export declare class WatsonHealthLaunchStudy_116 extends CarbonIcon {}
export declare class WatsonHealthLaunchStudy_120 extends CarbonIcon {}
export declare class WatsonHealthLaunchStudy_124 extends CarbonIcon {}
export declare class WatsonHealthLaunchStudy_132 extends CarbonIcon {}
export declare class WatsonHealthLaunchStudy_216 extends CarbonIcon {}
export declare class WatsonHealthLaunchStudy_220 extends CarbonIcon {}
export declare class WatsonHealthLaunchStudy_224 extends CarbonIcon {}
export declare class WatsonHealthLaunchStudy_232 extends CarbonIcon {}
export declare class WatsonHealthLaunchStudy_316 extends CarbonIcon {}
export declare class WatsonHealthLaunchStudy_320 extends CarbonIcon {}
export declare class WatsonHealthLaunchStudy_324 extends CarbonIcon {}
export declare class WatsonHealthLaunchStudy_332 extends CarbonIcon {}
export declare class WatsonHealthMagnify16 extends CarbonIcon {}
export declare class WatsonHealthMagnify20 extends CarbonIcon {}
export declare class WatsonHealthMagnify24 extends CarbonIcon {}
export declare class WatsonHealthMagnify32 extends CarbonIcon {}
export declare class WatsonHealthMammogram16 extends CarbonIcon {}
export declare class WatsonHealthMammogram20 extends CarbonIcon {}
export declare class WatsonHealthMammogram24 extends CarbonIcon {}
export declare class WatsonHealthMammogram32 extends CarbonIcon {}
export declare class WatsonHealthNominate16 extends CarbonIcon {}
export declare class WatsonHealthNominate20 extends CarbonIcon {}
export declare class WatsonHealthNominate24 extends CarbonIcon {}
export declare class WatsonHealthNominate32 extends CarbonIcon {}
export declare class WatsonHealthPageScroll16 extends CarbonIcon {}
export declare class WatsonHealthPageScroll20 extends CarbonIcon {}
export declare class WatsonHealthPageScroll24 extends CarbonIcon {}
export declare class WatsonHealthPageScroll32 extends CarbonIcon {}
export declare class WatsonHealthPetImageB16 extends CarbonIcon {}
export declare class WatsonHealthPetImageB20 extends CarbonIcon {}
export declare class WatsonHealthPetImageB24 extends CarbonIcon {}
export declare class WatsonHealthPetImageB32 extends CarbonIcon {}
export declare class WatsonHealthPetImageO16 extends CarbonIcon {}
export declare class WatsonHealthPetImageO20 extends CarbonIcon {}
export declare class WatsonHealthPetImageO24 extends CarbonIcon {}
export declare class WatsonHealthPetImageO32 extends CarbonIcon {}
export declare class WatsonHealthPointerText16 extends CarbonIcon {}
export declare class WatsonHealthPointerText20 extends CarbonIcon {}
export declare class WatsonHealthPointerText24 extends CarbonIcon {}
export declare class WatsonHealthPointerText32 extends CarbonIcon {}
export declare class WatsonHealthRegionAnalysisArea16 extends CarbonIcon {}
export declare class WatsonHealthRegionAnalysisArea20 extends CarbonIcon {}
export declare class WatsonHealthRegionAnalysisArea24 extends CarbonIcon {}
export declare class WatsonHealthRegionAnalysisArea32 extends CarbonIcon {}
export declare class WatsonHealthRegionAnalysisVolume16 extends CarbonIcon {}
export declare class WatsonHealthRegionAnalysisVolume20 extends CarbonIcon {}
export declare class WatsonHealthRegionAnalysisVolume24 extends CarbonIcon {}
export declare class WatsonHealthRegionAnalysisVolume32 extends CarbonIcon {}
export declare class WatsonHealthRegistration16 extends CarbonIcon {}
export declare class WatsonHealthRegistration20 extends CarbonIcon {}
export declare class WatsonHealthRegistration24 extends CarbonIcon {}
export declare class WatsonHealthRegistration32 extends CarbonIcon {}
export declare class WatsonHealthRotate_18016 extends CarbonIcon {}
export declare class WatsonHealthRotate_18020 extends CarbonIcon {}
export declare class WatsonHealthRotate_18024 extends CarbonIcon {}
export declare class WatsonHealthRotate_18032 extends CarbonIcon {}
export declare class WatsonHealthRotate_36016 extends CarbonIcon {}
export declare class WatsonHealthRotate_36020 extends CarbonIcon {}
export declare class WatsonHealthRotate_36024 extends CarbonIcon {}
export declare class WatsonHealthRotate_36032 extends CarbonIcon {}
export declare class WatsonHealthSaveAnnotation16 extends CarbonIcon {}
export declare class WatsonHealthSaveAnnotation20 extends CarbonIcon {}
export declare class WatsonHealthSaveAnnotation24 extends CarbonIcon {}
export declare class WatsonHealthSaveAnnotation32 extends CarbonIcon {}
export declare class WatsonHealthSaveImage16 extends CarbonIcon {}
export declare class WatsonHealthSaveImage20 extends CarbonIcon {}
export declare class WatsonHealthSaveImage24 extends CarbonIcon {}
export declare class WatsonHealthSaveImage32 extends CarbonIcon {}
export declare class WatsonHealthSaveSeries16 extends CarbonIcon {}
export declare class WatsonHealthSaveSeries20 extends CarbonIcon {}
export declare class WatsonHealthSaveSeries24 extends CarbonIcon {}
export declare class WatsonHealthSaveSeries32 extends CarbonIcon {}
export declare class WatsonHealthScalpelCursor16 extends CarbonIcon {}
export declare class WatsonHealthScalpelCursor20 extends CarbonIcon {}
export declare class WatsonHealthScalpelCursor24 extends CarbonIcon {}
export declare class WatsonHealthScalpelCursor32 extends CarbonIcon {}
export declare class WatsonHealthScalpelLasso16 extends CarbonIcon {}
export declare class WatsonHealthScalpelLasso20 extends CarbonIcon {}
export declare class WatsonHealthScalpelLasso24 extends CarbonIcon {}
export declare class WatsonHealthScalpelLasso32 extends CarbonIcon {}
export declare class WatsonHealthScalpelSelect16 extends CarbonIcon {}
export declare class WatsonHealthScalpelSelect20 extends CarbonIcon {}
export declare class WatsonHealthScalpelSelect24 extends CarbonIcon {}
export declare class WatsonHealthScalpelSelect32 extends CarbonIcon {}
export declare class WatsonHealthSmoothing16 extends CarbonIcon {}
export declare class WatsonHealthSmoothing20 extends CarbonIcon {}
export declare class WatsonHealthSmoothing24 extends CarbonIcon {}
export declare class WatsonHealthSmoothing32 extends CarbonIcon {}
export declare class WatsonHealthSmoothingCursor16 extends CarbonIcon {}
export declare class WatsonHealthSmoothingCursor20 extends CarbonIcon {}
export declare class WatsonHealthSmoothingCursor24 extends CarbonIcon {}
export declare class WatsonHealthSmoothingCursor32 extends CarbonIcon {}
export declare class WatsonHealthSpineLabel16 extends CarbonIcon {}
export declare class WatsonHealthSpineLabel20 extends CarbonIcon {}
export declare class WatsonHealthSpineLabel24 extends CarbonIcon {}
export declare class WatsonHealthSpineLabel32 extends CarbonIcon {}
export declare class WatsonHealthSplitDiscard16 extends CarbonIcon {}
export declare class WatsonHealthSplitDiscard20 extends CarbonIcon {}
export declare class WatsonHealthSplitDiscard24 extends CarbonIcon {}
export declare class WatsonHealthSplitDiscard32 extends CarbonIcon {}
export declare class WatsonHealthStackedMove16 extends CarbonIcon {}
export declare class WatsonHealthStackedMove20 extends CarbonIcon {}
export declare class WatsonHealthStackedMove24 extends CarbonIcon {}
export declare class WatsonHealthStackedMove32 extends CarbonIcon {}
export declare class WatsonHealthStackedScrolling_116 extends CarbonIcon {}
export declare class WatsonHealthStackedScrolling_120 extends CarbonIcon {}
export declare class WatsonHealthStackedScrolling_124 extends CarbonIcon {}
export declare class WatsonHealthStackedScrolling_132 extends CarbonIcon {}
export declare class WatsonHealthStackedScrolling_216 extends CarbonIcon {}
export declare class WatsonHealthStackedScrolling_220 extends CarbonIcon {}
export declare class WatsonHealthStackedScrolling_224 extends CarbonIcon {}
export declare class WatsonHealthStackedScrolling_232 extends CarbonIcon {}
export declare class WatsonHealthStressBreathEditor16 extends CarbonIcon {}
export declare class WatsonHealthStressBreathEditor20 extends CarbonIcon {}
export declare class WatsonHealthStressBreathEditor24 extends CarbonIcon {}
export declare class WatsonHealthStressBreathEditor32 extends CarbonIcon {}
export declare class WatsonHealthStudyNext16 extends CarbonIcon {}
export declare class WatsonHealthStudyNext20 extends CarbonIcon {}
export declare class WatsonHealthStudyNext24 extends CarbonIcon {}
export declare class WatsonHealthStudyNext32 extends CarbonIcon {}
export declare class WatsonHealthStudyPrevious16 extends CarbonIcon {}
export declare class WatsonHealthStudyPrevious20 extends CarbonIcon {}
export declare class WatsonHealthStudyPrevious24 extends CarbonIcon {}
export declare class WatsonHealthStudyPrevious32 extends CarbonIcon {}
export declare class WatsonHealthStudySkip16 extends CarbonIcon {}
export declare class WatsonHealthStudySkip20 extends CarbonIcon {}
export declare class WatsonHealthStudySkip24 extends CarbonIcon {}
export declare class WatsonHealthStudySkip32 extends CarbonIcon {}
export declare class WatsonHealthSubVolume16 extends CarbonIcon {}
export declare class WatsonHealthSubVolume20 extends CarbonIcon {}
export declare class WatsonHealthSubVolume24 extends CarbonIcon {}
export declare class WatsonHealthSubVolume32 extends CarbonIcon {}
export declare class WatsonHealthTextAnnotationToggle16 extends CarbonIcon {}
export declare class WatsonHealthTextAnnotationToggle20 extends CarbonIcon {}
export declare class WatsonHealthTextAnnotationToggle24 extends CarbonIcon {}
export declare class WatsonHealthTextAnnotationToggle32 extends CarbonIcon {}
export declare class WatsonHealthThreshold16 extends CarbonIcon {}
export declare class WatsonHealthThreshold20 extends CarbonIcon {}
export declare class WatsonHealthThreshold24 extends CarbonIcon {}
export declare class WatsonHealthThreshold32 extends CarbonIcon {}
export declare class WatsonHealthThumbnailPreview16 extends CarbonIcon {}
export declare class WatsonHealthThumbnailPreview20 extends CarbonIcon {}
export declare class WatsonHealthThumbnailPreview24 extends CarbonIcon {}
export declare class WatsonHealthThumbnailPreview32 extends CarbonIcon {}
export declare class WatsonHealthWindowAuto16 extends CarbonIcon {}
export declare class WatsonHealthWindowAuto20 extends CarbonIcon {}
export declare class WatsonHealthWindowAuto24 extends CarbonIcon {}
export declare class WatsonHealthWindowAuto32 extends CarbonIcon {}
export declare class WatsonHealthWindowBase16 extends CarbonIcon {}
export declare class WatsonHealthWindowBase20 extends CarbonIcon {}
export declare class WatsonHealthWindowBase24 extends CarbonIcon {}
export declare class WatsonHealthWindowBase32 extends CarbonIcon {}
export declare class WatsonHealthWindowOverlay16 extends CarbonIcon {}
export declare class WatsonHealthWindowOverlay20 extends CarbonIcon {}
export declare class WatsonHealthWindowOverlay24 extends CarbonIcon {}
export declare class WatsonHealthWindowOverlay32 extends CarbonIcon {}
export declare class WatsonHealthWindowPreset16 extends CarbonIcon {}
export declare class WatsonHealthWindowPreset20 extends CarbonIcon {}
export declare class WatsonHealthWindowPreset24 extends CarbonIcon {}
export declare class WatsonHealthWindowPreset32 extends CarbonIcon {}
export declare class WatsonHealthZoomPan16 extends CarbonIcon {}
export declare class WatsonHealthZoomPan20 extends CarbonIcon {}
export declare class WatsonHealthZoomPan24 extends CarbonIcon {}
export declare class WatsonHealthZoomPan32 extends CarbonIcon {}
export declare class WatsonMachineLearning16 extends CarbonIcon {}
export declare class WatsonMachineLearning20 extends CarbonIcon {}
export declare class WatsonMachineLearning24 extends CarbonIcon {}
export declare class WatsonMachineLearning32 extends CarbonIcon {}
export declare class WaveDirection16 extends CarbonIcon {}
export declare class WaveDirection20 extends CarbonIcon {}
export declare class WaveDirection24 extends CarbonIcon {}
export declare class WaveDirection32 extends CarbonIcon {}
export declare class WaveHeight16 extends CarbonIcon {}
export declare class WaveHeight20 extends CarbonIcon {}
export declare class WaveHeight24 extends CarbonIcon {}
export declare class WaveHeight32 extends CarbonIcon {}
export declare class WavePeriod16 extends CarbonIcon {}
export declare class WavePeriod20 extends CarbonIcon {}
export declare class WavePeriod24 extends CarbonIcon {}
export declare class WavePeriod32 extends CarbonIcon {}
export declare class WeatherFrontCold16 extends CarbonIcon {}
export declare class WeatherFrontCold20 extends CarbonIcon {}
export declare class WeatherFrontCold24 extends CarbonIcon {}
export declare class WeatherFrontCold32 extends CarbonIcon {}
export declare class WeatherFrontStationary16 extends CarbonIcon {}
export declare class WeatherFrontStationary20 extends CarbonIcon {}
export declare class WeatherFrontStationary24 extends CarbonIcon {}
export declare class WeatherFrontStationary32 extends CarbonIcon {}
export declare class WeatherFrontWarm16 extends CarbonIcon {}
export declare class WeatherFrontWarm20 extends CarbonIcon {}
export declare class WeatherFrontWarm24 extends CarbonIcon {}
export declare class WeatherFrontWarm32 extends CarbonIcon {}
export declare class WeatherStation16 extends CarbonIcon {}
export declare class WeatherStation20 extends CarbonIcon {}
export declare class WeatherStation24 extends CarbonIcon {}
export declare class WeatherStation32 extends CarbonIcon {}
export declare class Websheet16 extends CarbonIcon {}
export declare class Websheet20 extends CarbonIcon {}
export declare class Websheet24 extends CarbonIcon {}
export declare class Websheet32 extends CarbonIcon {}
export declare class Wheat16 extends CarbonIcon {}
export declare class Wheat20 extends CarbonIcon {}
export declare class Wheat24 extends CarbonIcon {}
export declare class Wheat32 extends CarbonIcon {}
export declare class Wifi16 extends CarbonIcon {}
export declare class Wifi20 extends CarbonIcon {}
export declare class Wifi24 extends CarbonIcon {}
export declare class Wifi32 extends CarbonIcon {}
export declare class WifiOff16 extends CarbonIcon {}
export declare class WifiOff20 extends CarbonIcon {}
export declare class WifiOff24 extends CarbonIcon {}
export declare class WifiOff32 extends CarbonIcon {}
export declare class Wikis16 extends CarbonIcon {}
export declare class Wikis20 extends CarbonIcon {}
export declare class Wikis24 extends CarbonIcon {}
export declare class Wikis32 extends CarbonIcon {}
export declare class WindGusts16 extends CarbonIcon {}
export declare class WindGusts20 extends CarbonIcon {}
export declare class WindGusts24 extends CarbonIcon {}
export declare class WindGusts32 extends CarbonIcon {}
export declare class WindStream16 extends CarbonIcon {}
export declare class WindStream20 extends CarbonIcon {}
export declare class WindStream24 extends CarbonIcon {}
export declare class WindStream32 extends CarbonIcon {}
export declare class Windy16 extends CarbonIcon {}
export declare class Windy20 extends CarbonIcon {}
export declare class Windy24 extends CarbonIcon {}
export declare class Windy32 extends CarbonIcon {}
export declare class WindyDust16 extends CarbonIcon {}
export declare class WindyDust20 extends CarbonIcon {}
export declare class WindyDust24 extends CarbonIcon {}
export declare class WindyDust32 extends CarbonIcon {}
export declare class WindySnow16 extends CarbonIcon {}
export declare class WindySnow20 extends CarbonIcon {}
export declare class WindySnow24 extends CarbonIcon {}
export declare class WindySnow32 extends CarbonIcon {}
export declare class WindyStrong16 extends CarbonIcon {}
export declare class WindyStrong20 extends CarbonIcon {}
export declare class WindyStrong24 extends CarbonIcon {}
export declare class WindyStrong32 extends CarbonIcon {}
export declare class WinterWarning16 extends CarbonIcon {}
export declare class WinterWarning20 extends CarbonIcon {}
export declare class WinterWarning24 extends CarbonIcon {}
export declare class WinterWarning32 extends CarbonIcon {}
export declare class WintryMix16 extends CarbonIcon {}
export declare class WintryMix20 extends CarbonIcon {}
export declare class WintryMix24 extends CarbonIcon {}
export declare class WintryMix32 extends CarbonIcon {}
export declare class WirelessCheckout16 extends CarbonIcon {}
export declare class WirelessCheckout20 extends CarbonIcon {}
export declare class WirelessCheckout24 extends CarbonIcon {}
export declare class WirelessCheckout32 extends CarbonIcon {}
export declare class Wmv16 extends CarbonIcon {}
export declare class Wmv20 extends CarbonIcon {}
export declare class Wmv24 extends CarbonIcon {}
export declare class Wmv32 extends CarbonIcon {}
export declare class WordCloud16 extends CarbonIcon {}
export declare class WordCloud20 extends CarbonIcon {}
export declare class WordCloud24 extends CarbonIcon {}
export declare class WordCloud32 extends CarbonIcon {}
export declare class Workspace16 extends CarbonIcon {}
export declare class Workspace20 extends CarbonIcon {}
export declare class Workspace24 extends CarbonIcon {}
export declare class Workspace32 extends CarbonIcon {}
export declare class WorkspaceImport16 extends CarbonIcon {}
export declare class WorkspaceImport20 extends CarbonIcon {}
export declare class WorkspaceImport24 extends CarbonIcon {}
export declare class WorkspaceImport32 extends CarbonIcon {}
export declare class Worship16 extends CarbonIcon {}
export declare class Worship20 extends CarbonIcon {}
export declare class Worship24 extends CarbonIcon {}
export declare class Worship32 extends CarbonIcon {}
export declare class WorshipChristian16 extends CarbonIcon {}
export declare class WorshipChristian20 extends CarbonIcon {}
export declare class WorshipChristian24 extends CarbonIcon {}
export declare class WorshipChristian32 extends CarbonIcon {}
export declare class WorshipJewish16 extends CarbonIcon {}
export declare class WorshipJewish20 extends CarbonIcon {}
export declare class WorshipJewish24 extends CarbonIcon {}
export declare class WorshipJewish32 extends CarbonIcon {}
export declare class WorshipMuslim16 extends CarbonIcon {}
export declare class WorshipMuslim20 extends CarbonIcon {}
export declare class WorshipMuslim24 extends CarbonIcon {}
export declare class WorshipMuslim32 extends CarbonIcon {}
export declare class XAxis16 extends CarbonIcon {}
export declare class XAxis20 extends CarbonIcon {}
export declare class XAxis24 extends CarbonIcon {}
export declare class XAxis32 extends CarbonIcon {}
export declare class Xls16 extends CarbonIcon {}
export declare class Xls20 extends CarbonIcon {}
export declare class Xls24 extends CarbonIcon {}
export declare class Xls32 extends CarbonIcon {}
export declare class Xml16 extends CarbonIcon {}
export declare class Xml20 extends CarbonIcon {}
export declare class Xml24 extends CarbonIcon {}
export declare class Xml32 extends CarbonIcon {}
export declare class YAxis16 extends CarbonIcon {}
export declare class YAxis20 extends CarbonIcon {}
export declare class YAxis24 extends CarbonIcon {}
export declare class YAxis32 extends CarbonIcon {}
export declare class ZAxis16 extends CarbonIcon {}
export declare class ZAxis20 extends CarbonIcon {}
export declare class ZAxis24 extends CarbonIcon {}
export declare class ZAxis32 extends CarbonIcon {}
export declare class Zip16 extends CarbonIcon {}
export declare class Zip20 extends CarbonIcon {}
export declare class Zip24 extends CarbonIcon {}
export declare class Zip32 extends CarbonIcon {}
export declare class ZipReference16 extends CarbonIcon {}
export declare class ZipReference20 extends CarbonIcon {}
export declare class ZipReference24 extends CarbonIcon {}
export declare class ZipReference32 extends CarbonIcon {}
export declare class ZoomIn16 extends CarbonIcon {}
export declare class ZoomIn20 extends CarbonIcon {}
export declare class ZoomIn24 extends CarbonIcon {}
export declare class ZoomIn32 extends CarbonIcon {}
export declare class ZoomOut16 extends CarbonIcon {}
export declare class ZoomOut20 extends CarbonIcon {}
export declare class ZoomOut24 extends CarbonIcon {}
export declare class ZoomOut32 extends CarbonIcon {}
export declare class ZoomReset16 extends CarbonIcon {}
export declare class ZoomReset20 extends CarbonIcon {}
export declare class ZoomReset24 extends CarbonIcon {}
export declare class ZoomReset32 extends CarbonIcon {}
export declare class _4K16 extends CarbonIcon {}
export declare class _4K20 extends CarbonIcon {}
export declare class _4K24 extends CarbonIcon {}
export declare class _4K32 extends CarbonIcon {}
export declare class _4KFilled16 extends CarbonIcon {}
export declare class _4KFilled20 extends CarbonIcon {}
export declare class _4KFilled24 extends CarbonIcon {}
export declare class _4KFilled32 extends CarbonIcon {}
