import os
from arcnagios import arcutils, jobutils
from arcnagios.nagutils import ServiceOK, ServiceWARNING

class Check_arcce_clean(jobutils.JobNagiosPlugin):

    def __init__(self):
	jobutils.JobNagiosPlugin.__init__(self)
	ap = self.argparser.add_argument_group('Job Cleaner Options')
	ap.add_argument('--timeout', dest = 'timeout',
		type = int, default = 20, help = 'Timeout')
	ap.add_argument('--max-age', dest = 'max_age',
		type = int, default = 604800,
		help = 'Max age before jobs info is cleaned.')
	ap.add_argument('--use-jobs-xml',
		default = False, action = 'store_true',
		help = 'DEPRECATED. Load jobs.xml directly instead of '
                       'asking arcstat.')

    def check(self):
	if not os.path.exists(self.top_workdir):
	    self.log.info('The work directory is %s.'%self.top_workdir)
	    return ServiceOK('No jobs to clean since the working directory '
			     'has not yet been created.')
	self.require_voms_proxy()
	total_count, pruned_count, failed_count = \
	    arcutils.arcprune(max_age = self.opts.max_age,
			      use_jobs_xml = self.opts.use_jobs_xml,
			      timeout = self.opts.timeout, log = self.log)
	if failed_count > 0:
	    return ServiceWARNING('Cleaned %d and failed to clean %d of %d jobs'
		    %(pruned_count, failed_count, total_count))
	else:
	    return ServiceOK('Cleaned %d of %d jobs'%(pruned_count,total_count))
