/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db.adapter;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;

public abstract class DB {
    public static final int LIMIT_STYLE_NONE = 0;
    public static final int LIMIT_STYLE_POSTGRES = 1;
    public static final int LIMIT_STYLE_MYSQL = 2;
    public static final int LIMIT_STYLE_SYBASE = 3;
    protected String DB_USER;
    protected String DB_PASS;
    protected String DB_CONNECTION;
    private String JDBCDriver = null;

    public Connection getConnection() throws SQLException {
        try {
            return DriverManager.getConnection(this.DB_CONNECTION, this.DB_USER, this.DB_PASS);
        }
        catch (ClassCircularityError e) {
            return DriverManager.getConnection(this.DB_CONNECTION, this.DB_USER, this.DB_PASS);
        }
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() throws SQLException {
        throw new SQLException("ConnectionPoolDataSource objects not supported by JDBC driver");
    }

    public void init(String url, String username, String password) throws Exception {
        this.DB_USER = username;
        this.DB_PASS = password;
        this.DB_CONNECTION = url;
        if (this.JDBCDriver == null) {
            throw new Exception("The JDBC driver must be set for the DB object with a URL of " + url);
        }
        Class.forName(this.JDBCDriver).newInstance();
    }

    public abstract String toUpperCase(String var1);

    public abstract char getStringDelimiter();

    public abstract String getIdSqlForAutoIncrement(Object var1);

    public abstract String getSequenceSql(Object var1);

    public abstract void lockTable(Connection var1, String var2) throws SQLException;

    public abstract void unlockTable(Connection var1, String var2) throws SQLException;

    public abstract String ignoreCase(String var1);

    public String ignoreCaseInOrderBy(String in) {
        return this.ignoreCase(in);
    }

    public void setJDBCDriver(String newDriver) {
        this.JDBCDriver = newDriver;
    }

    public String getJDBCDriver() {
        return this.JDBCDriver;
    }

    public boolean objectDataNeedsTrans() {
        return false;
    }

    public boolean supportsNativeLimit() {
        return false;
    }

    public boolean supportsNativeOffset() {
        return false;
    }

    public boolean escapeText() {
        return true;
    }

    public int getLimitStyle() {
        return 0;
    }

    protected DB() {
    }
}

