# Teaching Module on Motion Planning

We aim to transform how college students learn robotics by offering a motion planning curriculum that enhances deep learning and is supported by OMPL.app, an integrated software environment. Students will be challenged to work on real-world robotics problems, and develop deeper knowledge by reflecting on and formally evaluating their results. Our intention is to scaffold learning by freeing students of tedious details and heavy programming and help them through a hands-on problem-based learning approach to develop critical thinking within robotics and outside robotics.

As part of this effort, we have developed a collection of assignments that can be used in robotics classes that include a module on sampling-based planners. The assignments vary in difficulty and can be tailored to the needs of a class. They have been tested at the “Robotics Algorithms” class offered at Rice University. The current set of assignments includes:

1. An introductory assignment to simply run the OMPL.app software as-is. Students are asked to load different environments in the GUI, select different planners and different parameter settings, and start to develop some intuition for the difficulty of motion planning. Students are also asked to look at demo programs, so that they get an idea on how to solve motion planning problems programmatically.
2. A systematic comparison of motion planners. Students need to write a benchmarking program, collect performance metrics. They will learn the importance of randomness and the sensitivity to a specific motion planning problem.
3. Development of a new motion planning algorithm for dynamical systems. The students are asked to test their planner on a pendulum system and a simple car-like vehicle system and compare the performance against two planning algorithms that are already implemented in OMPL.
4. A final project on topics such as:

  - Path clustering
  - Path optimization (see [gallery](gallery.html#gallery_comp450))
  - Dynamic manipulation
  - Centralized multi-robot planning
  - Protein folding

We are looking for educational partners to use and further develop the material. If you are interested in the educational material, please contact [Mark Moll](http://www.cs.rice.edu/~mmoll) and [Lydia Kavraki](http://www.cs.rice.edu/~kavraki).


\htmlonly
<img src="../images/comp450-Fall2010.jpg" width="100%">
<p class="centeralign">
<b>Students from Rice University's COMP450 Algorithmic Robotics class, Fall 2010.</b>
</p>
\endhtmlonly
