/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_BIOSSTRING_H_
#define OPENDRIM_BIOSSTRING_H_

#include <Instance.h>

const static char* OpenDRIM_BIOSString_classnames[] = {"OpenDRIM_BIOSString"};
static string OpenDRIM_BIOSString_NAMESPACE = _NAMESPACE;

class OpenDRIM_BIOSString {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string AttributeName;
	bool AttributeName_isNULL;
	
	vector<string> CurrentValue;
	bool CurrentValue_isNULL;
	
	vector<string> DefaultValue;
	bool DefaultValue_isNULL;
	
	vector<string> PendingValue;
	bool PendingValue_isNULL;
	
	bool IsOrderedList;
	bool IsOrderedList_isNULL;
	
	bool IsReadOnly;
	bool IsReadOnly_isNULL;
	
	unsigned int StringType;
	bool StringType_isNULL;
	
	unsigned long long MinLength;
	bool MinLength_isNULL;
	
	unsigned long long MaxLength;
	bool MaxLength_isNULL;
	
	string ValueExpression;
	bool ValueExpression_isNULL;
	
	OpenDRIM_BIOSString() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstanceID_isNULL = true;
		AttributeName_isNULL = true;
		CurrentValue_isNULL = true;
		DefaultValue_isNULL = true;
		PendingValue_isNULL = true;
		IsOrderedList_isNULL = true;
		IsReadOnly_isNULL = true;
		StringType_isNULL = true;
		MinLength_isNULL = true;
		MaxLength_isNULL = true;
		ValueExpression_isNULL = true;
	}
	
	~OpenDRIM_BIOSString() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getAttributeName(string& value) const {
		if (AttributeName_isNULL==true)
			return NOT_FOUND;
		value = AttributeName;
		return OK;
	}
	
	int setAttributeName(const string& newValue) {
		AttributeName = newValue;
		AttributeName_isNULL = false;
		return OK;
	}

	int getCurrentValue(vector<string>& value) const {
		if (CurrentValue_isNULL==true)
			return NOT_FOUND;
		value = CurrentValue;
		return OK;
	}
	
	int setCurrentValue(const vector<string>& newValue) {
		CurrentValue = newValue;
		CurrentValue_isNULL = false;
		return OK;
	}

	int getDefaultValue(vector<string>& value) const {
		if (DefaultValue_isNULL==true)
			return NOT_FOUND;
		value = DefaultValue;
		return OK;
	}
	
	int setDefaultValue(const vector<string>& newValue) {
		DefaultValue = newValue;
		DefaultValue_isNULL = false;
		return OK;
	}

	int getPendingValue(vector<string>& value) const {
		if (PendingValue_isNULL==true)
			return NOT_FOUND;
		value = PendingValue;
		return OK;
	}
	
	int setPendingValue(const vector<string>& newValue) {
		PendingValue = newValue;
		PendingValue_isNULL = false;
		return OK;
	}

	int getIsOrderedList(bool& value) const {
		if (IsOrderedList_isNULL==true)
			return NOT_FOUND;
		value = IsOrderedList;
		return OK;
	}
	
	int setIsOrderedList(const bool& newValue) {
		IsOrderedList = newValue;
		IsOrderedList_isNULL = false;
		return OK;
	}

	int getIsReadOnly(bool& value) const {
		if (IsReadOnly_isNULL==true)
			return NOT_FOUND;
		value = IsReadOnly;
		return OK;
	}
	
	int setIsReadOnly(const bool& newValue) {
		IsReadOnly = newValue;
		IsReadOnly_isNULL = false;
		return OK;
	}

	int getStringType(unsigned int& value) const {
		if (StringType_isNULL==true)
			return NOT_FOUND;
		value = StringType;
		return OK;
	}
	
	int setStringType(const unsigned int& newValue) {
		StringType = newValue;
		StringType_isNULL = false;
		return OK;
	}

	int getMinLength(unsigned long long& value) const {
		if (MinLength_isNULL==true)
			return NOT_FOUND;
		value = MinLength;
		return OK;
	}
	
	int setMinLength(const unsigned long long& newValue) {
		MinLength = newValue;
		MinLength_isNULL = false;
		return OK;
	}

	int getMaxLength(unsigned long long& value) const {
		if (MaxLength_isNULL==true)
			return NOT_FOUND;
		value = MaxLength;
		return OK;
	}
	
	int setMaxLength(const unsigned long long& newValue) {
		MaxLength = newValue;
		MaxLength_isNULL = false;
		return OK;
	}

	int getValueExpression(string& value) const {
		if (ValueExpression_isNULL==true)
			return NOT_FOUND;
		value = ValueExpression;
		return OK;
	}
	
	int setValueExpression(const string& newValue) {
		ValueExpression = newValue;
		ValueExpression_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_BIOSSTRING_H_*/
