/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_HardwareThreadAccess.h"

vector<_processor_topology> _previous_cpu_info_processors_information;

int CPU_OpenDRIM_HardwareThread_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CPU_getProcessors("/proc/cpuinfo", _previous_cpu_info_processors_information, errorMessage));
	CF_assert(CPU_getLoadAverages(_previous_cpu_info_processors_information, _previous_cpu_info_processors_information, errorMessage));
	_L_;
	return OK;
}

int CPU_OpenDRIM_HardwareThread_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int CPU_OpenDRIM_HardwareThread_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_HardwareThread>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	// get info from cpuinfo
	vector<_processor_topology> cpu_info_processors_information;
	CF_assert(CPU_getProcessors("/proc/cpuinfo", cpu_info_processors_information, errorMessage));
	CF_assert(CPU_getLoadAverages(cpu_info_processors_information, _previous_cpu_info_processors_information, errorMessage));
	_previous_cpu_info_processors_information = cpu_info_processors_information;
	
	for (unsigned int i = 0; i < cpu_info_processors_information.size(); i++) {
		for (unsigned int j = 0; j < cpu_info_processors_information[i].processor_cores.size(); j++) {
			for (unsigned int k = 0; k < cpu_info_processors_information[i].processor_cores[j].nb_hardware_thread; k++) {
				OpenDRIM_HardwareThread instance;
				instance.setInstanceID(CF_intToStr(i) + ":" + CF_intToStr(j) + ":" + CF_intToStr(k));
				if (discriminant == "ei") {
					CF_assert(CPU_OpenDRIM_HardwareThread_populate(instance, cpu_info_processors_information[i], j, k, errorMessage));
				}
				result.push_back(instance);
			}
		}
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_HardwareThread_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_HardwareThread& instance, const char** properties, string& errorMessage) {
	_E_;
	string InstanceID;
	instance.getInstanceID(InstanceID);
	vector<string> InstanceID_elements;
	CF_splitText(InstanceID_elements, InstanceID, ':');
	if (InstanceID_elements.size() != 3)
		return NOT_FOUND;
	if (!CF_isNumber(InstanceID_elements[0]) || !CF_isNumber(InstanceID_elements[1]) || !CF_isNumber(InstanceID_elements[2]))
		return NOT_FOUND;
	unsigned int processor_id = atoll(InstanceID_elements[0].c_str());
	unsigned int core_id = atoll(InstanceID_elements[1].c_str());
	unsigned int thread_id = atoll(InstanceID_elements[2].c_str());
	
	// get info from cpuinfo
	vector<_processor_topology> cpu_info_processors_information;
	CF_assert(CPU_getProcessors("/proc/cpuinfo", cpu_info_processors_information, errorMessage));
	CF_assert(CPU_getLoadAverages(cpu_info_processors_information, _previous_cpu_info_processors_information, errorMessage));
	_previous_cpu_info_processors_information = cpu_info_processors_information;
	
	// does this thread exists ?
	if (processor_id >= cpu_info_processors_information.size())
		return NOT_FOUND;
	if (core_id >= cpu_info_processors_information[processor_id].processor_cores.size())
		return NOT_FOUND;
	if (thread_id >= cpu_info_processors_information[processor_id].processor_cores[core_id].nb_hardware_thread)
		return NOT_FOUND;
	
	// populate the instance
	CF_assert(CPU_OpenDRIM_HardwareThread_populate(instance, cpu_info_processors_information[processor_id], core_id, thread_id, errorMessage));
	_L_;
	return OK;
}

int CPU_OpenDRIM_HardwareThread_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HardwareThread& newInstance, const OpenDRIM_HardwareThread& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_HardwareThread_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HardwareThread& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_HardwareThread_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HardwareThread& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_HardwareThread_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HardwareThread& instance, unsigned int& returnValue, const OpenDRIM_HardwareThread_RequestStateChange_In& in, OpenDRIM_HardwareThread_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_HardwareThread_populate(OpenDRIM_HardwareThread& instance, const _processor_topology& cpu_info_processor_information, unsigned int core_id, unsigned int thread_id, string& errorMessage) {
	_E_;
	
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] InstanceID
	 * [X] EnabledState
	 * [X] RequestedState
	 * [X] OperationalStatus
	 * [X] HealthState
	 * [X] ElementName
	 */
	
	vector<unsigned short> OperationalStatus;
	
	// default
	// we don't support RequestedStateChange()
	instance.setRequestedState(12); // Not Applicable
	instance.setEnabledState(5);    // Not Applicable
	OperationalStatus.push_back(0); // unknown
	instance.setOperationalStatus(OperationalStatus);
	instance.setHealthState(0);     // unknown
	
	// set info from /proc/cpuinfo
	instance.setElementName(cpu_info_processor_information.name + " core hardware thread");
	
	// load percentage
	instance.setLoadPercentage(cpu_info_processor_information.processor_cores[core_id].hardware_thread_load_averages[thread_id]);
	_L_;
	return OK;
}
