/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <GTLCore/Type.h>
#include <GTLCore/TypesManager.h>

class TestFloatType : public GTLTest::Case {
  public:
    TestFloatType() : GTLTest::Case("Float")
    {
    }
    virtual void runTest()
    {
      GTLTEST_CHECK_EQUAL(Type::Float32->dataType(), Type::FLOAT32);
      GTLTEST_CHECK_EQUAL(Type::Float32->bitsSize(), 32);
      GTLTEST_CHECK_EQUAL(Type::Float32->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::Float32->countStructDataMembers(), 0);
      GTLTEST_CHECK(Type::Float32->isNumber());
      GTLTEST_CHECK(not Type::Float32->isInteger());
      GTLTEST_CHECK(Type::Float32->isFloatingPoint());
      GTLTEST_CHECK(not Type::Float32->isStructure());
    }
};

class TestIntegerType : public GTLTest::Case {
  public:
    TestIntegerType() : GTLTest::Case("Integer")
    {
    }
    virtual void runTest()
    {
      GTLTEST_CHECK_EQUAL(Type::Boolean->dataType(), Type::BOOLEAN);
      GTLTEST_CHECK_EQUAL(Type::Boolean->bitsSize(), 1);
      GTLTEST_CHECK_EQUAL(Type::Boolean->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::Boolean->countStructDataMembers(), 0);
      GTLTEST_CHECK(Type::Boolean->isNumber());
      GTLTEST_CHECK(Type::Boolean->isInteger());
      GTLTEST_CHECK(not Type::Boolean->isFloatingPoint());
      GTLTEST_CHECK(not Type::Boolean->isStructure());
      
      GTLTEST_CHECK_EQUAL(Type::Integer8->dataType(), Type::INTEGER8);
      GTLTEST_CHECK_EQUAL(Type::Integer8->bitsSize(), 8);
      GTLTEST_CHECK_EQUAL(Type::Integer8->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::Integer8->countStructDataMembers(), 0);
      GTLTEST_CHECK(Type::Integer8->isNumber());
      GTLTEST_CHECK(Type::Integer8->isInteger());
      GTLTEST_CHECK(not Type::Integer8->isFloatingPoint());
      GTLTEST_CHECK(not Type::Integer8->isStructure());
      
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger8->dataType(), Type::UNSIGNED_INTEGER8);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger8->bitsSize(), 8);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger8->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger8->countStructDataMembers(), 0);
      GTLTEST_CHECK(Type::UnsignedInteger8->isNumber());
      GTLTEST_CHECK(Type::UnsignedInteger8->isInteger());
      GTLTEST_CHECK(not Type::UnsignedInteger8->isFloatingPoint());
      GTLTEST_CHECK(not Type::UnsignedInteger8->isStructure());
      
      GTLTEST_CHECK_EQUAL(Type::Integer16->dataType(), Type::INTEGER16);
      GTLTEST_CHECK_EQUAL(Type::Integer16->bitsSize(), 16);
      GTLTEST_CHECK_EQUAL(Type::Integer16->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::Integer16->countStructDataMembers(), 0);
      GTLTEST_CHECK(Type::Integer16->isNumber());
      GTLTEST_CHECK(Type::Integer16->isInteger());
      GTLTEST_CHECK(not Type::Integer16->isFloatingPoint());
      GTLTEST_CHECK(not Type::Integer16->isStructure());
      
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger16->dataType(), Type::UNSIGNED_INTEGER16);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger16->bitsSize(), 16);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger16->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger16->countStructDataMembers(), 0);
      GTLTEST_CHECK(Type::UnsignedInteger16->isNumber());
      GTLTEST_CHECK(Type::UnsignedInteger16->isInteger());
      GTLTEST_CHECK(not Type::UnsignedInteger16->isFloatingPoint());
      GTLTEST_CHECK(not Type::UnsignedInteger16->isStructure());
      
      GTLTEST_CHECK_EQUAL(Type::Integer32->dataType(), Type::INTEGER32);
      GTLTEST_CHECK_EQUAL(Type::Integer32->bitsSize(), 32);
      GTLTEST_CHECK_EQUAL(Type::Integer32->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::Integer32->countStructDataMembers(), 0);
      GTLTEST_CHECK(Type::Integer32->isNumber());
      GTLTEST_CHECK(Type::Integer32->isInteger());
      GTLTEST_CHECK(not Type::Integer32->isFloatingPoint());
      GTLTEST_CHECK(not Type::Integer32->isStructure());
      
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger32->dataType(), Type::UNSIGNED_INTEGER32);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger32->bitsSize(), 32);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger32->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger32->countStructDataMembers(), 0);
      GTLTEST_CHECK(Type::UnsignedInteger32->isNumber());
      GTLTEST_CHECK(Type::UnsignedInteger32->isInteger());
      GTLTEST_CHECK(not Type::UnsignedInteger32->isFloatingPoint());
      GTLTEST_CHECK(not Type::UnsignedInteger32->isStructure());
    }
};

class TestStructDataMember : public GTLTest::Case {
  public:
    TestStructDataMember() : GTLTest::Case("StructDataMember")
    {
    }
    virtual void runTest()
    {
      const GTLCore::Type* arrayType = GTLCore::TypesManager::getArray(GTLCore::Type::UnsignedInteger8);
      std::list<int> sizes;
      sizes.push_back(3);
      GTLCore::Type::StructDataMember sdm("hello", arrayType, sizes);
      GTLTEST_CHECK_EQUAL(sdm.name(), "hello");
      GTLTEST_CHECK_EQUAL(sdm.type(), arrayType);
      GTLTEST_CHECK_EQUAL(sdm.initialSizes().size(), 1);
      GTLTEST_CHECK_EQUAL(sdm.initialSizes().back(), 3);
      GTLCore::Type::StructDataMember sdm2 = sdm;
      GTLTEST_CHECK_EQUAL(sdm2.name(), "hello");
      GTLTEST_CHECK_EQUAL(sdm2.type(), arrayType);
      GTLTEST_CHECK_EQUAL(sdm2.initialSizes().size(), 1);
      GTLTEST_CHECK_EQUAL(sdm2.initialSizes().back(), 3);
    }
};

class TestType : public GTLTest::Suite {
  public:
    TestType() : GTLTest::Suite("Type")
    {
      addCase( new TestIntegerType);
      addCase( new TestFloatType);
      addCase( new TestStructDataMember);
    }
};

