/*
 *  Copyright (c) 2009-2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Source_p.h"

using namespace GTLFragment;

#include <fstream>

#include "GTLCore/Debug.h"
#include "MetadataLexer_p.h"
#include "MetadataParser_p.h"
#include "Metadata.h"
#include "GTLCore/CompilationMessage.h"

#include "GTLCore/Metadata/Factory_p.h"
#include <GTLCore/CompilationMessages.h>


// ---- Library::Private ---- //

void Source::Private::compileMetaData()
{
  metadata = 0;
  std::istringstream iss(source);
  MetadataLexer* lexer = new MetadataLexer(&iss);
  MetadataParser parser( lexer, "" );
  metadata = parser.parse();
  compilationErrors = parser.errorMessages();
  metadataCompilationFailed = not compilationErrors.errors().empty();
  GTL_DEBUG( compilationErrors.errors().size() );
  GTL_DEBUG( parser.errorMessages().errors().size() );
  if( compilationErrors.errors().size() != 0 )
  {
    GTLCore::Metadata::Factory::deleteEntry( metadata );
    metadata = 0;
  }
}

void Source::Private::update()
{
  if(uptodate) return;
  uptodate = true;
  specificUpdate(source, name);
}

Source::Private* Source::Private::clone()
{
  return new Private(*this);
}

void Source::Private::specificUpdate(const GTLCore::String& _source, GTLCore::String& name)
{
}
