# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 198-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53442);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 198-1 (nullmailer)";
 script_name(name);

 desc = "The remote host is missing an update to nullmailer
announced via advisory DSA 198-1.

A problem has been discovered in nullmailer, a simple relay-only mail
transport agent for hosts that relay mail to a fixed set of smart
relays.  When a mail is to be delivered locally to a user that doesn't
exist, nullmailer tries to deliver it, discovers a user unknown error
and stops delivering.  Unfortunately, it stops delivering entirely,
not only this mail.  Hence, it's very easy to craft a denial of service.

This problem has been fixed in version 1.00RC5-16.1woody2 for the
current stable distribution (woody) and in version 1.00RC5-17 for the
unstable distribution (sid).  The old stable distribution (potato)
does not contain a nullmailer package.

We recommend that you upgrade your nullmailer package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20198-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 198-1 (nullmailer)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"nullmailer", ver:"1.00RC5-16.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
