###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for gimp FEDORA-2009-11880
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861608);
  script_version("$Revision: 7426 $: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2009-11880");
  script_name("Fedora Update for gimp FEDORA-2009-11880");
  desc = "

  Vulnerability Insight:
  GIMP (GNU Image Manipulation Program) is a powerful image composition and
  editing program, which can be extremely useful for creating logos and other
  graphics for webpages. GIMP has many of the tools and filters you would expect
  to find in similar commercial offerings, and some interesting extras as well.
  GIMP provides a large image manipulation toolbox, including channel operations
  and layers, effects, sub-pixel imaging and anti-aliasing, and conversions, all
  with multi-level undo.


  Affected Software/OS:
  gimp on Fedora 11

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2010-January/msg00184.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gimp");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC11")
{

  if(isrpmvuln(pkg:"gimp", rpm:"gimp~2.6.8~1.fc11", rls:"FC11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}