###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_thunderbird_detect_win.nasl 302 2008-10-03 14:23:34Z oct $
#
# Mozilla Thunderbird Version Detection (Windows)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(800015);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Mozilla Thunderbird Version Detection (Windows)");
  desc = "
  Overview : This script retrieves Mozilla ThunderBird Version and
  saves it in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set Version of Mozilla Thunderbird in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){ # Confirm it is Windows
  exit(0);
}

# Get ThunderBird Version from Registry
birdVer = registry_get_sz(item:"CurrentVersion", 
                          key:"SOFTWARE\Mozilla\Mozilla Thunderbird");
if(!birdVer){
  exit(0);
}

if(!ereg(pattern:"1\.5[^.0-9]", string:birdVer))
{
  birdVer = eregmatch(pattern:"[0-9.]+", string:birdVer);
  set_kb_item(name:"Thunderbird/Win/Ver",value:birdVer[0]);
  exit(0);
}

# Special case for thunderbird 1.5 (Get the version from file)
if("1.5" >< birdVer)
{
  filePath = registry_get_sz(item:"PathToExe",
                             key:"SOFTWARE\Mozilla\Mozilla Thunderbird 1.5\bin");
  if(!filePath){
    exit(0);
  }

  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:filePath);
  file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:filePath);

  soc = open_sock_tcp(port);
  if(!soc){
    exit(0);
  }

  r = smb_session_request(soc:soc, remote:name);
  if(!r){
    close(soc);
    exit(0);
  }

  prot = smb_neg_prot(soc:soc);
  if(!prot){
    close(soc);
    exit(0);
  }

  r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
  if(!r){
    close(soc);
    exit(0);
  }

  uid = session_extract_uid(reply:r);
  r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
  tid = tconx_extract_tid(reply:r);
  if(!tid){
    close(soc);
    exit(0);
  }

  fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
  if(!fid){
    close(soc);
    exit(0);
  }

  fileVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid,
                       offset:260000, verstr="prod");
  close(soc);
  if(fileVer){
    set_kb_item(name:"Thunderbird/Win/Ver",value:fileVer);
  }
}
else
{
  birdVer = registry_get_sz(item:"CurrentVersion", 
                            key:"SOFTWARE\mozilla.org\Mozilla Thunderbird");
  if(birdVer)
  {
    birdVer = eregmatch(pattern:"[0-9.]+", string:birdVer);
    set_kb_item(name:"Thunderbird/Win/Ver",value:birdVer[0]);
    security_note(data:"Mozilla Thunderbird version " + birdVer[0] +
                         " was detected on the host");
  }
}
