##############################################################################
#
#  ESET Smart Security easdrv.sys Local Privilege Escalation Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/01
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0150
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900114);
 script_cve_id("CVE-2008-7107");
 script_bugtraq_id(30719);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_tag(name:"cvss_base", value:"6.6");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Privilege escalation");
 script_name("ESET Smart Security easdrv.sys Local Privilege Escalation Vulnerability");
 script_summary("Check for vulnerable version and prior of ESET");
 desc = "
 Overview : The host is running ESET Smart Security, which is prone to a local
 privilege escalation vulnerability.

 Vulnerability Insight :

        The flaw exists due to an error in easdrv.sys driver file.

        Impact: Local exploitation will allow attackers to execute arbitrary
        code with kernel level privileges to result in complete compromise of
        the system.

 Impact Level : Application

 Affected Software/OS:
 - Eset Software Smart Security 3.0.667.0 and prior on Windows (All)

 Fix : Upgrade to Eset Software Smart Security version 4.0.474 or later
 For update refer, http://www.eset.com/

 References : http://www.securityfocus.com/bid/30719/discuss

 CVSS Score :
        CVSS Base Score     : 6.6 (AV:L/AC:M/Au:SI/C:C/I:C/A:C)
        CVSS Temporal Score : 5.9
 Risk factor : High"; 

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}

 include("smb_nt.inc");

 if (!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }
 
 esetVer = registry_get_sz(key:"SOFTWARE\ESET\ESET Security\CurrentVersion\Info",
			   item:"ProductVersion");
 if(!esetVer){
	exit(0);
 } 

 # Grep Eset Software Smart Security version <= 3.0.667.0
 if(egrep(pattern:"^([0-2]\..*|3\.0\.([0-5]?[0-9]?[0-9]|6[0-5][0-9]|66[0-7])\.0)$",
	  string:esetVer)){
	security_warning(0);
 }
