/*
 *   Copyright 2009 - 2010 by Giulio Camuffo <giuliocamuffo@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef WOLFMETER_H
#define WOLFMETER_H

#include <Plasma/Meter>

class QGraphicsSceneMouseEvent;
class WolfLabel;

class WolfMeter : public Plasma::Meter
{
    Q_OBJECT

    public:
        WolfMeter(QGraphicsWidget *parent);
        ~WolfMeter(void);

        void mousePressEvent(QGraphicsSceneMouseEvent *event);
        bool contains(const QPointF& point) const;

    public slots:
        void setPosition(const int pos, const int total);
        void clear();

    protected:
        void resizeEvent(QGraphicsSceneResizeEvent *event);

    signals:
        void valueChanged(int value);

    private:
        void updateLabel(QSizeF size);

        WolfLabel *m_label;

};

#endif
