/***********************************************************************************
* Smooth Tasks
* Copyright (C) 2009 Marcin Baszczewski <marcin.baszczewski@gmail.com>
* Copyright (C) 2009 Mathias Panzenböck <grosser.meister.morti@gmx.net>
* Copyright (C) 2009-2012 Toni Dietze <smooth-tasks@derflupp.e4ward.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/
#ifndef SMOOTHTASKS_TASKICON_H
#define SMOOTHTASKS_TASKICON_H

// Qt
#include <QObject>
#include <QPixmap>
#include <QIcon>

// C++
#include <limits>

class QPropertyAnimation;
class QStyleOptionGraphicsItem;

namespace SmoothTasks {

class Applet;
class TaskItem;

class TaskIcon : public QObject {
	Q_OBJECT
	Q_PROPERTY(qreal startupAnimationProgress
	           READ  startupAnimationProgress
	           WRITE setStartupAnimationProgress)

public:
	TaskIcon(TaskItem *item);

	void paint(QPainter *p, qreal hover, bool isGroup);
	void setRects(const QRectF& contentsRdRect, const QRectF& maxRdRect);
	QRgb highlightColor() const;
	QSize rdSize();
	QPointF pos() const { return m_pos; }
	QSizeF preferredRdSize(const qreal rdHeightContents = std::numeric_limits<qreal>::infinity(), const qreal rdHeightMax = std::numeric_limits<qreal>::infinity()) const;
	
	static QSizeF preferredRdSize(const QIcon& qIcon, const Applet& applet, const Qt::Orientation& orientation, const qreal rdHeightContents, const qreal rdHeightMax);

public slots:
	void setIcon(const QIcon& icon);
	void startStartupAnimation(int duration = 300);
	void stopStartupAnimation();

private:
	qreal rdHeight() const;
	QSize actualRdSize(const QSize &size, QIcon::Mode mode = QIcon::Normal, QIcon::State state = QIcon::Off) const;
	
	static QSize actualRdSize(const QIcon& qIcon, const Qt::Orientation& orientation, const QSize &size, QIcon::Mode mode = QIcon::Normal, QIcon::State state = QIcon::Off);
	
	QRgb averageColor() const;
	QRgb meanColor() const;
	QRgb dominantColor() const;
	
	TaskItem *m_item;
	QIcon     m_icon;
	QRgb      m_highlightColor;
	QRectF    m_contentsRdRect;
	QRectF    m_maxRdRect;
	QPixmap   m_pixmap;
	qreal     m_progress;
	QPointF   m_pos;
	QSize     m_size;
	QPropertyAnimation* m_startupAnimation;

	void updatePos();
	void animationHover(qreal hover);
	void animationStartup(qreal progress);
	qreal startupAnimationProgress() const { return m_progress; }
	void setStartupAnimationProgress(qreal progress);

signals:
	void update();
};

} // namespace SmoothTasks
#endif
