/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MethodImplementationFilter;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.MethodOptimizationInfo;

public class NonPrivateMemberMarker
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor {
    private final MethodImplementationFilter filteredMethodMarker = new MethodImplementationFilter(this);

    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.methodAccept("<clinit>", "()V", this);
        programClass.methodAccept("<init>", "()V", this);
        programClass.methodsAccept(this.filteredMethodMarker);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.methodsAccept(this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.referencedMemberAccept(this);
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        Clazz clazz2 = refConstant.referencedClass;
        if (clazz2 != null && !clazz2.equals(clazz) || !refConstant.getClassName(clazz).equals(clazz.getName())) {
            refConstant.referencedMemberAccept(this);
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        NonPrivateMemberMarker.markCanNotBeMadePrivate(programField);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        NonPrivateMemberMarker.markCanNotBeMadePrivate(libraryField);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        NonPrivateMemberMarker.markCanNotBeMadePrivate(programMethod);
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        NonPrivateMemberMarker.markCanNotBeMadePrivate(libraryMethod);
    }

    private static void markCanNotBeMadePrivate(Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        if (fieldOptimizationInfo != null) {
            fieldOptimizationInfo.setCanNotBeMadePrivate();
        }
    }

    public static boolean canBeMadePrivate(Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        return fieldOptimizationInfo != null && fieldOptimizationInfo.canBeMadePrivate();
    }

    private static void markCanNotBeMadePrivate(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setCanNotBeMadePrivate();
        }
    }

    public static boolean canBeMadePrivate(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo != null && methodOptimizationInfo.canBeMadePrivate();
    }
}

