/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;
import weka.gui.GenericObjectEditor;
import weka.gui.experiment.Messages;

public class OutputFormatDialog
extends JDialog {
    private static final long serialVersionUID = 2169792738187807378L;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected int m_Result;
    protected static Vector m_OutputFormatClasses = null;
    protected static Vector m_OutputFormatNames = null;
    protected Class m_ResultMatrix;
    protected JComboBox m_OutputFormatComboBox;
    protected JSpinner m_MeanPrecSpinner;
    protected JSpinner m_StdDevPrecSpinner;
    protected JCheckBox m_ShowAverageCheckBox;
    protected JCheckBox m_RemoveFilterNameCheckBox;
    protected JButton m_OkButton;
    protected JButton m_CancelButton;
    protected int m_MeanPrec;
    protected int m_StdDevPrec;
    protected boolean m_RemoveFilterName;
    protected boolean m_ShowAverage;

    public OutputFormatDialog(Frame parent) {
        Messages.getInstance();
        super((Window)parent, Messages.getString("OutputFormatDialog_Title_Text"), Dialog.ModalityType.DOCUMENT_MODAL);
        this.m_Result = 1;
        this.m_ResultMatrix = ResultMatrixPlainText.class;
        this.m_OutputFormatComboBox = new JComboBox(m_OutputFormatNames);
        this.m_MeanPrecSpinner = new JSpinner();
        this.m_StdDevPrecSpinner = new JSpinner();
        this.m_ShowAverageCheckBox = new JCheckBox("");
        this.m_RemoveFilterNameCheckBox = new JCheckBox("");
        Messages.getInstance();
        this.m_OkButton = new JButton(Messages.getString("OutputFormatDialog_OkButton_JButton_Text"));
        Messages.getInstance();
        this.m_CancelButton = new JButton(Messages.getString("OutputFormatDialog_CancelButton_JButton_Text"));
        this.m_MeanPrec = 2;
        this.m_StdDevPrec = 2;
        this.m_RemoveFilterName = false;
        this.m_ShowAverage = false;
        this.createDialog();
    }

    protected void createDialog() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridLayout(5, 2));
        this.getContentPane().add((Component)panel, "Center");
        SpinnerNumberModel model = (SpinnerNumberModel)this.m_MeanPrecSpinner.getModel();
        model.setMaximum(new Integer(20));
        model.setMinimum(new Integer(0));
        model = (SpinnerNumberModel)this.m_StdDevPrecSpinner.getModel();
        model.setMaximum(new Integer(20));
        model.setMinimum(new Integer(0));
        Messages.getInstance();
        JLabel label = new JLabel(Messages.getString("OutputFormatDialog_CreateDialog_MeanPrecision_JLabel_Text"));
        label.setDisplayedMnemonic('M');
        label.setLabelFor(this.m_MeanPrecSpinner);
        panel.add(label);
        panel.add(this.m_MeanPrecSpinner);
        Messages.getInstance();
        label = new JLabel(Messages.getString("OutputFormatDialog_CreateDialog_StdDevPrecision_JLabel_Text"));
        label.setDisplayedMnemonic('S');
        label.setLabelFor(this.m_StdDevPrecSpinner);
        panel.add(label);
        panel.add(this.m_StdDevPrecSpinner);
        Messages.getInstance();
        label = new JLabel(Messages.getString("OutputFormatDialog_CreateDialog_OutputFormat_JLabel_Text"));
        label.setDisplayedMnemonic('F');
        label.setLabelFor(this.m_OutputFormatComboBox);
        panel.add(label);
        panel.add(this.m_OutputFormatComboBox);
        this.m_OutputFormatComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OutputFormatDialog.this.getData();
            }
        });
        Messages.getInstance();
        label = new JLabel(Messages.getString("OutputFormatDialog_CreateDialog_ShowAverage_JLabel_Text"));
        label.setDisplayedMnemonic('A');
        label.setLabelFor(this.m_ShowAverageCheckBox);
        panel.add(label);
        panel.add(this.m_ShowAverageCheckBox);
        Messages.getInstance();
        label = new JLabel(Messages.getString("OutputFormatDialog_CreateDialog_RemoveFilterClassnames_JLabel_Text"));
        label.setDisplayedMnemonic('R');
        label.setLabelFor(this.m_RemoveFilterNameCheckBox);
        panel.add(label);
        panel.add(this.m_RemoveFilterNameCheckBox);
        panel = new JPanel(new FlowLayout(2));
        this.getContentPane().add((Component)panel, "South");
        this.m_CancelButton.setMnemonic('C');
        this.m_CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OutputFormatDialog.this.m_Result = 1;
                OutputFormatDialog.this.setVisible(false);
            }
        });
        this.m_OkButton.setMnemonic('O');
        this.m_OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OutputFormatDialog.this.getData();
                OutputFormatDialog.this.m_Result = 0;
                OutputFormatDialog.this.setVisible(false);
            }
        });
        panel.add(this.m_OkButton);
        panel.add(this.m_CancelButton);
        this.getRootPane().setDefaultButton(this.m_OkButton);
        this.pack();
    }

    private void setData() {
        this.m_MeanPrecSpinner.setValue(new Integer(this.m_MeanPrec));
        this.m_StdDevPrecSpinner.setValue(new Integer(this.m_StdDevPrec));
        this.m_ShowAverageCheckBox.setSelected(this.m_ShowAverage);
        this.m_RemoveFilterNameCheckBox.setSelected(this.m_RemoveFilterName);
        for (int i = 0; i < m_OutputFormatClasses.size(); ++i) {
            if (!m_OutputFormatClasses.get(i).equals(this.m_ResultMatrix)) continue;
            this.m_OutputFormatComboBox.setSelectedItem(m_OutputFormatNames.get(i));
            break;
        }
    }

    private void getData() {
        this.m_MeanPrec = Integer.parseInt(this.m_MeanPrecSpinner.getValue().toString());
        this.m_StdDevPrec = Integer.parseInt(this.m_StdDevPrecSpinner.getValue().toString());
        this.m_ShowAverage = this.m_ShowAverageCheckBox.isSelected();
        this.m_RemoveFilterName = this.m_RemoveFilterNameCheckBox.isSelected();
        this.m_ResultMatrix = (Class)m_OutputFormatClasses.get(this.m_OutputFormatComboBox.getSelectedIndex());
    }

    public void setMeanPrec(int precision) {
        this.m_MeanPrec = precision;
    }

    public int getMeanPrec() {
        return this.m_MeanPrec;
    }

    public void setStdDevPrec(int precision) {
        this.m_StdDevPrec = precision;
    }

    public int getStdDevPrec() {
        return this.m_StdDevPrec;
    }

    public void setResultMatrix(Class matrix) {
        this.m_ResultMatrix = matrix;
    }

    public Class getResultMatrix() {
        return this.m_ResultMatrix;
    }

    public void setRemoveFilterName(boolean remove) {
        this.m_RemoveFilterName = remove;
    }

    public boolean getRemoveFilterName() {
        return this.m_RemoveFilterName;
    }

    public void setShowAverage(boolean show) {
        this.m_ShowAverage = show;
    }

    public boolean getShowAverage() {
        return this.m_ShowAverage;
    }

    protected void setFormat() {
        for (int i = 0; i < m_OutputFormatClasses.size(); ++i) {
            if (!m_OutputFormatNames.get(i).toString().equals(this.m_OutputFormatComboBox.getItemAt(i).toString())) continue;
            this.m_OutputFormatComboBox.setSelectedIndex(i);
            break;
        }
    }

    public int getResult() {
        return this.m_Result;
    }

    public int showDialog() {
        this.m_Result = 1;
        this.setData();
        this.setVisible(true);
        return this.m_Result;
    }

    public static void main(String[] args) {
        OutputFormatDialog dialog = new OutputFormatDialog(null);
        if (dialog.showDialog() == 0) {
            Messages.getInstance();
            System.out.println(Messages.getString("OutputFormatDialog_Main_Accepted_Text"));
        } else {
            Messages.getInstance();
            System.out.println(Messages.getString("OutputFormatDialog_Main_Aborted_Text"));
        }
    }

    static {
        Vector<String> classes = GenericObjectEditor.getClassnames(ResultMatrix.class.getName());
        m_OutputFormatClasses = new Vector();
        m_OutputFormatNames = new Vector();
        for (int i = 0; i < classes.size(); ++i) {
            try {
                Class<?> cls = Class.forName(classes.get(i).toString());
                ResultMatrix matrix = (ResultMatrix)cls.newInstance();
                m_OutputFormatClasses.add(cls);
                m_OutputFormatNames.add(matrix.getDisplayName());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

