/*
            Copyright Oliver Kowalke 2009.
   Distributed under the Boost Software License, Version 1.0.
      (See accompanying file LICENSE_1_0.txt or copy at
          http://www.boost.org/LICENSE_1_0.txt)
*/

/*******************************************************************
 *                                                                 *
 *  -------------------------------------------------------------  *
 *  |  0  |  1  |  2  |  3  |  4  |  5  |  6  |  7  |  8  |  9  |  *
 *  -------------------------------------------------------------  *
 *  |  0  |  4  |  8  |  12 |  16 |  20 |  24 |  28 |  32 |  36 |  *
 *  -------------------------------------------------------------  *
 *  | R13 | R14 | R15 | R16 | R17 | R18 | R19 | R20 | R21 | R22 |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  10 |  11 |  12 |  13 |  14 |  15 |  16 |  17 |  18 |  19 |  *
 *  -------------------------------------------------------------  *
 *  |  40 |  44 |  48 |  52 |  56 |  60 |  64 |  68 |  72 |  76 |  *
 *  -------------------------------------------------------------  *
 *  | R23 | R24 | R25 | R26 | R27 | R28 | R29 | R30 | R31 |  SP |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  20 |  21 |  22 |                                         |  *
 *  -------------------------------------------------------------  *
 *  |  80 |  84 |  88 |                                         |  *
 *  -------------------------------------------------------------  *
 *  |  CR |  LR |  PC |                                         |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  23 |  24 |  25 |                                         |  *
 *  -------------------------------------------------------------  *
 *  |  92 |  96 | 100 |                                         |  *
 *  -------------------------------------------------------------  *
 *  |  sp | size|<pad>|                                         |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  26 |  27 |  28 |  29 |  30 |  31 |  32 |  33 |  34 |  35 |  *
 *  -------------------------------------------------------------  *
 *  | 104 | 108 | 112 | 116 | 120 | 124 | 128 | 132 | 136 | 140 |  *
 *  -------------------------------------------------------------  *
 *  |    F14    |    F15    |    F16    |    F17    |    F18    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  36 |  37 |  38 |  39 |  40 |  41 |  42 |  43 |  44 |  45 |  *
 *  -------------------------------------------------------------  *
 *  | 144 | 148 | 152 | 156 | 160 | 164 | 168 | 172 | 176 | 180 |  *
 *  -------------------------------------------------------------  *
 *  |    F19    |    F20    |    F21    |    F22    |    F23    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  46 |  47 |  48 |  49 |  50 |  51 |  52 |  53 |  54 |  55 |  *
 *  -------------------------------------------------------------  *
 *  | 184 | 188 | 192 | 196 | 200 | 204 | 208 | 212 | 216 | 220 |  *
 *  -------------------------------------------------------------  *
 *  |    F24    |    F25    |    F26    |    F27    |    F28    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  56 |  57 |  58 |  59 |  60 |  61 |  62 |  63 |           |  *
 *  -------------------------------------------------------------  *
 *  | 224 | 228 | 232 | 236 | 240 | 244 | 248 | 252 |           |  *
 *  -------------------------------------------------------------  *
 *  |    F29    |    F30    |    F31    |   fpscr   |           |  *
 *  -------------------------------------------------------------  *
 *                                                                 *
 * *****************************************************************/

.text
.globl make_fcontext
.align 2
.type make_fcontext,@function
make_fcontext:
    mflr    %r6                 # save return address into R6

    mr      %r0, %r3
    subi    %r3, %r3, 256       # reserve space for fcontext_t at top of context stack

    # call align_stack, R3 contains address at 16 byte boundary after return
    # == pointer to fcontext_t and address of context stack
    rlwinm  %r3, %r3, 0, 0, 27

    stw     %r0, 92(%r3)        # save address of context stack (base) in fcontext_t
    stw     %r4, 96(%r3)        # save context stack size in fcontext_t
    stw     %r5, 88(%r3)        # save address of context function in fcontext_t

    subi    %r0, %r3, 64        # reserve 64 bytes (linkage + parameter area), R4 % 16 == 0
    stw     %r0, 76(%r3)        # save address in R3 as stack pointer for context function

    mflr    %r0                 # load LR
    bl      1f                  # jump to label 1
1:
    mflr    %r4                      # load LR into R4
    addi    %r4, %r4, finish - 1b    # compute abs address of label finish
    mtlr    %r0                      # restore LR
    stw     %r4, 84(%r3)             # save address of finish as return address for context function
                                     # entered after context function returns

    mtlr    %r6                 # restore return address from R6

    blr

finish:
    # SP points to same address as SP on entry of context function
    mflr    %r0                 # save return address into R0
    stw     %r0, 4(%r1)         # save return address on stack, set up stack frame
    stwu    %r1, -16(%r1)       # allocate stack space, SP % 16 == 0

    li      %r3,  0             # exit code is zero
    bl      _exit@plt           # exit application
.size make_fcontext, .-make_fcontext
