# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ProtectedItemQueryObject(Model):
    """Filters to list backup items.

    :param health_state: Health State for the backed up item. Possible values
     include: 'Passed', 'ActionRequired', 'ActionSuggested', 'Invalid'
    :type health_state: str or :class:`HealthState
     <azure.mgmt.recoveryservicesbackup.models.HealthState>`
    :param backup_management_type: Backup management type for the backed up
     item. Possible values include: 'Invalid', 'AzureIaasVM', 'MAB', 'DPM',
     'AzureBackupServer', 'AzureSql'
    :type backup_management_type: str or :class:`BackupManagementType
     <azure.mgmt.recoveryservicesbackup.models.BackupManagementType>`
    :param item_type: Type of workload this item represents. Possible values
     include: 'Invalid', 'VM', 'FileFolder', 'AzureSqlDb', 'SQLDB', 'Exchange',
     'Sharepoint', 'VMwareVM', 'SystemState', 'Client', 'GenericDataSource'
    :type item_type: str or :class:`DataSourceType
     <azure.mgmt.recoveryservicesbackup.models.DataSourceType>`
    :param policy_name: Backup policy name associated with the backup item.
    :type policy_name: str
    :param container_name: Name of the container.
    :type container_name: str
    :param backup_engine_name: Backup Engine name
    :type backup_engine_name: str
    :param friendly_name: Friendly name of protected item
    :type friendly_name: str
    """

    _attribute_map = {
        'health_state': {'key': 'healthState', 'type': 'str'},
        'backup_management_type': {'key': 'backupManagementType', 'type': 'str'},
        'item_type': {'key': 'itemType', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'backup_engine_name': {'key': 'backupEngineName', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
    }

    def __init__(self, health_state=None, backup_management_type=None, item_type=None, policy_name=None, container_name=None, backup_engine_name=None, friendly_name=None):
        self.health_state = health_state
        self.backup_management_type = backup_management_type
        self.item_type = item_type
        self.policy_name = policy_name
        self.container_name = container_name
        self.backup_engine_name = backup_engine_name
        self.friendly_name = friendly_name
