# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .chaos_event import ChaosEvent


class ExecutingFaultsChaosEvent(ChaosEvent):
    """Describes a Chaos event that gets generated when Chaos has decided on the
    faults for an iteration. This Chaos event contains the details of the
    faults as a list of strings.

    :param time_stamp_utc:
    :type time_stamp_utc: datetime
    :param Kind: Polymorphic Discriminator
    :type Kind: str
    :param faults:
    :type faults: list of str
    """ 

    _validation = {
        'time_stamp_utc': {'required': True},
        'Kind': {'required': True},
    }

    _attribute_map = {
        'time_stamp_utc': {'key': 'TimeStampUtc', 'type': 'iso-8601'},
        'Kind': {'key': 'Kind', 'type': 'str'},
        'faults': {'key': 'Faults', 'type': '[str]'},
    }

    def __init__(self, time_stamp_utc, faults=None):
        super(ExecutingFaultsChaosEvent, self).__init__(time_stamp_utc=time_stamp_utc)
        self.faults = faults
        self.Kind = 'ExecutingFaults'
