# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.extendedlocation.aio import CustomLocations

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCustomLocationsCustomLocationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CustomLocations, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_operations(self, resource_group):
        response = self.client.custom_locations.list_operations(
            api_version="2021-08-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_subscription(self, resource_group):
        response = self.client.custom_locations.list_by_subscription(
            api_version="2021-08-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_resource_group(self, resource_group):
        response = self.client.custom_locations.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2021-08-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.custom_locations.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2021-08-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.custom_locations.begin_create_or_update(
                resource_group_name=resource_group.name,
                resource_name="str",
                parameters={
                    "location": "str",
                    "authentication": {"type": "str", "value": "str"},
                    "clusterExtensionIds": ["str"],
                    "displayName": "str",
                    "hostResourceId": "str",
                    "hostType": "str",
                    "id": "str",
                    "identity": {"principalId": "str", "tenantId": "str", "type": "str"},
                    "name": "str",
                    "namespace": "str",
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2021-08-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.custom_locations.begin_delete(
                resource_group_name=resource_group.name,
                resource_name="str",
                api_version="2021-08-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_update(self, resource_group):
        response = await self.client.custom_locations.update(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2021-08-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_enabled_resource_types(self, resource_group):
        response = self.client.custom_locations.list_enabled_resource_types(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2021-08-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
