
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Vrml_Material.hxx>
#include <TopoDS_Shape.hxx>
#include <TDocStd_Document.hxx>

// module includes
#include <VrmlAPI.hxx>
#include <VrmlAPI_CafReader.hxx>
#include <VrmlAPI_RepresentationOfShape.hxx>
#include <VrmlAPI_Writer.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <VrmlConverter_Drawer.hxx>

// Module definiiton
void register_VrmlAPI(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("VrmlAPI"));
py::object klass;

//Python trampoline classes

// classes

    // Class VrmlAPI from ./opencascade/VrmlAPI.hxx
    klass = m.attr("VrmlAPI");

    // default constructor
    register_default_constructor<VrmlAPI , shared_ptr<VrmlAPI>>(m,"VrmlAPI");

    // nested enums

    static_cast<py::class_<VrmlAPI , shared_ptr<VrmlAPI>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Write_s",
                    (Standard_Boolean (*)( const TopoDS_Shape & ,  const Standard_CString ,  const Standard_Integer  ) ) static_cast<Standard_Boolean (*)( const TopoDS_Shape & ,  const Standard_CString ,  const Standard_Integer  ) >(&VrmlAPI::Write),
                    R"#(With help of this class user can change parameters of writing. Converts the shape aShape to VRML format of the passed version and writes it to the file identified by aFileName using default parameters.)#"  , py::arg("aShape"),  py::arg("aFileName"),  py::arg("aVersion")=static_cast<const Standard_Integer>(2)
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class VrmlAPI_CafReader from ./opencascade/VrmlAPI_CafReader.hxx
    klass = m.attr("VrmlAPI_CafReader");

    // default constructor
    register_default_constructor<VrmlAPI_CafReader ,opencascade::handle<VrmlAPI_CafReader>>(m,"VrmlAPI_CafReader");

    // nested enums

    static_cast<py::class_<VrmlAPI_CafReader ,opencascade::handle<VrmlAPI_CafReader>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&VrmlAPI_CafReader::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&VrmlAPI_CafReader::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (VrmlAPI_CafReader::*)() const) static_cast<const opencascade::handle<Standard_Type> & (VrmlAPI_CafReader::*)() const>(&VrmlAPI_CafReader::DynamicType),
             R"#(None)#"
             
         )
;

    // Class VrmlAPI_Writer from ./opencascade/VrmlAPI_Writer.hxx
    klass = m.attr("VrmlAPI_Writer");


    // nested enums

    static_cast<py::class_<VrmlAPI_Writer , shared_ptr<VrmlAPI_Writer>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("ResetToDefaults",
             (void (VrmlAPI_Writer::*)() ) static_cast<void (VrmlAPI_Writer::*)() >(&VrmlAPI_Writer::ResetToDefaults),
             R"#(Resets all parameters (representation, deflection) to their default values..)#" 
          )
        .def("Drawer",
             (opencascade::handle<VrmlConverter_Drawer> (VrmlAPI_Writer::*)() const) static_cast<opencascade::handle<VrmlConverter_Drawer> (VrmlAPI_Writer::*)() const>(&VrmlAPI_Writer::Drawer),
             R"#(Returns drawer object)#" 
          )
        .def("SetDeflection",
             (void (VrmlAPI_Writer::*)( const Standard_Real  ) ) static_cast<void (VrmlAPI_Writer::*)( const Standard_Real  ) >(&VrmlAPI_Writer::SetDeflection),
             R"#(Sets the deflection aDef of the mesh algorithm which is used to compute the shaded representation of the translated shape. The default value is -1. When the deflection value is less than 0, the deflection is calculated from the relative size of the shaped.)#"  , py::arg("aDef")
          )
        .def("SetRepresentation",
             (void (VrmlAPI_Writer::*)( const VrmlAPI_RepresentationOfShape  ) ) static_cast<void (VrmlAPI_Writer::*)( const VrmlAPI_RepresentationOfShape  ) >(&VrmlAPI_Writer::SetRepresentation),
             R"#(Sets the representation of the shape aRep which is written to the VRML file. The three options are : - shaded - wireframe - both shaded and wireframe (default) defined through the VrmlAPI_RepresentationOfShape enumeration.)#"  , py::arg("aRep")
          )
        .def("GetRepresentation",
             (VrmlAPI_RepresentationOfShape (VrmlAPI_Writer::*)() const) static_cast<VrmlAPI_RepresentationOfShape (VrmlAPI_Writer::*)() const>(&VrmlAPI_Writer::GetRepresentation),
             R"#(Returns the representation of the shape which is written to the VRML file. Types of representation are set through the VrmlAPI_RepresentationOfShape enumeration.)#" 
          )
        .def("GetFrontMaterial",
             (opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const) static_cast<opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const>(&VrmlAPI_Writer::GetFrontMaterial),
             R"#(None)#" 
          )
        .def("GetPointsMaterial",
             (opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const) static_cast<opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const>(&VrmlAPI_Writer::GetPointsMaterial),
             R"#(None)#" 
          )
        .def("GetUisoMaterial",
             (opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const) static_cast<opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const>(&VrmlAPI_Writer::GetUisoMaterial),
             R"#(None)#" 
          )
        .def("GetVisoMaterial",
             (opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const) static_cast<opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const>(&VrmlAPI_Writer::GetVisoMaterial),
             R"#(None)#" 
          )
        .def("GetLineMaterial",
             (opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const) static_cast<opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const>(&VrmlAPI_Writer::GetLineMaterial),
             R"#(None)#" 
          )
        .def("GetWireMaterial",
             (opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const) static_cast<opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const>(&VrmlAPI_Writer::GetWireMaterial),
             R"#(None)#" 
          )
        .def("GetFreeBoundsMaterial",
             (opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const) static_cast<opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const>(&VrmlAPI_Writer::GetFreeBoundsMaterial),
             R"#(None)#" 
          )
        .def("GetUnfreeBoundsMaterial",
             (opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const) static_cast<opencascade::handle<Vrml_Material> (VrmlAPI_Writer::*)() const>(&VrmlAPI_Writer::GetUnfreeBoundsMaterial),
             R"#(None)#" 
          )
        .def("Write",
             (Standard_Boolean (VrmlAPI_Writer::*)( const TopoDS_Shape & ,  const Standard_CString ,  const Standard_Integer  ) const) static_cast<Standard_Boolean (VrmlAPI_Writer::*)( const TopoDS_Shape & ,  const Standard_CString ,  const Standard_Integer  ) const>(&VrmlAPI_Writer::Write),
             R"#(Converts the shape aShape to VRML format of the passed version and writes it to the file identified by aFile.)#"  , py::arg("aShape"),  py::arg("aFile"),  py::arg("aVersion")=static_cast<const Standard_Integer>(2)
          )
        .def("WriteDoc",
             (Standard_Boolean (VrmlAPI_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const Standard_CString ,  const Standard_Real  ) const) static_cast<Standard_Boolean (VrmlAPI_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const Standard_CString ,  const Standard_Real  ) const>(&VrmlAPI_Writer::WriteDoc),
             R"#(Converts the document to VRML format of the passed version and writes it to the file identified by aFile.)#"  , py::arg("theDoc"),  py::arg("theFile"),  py::arg("theScale")
          )
    // methods using call by reference i.s.o. return
        .def("SetTransparencyToMaterial",
             []( VrmlAPI_Writer &self , Vrml_Material& aMaterial,const Standard_Real aTransparency ){
                 opencascade::handle<Vrml_Material>  aMaterial_ptr; aMaterial_ptr = &aMaterial;

                 self.SetTransparencyToMaterial(aMaterial_ptr,aTransparency);
                 if ( aMaterial_ptr.get() != &aMaterial ) copy_if_copy_constructible(aMaterial, *aMaterial_ptr);

                 return std::make_tuple(); },
             R"#(Set transparency to given material)#"  , py::arg("aMaterial"),  py::arg("aTransparency")
          )
        .def("SetShininessToMaterial",
             []( VrmlAPI_Writer &self , Vrml_Material& aMaterial,const Standard_Real aShininess ){
                 opencascade::handle<Vrml_Material>  aMaterial_ptr; aMaterial_ptr = &aMaterial;

                 self.SetShininessToMaterial(aMaterial_ptr,aShininess);
                 if ( aMaterial_ptr.get() != &aMaterial ) copy_if_copy_constructible(aMaterial, *aMaterial_ptr);

                 return std::make_tuple(); },
             R"#(None)#"  , py::arg("aMaterial"),  py::arg("aShininess")
          )
        .def("SetAmbientColorToMaterial",
             []( VrmlAPI_Writer &self , Vrml_Material& aMaterial,const opencascade::handle<Quantity_HArray1OfColor> & Color ){
                 opencascade::handle<Vrml_Material>  aMaterial_ptr; aMaterial_ptr = &aMaterial;

                 self.SetAmbientColorToMaterial(aMaterial_ptr,Color);
                 if ( aMaterial_ptr.get() != &aMaterial ) copy_if_copy_constructible(aMaterial, *aMaterial_ptr);

                 return std::make_tuple(); },
             R"#(None)#"  , py::arg("aMaterial"),  py::arg("Color")
          )
        .def("SetDiffuseColorToMaterial",
             []( VrmlAPI_Writer &self , Vrml_Material& aMaterial,const opencascade::handle<Quantity_HArray1OfColor> & Color ){
                 opencascade::handle<Vrml_Material>  aMaterial_ptr; aMaterial_ptr = &aMaterial;

                 self.SetDiffuseColorToMaterial(aMaterial_ptr,Color);
                 if ( aMaterial_ptr.get() != &aMaterial ) copy_if_copy_constructible(aMaterial, *aMaterial_ptr);

                 return std::make_tuple(); },
             R"#(None)#"  , py::arg("aMaterial"),  py::arg("Color")
          )
        .def("SetSpecularColorToMaterial",
             []( VrmlAPI_Writer &self , Vrml_Material& aMaterial,const opencascade::handle<Quantity_HArray1OfColor> & Color ){
                 opencascade::handle<Vrml_Material>  aMaterial_ptr; aMaterial_ptr = &aMaterial;

                 self.SetSpecularColorToMaterial(aMaterial_ptr,Color);
                 if ( aMaterial_ptr.get() != &aMaterial ) copy_if_copy_constructible(aMaterial, *aMaterial_ptr);

                 return std::make_tuple(); },
             R"#(None)#"  , py::arg("aMaterial"),  py::arg("Color")
          )
        .def("SetEmissiveColorToMaterial",
             []( VrmlAPI_Writer &self , Vrml_Material& aMaterial,const opencascade::handle<Quantity_HArray1OfColor> & Color ){
                 opencascade::handle<Vrml_Material>  aMaterial_ptr; aMaterial_ptr = &aMaterial;

                 self.SetEmissiveColorToMaterial(aMaterial_ptr,Color);
                 if ( aMaterial_ptr.get() != &aMaterial ) copy_if_copy_constructible(aMaterial, *aMaterial_ptr);

                 return std::make_tuple(); },
             R"#(None)#"  , py::arg("aMaterial"),  py::arg("Color")
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions
// ./opencascade/VrmlAPI.hxx
// ./opencascade/VrmlAPI_CafReader.hxx
// ./opencascade/VrmlAPI_RepresentationOfShape.hxx
// ./opencascade/VrmlAPI_Writer.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
