import torch
import torch.nn.functional as F

from torch_geometric.nn import FastRGCNConv


class RGCN(torch.nn.Module):
    def __init__(self, in_channels, out_channels, num_relations):
        super().__init__()
        self.conv1 = FastRGCNConv(in_channels, 16, num_relations, num_bases=30)
        self.conv2 = FastRGCNConv(16, out_channels, num_relations,
                                  num_bases=30)

    def forward(self, data):
        edge_index, edge_type = data.edge_index, data.edge_type
        x = F.relu(self.conv1(None, edge_index, edge_type))
        x = self.conv2(x, edge_index, edge_type)
        return F.log_softmax(x, dim=1)
