% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obtainEnvironmentPath.R
\name{obtainEnvironmentPath}
\alias{obtainEnvironmentPath}
\title{Obtain the environment path}
\usage{
obtainEnvironmentPath(env)
}
\arguments{
\item{env}{A \linkS4class{BasiliskEnvironment} object specifying the environment.
Alternatively a string containing a path to an existing environment.}
}
\value{
String containing the path to an instantiated Conda environment.

For a BasiliskEnvironment \code{env}, the function will also lazily create the environment if \code{useSystemDir()} returns \code{FALSE}
and the environment does not already exist.
}
\description{
Obtain a path to a Conda environment, lazily installing it if necessary.
}
\examples{
if (.Platform$OS.type != "windows") {
 \dontshow{basilisk.utils::installConda()}

 tmploc <- file.path(tempdir(), "my_package_A")
 if (!file.exists(tmploc)) {
     setupBasiliskEnv(tmploc, c('pandas=1.4.3'))
 }
 obtainEnvironmentPath(tmploc)

 env <- BasiliskEnvironment("test_env", "basilisk", 
     packages=c("scikit-learn=1.1.1", "pandas=1.43.1"))
 \dontrun{obtainEnvironmentPath(env)}
}
}
\author{
Aaron Lun
}
