% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colAvgsPerRowSet.R, R/rowAvgsPerColSet.R
\name{colAvgsPerRowSet,DelayedMatrix-method}
\alias{colAvgsPerRowSet,DelayedMatrix-method}
\alias{rowAvgsPerColSet,DelayedMatrix-method}
\title{Calculates for each row (column) a summary statistic for equally sized
subsets of columns (rows)}
\usage{
\S4method{colAvgsPerRowSet}{DelayedMatrix}(
  X,
  W = NULL,
  cols = NULL,
  S,
  FUN = colMeans,
  ...,
  force_block_processing = FALSE,
  na.rm = NA,
  tFUN = FALSE
)

\S4method{rowAvgsPerColSet}{DelayedMatrix}(
  X,
  W = NULL,
  rows = NULL,
  S,
  FUN = rowMeans,
  ...,
  force_block_processing = FALSE,
  na.rm = NA,
  tFUN = FALSE
)
}
\arguments{
\item{X}{A NxM \linkS4class{DelayedMatrix}.}

\item{W}{An optional numeric \code{NxM} matrix of weights.}

\item{S}{An \link{integer} \code{KxJ} matrix that specifying the \code{J} subsets. Each
column hold \code{K} column (row) indices for the corresponding subset. The
range of values is [1, M] ([1,N]).}

\item{FUN}{A row-by-row (column-by-column) summary statistic function. It is
applied to to each column (row) subset of \code{X} that is specified by \code{S}.}

\item{...}{Additional arguments passed to specific methods.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{na.rm}{(logical) Argument passed to \code{FUN()} as \code{na.rm = na.rm}.
If \code{NA} (default), then \code{na.rm = TRUE} is used if \code{X} or \code{S} holds missing values,
otherwise \code{na.rm = FALSE}.}

\item{tFUN}{If \code{TRUE}, \code{X} is transposed before it is passed to \code{FUN}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset (and/or
columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}
}
\value{
Returns a numeric \code{JxN} (\code{MxJ}) matrix.
}
\description{
Calculates for each row (column) a summary statistic for equally sized
subsets of columns (rows).
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowAvgsPerColSet}} /
\code{matrixStats::\link[matrixStats]{colAvgsPerRowSet}}.
}
\examples{
# A DelayedMatrix with a 'DataFrame' seed
dm_DF <- DelayedArray(S4Vectors::DataFrame(C1 = rep(1L, 5),
                                           C2 = as.integer((0:4) ^ 2),
                                           C3 = seq(-5L, -1L, 1L)))
colAvgsPerRowSet(dm_DF, S = matrix(1:2, ncol = 2))

rowAvgsPerColSet(dm_DF, S = matrix(1:2, ncol = 1))
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowAvgsPerColSet]{rowAvgsPerColSet}()}
and \code{matrixStats::\link[matrixStats:rowAvgsPerColSet]{colAvgsPerRowSet}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
}
}
\author{
Peter Hickey
}
