% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/337-extractDrugMomentOfInertia.R
\name{extractDrugMomentOfInertia}
\alias{extractDrugMomentOfInertia}
\title{Descriptor that Calculates the Principal Moments of
Inertia and Ratios of the Principal Moments}
\usage{
extractDrugMomentOfInertia(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns 7 columns named
\code{MOMI.X}, \code{MOMI.Y}, \code{MOMI.Z},
\code{MOMI.XY}, \code{MOMI.XZ}, \code{MOMI.YZ}, \code{MOMI.R}:
\itemize{
\item \code{MOMI.X} - MI along X axis
\item \code{MOMI.Y} - MI along Y axis
\item \code{MOMI.Z} - MI along Z axis
\item \code{MOMI.XY} - X/Y
\item \code{MOMI.XZ} - X/Z
\item \code{MOMI.YZ} - Y/Z
\item \code{MOMI.R} - Radius of gyration
}
One important aspect of the algorithm is that if the eigenvalues
of the MI tensor are below \code{1e-3},
then the ratio's are set to a default of 1000.
}
\description{
Descriptor that Calculates the Principal Moments of
Inertia and Ratios of the Principal Moments
}
\details{
A descriptor that calculates the moment of inertia and radius of gyration.
Moment of inertia (MI) values characterize the mass distribution of a molecule.
Related to the MI values, ratios of the MI values along the three principal
axes are also well know modeling variables.
This descriptor calculates the MI values along the
X, Y and Z axes as well as the ratio's X/Y, X/Z and Y/Z.
Finally it also calculates the radius of
gyration of the molecule.
}
\examples{
sdf = system.file('sysdata/OptAA3d.sdf', package = 'Rcpi')
\donttest{
mol = readMolFromSDF(sdf)
dat = extractDrugMomentOfInertia(mol)
head(dat)}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Inertia}
\keyword{Moment}
\keyword{extractDrugMomentOfInertia}
