% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRLE.R
\name{plotRLE}
\alias{plotRLE}
\alias{plotRLE,SingleCellExperiment-method}
\title{Plot relative log expression}
\usage{
plotRLE(
  object,
  exprs_values = "logcounts",
  exprs_logged = TRUE,
  style = "minimal",
  legend = TRUE,
  ordering = NULL,
  colour_by = NULL,
  by_exprs_values = exprs_values,
  BPPARAM = BiocParallel::bpparam(),
  ...
)
}
\arguments{
\item{object}{A SingleCellExperiment object.}

\item{exprs_values}{A string or integer scalar specifying the expression matrix in \code{object} to use.}

\item{exprs_logged}{A logical scalar indicating whether the expression matrix is already log-transformed.
If not, a log2-transformation (+1) will be performed prior to plotting.}

\item{style}{String defining the boxplot style to use, either \code{"minimal"} (default) or \code{"full"}; see Details.}

\item{legend}{Logical scalar specifying whether a legend should be shown.}

\item{ordering}{A vector specifying the ordering of cells in the RLE plot.
This can be useful for arranging cells by experimental conditions or batches.}

\item{colour_by}{Specification of a column metadata field or a feature to colour by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{by_exprs_values}{A string or integer scalar specifying which assay to obtain expression values from,
for use in point aesthetics - see the \code{exprs_values} argument in \code{?\link{retrieveCellInfo}}.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object to be used to parallelise operations using \code{\link{DelayedArray}}.}

\item{...}{further arguments passed to \code{\link[ggplot2]{geom_boxplot}} when \code{style="full"}.}
}
\value{
A ggplot object
}
\description{
Produce a relative log expression (RLE) plot of one or more transformations of cell expression values.
}
\details{
Relative log expression (RLE) plots are a powerful tool for visualising unwanted variation in high dimensional data. 
These plots were originally devised for gene expression data from microarrays but can also be used on single-cell expression data.
RLE plots are particularly useful for assessing whether a procedure aimed at removing unwanted variation (e.g., scaling normalisation) has been successful. 

If style is \dQuote{full}, the usual \pkg{ggplot2} boxplot is created for each cell.
Here, the box shows the inter-quartile range and whiskers extend no more than 1.5 times the IQR from the hinge (the 25th or 75th percentile).
Data beyond the whiskers are called outliers and are plotted individually. 
The median (50th percentile) is shown with a white bar.
This approach is detailed and flexible, but can take a long time to plot for large datasets.

If style is \dQuote{minimal}, a Tufte-style boxplot is created for each cell.
Here, the median is shown with a circle, the IQR in a grey line, and \dQuote{whiskers} (as defined above) for the plots are shown with coloured lines. 
No outliers are shown for this plot style.
This approach is more succinct and faster for large numbers of cells.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)

plotRLE(example_sce, colour_by = "Mutation_Status", style = "minimal")

plotRLE(example_sce, colour_by = "Mutation_Status", style = "full",
       outlier.alpha = 0.1, outlier.shape = 3, outlier.size = 0)

}
\references{
Gandolfo LC, Speed TP (2017). 
RLE plots: visualising unwanted variation in high dimensional data. 
\emph{arXiv}.
}
\author{
Davis McCarthy,
with modifications by Aaron Lun
}
