% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_nzv.R
\name{freq_cut}
\alias{freq_cut}
\alias{unique_cut}
\title{Near-zero variance parameters}
\usage{
freq_cut(range = c(5, 25), trans = NULL)

unique_cut(range = c(0, 100), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
These parameters control the specificity of the filter for near-zero
variance parameters in \code{recipes::step_nzv()}.
}
\details{
Smaller values of \code{freq_cut()} and \code{unique_cut()} make the filter less
sensitive.
}
\examples{
freq_cut()
unique_cut()
}
