% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.R
\name{is_empty}
\alias{is_empty}
\title{Check if repository is empty}
\usage{
is_empty(repo = ".")
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}
}
\value{
\code{TRUE} if repository is empty else \code{FALSE}.
}
\description{
Check if repository is empty
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Check if it's an empty repository
is_empty(repo)

## Commit a file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Check if it's an empty repository
is_empty(repo)
}
}
