% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue.R, R/sql.R
\name{glue_collapse}
\alias{glue_collapse}
\alias{glue_sql_collapse}
\title{Collapse a character vector}
\usage{
glue_collapse(x, sep = "", width = Inf, last = "")

glue_sql_collapse(x, sep = "", width = Inf, last = "")
}
\arguments{
\item{x}{The character vector to collapse.}

\item{sep}{a character string to separate the terms.  Not
    \code{\link[base]{NA_character_}}.}

\item{width}{The maximum string width before truncating with \code{...}.}

\item{last}{String used to separate the last two items if \code{x} has at least
2 items.}
}
\value{
Always returns a length-1 glue object, as created by \code{\link[=as_glue]{as_glue()}}.
}
\description{
\code{glue_collapse()} collapses a character vector of any length into a length 1 vector.
\code{glue_sql_collapse()} does the same but returns a \verb{[DBI::SQL()]}
object rather than a glue object.
}
\examples{
glue_collapse(glue("{1:10}"))

# Wide values can be truncated
glue_collapse(glue("{1:10}"), width = 5)

glue_collapse(1:4, ", ", last = " and ")
}
