% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contest.R
\name{contestMD.lmerModLmerTest}
\alias{contestMD.lmerModLmerTest}
\alias{calcSatterth}
\alias{contestMD.lmerMod}
\title{Multiple Degrees-of-Freedom Contrast Tests}
\usage{
\method{contestMD}{lmerModLmerTest}(
  model,
  L,
  rhs = 0,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  eps = sqrt(.Machine$double.eps),
  ...
)

calcSatterth(model, L)

\method{contestMD}{lmerMod}(
  model,
  L,
  rhs = 0,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  eps = sqrt(.Machine$double.eps),
  ...
)
}
\arguments{
\item{model}{a model object fitted with \code{lmer} from package
\pkg{lmerTest}, i.e., an object of class \code{\link{lmerModLmerTest}}.}

\item{L}{a contrast matrix with nrow >= 1 and ncol ==
\code{length(fixef(model))}.}

\item{rhs}{right-hand-side of the statistical test, i.e. the hypothesized
value. A numeric vector of length \code{nrow(L)} or a numeric scalar.}

\item{ddf}{the method for computing the denominator degrees of freedom and
F-statistics. \code{ddf="Kenward-Roger"} uses Kenward-Roger's method.}

\item{eps}{tolerance on eigenvalues to determine if an eigenvalue is
positive. The number of positive eigenvalues determine the rank of
L and the numerator df of the F-test.}

\item{...}{currently not used.}
}
\value{
a \code{data.frame} with one row and columns with \code{"Sum Sq"},
\code{"Mean Sq"}, \code{"F value"}, \code{"NumDF"} (numerator df),
\code{"DenDF"} (denominator df) and \code{"Pr(>F)"} (p-value).
}
\description{
Compute the multi degrees-of-freedom test in a linear mixed model fitted
by \code{\link{lmer}}. The contrast (L) specifies a linear function of the
mean-value parameters, beta. Satterthwaite's method is used to compute the
denominator df for the F-test.
}
\details{
The F-value and associated p-value is for the hypothesis
\eqn{L \beta = \mathrm{rhs}}{L \beta = rhs} in which rhs may be non-zero
and \eqn{\beta} is \code{fixef(model)}.

Note: NumDF = row-rank(L) is determined automatically so row rank-deficient L
are allowed. One-dimensional contrasts are also allowed (L has 1 row).
}
\examples{

data("sleepstudy", package="lme4")
fm <- lmer(Reaction ~ Days + I(Days^2) + (1|Subject) + (0+Days|Subject),
           sleepstudy)

# Define 2-df contrast - since L has 2 (linearly independent) rows
# the F-test is on 2 (numerator) df:
L <- rbind(c(0, 1, 0), # Note: ncol(L) == length(fixef(fm))
           c(0, 0, 1))

# Make the 2-df F-test of any effect of Days:
contestMD(fm, L)

# Illustrate rhs argument:
contestMD(fm, L, rhs=c(5, .1))

# Make the 1-df F-test of the effect of Days^2:
contestMD(fm, L[2, , drop=FALSE])
# Same test, but now as a t-test instead:
contest1D(fm, L[2, , drop=TRUE])

}
\seealso{
\code{\link[=contest.lmerModLmerTest]{contest}} for a flexible and
general interface to tests of contrasts among fixed-effect parameters.
\code{\link[=contest1D.lmerModLmerTest]{contest1D}} is a direct interface for
tests of 1-dimensional contrasts.
}
\author{
Rune Haubo B. Christensen
}
