% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instants.r
\name{make_datetime}
\alias{make_datetime}
\alias{make_date}
\title{Efficient creation of date-times from numeric representations}
\usage{
make_datetime(year = 1970L, month = 1L, day = 1L, hour = 0L, min = 0L,
  sec = 0, tz = "UTC")

make_date(year = 1970L, month = 1L, day = 1L)
}
\arguments{
\item{year}{numeric year}

\item{month}{numeric month}

\item{day}{numeric day}

\item{hour}{numeric hour}

\item{min}{numeric minute}

\item{sec}{numeric second}

\item{tz}{time zone. Defaults to UTC.}
}
\description{
\code{make_datetime()} is a very fast drop-in replacement for
\code{\link[base:ISOdate]{base::ISOdate()}} and \code{\link[base:ISOdatetime]{base::ISOdatetime()}}. \code{make_date()} produces
objects of class \code{Date}.
}
\details{
Input vectors are silently recycled. All inputs except \code{sec} are
silently converted to integer vectors; \code{sec} can be either integer or
double.
}
\examples{
make_datetime(year = 1999, month = 12, day = 22, sec = 10)
make_datetime(year = 1999, month = 12, day = 22, sec = c(10, 11))
}
