% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ddf_Lb.R
\name{get_ddf_Lb}
\alias{Lb_ddf}
\alias{ddf_Lb}
\alias{get_Lb_ddf}
\alias{get_Lb_ddf.lmerMod}
\alias{get_ddf_Lb}
\alias{get_ddf_Lb.lmerMod}
\title{Adjusted denomintor degress freedom for linear estimate for linear
    mixed model.}
\usage{
get_Lb_ddf(object, L)

\method{get_Lb_ddf}{lmerMod}(object, L)

Lb_ddf(L, V0, Vadj)

get_ddf_Lb(object, Lcoef)

\method{get_ddf_Lb}{lmerMod}(object, Lcoef)

ddf_Lb(VVa, Lcoef, VV0 = VVa)
}
\arguments{
\item{object}{A linear mixed model object.}

\item{L}{A vector with the same length as \code{fixef(object)} or a matrix
with the same number of columns as the length of \code{fixef(object)}}

\item{V0, Vadj}{Unadjusted and adjusted covariance matrix for the fixed
effects parameters. Undjusted covariance matrix is obtained with
\code{vcov()} and adjusted with \code{vcovAdj()}.}

\item{Lcoef}{Linear contrast matrix}

\item{VVa}{Adjusted covariance matrix}

\item{VV0}{Unadjusted covariance matrix}
}
\value{
Adjusted degrees of freedom (adjusment made by a Kenward-Roger
    approximation).
}
\description{
Get adjusted denomintor degress freedom for testing Lb=0 in a
    linear mixed model where L is a restriction matrix.
}
\examples{

(fmLarge <- lmer(Reaction ~ Days + (Days|Subject), sleepstudy))
## removing Days
(fmSmall <- lmer(Reaction ~ 1 + (Days|Subject), sleepstudy))
anova(fmLarge,fmSmall)

KRmodcomp(fmLarge, fmSmall)  ## 17 denominator df's
get_Lb_ddf(fmLarge, c(0,1)) ## 17 denominator df's

# Notice: The restriction matrix L corresponding to the test above
# can be found with
L <- model2restrictionMatrix(fmLarge, fmSmall)
L

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\references{
Ulrich Halekoh, Søren Højsgaard (2014)., A Kenward-Roger
    Approximation and Parametric Bootstrap Methods for Tests in Linear Mixed
    Models - The R Package pbkrtest., Journal of Statistical Software,
    58(10), 1-30., \url{http://www.jstatsoft.org/v59/i09/}
}
\seealso{
\code{\link{KRmodcomp}}, \code{\link{vcovAdj}},
    \code{\link{model2restrictionMatrix}},
    \code{\link{restrictionMatrix2model}}
}
\keyword{inference}
\keyword{models}

