% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{order}
\alias{order}
\alias{order.default}
\alias{order.data.frame}
\alias{order.matrix}
\alias{sort.data.frame}
\title{Implement the \code{\link{sort}} and \code{\link{order}} methods for
\code{\link{data.frame}} and \code{\link{matrix}}, sorting it in
lexicographic order.}
\usage{
order(..., na.last = TRUE, decreasing = FALSE)

\method{order}{default}(..., na.last = TRUE, decreasing = FALSE)

\method{order}{data.frame}(..., na.last = TRUE, decreasing = FALSE)

\method{order}{matrix}(..., na.last = TRUE, decreasing = FALSE)

\method{sort}{data.frame}(x, decreasing = FALSE, ...)
}
\arguments{
\item{\dots}{Ignored for \code{sort}. For \code{order}, first argument is
the data frame to be ordered. (This is needed for compatibility with
\code{\link[base]{order}}.)}

\item{na.last}{See \code{\link[base]{order}} documentation.}

\item{decreasing}{Whether to sort in decreasing order.}

\item{x}{A \code{\link{data.frame}} to sort.}
}
\value{
For \code{sort}, a data frame, sorted lexicographically. For
\code{order}, a permutation \code{I} (of a vector \code{1:nrow(x)}) such
that \code{x[I,,drop=FALSE]} equals \code{x} ordered lexicographically.
}
\description{
These function return a data frame sorted in lexcographic order or a
permutation that will rearrange it into lexicographic order: first by the
first column, ties broken by the second, remaining ties by the third, etc..
}
\examples{

data(iris)

head(iris)

head(order(iris))

head(sort(iris))

stopifnot(identical(sort(iris),iris[order(iris),]))
}
\seealso{
\code{\link{data.frame}}, \code{\link{sort}}, \code{\link{order}},
\code{\link{matrix}}
}
\keyword{manip}
