% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\docType{data}
\name{graph-context}
\alias{graph-context}
\alias{.graph_context}
\alias{.register_graph_context}
\alias{.free_graph_context}
\title{Register a graph context for the duration of the current frame}
\format{
An object of class \code{ContextBuilder} (inherits from \code{R6}) of length 12.
}
\usage{
.graph_context

.register_graph_context(graph, free = FALSE, env = parent.frame())

.free_graph_context(env = parent.frame())
}
\arguments{
\item{graph}{A \code{tbl_graph} object}

\item{free}{Should the active state of the graph be ignored?}

\item{env}{The environment where the context should be active}
}
\description{
This function sets the provided graph to be the context for tidygraph
algorithms, such as e.g. \code{\link[=node_is_center]{node_is_center()}}, for the duration of the current
environment. It automatically removes the graph once the environment exits.
}
\keyword{datasets}
\keyword{internal}
