% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browser.R
\name{browser_print}
\alias{browser_print}
\title{Print a web page to PDF/PNG/JPEG}
\usage{
browser_print(
  url,
  output = ".pdf",
  args = "default",
  window_size = c(1280, 1024),
  browser = env_option("xfun.browser", find_browser())
)
}
\arguments{
\item{url}{Path or URL to the page to be printed.}

\item{output}{An output filename. If only an extension is provided, the
filename will be inferred from \code{url} via \code{\link[=url_filename]{url_filename()}}. Only \code{.pdf},
\code{.png}, and \code{.jpeg} are supported.}

\item{args}{Command-line arguments to be passed to the headless browser. The
default arguments can be found in \code{xfun:::browser_args()}. You may pass
additional arguments on top of these via, e.g., \code{c('default', '--no-pdf-header-footer')}, or completely override the default arguments by
providing a vector of other arguments.}

\item{window_size}{The browser window size when printing to PNG/JPEG.}

\item{browser}{Path to the web browser. By default, the browser is found via
\code{xfun:::find_browser()}. If it cannot be found, you may set the global
option \code{options(xfun.browser = )} or environment variable \code{R_XFUN_BROWSER}
to the path of the browser, or simply pass the path to the \code{browser}
argument.}
}
\value{
The \code{output} path if the web page is successfully printed.
}
\description{
Print a web page via a headless browser such as Chromium or Google Chrome.
}
\examples{\dontshow{if (interactive()) \{}
xfun::browser_print("https://www.r-project.org")
\dontshow{\}}
}
