# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from RadiusManager.idl.

use strict;

package Raritan::RPC::auth::RadiusManager;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "auth.RadiusManager:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::auth::RadiusManager::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant ERR_INVALID_CFG => 1;

use constant ERR_SERVER_UNSPECIFIED => 2;

use constant ERR_INVALID_SHARED_SECRET => 3;

use constant ERR_SERVER_UNREACHABLE => 4;

use constant ERR_AUTHENTICATION_FAILED => 5;

use constant ERR_NO_ROLES => 6;

use constant ERR_NO_KNOWN_ROLES => 7;

use Raritan::RPC::radius::ServerSettings;

sub getRadiusServers($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getRadiusServers', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::radius::ServerSettings::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

use Raritan::RPC::radius::ServerSettings;

sub setRadiusServers($$) {
    my ($self, $serverList) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'serverList'} = [];
    for (my $i0 = 0; $i0 <= $#{$serverList}; $i0++) {
        $args->{'serverList'}->[$i0] = Raritan::RPC::radius::ServerSettings::encode($serverList->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setRadiusServers', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::radius::ServerSettings;

sub testRadiusServer($$$$) {
    my ($self, $username, $password, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'username'} = "$username";
    $args->{'password'} = "$password";
    $args->{'settings'} = Raritan::RPC::radius::ServerSettings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'testRadiusServer', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('auth.RadiusManager', 1, 0, 0, 'Raritan::RPC::auth::RadiusManager');
1;
