// https://github.com/rust-lang/rust-clippy/issues/12917
#![warn(clippy::doc_lazy_continuation)]

/// This is a constant.
///
/// The meaning of which should not be explained.
pub const A: i32 = 42;

/// This is another constant, no longer used.
///
/// This block of documentation has a long
/// explanation and derivation to explain
/// why it is what it is, and how it's used.
///
/// It is left here for historical reasons, and
/// for reference.
///
/// Reasons it's great:
///  - First reason
///  - Second reason
//pub const B: i32 = 1337;

/// This is yet another constant.
///
/// This has a similar fate as `B`.
///
/// Reasons it's useful:
///  1. First reason
///  2. Second reason
//pub const C: i32 = 8008;

/// This is still in use.
pub const D: i32 = 20;

/// > blockquote code path

/// bottom text
pub const E: i32 = 20;

/// > blockquote code path
#[repr(C)]
/// bottom text
pub struct Foo(i32);
