/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.installer.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;

public class InstallUtil {
    public static final short kSystemDomain = -32766;
    public static final short kLocalDomain = -32765;
    public static final short kNetworkDomain = -32764;
    public static final short kUserDomain = -32763;
    public static final short kClassicDomain = -32762;
    public static final int kPreferenceFolder = 1886545254;
    public static final int kApplicationSupportFolder = 1634956656;
    public static final int kSharedUserDataFolder = 1935958388;
    public static final int kApplicationFolder = 1634758771;
    public static final int kExtensionFolder = 1702392942;
    public static final int kDomainLibraryFolder = 1684826466;

    public static String getSharedFolderPath() {
        return InstallUtil.getFolderPath(1935958388);
    }

    public static String getApplicationFolderPath() {
        return InstallUtil.getFolderPath(1634758771);
    }

    public static String getGlobalApplicationFolderPath() {
        return InstallUtil.getFolderPath((short)-32766, 1634758771);
    }

    public static String getFolderPath(int folderKind) {
        try {
            Class<?> clazz = Class.forName("com.apple.eio.FileManager");
            Method m = clazz.getMethod("findFolder", Integer.TYPE);
            return (String)m.invoke(null, new Integer(folderKind));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getFolderPath(short domain, int folderKind) {
        try {
            Class<?> clazz = Class.forName("com.apple.eio.FileManager");
            Method m = clazz.getMethod("findFolder", Short.TYPE, Integer.TYPE);
            return (String)m.invoke(null, new Short(domain), new Integer(folderKind));
        }
        catch (Throwable t) {
            System.out.println("getFolderPath Throwable " + t);
            return null;
        }
    }

    public static void copyResourceToFile(String absResPath, File file) {
        try {
            InputStream is = InstallUtil.class.getResourceAsStream(absResPath);
            byte[] buffer = new byte[4096];
            int rb = 0;
            if (is != null) {
                FileOutputStream fos = new FileOutputStream(file);
                while ((rb = is.read(buffer, 0, buffer.length)) > 0) {
                    fos.write(buffer, 0, rb);
                }
                fos.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void installPart(Preferences sysPref, Preferences checkPref, String resPathName, File fileToInstall) {
        if (fileToInstall == null || resPathName == null) {
            return;
        }
        boolean needInstall = checkPref == null;
        char separator = File.separatorChar;
        long prevLength = 0L;
        File fooFile = new File(resPathName);
        String resName = fooFile.getName();
        String resParentName = fooFile.getParent();
        if (separator != '/') {
            resParentName = resParentName.replace(separator, '/');
        }
        Preferences installPref = sysPref.node(resParentName);
        if (!needInstall) {
            try {
                prevLength = fileToInstall.length();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        boolean bl = needInstall = prevLength == 0L;
        if (!needInstall) {
            String checkResParentName = resParentName.substring(1);
            Preferences checkInstallPref = null;
            try {
                checkInstallPref = checkPref.nodeExists(checkResParentName) ? checkPref.node(checkResParentName) : null;
            }
            catch (Throwable t) {
                checkInstallPref = null;
            }
            long installValueLength = installPref.getLong(resName, 0L);
            long checkValueLength = checkInstallPref == null ? 0L : checkInstallPref.getLong(resName, 0L);
            boolean bl2 = needInstall = checkValueLength != 0L && (installValueLength != prevLength || checkValueLength != prevLength || checkValueLength != installValueLength);
        }
        if (!needInstall) {
            System.out.println("File " + fileToInstall + " is uptodate");
        } else {
            System.out.println("copy file " + fileToInstall);
            InstallUtil.copyResourceToFile(resPathName, fileToInstall);
            try {
                long newLength = fileToInstall.length();
                installPref.putLong(resName, newLength);
                installPref.flush();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }
}

