/*
    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) 2011  Guillaume DE BURE <guillaume.debure@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "simulationwidget.h"

#include <Plasma/Label>
#include <Plasma/ToolButton>

#include "skgmainpanel.h"
#include "skgdocumentbank.h"

SimulationWidget::SimulationWidget(QObject* iParent, const QVariantList& args): Applet(iParent, args)
{
    // This signalMapper will be used to open the account tab when clicking on the
    // corresponding button
    signalMapper = new QSignalMapper(this);
    connect(signalMapper, SIGNAL(mapped(QString)), this, SLOT(openAccountTab(QString)));
}

SimulationWidget::~SimulationWidget()
{}

void SimulationWidget::init()
{
    widgetLayout = new QGraphicsLinearLayout(Qt::Vertical);
    setLayout(widgetLayout);

    Plasma::DataEngine* engine = dataEngine("skgdataengine");
    if (engine->isValid())  engine->connectSource("Interests", this);
}

void SimulationWidget::dataUpdated(const QString& sourceName, const Plasma::DataEngine::Data& engineData)
{
    if (sourceName != "Interests") return;

    QHash<QString, QStringList> listData;
    for (int i = 0 ; i < engineData.keys().count() ; ++i) {
        QString keyId = engineData.keys().at(i);
        QVariant valuesVariant = engineData.value(keyId);
        QStringList values = valuesVariant.value<QStringList>();

        listData[keyId] = values;
    }

    // Get the current document
    SKGMainPanel* panel = SKGMainPanel::getMainPanel();
    doc = qobject_cast<SKGDocumentBank*> (panel->getDocument());

    // Get the primary unit
    primary = doc->getPrimaryUnit();

    // Initialisation
    int nb = widgetLayout->count();
    for (int i = 0; widgetLayout && i < nb; ++i) {
        QGraphicsLayoutItem* item = widgetLayout->itemAt(0);
        if (item) {
            widgetLayout->removeAt(0);
            delete item;
        }
    }

    for (int i = 0; i < listData.count(); ++i) {
        // Operation id
        QString keyId = listData.keys().at(i);

        QStringList values = listData[keyId];

        QString account = values[0];

        QGraphicsLinearLayout* lineLayout = new QGraphicsLinearLayout(Qt::Horizontal);
        widgetLayout->addItem(lineLayout);

        Plasma::ToolButton* accountButton = new Plasma::ToolButton();
        accountButton->setText(account);
        lineLayout->addItem(accountButton);

        // Open the account in a new tab when clicking on the account
        connect(accountButton, SIGNAL(clicked()), signalMapper, SLOT(map()));
        signalMapper->setMapping(accountButton, account);

        lineLayout->addStretch(20);

        Plasma::Label* interestLabel = new Plasma::Label();
        interestLabel->setText(doc->formatMoney(SKGServices::stringToDouble(values.at(1)), primary));
        lineLayout->addItem(interestLabel);
    }

    widgetLayout->addStretch(20);
}

void SimulationWidget::openAccountTab(QString accountName)
{
    // And finally, open a new tab for this account
    SKGMainPanel::getMainPanel()->openPage("skg://skrooge_operation_plugin/?account=" % SKGServices::encodeForUrl(accountName));
}

#include "simulationwidget.moc"
