/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.db.DBColumn;
import adql.db.DBIdentifier;
import adql.db.DBTable;
import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLSet;
import adql.query.TextPosition;
import java.util.NoSuchElementException;

public class WithItem
implements ADQLObject {
    public static final LanguageFeature FEATURE = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adql-common-table", "WITH", true, "A Common Table Expression lets create a temporary named result set that can be referred to elsewhere in a main query.");
    protected String label;
    protected boolean caseSensitive = false;
    protected ADQLSet query;
    protected TextPosition position = null;
    protected DBTable dbLink = null;

    public WithItem(String label, ADQLSet query) {
        if (label == null || label.trim().isEmpty()) {
            throw new NullPointerException("Missing label of the WITH item!");
        }
        if (query == null) {
            throw new NullPointerException("Missing query of the WITH item!");
        }
        this.setLabel(label);
        this.query = query;
    }

    public WithItem(WithItem toCopy) {
        this.label = toCopy.label;
        this.query = toCopy.query;
        this.position = toCopy.position;
    }

    @Override
    public final String getName() {
        return this.label;
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) throws NullPointerException {
        String tmp = DBIdentifier.normalize(label);
        if (tmp == null) {
            throw new NullPointerException("Missing CTE's label! (CTE = WITH's query)");
        }
        this.label = tmp;
        this.caseSensitive = DBIdentifier.isDelimited(label);
    }

    public final boolean isLabelCaseSensitive() {
        return this.caseSensitive;
    }

    public final void setLabelCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public final ADQLSet getQuery() {
        return this.query;
    }

    public final void setQuery(ADQLSet query) {
        this.query = query;
    }

    public final DBTable getDBLink() {
        return this.dbLink;
    }

    public final void setDBLink(DBTable dbMeta) {
        this.dbLink = dbMeta;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition newPosition) {
        this.position = newPosition;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new WithItem(this);
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean queryReturned = false;

            @Override
            public ADQLObject next() {
                if (this.queryReturned) {
                    throw new NoSuchElementException("Iteration already finished! No more element available.");
                }
                this.queryReturned = true;
                return WithItem.this.query;
            }

            @Override
            public boolean hasNext() {
                return !this.queryReturned;
            }

            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (!this.queryReturned) {
                    throw new IllegalStateException("No iteration yet started!");
                }
                if (replacer == null) {
                    throw new UnsupportedOperationException("Impossible to remove the query from a WithItem object! You have to remove the WithItem from its ClauseWith for that.");
                }
                if (!(replacer instanceof ADQLSet)) {
                    throw new UnsupportedOperationException("Impossible to replace an ADQLSet by a " + replacer.getClass() + "!");
                }
                WithItem.this.query = (ADQLSet)replacer;
            }
        };
    }

    @Override
    public String toADQL() {
        return DBIdentifier.denormalize(this.label, this.caseSensitive) + " AS (\n" + this.query.toADQL() + "\n)";
    }

    public DBColumn[] getResultingColumns() {
        return this.query.getResultingColumns();
    }
}

