/* ====================================================================
 * Copyright (c) 2008  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "NullDiffInfoModel.h"
#include "DiffInfo.h"
#include "sublib/NullTextModel.h"

// sys
#include <assert.h>

static DiffInfos     NullDiffInfos;
static DiffInfo      NullDiffInfo( ctCommon, 0, BlockInfo() );
static NullTextModel NullModel;

NullDiffInfoModel::NullDiffInfoModel()
{
}

NullDiffInfoModel::~NullDiffInfoModel()
{
}

DiffInfos& NullDiffInfoModel::getInfos()
{
  return NullDiffInfos;
}

DiffInfo& NullDiffInfoModel::getInfo( int numBlock )
{
  return NullDiffInfo;
}

DiffInfo& NullDiffInfoModel::getDiffInfo( int numDiff )
{
  return NullDiffInfo;
}

const BlockInfo& NullDiffInfoModel::getBlockInfo( int numBlock )
{
  return NullDiffInfo.getBlockInfo();
}

const BlockInfo& NullDiffInfoModel::getDiffBlockInfo( int numDiff )
{
  return NullDiffInfo.getBlockInfo();
}

TextModel* NullDiffInfoModel::getModel( DiffInfoModel::DiffModel dm )
{
  return &NullModel;
}

int NullDiffInfoModel::getDiffCnt()
{
  return 0;
}

int NullDiffInfoModel::getConflictCnt()
{
  return 0;
}

int NullDiffInfoModel::setActiveDiff( int num )
{
  return 0;
}

int NullDiffInfoModel::getActiveDiff()
{
  return 0;
}

int NullDiffInfoModel::nextDiff()
{
  return 0;
}

int NullDiffInfoModel::prevDiff()
{
  return 0;
}

bool NullDiffInfoModel::hasPrevDiff()
{
  return false;
}

bool NullDiffInfoModel::hasNextDiff()
{
  return false;
}
