; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mtriple=powerpc64-unknown-unknown < %s | FileCheck %s \
; RUN:   -check-prefix=P9
; RUN: llc -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s \
; RUN:   -check-prefix=P8
; RUN: llc -mcpu=pwr7 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mtriple=powerpc64-unknown-unknown < %s | FileCheck %s \
; RUN:   -check-prefix=P7
; RUN: llc -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mtriple=powerpc-ibm-aix-xcoff < %s | FileCheck %s \
; RUN:   -check-prefix=P9-AIX32
; RUN: llc -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mtriple=powerpc-ibm-aix-xcoff < %s | FileCheck %s \
; RUN:   -check-prefix=P8-AIX32
; RUN: llc -mcpu=pwr7 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -mtriple=powerpc-ibm-aix-xcoff < %s | FileCheck %s \
; RUN:   -check-prefix=P7-AIX32

; v2f64
define dso_local void @test(ptr nocapture %c, ptr nocapture readonly %a) local_unnamed_addr {
; P9-LABEL: test:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r4, r4, 24
; P9-NEXT:    lxvdsx vs0, 0, r4
; P9-NEXT:    stxv vs0, 0(r3)
; P9-NEXT:    blr
;
; P8-LABEL: test:
; P8:       # %bb.0: # %entry
; P8-NEXT:    addi r4, r4, 24
; P8-NEXT:    lxvdsx vs0, 0, r4
; P8-NEXT:    stxvd2x vs0, 0, r3
; P8-NEXT:    blr
;
; P7-LABEL: test:
; P7:       # %bb.0: # %entry
; P7-NEXT:    addi r4, r4, 24
; P7-NEXT:    lxvdsx vs0, 0, r4
; P7-NEXT:    stxvd2x vs0, 0, r3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    addi r4, r4, 24
; P9-AIX32-NEXT:    lxvdsx vs0, 0, r4
; P9-AIX32-NEXT:    stxv vs0, 0(r3)
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    addi r4, r4, 24
; P8-AIX32-NEXT:    lxvdsx vs0, 0, r4
; P8-AIX32-NEXT:    stxvd2x vs0, 0, r3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    addi r4, r4, 24
; P7-AIX32-NEXT:    lxvdsx vs0, 0, r4
; P7-AIX32-NEXT:    stxvd2x vs0, 0, r3
; P7-AIX32-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds double, ptr %a, i64 3
  %0 = load double, ptr %arrayidx, align 8
  %splat.splatinsert.i = insertelement <2 x double> undef, double %0, i32 0
  %splat.splat.i = shufflevector <2 x double> %splat.splatinsert.i, <2 x double> undef, <2 x i32> zeroinitializer
  store <2 x double> %splat.splat.i, ptr %c, align 16
  ret void
}

; v4f32
define dso_local void @test2(ptr nocapture %c, ptr nocapture readonly %a) local_unnamed_addr {
; P9-LABEL: test2:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r4, r4, 12
; P9-NEXT:    lxvwsx vs0, 0, r4
; P9-NEXT:    stxv vs0, 0(r3)
; P9-NEXT:    blr
;
; P8-LABEL: test2:
; P8:       # %bb.0: # %entry
; P8-NEXT:    addi r4, r4, 12
; P8-NEXT:    lfiwzx f0, 0, r4
; P8-NEXT:    xxspltw vs0, vs0, 1
; P8-NEXT:    xxswapd vs0, vs0
; P8-NEXT:    stxvd2x vs0, 0, r3
; P8-NEXT:    blr
;
; P7-LABEL: test2:
; P7:       # %bb.0: # %entry
; P7-NEXT:    addi r4, r4, 12
; P7-NEXT:    lfiwzx f0, 0, r4
; P7-NEXT:    xxspltw vs0, vs0, 1
; P7-NEXT:    stxvw4x vs0, 0, r3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test2:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    addi r4, r4, 12
; P9-AIX32-NEXT:    lxvwsx vs0, 0, r4
; P9-AIX32-NEXT:    stxv vs0, 0(r3)
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test2:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    addi r4, r4, 12
; P8-AIX32-NEXT:    lfiwzx f0, 0, r4
; P8-AIX32-NEXT:    xxspltw vs0, vs0, 1
; P8-AIX32-NEXT:    stxvw4x vs0, 0, r3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test2:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    addi r4, r4, 12
; P7-AIX32-NEXT:    lfiwzx f0, 0, r4
; P7-AIX32-NEXT:    xxspltw vs0, vs0, 1
; P7-AIX32-NEXT:    stxvw4x vs0, 0, r3
; P7-AIX32-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds float, ptr %a, i64 3
  %0 = load float, ptr %arrayidx, align 4
  %splat.splatinsert.i = insertelement <4 x float> undef, float %0, i32 0
  %splat.splat.i = shufflevector <4 x float> %splat.splatinsert.i, <4 x float> undef, <4 x i32> zeroinitializer
  store <4 x float> %splat.splat.i, ptr %c, align 16
  ret void
}

; v4i32
define dso_local void @test3(ptr nocapture %c, ptr nocapture readonly %a) local_unnamed_addr {
; P9-LABEL: test3:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r4, r4, 12
; P9-NEXT:    lxvwsx vs0, 0, r4
; P9-NEXT:    stxv vs0, 0(r3)
; P9-NEXT:    blr
;
; P8-LABEL: test3:
; P8:       # %bb.0: # %entry
; P8-NEXT:    addi r4, r4, 12
; P8-NEXT:    lfiwzx f0, 0, r4
; P8-NEXT:    xxspltw vs0, vs0, 1
; P8-NEXT:    xxswapd vs0, vs0
; P8-NEXT:    stxvd2x vs0, 0, r3
; P8-NEXT:    blr
;
; P7-LABEL: test3:
; P7:       # %bb.0: # %entry
; P7-NEXT:    addi r4, r4, 12
; P7-NEXT:    lfiwzx f0, 0, r4
; P7-NEXT:    xxspltw vs0, vs0, 1
; P7-NEXT:    stxvw4x vs0, 0, r3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test3:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    addi r4, r4, 12
; P9-AIX32-NEXT:    lxvwsx vs0, 0, r4
; P9-AIX32-NEXT:    stxv vs0, 0(r3)
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test3:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    addi r4, r4, 12
; P8-AIX32-NEXT:    lfiwzx f0, 0, r4
; P8-AIX32-NEXT:    xxspltw vs0, vs0, 1
; P8-AIX32-NEXT:    stxvw4x vs0, 0, r3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test3:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    addi r4, r4, 12
; P7-AIX32-NEXT:    lfiwzx f0, 0, r4
; P7-AIX32-NEXT:    xxspltw vs0, vs0, 1
; P7-AIX32-NEXT:    stxvw4x vs0, 0, r3
; P7-AIX32-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 3
  %0 = load i32, ptr %arrayidx, align 4
  %splat.splatinsert.i = insertelement <4 x i32> undef, i32 %0, i32 0
  %splat.splat.i = shufflevector <4 x i32> %splat.splatinsert.i, <4 x i32> undef, <4 x i32> zeroinitializer
  store <4 x i32> %splat.splat.i, ptr %c, align 16
  ret void
}


; v2i64
define dso_local void @test4(ptr nocapture %c, ptr nocapture readonly %a) local_unnamed_addr {
; P9-LABEL: test4:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r4, r4, 24
; P9-NEXT:    lxvdsx vs0, 0, r4
; P9-NEXT:    stxv vs0, 0(r3)
; P9-NEXT:    blr
;
; P8-LABEL: test4:
; P8:       # %bb.0: # %entry
; P8-NEXT:    addi r4, r4, 24
; P8-NEXT:    lxvdsx vs0, 0, r4
; P8-NEXT:    stxvd2x vs0, 0, r3
; P8-NEXT:    blr
;
; P7-LABEL: test4:
; P7:       # %bb.0: # %entry
; P7-NEXT:    addi r4, r4, 24
; P7-NEXT:    lxvdsx vs0, 0, r4
; P7-NEXT:    stxvd2x vs0, 0, r3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test4:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lwz r5, 24(r4)
; P9-AIX32-NEXT:    lwz r4, 28(r4)
; P9-AIX32-NEXT:    stw r4, -16(r1)
; P9-AIX32-NEXT:    lwz r4, L..C0(r2) # %const.0
; P9-AIX32-NEXT:    stw r5, -32(r1)
; P9-AIX32-NEXT:    lxv v3, -16(r1)
; P9-AIX32-NEXT:    lxv v4, -32(r1)
; P9-AIX32-NEXT:    lxv v2, 0(r4)
; P9-AIX32-NEXT:    vperm v2, v4, v3, v2
; P9-AIX32-NEXT:    stxv v2, 0(r3)
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test4:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lwz r5, L..C0(r2) # %const.0
; P8-AIX32-NEXT:    lwz r6, 28(r4)
; P8-AIX32-NEXT:    lwz r4, 24(r4)
; P8-AIX32-NEXT:    stw r6, -16(r1)
; P8-AIX32-NEXT:    stw r4, -32(r1)
; P8-AIX32-NEXT:    addi r4, r1, -16
; P8-AIX32-NEXT:    lxvw4x v2, 0, r5
; P8-AIX32-NEXT:    addi r5, r1, -32
; P8-AIX32-NEXT:    lxvw4x v3, 0, r4
; P8-AIX32-NEXT:    lxvw4x v4, 0, r5
; P8-AIX32-NEXT:    vperm v2, v4, v3, v2
; P8-AIX32-NEXT:    stxvw4x v2, 0, r3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test4:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lwz r5, L..C0(r2) # %const.0
; P7-AIX32-NEXT:    lwz r6, 24(r4)
; P7-AIX32-NEXT:    lwz r4, 28(r4)
; P7-AIX32-NEXT:    stw r4, -16(r1)
; P7-AIX32-NEXT:    stw r6, -32(r1)
; P7-AIX32-NEXT:    lxvw4x v2, 0, r5
; P7-AIX32-NEXT:    addi r4, r1, -16
; P7-AIX32-NEXT:    addi r5, r1, -32
; P7-AIX32-NEXT:    lxvw4x v3, 0, r4
; P7-AIX32-NEXT:    lxvw4x v4, 0, r5
; P7-AIX32-NEXT:    vperm v2, v4, v3, v2
; P7-AIX32-NEXT:    stxvw4x v2, 0, r3
; P7-AIX32-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i64, ptr %a, i64 3
  %0 = load i64, ptr %arrayidx, align 8
  %splat.splatinsert.i = insertelement <2 x i64> undef, i64 %0, i32 0
  %splat.splat.i = shufflevector <2 x i64> %splat.splatinsert.i, <2 x i64> undef, <2 x i32> zeroinitializer
  store <2 x i64> %splat.splat.i, ptr %c, align 16
  ret void
}

; sext v2i64
define void @test5(ptr %a, ptr %in) {
; P9-LABEL: test5:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lfiwax f0, 0, r4
; P9-NEXT:    xxspltd vs0, f0, 0
; P9-NEXT:    stxv vs0, 0(r3)
; P9-NEXT:    blr
;
; P8-LABEL: test5:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lfiwax f0, 0, r4
; P8-NEXT:    xxspltd vs0, f0, 0
; P8-NEXT:    stxvd2x vs0, 0, r3
; P8-NEXT:    blr
;
; P7-LABEL: test5:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lfiwax f0, 0, r4
; P7-NEXT:    xxspltd vs0, f0, 0
; P7-NEXT:    stxvd2x vs0, 0, r3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test5:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lwz r4, 0(r4)
; P9-AIX32-NEXT:    srawi r5, r4, 31
; P9-AIX32-NEXT:    stw r4, -16(r1)
; P9-AIX32-NEXT:    lwz r4, L..C1(r2) # %const.0
; P9-AIX32-NEXT:    lxv v3, -16(r1)
; P9-AIX32-NEXT:    stw r5, -32(r1)
; P9-AIX32-NEXT:    lxv v4, -32(r1)
; P9-AIX32-NEXT:    lxv v2, 0(r4)
; P9-AIX32-NEXT:    vperm v2, v4, v3, v2
; P9-AIX32-NEXT:    stxv v2, 0(r3)
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test5:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lwz r5, L..C1(r2) # %const.0
; P8-AIX32-NEXT:    lwz r4, 0(r4)
; P8-AIX32-NEXT:    stw r4, -16(r1)
; P8-AIX32-NEXT:    srawi r4, r4, 31
; P8-AIX32-NEXT:    stw r4, -32(r1)
; P8-AIX32-NEXT:    lxvw4x v2, 0, r5
; P8-AIX32-NEXT:    addi r4, r1, -16
; P8-AIX32-NEXT:    addi r5, r1, -32
; P8-AIX32-NEXT:    lxvw4x v3, 0, r4
; P8-AIX32-NEXT:    lxvw4x v4, 0, r5
; P8-AIX32-NEXT:    vperm v2, v4, v3, v2
; P8-AIX32-NEXT:    stxvw4x v2, 0, r3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test5:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lwz r4, 0(r4)
; P7-AIX32-NEXT:    lwz r5, L..C1(r2) # %const.0
; P7-AIX32-NEXT:    srawi r6, r4, 31
; P7-AIX32-NEXT:    stw r4, -16(r1)
; P7-AIX32-NEXT:    addi r4, r1, -16
; P7-AIX32-NEXT:    stw r6, -32(r1)
; P7-AIX32-NEXT:    lxvw4x v2, 0, r5
; P7-AIX32-NEXT:    addi r5, r1, -32
; P7-AIX32-NEXT:    lxvw4x v3, 0, r4
; P7-AIX32-NEXT:    lxvw4x v4, 0, r5
; P7-AIX32-NEXT:    vperm v2, v4, v3, v2
; P7-AIX32-NEXT:    stxvw4x v2, 0, r3
; P7-AIX32-NEXT:    blr
entry:
  %0 = load i32, ptr %in, align 4
  %conv = sext i32 %0 to i64
  %splat.splatinsert.i = insertelement <2 x i64> poison, i64 %conv, i32 0
  %splat.splat.i = shufflevector <2 x i64> %splat.splatinsert.i, <2 x i64> poison, <2 x i32> zeroinitializer
  store <2 x i64> %splat.splat.i, ptr %a, align 16
  ret void
}

; zext v2i64
define void @test6(ptr %a, ptr %in) {
; P9-LABEL: test6:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lfiwzx f0, 0, r4
; P9-NEXT:    xxspltd vs0, f0, 0
; P9-NEXT:    stxv vs0, 0(r3)
; P9-NEXT:    blr
;
; P8-LABEL: test6:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lfiwzx f0, 0, r4
; P8-NEXT:    xxspltd vs0, f0, 0
; P8-NEXT:    stxvd2x vs0, 0, r3
; P8-NEXT:    blr
;
; P7-LABEL: test6:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lfiwzx f0, 0, r4
; P7-NEXT:    xxspltd vs0, f0, 0
; P7-NEXT:    stxvd2x vs0, 0, r3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test6:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lwz r4, 0(r4)
; P9-AIX32-NEXT:    li r5, 0
; P9-AIX32-NEXT:    stw r5, -32(r1)
; P9-AIX32-NEXT:    lxv v3, -32(r1)
; P9-AIX32-NEXT:    stw r4, -16(r1)
; P9-AIX32-NEXT:    lwz r4, L..C2(r2) # %const.0
; P9-AIX32-NEXT:    lxv v4, -16(r1)
; P9-AIX32-NEXT:    lxv v2, 0(r4)
; P9-AIX32-NEXT:    vperm v2, v3, v4, v2
; P9-AIX32-NEXT:    stxv v2, 0(r3)
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test6:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lwz r6, L..C2(r2) # %const.0
; P8-AIX32-NEXT:    lwz r4, 0(r4)
; P8-AIX32-NEXT:    li r5, 0
; P8-AIX32-NEXT:    stw r5, -32(r1)
; P8-AIX32-NEXT:    addi r5, r1, -16
; P8-AIX32-NEXT:    stw r4, -16(r1)
; P8-AIX32-NEXT:    addi r4, r1, -32
; P8-AIX32-NEXT:    lxvw4x v2, 0, r6
; P8-AIX32-NEXT:    lxvw4x v3, 0, r4
; P8-AIX32-NEXT:    lxvw4x v4, 0, r5
; P8-AIX32-NEXT:    vperm v2, v3, v4, v2
; P8-AIX32-NEXT:    stxvw4x v2, 0, r3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test6:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lwz r5, L..C2(r2) # %const.0
; P7-AIX32-NEXT:    lwz r4, 0(r4)
; P7-AIX32-NEXT:    li r6, 0
; P7-AIX32-NEXT:    stw r6, -32(r1)
; P7-AIX32-NEXT:    stw r4, -16(r1)
; P7-AIX32-NEXT:    addi r4, r1, -32
; P7-AIX32-NEXT:    lxvw4x v2, 0, r5
; P7-AIX32-NEXT:    addi r5, r1, -16
; P7-AIX32-NEXT:    lxvw4x v3, 0, r4
; P7-AIX32-NEXT:    lxvw4x v4, 0, r5
; P7-AIX32-NEXT:    vperm v2, v3, v4, v2
; P7-AIX32-NEXT:    stxvw4x v2, 0, r3
; P7-AIX32-NEXT:    blr
entry:
  %0 = load i32, ptr %in, align 4
  %conv = zext i32 %0 to i64
  %splat.splatinsert.i = insertelement <2 x i64> poison, i64 %conv, i32 0
  %splat.splat.i = shufflevector <2 x i64> %splat.splatinsert.i, <2 x i64> poison, <2 x i32> zeroinitializer
  store <2 x i64> %splat.splat.i, ptr %a, align 16
  ret void
}

; v8i16
define void @test7(ptr %a, ptr %in) {
; P9-LABEL: test7:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lxsihzx v2, 0, r4
; P9-NEXT:    vsplth v2, v2, 3
; P9-NEXT:    stxv v2, 0(r3)
; P9-NEXT:    blr
;
; P8-LABEL: test7:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lhzx r4, 0, r4
; P8-NEXT:    mtvsrwz v2, r4
; P8-NEXT:    vsplth v2, v2, 3
; P8-NEXT:    xxswapd vs0, v2
; P8-NEXT:    stxvd2x vs0, 0, r3
; P8-NEXT:    blr
;
; P7-LABEL: test7:
; P7:       # %bb.0: # %entry
; P7-NEXT:    li r5, 1
; P7-NEXT:    lvx v2, 0, r4
; P7-NEXT:    lvsl v4, 0, r4
; P7-NEXT:    lvx v3, r5, r4
; P7-NEXT:    vperm v2, v2, v3, v4
; P7-NEXT:    vsplth v2, v2, 0
; P7-NEXT:    stxvw4x v2, 0, r3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test7:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lxsihzx v2, 0, r4
; P9-AIX32-NEXT:    vsplth v2, v2, 3
; P9-AIX32-NEXT:    stxv v2, 0(r3)
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test7:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lhzx r4, 0, r4
; P8-AIX32-NEXT:    mtvsrwz v2, r4
; P8-AIX32-NEXT:    vsplth v2, v2, 3
; P8-AIX32-NEXT:    stxvw4x v2, 0, r3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test7:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    li r5, 1
; P7-AIX32-NEXT:    lvx v2, 0, r4
; P7-AIX32-NEXT:    lvsl v4, 0, r4
; P7-AIX32-NEXT:    lvx v3, r5, r4
; P7-AIX32-NEXT:    vperm v2, v2, v3, v4
; P7-AIX32-NEXT:    vsplth v2, v2, 0
; P7-AIX32-NEXT:    stxvw4x v2, 0, r3
; P7-AIX32-NEXT:    blr
entry:
  %0 = load i16, ptr %in, align 2
  %splat.splatinsert.i = insertelement <8 x i16> poison, i16 %0, i32 0
  %splat.splat.i = shufflevector <8 x i16> %splat.splatinsert.i, <8 x i16> poison, <8 x i32> zeroinitializer
  store <8 x i16> %splat.splat.i, ptr %a, align 16
  ret void
}

; v16i8
define void @test8(ptr %a, ptr %in) {
; P9-LABEL: test8:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lxsibzx v2, 0, r4
; P9-NEXT:    vspltb v2, v2, 7
; P9-NEXT:    stxv v2, 0(r3)
; P9-NEXT:    blr
;
; P8-LABEL: test8:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lbzx r4, 0, r4
; P8-NEXT:    mtvsrwz v2, r4
; P8-NEXT:    vspltb v2, v2, 7
; P8-NEXT:    xxswapd vs0, v2
; P8-NEXT:    stxvd2x vs0, 0, r3
; P8-NEXT:    blr
;
; P7-LABEL: test8:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lvsl v2, 0, r4
; P7-NEXT:    lvx v3, 0, r4
; P7-NEXT:    vperm v2, v3, v3, v2
; P7-NEXT:    vspltb v2, v2, 0
; P7-NEXT:    stxvw4x v2, 0, r3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test8:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lxsibzx v2, 0, r4
; P9-AIX32-NEXT:    vspltb v2, v2, 7
; P9-AIX32-NEXT:    stxv v2, 0(r3)
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test8:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lbzx r4, 0, r4
; P8-AIX32-NEXT:    mtvsrwz v2, r4
; P8-AIX32-NEXT:    vspltb v2, v2, 7
; P8-AIX32-NEXT:    stxvw4x v2, 0, r3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test8:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lvsl v2, 0, r4
; P7-AIX32-NEXT:    lvx v3, 0, r4
; P7-AIX32-NEXT:    vperm v2, v3, v3, v2
; P7-AIX32-NEXT:    vspltb v2, v2, 0
; P7-AIX32-NEXT:    stxvw4x v2, 0, r3
; P7-AIX32-NEXT:    blr
entry:
  %0 = load i8, ptr %in, align 1
  %splat.splatinsert.i = insertelement <16 x i8> poison, i8 %0, i32 0
  %splat.splat.i = shufflevector <16 x i8> %splat.splatinsert.i, <16 x i8> poison, <16 x i32> zeroinitializer
  store <16 x i8> %splat.splat.i, ptr %a, align 16
  ret void
}

define <16 x i8> @unadjusted_lxvwsx(ptr %s, ptr %t) {
; P9-LABEL: unadjusted_lxvwsx:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lxvwsx v2, 0, r3
; P9-NEXT:    blr
;
; P8-LABEL: unadjusted_lxvwsx:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lfiwzx f0, 0, r3
; P8-NEXT:    xxspltw v2, vs0, 1
; P8-NEXT:    blr
;
; P7-LABEL: unadjusted_lxvwsx:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lfiwzx f0, 0, r3
; P7-NEXT:    xxspltw v2, vs0, 1
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: unadjusted_lxvwsx:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lxvwsx v2, 0, r3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: unadjusted_lxvwsx:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lfiwzx f0, 0, r3
; P8-AIX32-NEXT:    xxspltw v2, vs0, 1
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: unadjusted_lxvwsx:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lfiwzx f0, 0, r3
; P7-AIX32-NEXT:    xxspltw v2, vs0, 1
; P7-AIX32-NEXT:    blr
  entry:
    %0 = load <4 x i8>, ptr %s, align 4
    %1 = shufflevector <4 x i8> %0, <4 x i8> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
    ret <16 x i8> %1
}

define <16 x i8> @adjusted_lxvwsx(ptr %s, ptr %t) {
; P9-LABEL: adjusted_lxvwsx:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r3, r3, 4
; P9-NEXT:    lxvwsx v2, 0, r3
; P9-NEXT:    blr
;
; P8-LABEL: adjusted_lxvwsx:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lfdx f0, 0, r3
; P8-NEXT:    xxspltw v2, vs0, 0
; P8-NEXT:    blr
;
; P7-LABEL: adjusted_lxvwsx:
; P7:       # %bb.0: # %entry
; P7-NEXT:    ld r3, 0(r3)
; P7-NEXT:    addi r4, r1, -16
; P7-NEXT:    std r3, -16(r1)
; P7-NEXT:    lxvw4x vs0, 0, r4
; P7-NEXT:    xxspltw v2, vs0, 1
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: adjusted_lxvwsx:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    addi r3, r3, 4
; P9-AIX32-NEXT:    lxvwsx v2, 0, r3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: adjusted_lxvwsx:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    addi r3, r3, 4
; P8-AIX32-NEXT:    lfiwzx f0, 0, r3
; P8-AIX32-NEXT:    xxspltw v2, vs0, 1
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: adjusted_lxvwsx:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    addi r3, r3, 4
; P7-AIX32-NEXT:    lfiwzx f0, 0, r3
; P7-AIX32-NEXT:    xxspltw v2, vs0, 1
; P7-AIX32-NEXT:    blr
  entry:
    %0 = load <8 x i8>, ptr %s, align 8
    %1 = shufflevector <8 x i8> %0, <8 x i8> undef, <16 x i32> <i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
    ret <16 x i8> %1
}

define <16 x i8> @unadjusted_lxvwsx_v16i8(ptr %s, <16 x i8> %t) {
; P9-LABEL: unadjusted_lxvwsx_v16i8:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lxvwsx v2, 0, r3
; P9-NEXT:    blr
;
; P8-LABEL: unadjusted_lxvwsx_v16i8:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lxvd2x vs0, 0, r3
; P8-NEXT:    xxswapd v2, vs0
; P8-NEXT:    xxspltw v2, v2, 3
; P8-NEXT:    blr
;
; P7-LABEL: unadjusted_lxvwsx_v16i8:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lxvw4x vs0, 0, r3
; P7-NEXT:    xxspltw v2, vs0, 0
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: unadjusted_lxvwsx_v16i8:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lxvwsx v2, 0, r3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: unadjusted_lxvwsx_v16i8:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lxvw4x vs0, 0, r3
; P8-AIX32-NEXT:    xxspltw v2, vs0, 0
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: unadjusted_lxvwsx_v16i8:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lxvw4x vs0, 0, r3
; P7-AIX32-NEXT:    xxspltw v2, vs0, 0
; P7-AIX32-NEXT:    blr
  entry:
    %0 = load <16 x i8>, ptr %s, align 16
    %1 = shufflevector <16 x i8> %0, <16 x i8> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
    ret <16 x i8> %1
}

define <16 x i8> @adjusted_lxvwsx_v16i8(ptr %s, <16 x i8> %t) {
; P9-LABEL: adjusted_lxvwsx_v16i8:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r3, r3, 4
; P9-NEXT:    lxvwsx v2, 0, r3
; P9-NEXT:    blr
;
; P8-LABEL: adjusted_lxvwsx_v16i8:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lxvd2x vs0, 0, r3
; P8-NEXT:    xxswapd v2, vs0
; P8-NEXT:    xxspltw v2, v2, 2
; P8-NEXT:    blr
;
; P7-LABEL: adjusted_lxvwsx_v16i8:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lxvw4x vs0, 0, r3
; P7-NEXT:    xxspltw v2, vs0, 1
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: adjusted_lxvwsx_v16i8:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    addi r3, r3, 4
; P9-AIX32-NEXT:    lxvwsx v2, 0, r3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: adjusted_lxvwsx_v16i8:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lxvw4x vs0, 0, r3
; P8-AIX32-NEXT:    xxspltw v2, vs0, 1
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: adjusted_lxvwsx_v16i8:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lxvw4x vs0, 0, r3
; P7-AIX32-NEXT:    xxspltw v2, vs0, 1
; P7-AIX32-NEXT:    blr
  entry:
    %0 = load <16 x i8>, ptr %s, align 16
    %1 = shufflevector <16 x i8> %0, <16 x i8> undef, <16 x i32> <i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
    ret <16 x i8> %1
}

define <16 x i8> @adjusted_lxvwsx_v16i8_2(ptr %s, <16 x i8> %t) {
; P9-LABEL: adjusted_lxvwsx_v16i8_2:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r3, r3, 8
; P9-NEXT:    lxvwsx v2, 0, r3
; P9-NEXT:    blr
;
; P8-LABEL: adjusted_lxvwsx_v16i8_2:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lxvd2x vs0, 0, r3
; P8-NEXT:    xxswapd v2, vs0
; P8-NEXT:    xxspltw v2, v2, 1
; P8-NEXT:    blr
;
; P7-LABEL: adjusted_lxvwsx_v16i8_2:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lxvw4x vs0, 0, r3
; P7-NEXT:    xxspltw v2, vs0, 2
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: adjusted_lxvwsx_v16i8_2:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    addi r3, r3, 8
; P9-AIX32-NEXT:    lxvwsx v2, 0, r3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: adjusted_lxvwsx_v16i8_2:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lxvw4x vs0, 0, r3
; P8-AIX32-NEXT:    xxspltw v2, vs0, 2
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: adjusted_lxvwsx_v16i8_2:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lxvw4x vs0, 0, r3
; P7-AIX32-NEXT:    xxspltw v2, vs0, 2
; P7-AIX32-NEXT:    blr
  entry:
    %0 = load <16 x i8>, ptr %s, align 16
    %1 = shufflevector <16 x i8> %0, <16 x i8> undef, <16 x i32> <i32 8, i32 9, i32 10, i32 11, i32 8, i32 9, i32 10, i32 11, i32 8, i32 9, i32 10, i32 11, i32 8, i32 9, i32 10, i32 11>
    ret <16 x i8> %1
}

define <16 x i8> @adjusted_lxvwsx_v16i8_3(ptr %s, <16 x i8> %t) {
; P9-LABEL: adjusted_lxvwsx_v16i8_3:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r3, r3, 12
; P9-NEXT:    lxvwsx v2, 0, r3
; P9-NEXT:    blr
;
; P8-LABEL: adjusted_lxvwsx_v16i8_3:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lxvd2x vs0, 0, r3
; P8-NEXT:    xxswapd v2, vs0
; P8-NEXT:    xxspltw v2, v2, 0
; P8-NEXT:    blr
;
; P7-LABEL: adjusted_lxvwsx_v16i8_3:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lxvw4x vs0, 0, r3
; P7-NEXT:    xxspltw v2, vs0, 3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: adjusted_lxvwsx_v16i8_3:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    addi r3, r3, 12
; P9-AIX32-NEXT:    lxvwsx v2, 0, r3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: adjusted_lxvwsx_v16i8_3:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lxvw4x vs0, 0, r3
; P8-AIX32-NEXT:    xxspltw v2, vs0, 3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: adjusted_lxvwsx_v16i8_3:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lxvw4x vs0, 0, r3
; P7-AIX32-NEXT:    xxspltw v2, vs0, 3
; P7-AIX32-NEXT:    blr
  entry:
    %0 = load <16 x i8>, ptr %s, align 16
    %1 = shufflevector <16 x i8> %0, <16 x i8> undef, <16 x i32> <i32 12, i32 13, i32 14, i32 15, i32 12, i32 13, i32 14, i32 15, i32 12, i32 13, i32 14, i32 15, i32 12, i32 13, i32 14, i32 15>
    ret <16 x i8> %1
}

define <16 x i8> @unadjusted_lxvdsx(ptr %s, ptr %t) {
; P9-LABEL: unadjusted_lxvdsx:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lxvdsx v2, 0, r3
; P9-NEXT:    blr
;
; P8-LABEL: unadjusted_lxvdsx:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lxvdsx v2, 0, r3
; P8-NEXT:    blr
;
; P7-LABEL: unadjusted_lxvdsx:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lxvdsx v2, 0, r3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: unadjusted_lxvdsx:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lwz r4, 4(r3)
; P9-AIX32-NEXT:    stw r4, -16(r1)
; P9-AIX32-NEXT:    lwz r3, 0(r3)
; P9-AIX32-NEXT:    lxv vs0, -16(r1)
; P9-AIX32-NEXT:    stw r3, -32(r1)
; P9-AIX32-NEXT:    lxv vs1, -32(r1)
; P9-AIX32-NEXT:    xxmrghw vs0, vs1, vs0
; P9-AIX32-NEXT:    xxmrghd v2, vs0, vs0
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: unadjusted_lxvdsx:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lwz r4, 4(r3)
; P8-AIX32-NEXT:    stw r4, -16(r1)
; P8-AIX32-NEXT:    addi r4, r1, -32
; P8-AIX32-NEXT:    lwz r3, 0(r3)
; P8-AIX32-NEXT:    stw r3, -32(r1)
; P8-AIX32-NEXT:    addi r3, r1, -16
; P8-AIX32-NEXT:    lxvw4x vs0, 0, r3
; P8-AIX32-NEXT:    lxvw4x vs1, 0, r4
; P8-AIX32-NEXT:    xxmrghw vs0, vs1, vs0
; P8-AIX32-NEXT:    xxmrghd v2, vs0, vs0
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: unadjusted_lxvdsx:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lwz r5, 4(r3)
; P7-AIX32-NEXT:    addi r4, r1, -16
; P7-AIX32-NEXT:    stw r5, -16(r1)
; P7-AIX32-NEXT:    lwz r3, 0(r3)
; P7-AIX32-NEXT:    stw r3, -32(r1)
; P7-AIX32-NEXT:    addi r3, r1, -32
; P7-AIX32-NEXT:    lxvw4x vs0, 0, r4
; P7-AIX32-NEXT:    lxvw4x vs1, 0, r3
; P7-AIX32-NEXT:    xxmrghw vs0, vs1, vs0
; P7-AIX32-NEXT:    xxmrghd v2, vs0, vs0
; P7-AIX32-NEXT:    blr
  entry:
    %0 = load <8 x i8>, ptr %s, align 8
    %1 = shufflevector <8 x i8> %0, <8 x i8> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
    ret <16 x i8> %1
}

define <16 x i8> @unadjusted_lxvdsx_v16i8(ptr %s, <16 x i8> %t) {
; P9-LABEL: unadjusted_lxvdsx_v16i8:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lxvdsx v2, 0, r3
; P9-NEXT:    blr
;
; P8-LABEL: unadjusted_lxvdsx_v16i8:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lxvdsx v2, 0, r3
; P8-NEXT:    blr
;
; P7-LABEL: unadjusted_lxvdsx_v16i8:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lxvdsx v2, 0, r3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: unadjusted_lxvdsx_v16i8:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lxvdsx v2, 0, r3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: unadjusted_lxvdsx_v16i8:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lxvdsx v2, 0, r3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: unadjusted_lxvdsx_v16i8:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lxvdsx v2, 0, r3
; P7-AIX32-NEXT:    blr
  entry:
    %0 = load <16 x i8>, ptr %s, align 16
    %1 = shufflevector <16 x i8> %0, <16 x i8> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
    ret <16 x i8> %1
}

define <16 x i8> @adjusted_lxvdsx_v16i8(ptr %s, <16 x i8> %t) {
; P9-LABEL: adjusted_lxvdsx_v16i8:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r3, r3, 8
; P9-NEXT:    lxvdsx v2, 0, r3
; P9-NEXT:    blr
;
; P8-LABEL: adjusted_lxvdsx_v16i8:
; P8:       # %bb.0: # %entry
; P8-NEXT:    addi r3, r3, 8
; P8-NEXT:    lxvdsx v2, 0, r3
; P8-NEXT:    blr
;
; P7-LABEL: adjusted_lxvdsx_v16i8:
; P7:       # %bb.0: # %entry
; P7-NEXT:    addi r3, r3, 8
; P7-NEXT:    lxvdsx v2, 0, r3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: adjusted_lxvdsx_v16i8:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    addi r3, r3, 8
; P9-AIX32-NEXT:    lxvdsx v2, 0, r3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: adjusted_lxvdsx_v16i8:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    addi r3, r3, 8
; P8-AIX32-NEXT:    lxvdsx v2, 0, r3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: adjusted_lxvdsx_v16i8:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    addi r3, r3, 8
; P7-AIX32-NEXT:    lxvdsx v2, 0, r3
; P7-AIX32-NEXT:    blr
  entry:
    %0 = load <16 x i8>, ptr %s, align 16
    %1 = shufflevector <16 x i8> %0, <16 x i8> undef, <16 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
    ret <16 x i8> %1
}

define <8 x i16> @test_unaligned_v8i16(ptr %Ptr) {
; P9-LABEL: test_unaligned_v8i16:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r3, r3, 6
; P9-NEXT:    lxsihzx v2, 0, r3
; P9-NEXT:    vsplth v2, v2, 3
; P9-NEXT:    blr
;
; P8-LABEL: test_unaligned_v8i16:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lhz r3, 6(r3)
; P8-NEXT:    mtvsrwz v2, r3
; P8-NEXT:    vsplth v2, v2, 3
; P8-NEXT:    blr
;
; P7-LABEL: test_unaligned_v8i16:
; P7:       # %bb.0: # %entry
; P7-NEXT:    li r4, 1
; P7-NEXT:    addi r3, r3, 6
; P7-NEXT:    lvx v2, 0, r3
; P7-NEXT:    lvx v3, r4, r3
; P7-NEXT:    lvsl v4, 0, r3
; P7-NEXT:    vperm v2, v2, v3, v4
; P7-NEXT:    vsplth v2, v2, 0
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test_unaligned_v8i16:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    addi r3, r3, 6
; P9-AIX32-NEXT:    lxsihzx v2, 0, r3
; P9-AIX32-NEXT:    vsplth v2, v2, 3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test_unaligned_v8i16:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lhz r3, 6(r3)
; P8-AIX32-NEXT:    mtvsrwz v2, r3
; P8-AIX32-NEXT:    vsplth v2, v2, 3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test_unaligned_v8i16:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    li r4, 1
; P7-AIX32-NEXT:    addi r3, r3, 6
; P7-AIX32-NEXT:    lvx v2, 0, r3
; P7-AIX32-NEXT:    lvx v3, r4, r3
; P7-AIX32-NEXT:    lvsl v4, 0, r3
; P7-AIX32-NEXT:    vperm v2, v2, v3, v4
; P7-AIX32-NEXT:    vsplth v2, v2, 0
; P7-AIX32-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i16, ptr %Ptr, i64 3
  %0 = load i16, ptr %add.ptr, align 16
  %splat.splatinsert = insertelement <8 x i16> poison, i16 %0, i32 0
  %splat.splat = shufflevector <8 x i16> %splat.splatinsert, <8 x i16> poison, <8 x i32> zeroinitializer
  ret <8 x i16> %splat.splat
}

define <16 x i8> @test_unaligned_v16i8(ptr %Ptr) {
; P9-LABEL: test_unaligned_v16i8:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r3, r3, 3
; P9-NEXT:    lxsibzx v2, 0, r3
; P9-NEXT:    vspltb v2, v2, 7
; P9-NEXT:    blr
;
; P8-LABEL: test_unaligned_v16i8:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lbz r3, 3(r3)
; P8-NEXT:    mtvsrwz v2, r3
; P8-NEXT:    vspltb v2, v2, 7
; P8-NEXT:    blr
;
; P7-LABEL: test_unaligned_v16i8:
; P7:       # %bb.0: # %entry
; P7-NEXT:    addi r3, r3, 3
; P7-NEXT:    lvsl v2, 0, r3
; P7-NEXT:    lvx v3, 0, r3
; P7-NEXT:    vperm v2, v3, v3, v2
; P7-NEXT:    vspltb v2, v2, 0
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test_unaligned_v16i8:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    addi r3, r3, 3
; P9-AIX32-NEXT:    lxsibzx v2, 0, r3
; P9-AIX32-NEXT:    vspltb v2, v2, 7
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test_unaligned_v16i8:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lbz r3, 3(r3)
; P8-AIX32-NEXT:    mtvsrwz v2, r3
; P8-AIX32-NEXT:    vspltb v2, v2, 7
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test_unaligned_v16i8:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    addi r3, r3, 3
; P7-AIX32-NEXT:    lvsl v2, 0, r3
; P7-AIX32-NEXT:    lvx v3, 0, r3
; P7-AIX32-NEXT:    vperm v2, v3, v3, v2
; P7-AIX32-NEXT:    vspltb v2, v2, 0
; P7-AIX32-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %Ptr, i64 3
  %0 = load i8, ptr %add.ptr, align 16
  %splat.splatinsert = insertelement <16 x i8> poison, i8 %0, i32 0
  %splat.splat = shufflevector <16 x i8> %splat.splatinsert, <16 x i8> poison, <16 x i32> zeroinitializer
  ret <16 x i8> %splat.splat
}

define <8 x i16> @test_aligned_v8i16_1(ptr %Ptr) {
; P9-LABEL: test_aligned_v8i16_1:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lxsihzx v2, 0, r3
; P9-NEXT:    vsplth v2, v2, 3
; P9-NEXT:    blr
;
; P8-LABEL: test_aligned_v8i16_1:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lvx v2, 0, r3
; P8-NEXT:    vsplth v2, v2, 7
; P8-NEXT:    blr
;
; P7-LABEL: test_aligned_v8i16_1:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lvx v2, 0, r3
; P7-NEXT:    vsplth v2, v2, 0
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test_aligned_v8i16_1:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lxsihzx v2, 0, r3
; P9-AIX32-NEXT:    vsplth v2, v2, 3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test_aligned_v8i16_1:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lvx v2, 0, r3
; P8-AIX32-NEXT:    vsplth v2, v2, 0
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test_aligned_v8i16_1:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lvx v2, 0, r3
; P7-AIX32-NEXT:    vsplth v2, v2, 0
; P7-AIX32-NEXT:    blr
entry:
  %0 = load i16, ptr %Ptr, align 16
  %splat.splatinsert = insertelement <8 x i16> poison, i16 %0, i32 0
  %splat.splat = shufflevector <8 x i16> %splat.splatinsert, <8 x i16> poison, <8 x i32> zeroinitializer
  ret <8 x i16> %splat.splat
}

define <8 x i16> @test_aligned_v8i16_2(ptr %Ptr) {
; P9-LABEL: test_aligned_v8i16_2:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r3, r3, 32
; P9-NEXT:    lxsihzx v2, 0, r3
; P9-NEXT:    vsplth v2, v2, 3
; P9-NEXT:    blr
;
; P8-LABEL: test_aligned_v8i16_2:
; P8:       # %bb.0: # %entry
; P8-NEXT:    addi r3, r3, 32
; P8-NEXT:    lvx v2, 0, r3
; P8-NEXT:    vsplth v2, v2, 7
; P8-NEXT:    blr
;
; P7-LABEL: test_aligned_v8i16_2:
; P7:       # %bb.0: # %entry
; P7-NEXT:    addi r3, r3, 32
; P7-NEXT:    lvx v2, 0, r3
; P7-NEXT:    vsplth v2, v2, 0
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test_aligned_v8i16_2:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    addi r3, r3, 32
; P9-AIX32-NEXT:    lxsihzx v2, 0, r3
; P9-AIX32-NEXT:    vsplth v2, v2, 3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test_aligned_v8i16_2:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    addi r3, r3, 32
; P8-AIX32-NEXT:    lvx v2, 0, r3
; P8-AIX32-NEXT:    vsplth v2, v2, 0
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test_aligned_v8i16_2:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    addi r3, r3, 32
; P7-AIX32-NEXT:    lvx v2, 0, r3
; P7-AIX32-NEXT:    vsplth v2, v2, 0
; P7-AIX32-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i16, ptr %Ptr, i64 16
  %0 = load i16, ptr %add.ptr, align 16
  %splat.splatinsert = insertelement <8 x i16> poison, i16 %0, i32 0
  %splat.splat = shufflevector <8 x i16> %splat.splatinsert, <8 x i16> poison, <8 x i32> zeroinitializer
  ret <8 x i16> %splat.splat
}

define <16 x i8> @test_aligned_v16i8_1(ptr %Ptr) {
; P9-LABEL: test_aligned_v16i8_1:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lxsibzx v2, 0, r3
; P9-NEXT:    vspltb v2, v2, 7
; P9-NEXT:    blr
;
; P8-LABEL: test_aligned_v16i8_1:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lvx v2, 0, r3
; P8-NEXT:    vspltb v2, v2, 15
; P8-NEXT:    blr
;
; P7-LABEL: test_aligned_v16i8_1:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lvx v2, 0, r3
; P7-NEXT:    vspltb v2, v2, 0
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test_aligned_v16i8_1:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lxsibzx v2, 0, r3
; P9-AIX32-NEXT:    vspltb v2, v2, 7
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test_aligned_v16i8_1:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lvx v2, 0, r3
; P8-AIX32-NEXT:    vspltb v2, v2, 0
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test_aligned_v16i8_1:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lvx v2, 0, r3
; P7-AIX32-NEXT:    vspltb v2, v2, 0
; P7-AIX32-NEXT:    blr
entry:
  %0 = load i8, ptr %Ptr, align 16
  %splat.splatinsert = insertelement <16 x i8> poison, i8 %0, i32 0
  %splat.splat = shufflevector <16 x i8> %splat.splatinsert, <16 x i8> poison, <16 x i32> zeroinitializer
  ret <16 x i8> %splat.splat
}

define <16 x i8> @test_aligned_v16i8_2(ptr %Ptr) {
; P9-LABEL: test_aligned_v16i8_2:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addi r3, r3, 16
; P9-NEXT:    lxsibzx v2, 0, r3
; P9-NEXT:    vspltb v2, v2, 7
; P9-NEXT:    blr
;
; P8-LABEL: test_aligned_v16i8_2:
; P8:       # %bb.0: # %entry
; P8-NEXT:    addi r3, r3, 16
; P8-NEXT:    lvx v2, 0, r3
; P8-NEXT:    vspltb v2, v2, 15
; P8-NEXT:    blr
;
; P7-LABEL: test_aligned_v16i8_2:
; P7:       # %bb.0: # %entry
; P7-NEXT:    addi r3, r3, 16
; P7-NEXT:    lvx v2, 0, r3
; P7-NEXT:    vspltb v2, v2, 0
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test_aligned_v16i8_2:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    addi r3, r3, 16
; P9-AIX32-NEXT:    lxsibzx v2, 0, r3
; P9-AIX32-NEXT:    vspltb v2, v2, 7
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test_aligned_v16i8_2:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    addi r3, r3, 16
; P8-AIX32-NEXT:    lvx v2, 0, r3
; P8-AIX32-NEXT:    vspltb v2, v2, 0
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test_aligned_v16i8_2:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    addi r3, r3, 16
; P7-AIX32-NEXT:    lvx v2, 0, r3
; P7-AIX32-NEXT:    vspltb v2, v2, 0
; P7-AIX32-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %Ptr, i64 16
  %0 = load i8, ptr %add.ptr, align 16
  %splat.splatinsert = insertelement <16 x i8> poison, i8 %0, i32 0
  %splat.splat = shufflevector <16 x i8> %splat.splatinsert, <16 x i8> poison, <16 x i32> zeroinitializer
  ret <16 x i8> %splat.splat
}

; The following test case should not produce a load and splat node,
; as we cannot handle extending loads (from f32 to f64), and this test
; shows that there are multiple uses of the extending load (other than
; a build vector node). `lxvdsx` should not be produced in this case.
define <2 x double> @test_v2f64_multiple_use(ptr nocapture readonly %a, ptr nocapture %b, ptr nocapture %c) {
; P9-LABEL: test_v2f64_multiple_use:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lfs f0, 0(r3)
; P9-NEXT:    xxspltd v2, vs0, 0
; P9-NEXT:    lfd f1, 0(r4)
; P9-NEXT:    xsadddp f1, f1, f0
; P9-NEXT:    stfd f1, 0(r4)
; P9-NEXT:    lfd f1, 0(r5)
; P9-NEXT:    xsadddp f1, f1, f0
; P9-NEXT:    stfd f1, 0(r5)
; P9-NEXT:    blr
;
; P8-LABEL: test_v2f64_multiple_use:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lfs f0, 0(r3)
; P8-NEXT:    lfd f1, 0(r4)
; P8-NEXT:    xsadddp f1, f1, f0
; P8-NEXT:    xxspltd v2, vs0, 0
; P8-NEXT:    stfd f1, 0(r4)
; P8-NEXT:    lfd f1, 0(r5)
; P8-NEXT:    xsadddp f1, f1, f0
; P8-NEXT:    stfd f1, 0(r5)
; P8-NEXT:    blr
;
; P7-LABEL: test_v2f64_multiple_use:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lfs f0, 0(r3)
; P7-NEXT:    lfd f1, 0(r4)
; P7-NEXT:    xsadddp f1, f1, f0
; P7-NEXT:    xxspltd v2, vs0, 0
; P7-NEXT:    stfd f1, 0(r4)
; P7-NEXT:    lfd f1, 0(r5)
; P7-NEXT:    xsadddp f1, f1, f0
; P7-NEXT:    stfd f1, 0(r5)
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test_v2f64_multiple_use:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lfs f0, 0(r3)
; P9-AIX32-NEXT:    xxmrghd v2, vs0, vs0
; P9-AIX32-NEXT:    lfd f1, 0(r4)
; P9-AIX32-NEXT:    xsadddp f1, f1, f0
; P9-AIX32-NEXT:    stfd f1, 0(r4)
; P9-AIX32-NEXT:    lfd f1, 0(r5)
; P9-AIX32-NEXT:    xsadddp f1, f1, f0
; P9-AIX32-NEXT:    stfd f1, 0(r5)
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test_v2f64_multiple_use:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lfs f0, 0(r3)
; P8-AIX32-NEXT:    lfd f1, 0(r4)
; P8-AIX32-NEXT:    xsadddp f1, f1, f0
; P8-AIX32-NEXT:    xxmrghd v2, vs0, vs0
; P8-AIX32-NEXT:    stfd f1, 0(r4)
; P8-AIX32-NEXT:    lfd f1, 0(r5)
; P8-AIX32-NEXT:    xsadddp f1, f1, f0
; P8-AIX32-NEXT:    stfd f1, 0(r5)
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test_v2f64_multiple_use:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lfs f0, 0(r3)
; P7-AIX32-NEXT:    lfd f1, 0(r4)
; P7-AIX32-NEXT:    xsadddp f1, f1, f0
; P7-AIX32-NEXT:    xxmrghd v2, vs0, vs0
; P7-AIX32-NEXT:    stfd f1, 0(r4)
; P7-AIX32-NEXT:    lfd f1, 0(r5)
; P7-AIX32-NEXT:    xsadddp f1, f1, f0
; P7-AIX32-NEXT:    stfd f1, 0(r5)
; P7-AIX32-NEXT:    blr
entry:
  %0 = load float, ptr %a, align 4
  %conv = fpext float %0 to double
  %1 = load double, ptr %b, align 8
  %add = fadd double %1, %conv
  store double %add, ptr %b, align 8
  %2 = load double, ptr %c, align 8
  %add2 = fadd double %2, %conv
  store double %add2, ptr %c, align 8
  %vecinit = insertelement <2 x double> undef, double %conv, i64 0
  %vecinit5 = shufflevector <2 x double> %vecinit, <2 x double> poison, <2 x i32> zeroinitializer
  ret <2 x double> %vecinit5
}

define <4 x i32> @test_splatW(ptr %ptr) {
; P9-LABEL: test_splatW:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lxvwsx v2, 0, r3
; P9-NEXT:    blr
;
; P8-LABEL: test_splatW:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lxvd2x vs0, 0, r3
; P8-NEXT:    xxswapd v2, vs0
; P8-NEXT:    xxspltw v2, v2, 3
; P8-NEXT:    blr
;
; P7-LABEL: test_splatW:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lxvw4x vs0, 0, r3
; P7-NEXT:    xxspltw v2, vs0, 0
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test_splatW:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lxvwsx v2, 0, r3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test_splatW:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lxvw4x vs0, 0, r3
; P8-AIX32-NEXT:    xxspltw v2, vs0, 0
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test_splatW:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lxvw4x vs0, 0, r3
; P7-AIX32-NEXT:    xxspltw v2, vs0, 0
; P7-AIX32-NEXT:    blr
entry:
  %0 = load <8 x i16>, ptr %ptr, align 16
  %1 = shufflevector <8 x i16> %0, <8 x i16> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %2 = bitcast<8 x i16> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <4 x i32> @test_splatD(ptr %ptr) {
; P9-LABEL: test_splatD:
; P9:       # %bb.0: # %entry
; P9-NEXT:    lxvdsx v2, 0, r3
; P9-NEXT:    blr
;
; P8-LABEL: test_splatD:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lxvdsx v2, 0, r3
; P8-NEXT:    blr
;
; P7-LABEL: test_splatD:
; P7:       # %bb.0: # %entry
; P7-NEXT:    lxvdsx v2, 0, r3
; P7-NEXT:    blr
;
; P9-AIX32-LABEL: test_splatD:
; P9-AIX32:       # %bb.0: # %entry
; P9-AIX32-NEXT:    lxvdsx v2, 0, r3
; P9-AIX32-NEXT:    blr
;
; P8-AIX32-LABEL: test_splatD:
; P8-AIX32:       # %bb.0: # %entry
; P8-AIX32-NEXT:    lxvdsx v2, 0, r3
; P8-AIX32-NEXT:    blr
;
; P7-AIX32-LABEL: test_splatD:
; P7-AIX32:       # %bb.0: # %entry
; P7-AIX32-NEXT:    lxvdsx v2, 0, r3
; P7-AIX32-NEXT:    blr
entry:
  %0 = load <8 x i16>, ptr %ptr, align 16
  %1 = shufflevector <8 x i16> %0, <8 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %2 = bitcast<8 x i16> %1 to <4 x i32>
  ret <4 x i32> %2
}
