
import sys, site

# do standard skbuild setup
from skbuild.exceptions import SKBuildError
from skbuild import setup  # This line replaces 'from setuptools import setup'

with open('README.md', 'r') as fh:
     readme_file = fh.readlines()

long_description = ""
for line in readme_file[3:]:
    if line.rstrip() == "Quick Install":
        break
    else:
        long_description += line

long_description += "### Quick Install\n Tasmanian supports `--user` and venv install only, see the on-line documentation for details.\n"

# find out whether this is a virtual environment, real_prefix is an older test, base_refix is the newer one
if hasattr(sys, 'real_prefix') or (hasattr(sys, 'base_prefix') and sys.base_prefix != sys.prefix):
    final_install_path = sys.prefix # sys.prefix points to the virtual environment root
    isvirtual = True
else:
    isvirtual = False
    try:
        final_install_path = site.getuserbase()
    except:
        import os
        # some implementations do not provide compatible 'site' package, assume default Linux behavior
        final_install_path = os.getenv('HOME') + "/.local/"

# check if using OSX Framework environment
isosxframework = False
if sys.platform == 'darwin':
    try:
        if 'python/site-packages' in site.getusersitepackages():
            # appears to be Mac Framework using Library/Python/X.Y/lib/python/site-packages
            isosxframework = True
    except:
        # cannot determine if using Mac Framework
        pass

# setup cmake arguments
cmake_args=[
        '-DCMAKE_BUILD_TYPE=Release',
        '-DBUILD_SHARED_LIBS=ON',
        '-DTasmanian_ENABLE_RECOMMENDED:BOOL=ON',
        '-DTasmanian_ENABLE_PYTHON:BOOL=ON',
        '-DPython_EXECUTABLE:PATH={0:1s}'.format(sys.executable),
        '-DTasmanian_python_pip_final:PATH={0:1s}/'.format(final_install_path),
        ]
if isvirtual:
    cmake_args.append('-DTasmanian_windows_virtual:BOOL=ON')
if isosxframework:
    cmake_args.append('-DTasmanian_osx_framework:BOOL=ON')


# call the actual package setup command
setup(
    name='Tasmanian',
    version='8.2',
    author='Miroslav Stoyanov',
    author_email='stoyanovmk@ornl.gov',
    description='UQ library for sparse grids, optimization and Bayesian inference',
    long_description=long_description,
    long_description_content_type="text/markdown",
    url='https://tasmanian.ornl.gov',
    classifiers=[
        'Programming Language :: Python :: 3',
        'Programming Language :: C++',
        'Operating System :: OS Independent',
    ],
    install_requires=['numpy>=1.10'],
    ### cmake portion of the setup, specific to skbuild ###
    setup_requires=['numpy>=1.10', ],
    cmake_args=cmake_args,
    py_modules=[]
)
