-- test/test-tongue.util.lua
--
-- Lua I18N library 'Tongue' -- Tests for the util module
--
-- Copyright 2016 Daniel Silverstone <dsilvers@digital-scurf.org>
--
-- For Licence terms, see COPYING
--

-- Step one, start coverage

pcall(require, 'luacov')

local tongue = require 'tongue'

local testnames = {}

local real_assert = assert
local total_asserts = 0
local function assert(...)
   local retval = real_assert(...)
   total_asserts = total_asserts + 1
   return retval
end

local function add_test(suite, name, value)
   rawset(suite, name, value)
   testnames[#testnames+1] = name
end

local suite = setmetatable({}, {__newindex = add_test})

function suite.parse_categories()
   local categories = {
      { "en", "en", nil, nil },
      { "en_GB", "en", "GB", nil },
      { "en.UTF-8", "en", nil, "UTF-8" },
      { "en_GB.UTF-8", "en", "GB", "UTF-8" },
   }
   for _, cat in ipairs(categories) do
      local lang, country, charset = tongue.util.split_category(cat[1])
      assert(lang == cat[2], "Language wrong")
      assert(country == cat[3], "Country wrong")
      assert(charset == cat[4], "Charset wrong")
   end
end

local count_ok = 0
for _, testname in ipairs(testnames) do
--   print("Run: " .. testname)
   local ok, err = xpcall(suite[testname], debug.traceback)
   if not ok then
      print(err)
      print()
   else
      count_ok = count_ok + 1
   end
end

print(tostring(count_ok) .. "/" .. tostring(#testnames) .. " [" .. tostring(total_asserts) .. "] OK")

os.exit(count_ok == #testnames and 0 or 1)
