/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rfb.CMsgHandler;
import rfb.CMsgReader;
import rfb.Decoder;

public class RawDecoder
extends Decoder {
    CMsgReader reader;

    public RawDecoder(CMsgReader reader_) {
        this.reader = reader_;
    }

    public void readRect(int x, int y, int w, int h, CMsgHandler handler) {
        byte[] imageBuf = this.reader.getImageBuf(w, w * h);
        int nPixels = imageBuf.length / (this.reader.bpp() / 8);
        int nRows = nPixels / w;
        int bytesPerRow = w * (this.reader.bpp() / 8);
        while (h > 0) {
            if (nRows > h) {
                nRows = h;
            }
            this.reader.getInStream().readBytes(imageBuf, 0, nRows * bytesPerRow);
            handler.imageRect(x, y, w, nRows, imageBuf, 0);
            h -= nRows;
            y += nRows;
        }
    }
}

