/*
 * Copyright (C) 2012-2014 Robert Chéramy (robert@cheramy.net)
 *
 * This file is part of YASW (Yet Another Scan Wizard).
 *
 * YASW is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * YASW is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with YASW.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "basefilterwidget.h"
#include "ui_basefilterwidget.h"

BaseFilterWidget::BaseFilterWidget(QWidget *parent) :
    AbstractFilterWidget(parent),
    ui(new Ui::BaseFilterWidget)
{
    ui->setupUi(this);
}

BaseFilterWidget::~BaseFilterWidget()
{
    delete ui;
}

void BaseFilterWidget::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void BaseFilterWidget::setPixmap(QPixmap pixmap)
{
    ui->view->setPixmap(pixmap);
}

void BaseFilterWidget::setPreview(QPixmap pixmap)
{
    previewPixmap = pixmap;

}

bool BaseFilterWidget::preview()
{
    return ui->preview->isChecked();
}

void BaseFilterWidget::enableFilter(bool enable)
{
    ui->enable->setChecked(enable);
}


void BaseFilterWidget::on_enable_toggled(bool checked)
{
    emit enableFilterToggled(checked);
}
