package ONVIF::Media::Types::SystemCapabilitiesExtension;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %HttpFirmwareUpgrade_of :ATTR(:get<HttpFirmwareUpgrade>);
my %HttpSystemBackup_of :ATTR(:get<HttpSystemBackup>);
my %HttpSystemLogging_of :ATTR(:get<HttpSystemLogging>);
my %HttpSupportInformation_of :ATTR(:get<HttpSupportInformation>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        HttpFirmwareUpgrade
        HttpSystemBackup
        HttpSystemLogging
        HttpSupportInformation
        Extension

    ) ],
    {
        'HttpFirmwareUpgrade' => \%HttpFirmwareUpgrade_of,
        'HttpSystemBackup' => \%HttpSystemBackup_of,
        'HttpSystemLogging' => \%HttpSystemLogging_of,
        'HttpSupportInformation' => \%HttpSupportInformation_of,
        'Extension' => \%Extension_of,
    },
    {
        'HttpFirmwareUpgrade' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'HttpSystemBackup' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'HttpSystemLogging' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'HttpSupportInformation' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Extension' => 'ONVIF::Media::Types::SystemCapabilitiesExtension2',
    },
    {

        'HttpFirmwareUpgrade' => 'HttpFirmwareUpgrade',
        'HttpSystemBackup' => 'HttpSystemBackup',
        'HttpSystemLogging' => 'HttpSystemLogging',
        'HttpSupportInformation' => 'HttpSupportInformation',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::SystemCapabilitiesExtension

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
SystemCapabilitiesExtension from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * HttpFirmwareUpgrade


=item * HttpSystemBackup


=item * HttpSystemLogging


=item * HttpSupportInformation


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::SystemCapabilitiesExtension
   HttpFirmwareUpgrade =>  $some_value, # boolean
   HttpSystemBackup =>  $some_value, # boolean
   HttpSystemLogging =>  $some_value, # boolean
   HttpSupportInformation =>  $some_value, # boolean
   Extension =>  { # ONVIF::Media::Types::SystemCapabilitiesExtension2
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

